/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.util.ArrayList;
import java.util.TreeSet;
import standalone_spreadsheet.com.github.miachm.sods.Cell;
import standalone_spreadsheet.com.github.miachm.sods.Color;
import standalone_spreadsheet.com.github.miachm.sods.GroupCell;
import standalone_spreadsheet.com.github.miachm.sods.MutableInteger;
import standalone_spreadsheet.com.github.miachm.sods.OfficeAnnotation;
import standalone_spreadsheet.com.github.miachm.sods.RangeIterator;
import standalone_spreadsheet.com.github.miachm.sods.Sheet;
import standalone_spreadsheet.com.github.miachm.sods.Style;
import standalone_spreadsheet.com.github.miachm.sods.Vector;

public class Range {
    private static final int MAX_PRINTABLE = 500;
    private final int column_init;
    private final int row_init;
    private final int numrows;
    private final int numcolumns;
    private final Sheet sheet;

    Range(Sheet sheet, int row_init, int column_init, int numrows, int numcolumns) {
        if (row_init < 0) {
            throw new IndexOutOfBoundsException("Starting row is negative");
        }
        if (column_init < 0) {
            throw new IndexOutOfBoundsException("Starting column is negative");
        }
        if (numrows < 0) {
            throw new IndexOutOfBoundsException("Numrows can't be negative");
        }
        if (numcolumns < 0) {
            throw new IndexOutOfBoundsException("Numrows can't be negative");
        }
        if (row_init + numrows > sheet.getMaxRows()) {
            throw new IndexOutOfBoundsException("Range goes out of bounds: (end_of_range: " + (row_init + numrows) + ", maxrows in sheet: " + sheet.getMaxRows());
        }
        if (column_init + numcolumns > sheet.getMaxColumns()) {
            throw new IndexOutOfBoundsException("Range goes out of bounds: (end_of_range: " + (column_init + numcolumns) + ", maxcolumns in sheet: " + sheet.getMaxColumns());
        }
        this.sheet = sheet;
        this.row_init = row_init;
        this.column_init = column_init;
        this.numrows = numrows;
        this.numcolumns = numcolumns;
    }

    public void clear() {
        this.iterateRange((cell, row, column) -> cell.clear());
    }

    public void copyTo(Range dest) {
        if (dest.getNumValues() != this.getNumValues()) {
            throw new IllegalArgumentException("Error in copyTo, the range is of different size (" + dest.getNumValues() + " against " + this.getNumValues() + ")");
        }
        dest.setValues(this.getValues());
        dest.setFormulas(this.getFormulas());
        dest.setStyles(this.getStyles());
        dest.setAnnotations(this.getAnnotations());
    }

    public Range getCell(int row, int column) {
        if (row >= this.getNumRows()) {
            throw new IndexOutOfBoundsException("Row is greater than range size");
        }
        if (row < 0) {
            throw new IndexOutOfBoundsException("Row is negative");
        }
        if (column >= this.getNumColumns()) {
            throw new IndexOutOfBoundsException("Column is greater than range size");
        }
        if (column < 0) {
            throw new IndexOutOfBoundsException("Column is negative");
        }
        return new Range(this.sheet, this.row_init + row, this.column_init + column, 1, 1);
    }

    public int getColumn() {
        return this.column_init;
    }

    private Cell getFirstCell() {
        Cell cell = this.sheet.getCell(this.row_init, this.column_init);
        if (cell.getGroup() != null) {
            cell = cell.getGroup().getCell();
        }
        return cell;
    }

    public String getFormula() {
        return this.getFirstCell().getFormula();
    }

    public String[][] getFormulas() {
        String[][] formulas = new String[this.getNumRows()][this.getNumColumns()];
        this.iterateRange((cell, row, column) -> {
            formulas[row][column] = cell.getFormula();
        });
        return formulas;
    }

    public int getLastColumn() {
        return this.column_init + this.getNumColumns() - 1;
    }

    public int getLastRow() {
        return this.row_init + this.getNumRows() - 1;
    }

    public Range[] getMergedCells() {
        TreeSet groupCells = new TreeSet();
        this.iterateRange((cell, row, column) -> {
            if (cell.getGroup() != null) {
                groupCells.add(cell.getGroup());
            }
        });
        ArrayList<Range> result = new ArrayList<Range>();
        for (GroupCell groupCell : groupCells) {
            Vector cord = groupCell.getCord();
            Vector length = groupCell.getLength();
            Range range = new Range(this.sheet, cord.getX(), cord.getY(), length.getX(), length.getY());
            result.add(range);
        }
        return result.toArray(new Range[result.size()]);
    }

    public int getNumColumns() {
        return this.numcolumns;
    }

    public int getNumRows() {
        return this.numrows;
    }

    public int getRow() {
        return this.row_init;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public Object getValue() {
        return this.getFirstCell().getValue();
    }

    public Object[][] getValues() {
        Object[][] values = new Object[this.getNumRows()][this.getNumColumns()];
        this.iterateRange((cell, row, column) -> {
            values[row][column] = cell.getValue();
        });
        return values;
    }

    public Style getStyle() {
        return this.getFirstCell().getStyleCopy();
    }

    public Style[][] getStyles() {
        Style[][] arr = new Style[this.getNumRows()][this.getNumColumns()];
        this.iterateRange((cell, row, column) -> {
            arr[row][column] = cell.getStyleCopy();
        });
        return arr;
    }

    public OfficeAnnotation getAnnotation() {
        return this.getFirstCell().getAnnotation();
    }

    public OfficeAnnotation[][] getAnnotations() {
        OfficeAnnotation[][] arr = new OfficeAnnotation[this.getNumRows()][this.getNumColumns()];
        this.iterateRange((cell, row, column) -> {
            arr[row][column] = cell.getAnnotation();
        });
        return arr;
    }

    public int getNumValues() {
        return this.getNumColumns() * this.getNumRows();
    }

    public void setValue(Object o) {
        this.iterateRange((cell, row, column) -> cell.setValue(o));
    }

    public void setValues(Object ... o) {
        if (o.length != this.getNumValues()) {
            throw new IllegalArgumentException("Error in setValues, the number of the arguments doesn't fit (" + o.length + " against " + this.getNumValues() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.setValue(o[row * this.getNumColumns() + column]));
    }

    public void setValues(Object[][] o) {
        if (o.length == 0) {
            throw new IllegalArgumentException("Error in setValues, the array is empty");
        }
        if (o.length != this.getNumRows()) {
            throw new IllegalArgumentException("Error in setValues, the number of rows doesn't fit (" + o.length + " against " + this.getNumRows() + ")");
        }
        if (o[0].length != this.getNumColumns()) {
            throw new IllegalArgumentException("Error in setValues, the number of columns doesn't fit (" + o[0].length + " against " + this.getNumColumns() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.setValue(o[row][column]));
    }

    public void setFontBold(boolean bold) {
        this.iterateRange((cell, row, column) -> cell.getStyle().setBold(bold));
    }

    public void setFontBolds(boolean ... bold) {
        if (bold.length != this.getNumValues()) {
            throw new IllegalArgumentException("Error in setFontBold, the number of the arguments doesn't fit (" + bold.length + " against " + this.getNumValues() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setBold(bold[row * this.getNumColumns() + column]));
    }

    public void setFontBolds(boolean[][] bold) {
        if (bold.length == 0) {
            throw new IllegalArgumentException("Error in setFontBold, the array is empty");
        }
        if (bold.length != this.getNumRows()) {
            throw new IllegalArgumentException("Error in setFontBolds, the number of rows doesn't fit (" + bold.length + " against " + this.getNumRows() + ")");
        }
        if (bold[0].length != this.getNumColumns()) {
            throw new IllegalArgumentException("Error in setFontBolds, the number of columns doesn't fit (" + bold[0].length + " against " + this.getNumColumns() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setBold(bold[row][column]));
    }

    public void setFontItalic(boolean italic) {
        this.iterateRange((cell, row, column) -> cell.getStyle().setItalic(italic));
    }

    public void setFontItalics(boolean ... italic) {
        if (italic.length != this.getNumValues()) {
            throw new IllegalArgumentException("Error in setFontItalic, the number of the arguments doesn't fit (" + italic.length + " against " + this.getNumValues() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setItalic(italic[row * this.getNumColumns() + column]));
    }

    public void setFontItalics(boolean[][] italic) {
        if (italic.length == 0) {
            throw new IllegalArgumentException("Error in setFontItalics, the array is empty");
        }
        if (italic.length != this.getNumRows()) {
            throw new IllegalArgumentException("Error in setFontItalics, the number of rows doesn't fit (" + italic.length + " against " + this.getNumRows() + ")");
        }
        if (italic[0].length != this.getNumColumns()) {
            throw new IllegalArgumentException("Error in setFontItalics, the number of columns doesn't fit (" + italic[0].length + " against " + this.getNumColumns() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setItalic(italic[row][column]));
    }

    public void setFontUnderline(boolean underline) {
        this.iterateRange((cell, row, column) -> cell.getStyle().setUnderline(underline));
    }

    public void setFontUnderlines(boolean ... underline) {
        if (underline.length != this.getNumValues()) {
            throw new IllegalArgumentException("Error in setFontUnderlines, the number of the arguments doesn't fit (" + underline.length + " against " + this.getNumValues() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setUnderline(underline[row * this.getNumColumns() + column]));
    }

    public void setFontUnderlines(boolean[][] underline) {
        if (underline.length == 0) {
            throw new IllegalArgumentException("Error in setFontUnderlines, the array is empty");
        }
        if (underline.length != this.getNumRows()) {
            throw new IllegalArgumentException("Error in setFontUnderlines, the number of rows doesn't fit (" + underline.length + " against " + this.getNumRows() + ")");
        }
        if (underline[0].length != this.getNumColumns()) {
            throw new IllegalArgumentException("Error in setFontUnderlines, the number of columns doesn't fit (" + underline[0].length + " against " + this.getNumColumns() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setUnderline(underline[row][column]));
    }

    public void setFontColor(Color color) {
        this.iterateRange((cell, row, column) -> cell.getStyle().setFontColor(color));
    }

    public void setFontColors(Color ... color) {
        if (color.length != this.getNumValues()) {
            throw new IllegalArgumentException("Error in setFontColors, the number of the arguments doesn't fit (" + color.length + " against " + this.getNumValues() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setFontColor(color[row * this.getNumColumns() + column]));
    }

    public void setFontColors(Color[][] color) {
        if (color.length == 0) {
            throw new IllegalArgumentException("Error in setFontColors, the array is empty");
        }
        if (color.length != this.getNumRows()) {
            throw new IllegalArgumentException("Error in setFontColors, the number of rows doesn't fit (" + color.length + " against " + this.getNumRows() + ")");
        }
        if (color[0].length != this.getNumColumns()) {
            throw new IllegalArgumentException("Error in setFontColors, the number of columns doesn't fit (" + color[0].length + " against " + this.getNumColumns() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setFontColor(color[row][column]));
    }

    public void setBackgroundColor(Color color) {
        this.iterateRange((cell, row, column) -> cell.getStyle().setBackgroundColor(color));
    }

    public void setBackgroundColors(Color ... color) {
        if (color.length != this.getNumValues()) {
            throw new IllegalArgumentException("Error in setBackgroundColors, the number of the arguments doesn't fit (" + color.length + " against " + this.getNumValues() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setBackgroundColor(color[row * this.getNumColumns() + column]));
    }

    public void setBackgroundColors(Color[][] color) {
        if (color.length == 0) {
            throw new IllegalArgumentException("Error in setBackgroundColors, the array is empty");
        }
        if (color.length != this.getNumRows()) {
            throw new IllegalArgumentException("Error in setBackgroundColors, the number of rows doesn't fit (" + color.length + " against " + this.getNumRows() + ")");
        }
        if (color[0].length != this.getNumColumns()) {
            throw new IllegalArgumentException("Error in setBackgroundColors, the number of columns doesn't fit (" + color[0].length + " against " + this.getNumColumns() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setBackgroundColor(color[row][column]));
    }

    public void setFontSize(int fontSize) {
        this.iterateRange((cell, row, column) -> cell.getStyle().setFontSize(fontSize));
    }

    public void setFontSizes(int ... fontSizes) {
        if (fontSizes.length != this.getNumValues()) {
            throw new IllegalArgumentException("Error in setFontSizes, the number of the arguments doesn't fit (" + fontSizes.length + " against " + this.getNumValues() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setFontSize(fontSizes[row * this.getNumColumns() + column]));
    }

    public void setFontSizes(int[][] fontSizes) {
        if (fontSizes.length == 0) {
            throw new IllegalArgumentException("Error in setFontSizes, the array is empty");
        }
        if (fontSizes.length != this.getNumRows()) {
            throw new IllegalArgumentException("Error in setFontSizes, the number of rows doesn't fit (" + fontSizes.length + " against " + this.getNumRows() + ")");
        }
        if (fontSizes[0].length != this.getNumColumns()) {
            throw new IllegalArgumentException("Error in setFontSizes, the number of columns doesn't fit (" + fontSizes[0].length + " against " + this.getNumColumns() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.getStyle().setFontSize(fontSizes[row][column]));
    }

    private void iterateRange(RangeIterator e) {
        for (int i = 0; i < this.numrows; ++i) {
            for (int j = 0; j < this.numcolumns; ++j) {
                Cell cell = this.sheet.getCell(this.row_init + i, this.column_init + j);
                GroupCell groupCell = cell.getGroup();
                if (groupCell != null) {
                    cell = groupCell.getCell();
                }
                e.call(cell, i, j);
            }
        }
    }

    private String valuesToString() {
        StringBuilder builder = new StringBuilder();
        MutableInteger lastRow = new MutableInteger();
        this.iterateRange((cell, i, j) -> {
            if (lastRow.number != i) {
                builder.append("\n");
                lastRow.number = i;
            }
            if (j > 0) {
                builder.append(" , ");
            }
            builder.append(cell.getValue());
        });
        return builder.toString();
    }

    public void setFormula(String formula) {
        this.iterateRange((cell, row, column) -> cell.setFormula(formula));
    }

    public void setFormulas(String ... formula) {
        if (formula.length != this.getNumValues()) {
            throw new IllegalArgumentException("Error in setFormulas, the number of the arguments doesn't fit (" + formula.length + " against " + this.getNumValues() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.setFormula(formula[row * this.getNumColumns() + column]));
    }

    public void setFormulas(String[][] formula) {
        if (formula.length == 0) {
            throw new IllegalArgumentException("Error in setFormulas, the array is empty");
        }
        if (formula.length != this.getNumRows()) {
            throw new IllegalArgumentException("Error in setFormulas, the number of rows doesn't fit (" + formula.length + " against " + this.getNumRows() + ")");
        }
        if (formula[0].length != this.getNumColumns()) {
            throw new IllegalArgumentException("Error in setFormulas, the number of columns doesn't fit (" + formula[0].length + " against " + this.getNumColumns() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.setFormula(formula[row][column]));
    }

    public String toString() {
        return "Range{\ncolumn_init=" + this.column_init + "\nrow_init=" + this.row_init + "\nnumrows=" + this.numrows + "\nnumcolumns=" + this.numcolumns + "\nvalues =\n\n" + (this.getNumValues() < 500 ? this.valuesToString() : "too long for print") + "\n}";
    }

    public void setStyle(Style style) {
        this.iterateRange((cell, row, column) -> cell.setStyle(style));
    }

    public void setStyles(Style ... style) {
        if (style.length != this.getNumValues()) {
            throw new IllegalArgumentException("Error in setStyles, the number of the arguments doesn't fit (" + style.length + " against " + this.getNumValues() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.setStyle(style[row * this.getNumColumns() + column]));
    }

    public void setStyles(Style[][] style) {
        if (style.length == 0) {
            throw new IllegalArgumentException("Error in setStyles, the array is empty");
        }
        if (style.length != this.getNumRows()) {
            throw new IllegalArgumentException("Error in setStyles, the number of rows doesn't fit (" + style.length + " against " + this.getNumRows() + ")");
        }
        if (style[0].length != this.getNumColumns()) {
            throw new IllegalArgumentException("Error in setStyles, the number of columns doesn't fit (" + style[0].length + " against " + this.getNumColumns() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.setStyle(style[row][column]));
    }

    public void setAnnotation(OfficeAnnotation annotation) {
        this.iterateRange((cell, row, column) -> cell.setAnnotation(annotation));
    }

    public void setAnnotations(OfficeAnnotation ... annotations) {
        if (annotations.length != this.getNumValues()) {
            throw new IllegalArgumentException("Error in setAnnotations, the number of the arguments doesn't fit (" + annotations.length + " against " + this.getNumValues() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.setAnnotation(annotations[row * this.getNumColumns() + column]));
    }

    public void setAnnotations(OfficeAnnotation[][] annotations) {
        if (annotations.length == 0) {
            throw new IllegalArgumentException("Error in setAnnotations, the array is empty");
        }
        if (annotations.length != this.getNumRows()) {
            throw new IllegalArgumentException("Error in setAnnotations, the number of rows doesn't fit (" + annotations.length + " against " + this.getNumRows() + ")");
        }
        if (annotations[0].length != this.getNumColumns()) {
            throw new IllegalArgumentException("Error in setAnnotations, the number of columns doesn't fit (" + annotations[0].length + " against " + this.getNumColumns() + ")");
        }
        this.iterateRange((cell, row, column) -> cell.setAnnotation(annotations[row][column]));
    }

    public void merge() {
        if (this.getNumValues() <= 1) {
            return;
        }
        if (this.isPartOfMerge()) {
            throw new AssertionError((Object)"Error, one of the cells is already on a group");
        }
        Vector cord = new Vector(this.getRow(), this.getColumn());
        Vector length = new Vector(this.getNumRows(), this.getNumColumns());
        Cell firstCell = this.sheet.getCell(this.row_init, this.column_init);
        GroupCell groupCell = new GroupCell(cord, length, firstCell);
        this.iterateRange((cell, row, column) -> cell.setGroup(groupCell));
    }

    private boolean rowInRange(int row) {
        return row >= this.getRow() && row <= this.getLastRow();
    }

    private boolean columnsInrange(int column) {
        return column >= this.getColumn() && column <= this.getLastColumn();
    }

    public void split() {
        Range[] groupRange;
        for (Range range : groupRange = this.getMergedCells()) {
            if (!this.rowInRange(range.getRow()) || !this.rowInRange(range.getLastRow())) {
                throw new IllegalArgumentException("All the combined cells must be inside the range. The row interval (" + range.getRow() + " - " + range.getLastRow() + ") is not fully included");
            }
            if (this.columnsInrange(range.getColumn()) && this.columnsInrange(range.getLastColumn())) continue;
            throw new IllegalArgumentException("All the combined cells must be inside the range. The column interval (" + range.getColumn() + " , " + range.getLastColumn() + ") is not fully included");
        }
        for (Range range : groupRange) {
            for (int i = 0; i < range.getNumRows(); ++i) {
                for (int j = 0; j < range.getNumColumns(); ++j) {
                    Cell cell = this.sheet.getCell(range.getRow() + i, range.getColumn() + j);
                    if (i > 0 || j > 0) {
                        cell.clear();
                    }
                    cell.setGroup(null);
                }
            }
        }
    }

    public boolean isPartOfMerge() {
        return this.getMergedCells().length > 0;
    }
}

