/*
 * Decompiled with CFR 0.152.
 */
package internal.text.base.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataHierarchy;
import jdplus.toolkit.base.tsp.stream.DataSetTs;
import jdplus.toolkit.base.tsp.stream.HasTsStream;
import jdplus.toolkit.base.tsp.util.DataSetConversion;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import jdplus.toolkit.base.tsp.util.ImmutableValueFactory;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class XmlSupport
implements HasDataHierarchy,
HasTsStream {
    @NonNull
    private final String providerName;
    @NonNull
    private final ImmutableValueFactory<List<TsCollection>> xml;
    @NonNull
    private final DataSetConversion<List<TsCollection>, Integer> collectionIndex;
    @NonNull
    private final DataSetConversion<List<TsCollection>, Integer> seriesIndex;

    @NonNull
    public List<DataSet> children(@NonNull DataSource dataSource) throws IllegalArgumentException, IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        List data = (List)this.xml.load(dataSource);
        DataSet.Converter collectionParam = this.collectionIndex.getConverter((Object)data);
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.COLLECTION);
        return IntStream.range(0, data.size()).mapToObj(index -> {
            collectionParam.set(builder, (Object)index);
            return builder.build();
        }).collect(Collectors.toList());
    }

    @NonNull
    public List<DataSet> children(@NonNull DataSet parent) throws IllegalArgumentException, IOException {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)parent);
        List list = (List)this.xml.load(parent.getDataSource());
        DataSet.Converter collectionParam = this.collectionIndex.getConverter((Object)list);
        DataSet.Converter seriesParam = this.seriesIndex.getConverter((Object)list);
        int collection = (Integer)collectionParam.get(parent);
        TsCollection data = (TsCollection)list.get(collection);
        DataSet.Builder builder = DataSet.builder((DataSource)parent.getDataSource(), (DataSet.Kind)DataSet.Kind.SERIES);
        collectionParam.set(builder, (Object)collection);
        return IntStream.range(0, data.size()).mapToObj(series -> {
            seriesParam.set(builder, (Object)series);
            return builder.build();
        }).collect(Collectors.toList());
    }

    @NonNull
    public Stream<DataSetTs> getData(@NonNull DataSource dataSource, @NonNull TsInformationType type) throws IllegalArgumentException, IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        List data = (List)this.xml.load(dataSource);
        DataSet.Converter collectionParam = this.collectionIndex.getConverter((Object)data);
        DataSet.Converter seriesParam = this.seriesIndex.getConverter((Object)data);
        Stream<DataSetTs> result = IntStream.range(0, data.size()).mapToObj(Integer::valueOf).flatMap(collection -> IntStream.range(0, ((TsCollection)data.get((int)collection)).size()).mapToObj(series -> XmlSeries.of(collection, series, data)));
        return result.map(this.getMapper(dataSource, (DataSet.Converter<Integer>)collectionParam, (DataSet.Converter<Integer>)seriesParam));
    }

    @NonNull
    public Stream<DataSetTs> getData(@NonNull DataSet dataSet, @NonNull TsInformationType type) throws IllegalArgumentException, IOException {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSet.getDataSource());
        List data = (List)this.xml.load(dataSet.getDataSource());
        DataSet.Converter collectionParam = this.collectionIndex.getConverter((Object)data);
        DataSet.Converter seriesParam = this.seriesIndex.getConverter((Object)data);
        int collection = (Integer)collectionParam.get(dataSet);
        Stream<XmlSeries> result = IntStream.range(0, ((TsCollection)data.get(collection)).size()).filter(this.getFilter(dataSet, (DataSet.Converter<Integer>)seriesParam)).mapToObj(series -> XmlSeries.of(collection, series, data));
        return result.map(this.getMapper(dataSet.getDataSource(), (DataSet.Converter<Integer>)collectionParam, (DataSet.Converter<Integer>)seriesParam));
    }

    private IntPredicate getFilter(DataSet dataSet, DataSet.Converter<Integer> seriesParam) {
        switch (dataSet.getKind()) {
            case COLLECTION: {
                return index -> true;
            }
            case SERIES: {
                int series = (Integer)seriesParam.get(dataSet);
                return index -> index == series;
            }
        }
        return index -> false;
    }

    private Function<XmlSeries, DataSetTs> getMapper(DataSource dataSource, DataSet.Converter<Integer> collectionParam, DataSet.Converter<Integer> seriesParam) {
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        return xmlSeries -> {
            collectionParam.set(builder, (Object)xmlSeries.getCollection());
            seriesParam.set(builder, (Object)xmlSeries.getSeries());
            return new DataSetTs(builder.build(), xmlSeries.getName(), xmlSeries.getMeta(), xmlSeries.getData());
        };
    }

    @Generated
    private XmlSupport(@NonNull String providerName, @NonNull ImmutableValueFactory<List<TsCollection>> xml, @NonNull DataSetConversion<List<TsCollection>, Integer> collectionIndex, @NonNull DataSetConversion<List<TsCollection>, Integer> seriesIndex) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (xml == null) {
            throw new NullPointerException("xml is marked non-null but is null");
        }
        if (collectionIndex == null) {
            throw new NullPointerException("collectionIndex is marked non-null but is null");
        }
        if (seriesIndex == null) {
            throw new NullPointerException("seriesIndex is marked non-null but is null");
        }
        this.providerName = providerName;
        this.xml = xml;
        this.collectionIndex = collectionIndex;
        this.seriesIndex = seriesIndex;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull XmlSupport of(@NonNull String providerName, @NonNull ImmutableValueFactory<List<TsCollection>> xml, @NonNull DataSetConversion<List<TsCollection>, Integer> collectionIndex, @NonNull DataSetConversion<List<TsCollection>, Integer> seriesIndex) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (xml == null) {
            throw new NullPointerException("xml is marked non-null but is null");
        }
        if (collectionIndex == null) {
            throw new NullPointerException("collectionIndex is marked non-null but is null");
        }
        if (seriesIndex == null) {
            throw new NullPointerException("seriesIndex is marked non-null but is null");
        }
        return new XmlSupport(providerName, xml, collectionIndex, seriesIndex);
    }

    private static final class XmlSeries {
        private final int collection;
        private final int series;
        private final String name;
        private final Map<String, String> meta;
        private final TsData data;

        static XmlSeries of(int collectionIndex, int seriesIndex, List<TsCollection> data) {
            TsCollection col = data.get(collectionIndex);
            Ts ts = col.get(seriesIndex);
            return new XmlSeries(collectionIndex, seriesIndex, col.getName() + " - " + ts.getName(), ts.getMeta(), ts.getData());
        }

        @Generated
        public XmlSeries(int collection, int series, String name, Map<String, String> meta, TsData data) {
            this.collection = collection;
            this.series = series;
            this.name = name;
            this.meta = meta;
            this.data = data;
        }

        @Generated
        public int getCollection() {
            return this.collection;
        }

        @Generated
        public int getSeries() {
            return this.series;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Map<String, String> getMeta() {
            return this.meta;
        }

        @Generated
        public TsData getData() {
            return this.data;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XmlSeries)) {
                return false;
            }
            XmlSeries other = (XmlSeries)o;
            if (this.getCollection() != other.getCollection()) {
                return false;
            }
            if (this.getSeries() != other.getSeries()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, String> this$meta = this.getMeta();
            Map<String, String> other$meta = other.getMeta();
            if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
                return false;
            }
            TsData this$data = this.getData();
            TsData other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCollection();
            result = result * 59 + this.getSeries();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, String> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            TsData $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "XmlSupport.XmlSeries(collection=" + this.getCollection() + ", series=" + this.getSeries() + ", name=" + this.getName() + ", meta=" + String.valueOf(this.getMeta()) + ", data=" + String.valueOf(this.getData()) + ")";
        }
    }
}

