## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)
library(kableExtra)

## ----envir--------------------------------------------------------------------
tmpdr <- tempdir()
datdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
repfun::rs_setup(D_POP="SAFFL",D_POPLBL="Safety",
         D_POPDATA=repfun::adsl %>% dplyr::filter(SAFFL =='Y'), 
         D_SUBJID=c("STUDYID","USUBJID"), R_ADAMDATA=datdir)
repfun:::rfenv$G_POPDATA %>% dplyr::mutate(TRT01AN=ifelse(TRT01A=='Placebo',1,ifelse(TRT01A=='Xanomeline Low Dose',2,3))) %>%  
              repfun::ru_labels(varlabels=list('TRT01AN'='Actual Treatment for Period 01 (n)')) -> G_POPDATA

## ----update-------------------------------------------------------------------
adae <- repfun:::rfenv$adamdata$adae.rda() %>% dplyr::select(-SAFFL) %>% 
  repfun::ru_getdata(G_POPDATA, c("STUDYID", "USUBJID"), keeppopvars=c("TRT01AN", "TRT01A"))

## ----cntper-------------------------------------------------------------------
aesum_p <- repfun::ru_freq(adae,
                   dsetindenom=G_POPDATA,
                   countdistinctvars=c('STUDYID','USUBJID'),
                   groupbyvarsnumer=c('TRT01AN','TRT01A','AEBODSYS','AEDECOD'),
                   anyeventvars = c('AEBODSYS','AEDECOD'),
                   anyeventvalues = c('ANY EVENT','ANY EVENT'),
                   groupbyvarsdenom=c('TRT01AN'),
                   resultstyle="NUMERPCT",
                   totalforvar=c('TRT01AN'),
                   totalid=99,
                   totaldecode='Total',
                   codedecodevarpairs=c("TRT01AN", "TRT01A"),
                   varcodelistpairs=c(""),
                   codelistnames=list(),
                   resultpctdps=0) %>% repfun::ru_denorm(varstodenorm=c("tt_result", "PERCENT"), 
                                                 groupbyvars=c("tt_summarylevel", "AEBODSYS", "AEDECOD"), 
                                                 acrossvar="TRT01AN", acrossvarlabel="TRT01A", 
                                                 acrossvarprefix=c("tt_ac", "tt_p")) %>% 
                                       dplyr::mutate(ord1=ifelse(tt_summarylevel==0,0,1)) %>%              
                                       dplyr::rename(ord2=tt_summarylevel) %>% 
                                       dplyr::arrange(ord1,AEBODSYS,ord2,AEDECOD) %>%  
                                       dplyr::select(-c(starts_with('tt_p'),starts_with('ord')))

## ----stack--------------------------------------------------------------------
aesum_s <- repfun::ru_stackvar(dsetin=aesum_p,varsin=c('AEBODSYS','AEDECOD'),
                       varout='SYSPREF',sepc='/',splitc='~',
                       varlabel='Body System/Preferred Term')

## ----display------------------------------------------------------------------
lbls <- sapply(aesum_s,function(x){attr(x,"label")})
knitr::kable(head(aesum_s,10), col.names=paste(names(lbls),lbls,sep=": "), 
             caption = "Denormalized Data Set for Counts and Percents with Stacked Column") %>%  
  kable_styling(full_width = T) %>% column_spec(c(1,2,3), width_min = c('2in','2in','2in'))

