## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)
library(kableExtra)

## ----envir--------------------------------------------------------------------
tmpdr <- tempdir()
datdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
repfun::rs_setup(D_POP="SAFFL",D_POPLBL="Safety",
         D_POPDATA=repfun::adsl %>% dplyr::filter(SAFFL =='Y'), 
         D_SUBJID=c("STUDYID","USUBJID"), R_ADAMDATA=datdir)
repfun:::rfenv$G_POPDATA %>% mutate(TRT01AN=ifelse(TRT01A=='Placebo',1,ifelse(TRT01A=='Xanomeline Low Dose',2,3))) %>% 
  repfun::ru_labels(varlabels=list('TRT01AN'='Actual Treatment for Period 01 (n)')) -> G_POPDATA

## ----update-------------------------------------------------------------------
adae <- repfun:::rfenv$adamdata$adae.rda() %>% select(-SAFFL) %>% 
  repfun::ru_getdata(G_POPDATA, c("STUDYID", "USUBJID"), keeppopvars=c("TRT01AN", "TRT01A"))

## ----cntper-------------------------------------------------------------------
aesum_t <- repfun::ru_freq(adae,
                   dsetindenom=G_POPDATA,
                   countdistinctvars=c('STUDYID','USUBJID'),
                   groupbyvarsnumer=c('TRT01AN','TRT01A','AEBODSYS','AEDECOD'),
                   anyeventvars = c('AEBODSYS','AEDECOD'),
                   anyeventvalues = c('ANY EVENT','ANY EVENT'),
                   groupbyvarsdenom=c('TRT01AN'),
                   resultstyle="NUMERPCT",
                   totalforvar=c('TRT01AN'),
                   totalid=99,
                   totaldecode='Total',
                   codedecodevarpairs=c("TRT01AN", "TRT01A"),
                   resultpctdps=0) %>% repfun::ru_denorm(varstodenorm=c("tt_result", "PERCENT"), 
                                                 groupbyvars=c("tt_summarylevel", "AEBODSYS", "AEDECOD"), 
                                                 acrossvar="TRT01AN",
                                                 acrossvarlabel="TRT01A", acrossvarprefix=c("tt_ac", "tt_p")) %>% 
                                       arrange(tt_summarylevel, AEBODSYS, AEDECOD) %>%
                                       mutate(ord1=ifelse(tt_summarylevel==0,0,1)) %>% 
                                       rename(ord2=tt_summarylevel) %>% arrange(ord1,AEBODSYS,ord2,AEDECOD) %>%    
                                       select(-c(starts_with('tt_p'),starts_with('ord')))
#print(head(aesum_t,10))
#str(aesum_t)

## ----pagnum1------------------------------------------------------------------
#===========================
# Example 1: Simple paging.
#===========================
aesum_p1 <- repfun::ru_addpage(aesum_t,grpvars=c('AEBODSYS'),rowsprbdy=30) %>%
  mutate(Row_Number=row_number()) %>%
  repfun::ru_labels(varlabels=list('Row_Number'='DataFrame Row Number'))
lbls <- lapply(aesum_p1,function(x){attr(x,"label")})
knitr::kable(head(aesum_p1,10), col.names=paste(names(lbls),lbls,sep=": "),
             caption="Example 1: Simple Page Numbers Added to Dataframe using 30 Rows in Body of Report") %>%
  kable_styling(full_width = T) %>% column_spec(c(1,2), width_min = '3in')

## ----pagnum2------------------------------------------------------------------
#=======================================================================================================================
# Example 2: No splitvars, but 30 rows won't work for this data. (Which will revert to simple paging as in Example 1.)
#=======================================================================================================================
aesum_p2 <- repfun::ru_addpage(aesum_t,grpvars=c('AEBODSYS'),rowsprbdy=30,nosplitvars=TRUE) %>%
  mutate(Row_Number=row_number()) %>% repfun::ru_labels(varlabels=list('Row_Number'='DataFrame Row Number'))
lbls <- lapply(aesum_p2,function(x){attr(x,"label")})
knitr::kable(
  head(aesum_p2,10), col.names=paste(names(lbls),lbls,sep=": "),
  caption="Example 2: Add Paging to Dataframe with NoSplitVars when it Won't Work (Revert to Simple Paging)") %>%
  kable_styling(full_width = T) %>% column_spec(c(1,2), width_min ='3in')

## ----pagnum3------------------------------------------------------------------
#=============================================================================
# Example 3: NoSplitVars on AEBODSYS using 35 rows which works for this data.
#=============================================================================
aesum_p3 <- repfun::ru_addpage(aesum_t,grpvars=c('AEBODSYS'),rowsprbdy=35,nosplitvars=TRUE) %>%
  mutate(Row_Number=row_number()) %>% repfun::ru_labels(varlabels=list('Row_Number'='DataFrame Row Number'))
lbls <- lapply(aesum_p3,function(x){attr(x,"label")})
knitr::kable(
  head(aesum_p3,10), col.names=paste(names(lbls),lbls,sep=": "),
  caption = "Example 3: Add Paging to Dataframe with NoSplitVars when it Will Work using 35 Rows in Body of Report") %>%
  kable_styling(full_width = T) %>% column_spec(c(1,2), width_min ='3in')

