/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.ISearchLoop;

public abstract class AbstractSearchLoop
implements ISearchLoop {
    public final AbstractGlobalSearchStrategy searchStrategy;
    private int nodeCount;
    private int backtrackCount;
    private int restartCount;
    private int depthCount;
    protected boolean stop;

    public AbstractSearchLoop(AbstractGlobalSearchStrategy searchStrategy) {
        this.searchStrategy = searchStrategy;
    }

    @Override
    public final AbstractGlobalSearchStrategy getSearchStrategy() {
        return this.searchStrategy;
    }

    public final boolean isStopped() {
        return this.stop;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public final int getBacktrackCount() {
        return this.backtrackCount;
    }

    public final int getRestartCount() {
        return this.restartCount;
    }

    public final int getDepthCount() {
        return this.depthCount;
    }

    @Override
    public void initialize() {
        this.nodeCount = 0;
        this.backtrackCount = 0;
        this.restartCount = 0;
        this.depthCount = 0;
    }

    @Override
    public final Boolean run() {
        this.stop = false;
        this.initLoop();
        while (!this.stop) {
            switch (this.searchStrategy.nextMove) {
                case 1: {
                    ++this.nodeCount;
                    this.openNode();
                    break;
                }
                case 4: {
                    ++this.depthCount;
                    this.downBranch();
                    break;
                }
                case 2: {
                    if (this.searchStrategy.isTraceEmpty()) {
                        this.stop = true;
                        break;
                    }
                    --this.depthCount;
                    ++this.backtrackCount;
                    this.upBranch();
                    break;
                }
                case 8: {
                    ++this.restartCount;
                    this.restart();
                    this.depthCount = 0;
                    break;
                }
                case 0: {
                    this.initSearch();
                    break;
                }
                case 16: {
                    this.stop = true;
                }
            }
        }
        return this.endLoop();
    }

    public abstract void initLoop();

    public abstract void openNode();

    public abstract void upBranch();

    public abstract void downBranch();

    public abstract void restart();

    public abstract void initSearch();

    public abstract Boolean endLoop();
}

