## ----setup, message=FALSE, warning=FALSE, echo=FALSE--------------------------
set.seed(101)

library(ggdibbler)
library(ggplot2)
library(dplyr)
library(tibble)
library(patchwork)

# make prediction diamonds data
diamonds_pred <- smaller_diamonds
diamonds_pred$cut_pred <- smaller_uncertain_diamonds$cut
diamonds_pred <- diamonds_pred |> 
  rename("cut_true" = cut) |>
  relocate(c(cut_pred, cut_true), .before = carat)

options(rmarkdown.html_vignette.check_title = FALSE)

## -----------------------------------------------------------------------------
plot <- ggplot(uncertain_mtcars, aes(wt, mpg)) + geom_point_sample(times=5) 
plot + plot

## -----------------------------------------------------------------------------
p1 <- ggplot(mtcars, aes(wt, wt)) + geom_point()  +
  ggtitle("ggplot2")
p2 <- ggplot(uncertain_mtcars, aes(wt, wt)) + geom_point_sample(times=5) +
  ggtitle("ggdibbler")
p1 + p2

## -----------------------------------------------------------------------------
ggplot(uncertain_mtcars, aes(wt, after_stat(x))) + geom_point_sample(times=5) 

## -----------------------------------------------------------------------------
recent <- economics[economics$date > as.Date("2013-01-01"), ]
uncertain_recent <- uncertain_economics[uncertain_economics$date > as.Date("2013-01-01"), ]
p1 <- ggplot(recent, aes(date, unemploy)) + 
  geom_line() +
  geom_point() +
  ggtitle("ggplot2")
p2 <- ggplot(uncertain_recent, aes(date, unemploy)) + 
  geom_line_sample(alpha=0.5, seed=5)+ 
  geom_point_sample(alpha=0.5, seed=5) +
  ggtitle("ggdibbler")
p1 + p2

## -----------------------------------------------------------------------------
print(head(diamonds_pred))

## -----------------------------------------------------------------------------
ggplot(diamonds_pred, aes(x=cut_pred)) +
  geom_bar_sample(times=30)

## -----------------------------------------------------------------------------
ggplot(diamonds_pred, aes(x=cut_pred)) +
  geom_bar_sample(aes(fill=factor(after_stat(x)))) +
  labs(fill = "cut_pred")+
  scale_fill_brewer(palette = "Set1")

## -----------------------------------------------------------------------------

p1 <- ggplot(diamonds_pred, aes(x=cut_true)) +
  geom_bar() +
  ggtitle("No colour randomness")

p2 <- ggplot(diamonds_pred, aes(x=cut_true)) +
  geom_bar_sample(aes(fill= cut_pred), times=100, 
                  position= "stack_dodge") +
  scale_fill_brewer(palette = "Set1") +
  ggtitle("Random colour (dodge)")

p3 <- ggplot(diamonds_pred, aes(x=cut_true)) +
  geom_bar_sample(aes(fill= cut_pred), times=100, alpha=0.1,
                  position= "stack_identity") +
  scale_fill_brewer(palette = "Set1") +
  ggtitle("Random colour (identity)")

p2 | p3


## ----include=FALSE, eval=FALSE------------------------------------------------
# library(spelling)
# qmd <- "C_random-plots.Rmd"
# check_spelling <- spell_check_files(
#   qmd,
#   lang = "en_GB"
# )
# if (nrow(check_spelling) > 0) {
#   print(check_spelling)
#   stop("Check spelling in Qmd files!")
# }

