## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(NAPrior)

## ----install, eval=FALSE, include=TRUE----------------------------------------
# install.packages("devtools")
# devtools::install_github("EstravenZZZ/NAPrior")
# 

## ----include=TRUE-------------------------------------------------------------
library(NAPrior)

## ----tune_eNAP, echo=TRUE-----------------------------------------------------

tuned_ab <- tune_param_eNAP(
  y_C2C1=c(-0.4,-0.5,-0.5),
  s_EC2  = 0.12^2,                          # Var(E:C2)
  s_EC1  = 0.16^2,                          # Var(E:C1)
  s_C2C1 = c(0.12^2, 0.11^2, 0.15^2),       # vector => multiple external trials
  delta  = 0.5,                             # clinically meaningful difference on log-HR
  t1     = 0.999,                           # near full borrowing at Z = 0
  t0     = 0.05                             # near zero borrowing at Z(delta)
)
c(tuned_ab$a,tuned_ab$b)
plot(tuned_ab)

## ----NAP_example, echo=TRUE---------------------------------------------------
NAP_test1 <- NAP_prior(
  weight_mtd = "fixed", w = 1,            # w = 1 ⇒ informative component only (NAP)
  y_EC1  = -0.36, s_EC1  = 0.16^2,
  y_C2C1 = -0.30, s_C2C1 = 0.14^2       # single external → FE
)
NAP_test1$table
plot(NAP_test1)

## ----mNAP_example, echo=TRUE, warning=FALSE-----------------------------------
mNAP_test1 <- NAP_prior(
  weight_mtd = "fixed", w = 0.50,         # fixed mixture weight
  y_EC1  = -0.36, s_EC1  = 0.16^2,
  y_C2C1 = -0.30, s_C2C1 = 0.14^2,        # single external → FE
  tau0   = 1000
)
mNAP_test1$table
plot(mNAP_test1,main="mNAP prior")

## ----eNAP_example1, echo=TRUE-------------------------------------------------
eNAP_test1 <- NAP_prior(
  weight_mtd = "adaptive",
  a = tuned_ab$a, b = tuned_ab$b,         # from calibration
  y_EC1  = -0.36, s_EC1  = 0.16^2,                 # E:C1 (current, pre-change)
  y_C2C1 = c(-0.28, -0.35, -0.31),                 # C2:C1 (external trials)
  s_C2C1 = c(0.12^2, 0.11^2, 0.15^2),
  tau0   = 1000                                    # vague variance
)
eNAP_test1$table

## ----eNAP_example2, echo=TRUE, warning=FALSE----------------------------------
eNAP_test2 <- NAP_prior(
  weight_mtd = "adaptive",
  a = tuned_ab$a, b = tuned_ab$b,         # from calibration
  y_EC1  = -0.36, s_EC1  = 0.16^2,                 # E:C1 (current, pre-change)
  y_C2C1 = c(-0.28, -0.35, -0.31),                 # C2:C1 (external trials)
  s_C2C1 = c(0.12^2, 0.11^2, 0.15^2),
  y_EC2  = 0, s_EC2 = 0.2^2,
  tau0   = 1000                                    # vague variance
)
eNAP_test2$table
plot(eNAP_test2,main="eNAP prior")

## ----oc_example, echo=TRUE, message=FALSE-------------------------------------
set.seed(123)
# Run JAGS quietly
oc <- NULL
invisible(capture.output(
  oc <- NAP_oc(
    NAP_prior   = eNAP_test1,
    theta_EC2   = 0.00,                     # true log-HR for E:C2
    n_EC2       = 400,                      # total N for the post-SoC-change period
    lambda      = 1,                        # randomization ratio for the post-SoC-change period
    sim_model   = "Weibull",                # "Exponential" or "Weibull"
    model_param = c(shape = 1.2, rate = 0.05),
    nsim        = 100,
    iter        = 3000,
    chains      = 4
  ),
  type = "output"   # capture JAGS console output
))

# Now show only the summary in the knitted doc
summary(oc)

## ----conduct_example, echo=TRUE-----------------------------------------------
res <- NAP_posterior(
  NAP_prior = eNAP_test1,
  y_EC2     = -0.20,
  s_EC2     = 0.12^2,
  iter      = 4000,
  chains    = 4
)

res$posterior_sum   # mean, sd, 95% CI, prob_E_better, prior weight, post weight
res$enap_prior      # actual eNAP prior at analysis time with realized dynamic weight
# res$jags_fit is stored but does not print by default

