/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jebl.evolution.io.IllegalCharacterPolicy;
import jebl.evolution.io.ImmediateSequenceImporter;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.ImportHelper;
import jebl.evolution.io.SequenceImporter;
import jebl.evolution.sequences.BasicSequence;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.Utils;
import jebl.evolution.taxa.Taxon;
import jebl.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastaImporter
implements SequenceImporter,
ImmediateSequenceImporter {
    public static final String descriptionPropertyName = "description";
    private final ImportHelper helper;
    private final SequenceType sequenceType;
    private final boolean closeReaderAtEnd;
    private final Reader reader;
    private IllegalCharacterPolicy illegalCharacterPolicy = IllegalCharacterPolicy.abort;

    public FastaImporter(File file, SequenceType sequenceType) throws FileNotFoundException {
        this(new BufferedReader(new FileReader(file)), sequenceType, true);
        this.helper.setExpectedInputLength(file.length());
    }

    public void setIllegalCharacterPolicy(IllegalCharacterPolicy newPolicy) {
        this.illegalCharacterPolicy = newPolicy;
    }

    public FastaImporter(Reader reader, SequenceType sequenceType) {
        this(reader, sequenceType, false);
    }

    private FastaImporter(Reader reader, SequenceType sequenceType, boolean closeReaderAtEnd) {
        this.reader = reader;
        this.sequenceType = sequenceType;
        this.closeReaderAtEnd = closeReaderAtEnd;
        this.helper = new ImportHelper(reader);
        this.helper.setCommentDelimiters(';');
    }

    private List<Sequence> read(ImmediateSequenceImporter.Callback callback, ProgressListener progressListener) throws IOException, ImportException {
        ArrayList<Sequence> sequences = callback == null ? new ArrayList<Sequence>() : null;
        int fastaFirstChar = 62;
        String fasta1stCharAsString = new String(new char[]{'>'});
        SequenceType seqtypeForGapsAndMissing = this.sequenceType != null ? this.sequenceType : SequenceType.NUCLEOTIDE;
        final AtomicReference<IllegalCharacterPolicy> illegalCharacterPolicyForThisImport = new AtomicReference<IllegalCharacterPolicy>(this.illegalCharacterPolicy);
        try {
            while (this.helper.read() != '>') {
            }
            do {
                SequenceType type;
                String line = this.helper.readLine();
                StringTokenizer tokenizer = new StringTokenizer(line, " \t");
                String name = ImportHelper.convertControlsChars(tokenizer.nextToken());
                String description = tokenizer.hasMoreElements() ? ImportHelper.convertControlsChars(tokenizer.nextToken("")) : null;
                StringBuilder seq = new StringBuilder();
                this.helper.readSequence(seq, seqtypeForGapsAndMissing, fasta1stCharAsString, Integer.MAX_VALUE, "-", "?", "", null, progressListener);
                if (progressListener.isCanceled()) {
                    break;
                }
                Taxon taxon = Taxon.getTaxon(name);
                if (description != null && description.length() > 0) {
                    taxon.setAttribute(descriptionPropertyName, description);
                }
                SequenceType sequenceType = type = this.sequenceType != null ? this.sequenceType : Utils.guessSequenceType(seq);
                if (type == null) {
                    final String errorMessage = "Illegal sequence characters encountered on or before line " + this.helper.getLineNumber() + ".";
                    if (illegalCharacterPolicyForThisImport.get().equals((Object)IllegalCharacterPolicy.askUser)) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    IllegalCharacterPolicy[] options = new IllegalCharacterPolicy[]{IllegalCharacterPolicy.abort, IllegalCharacterPolicy.strip};
                                    int choice = JOptionPane.showOptionDialog(null, errorMessage + " What do you want to do?", "Illegal characters in sequences", 0, 2, null, (Object[])options, (Object)options[0]);
                                    illegalCharacterPolicyForThisImport.set(options[choice]);
                                }
                            });
                            if (illegalCharacterPolicyForThisImport.equals((Object)IllegalCharacterPolicy.abort)) {
                                ArrayList<Sequence> arrayList = sequences;
                                return arrayList;
                            }
                        }
                        catch (InterruptedException e) {
                            illegalCharacterPolicyForThisImport.set(IllegalCharacterPolicy.abort);
                        }
                        catch (InvocationTargetException e) {
                            illegalCharacterPolicyForThisImport.set(IllegalCharacterPolicy.abort);
                        }
                    }
                    switch (illegalCharacterPolicyForThisImport.get()) {
                        case strip: {
                            FastaImporter.removeNonAminoAcidOrNucleotideCharacters(seq);
                            type = Utils.guessSequenceType(seq);
                            if (type == null) {
                                throw new ImportException("The file contains both residues that are only nucleotides (e.g. U) and residues that are only amino acids (e.g. E). You should import the file using file type 'Fasta (nucleotide)' or 'Fasta (amino acid)' instead of 'Fasta (auto-detect)'.");
                            }
                            assert (type != null);
                            break;
                        }
                        default: {
                            throw new ImportException(errorMessage);
                        }
                    }
                }
                BasicSequence sequence = new BasicSequence(type, taxon, seq);
                seq.setLength(0);
                seq.trimToSize();
                if (description != null && description.length() > 0) {
                    sequence.setAttribute(descriptionPropertyName, description);
                }
                if (callback != null) {
                    callback.add(sequence);
                    continue;
                }
                sequences.add(sequence);
            } while (!progressListener.isCanceled() && this.helper.getLastDelimiter() == 62);
        }
        catch (EOFException e) {
        }
        catch (NoSuchElementException e) {
            throw new ImportException("Incorrectly formatted fasta file (near line " + this.helper.getLineNumber() + ")");
        }
        finally {
            if (this.closeReaderAtEnd && this.reader != null) {
                this.reader.close();
            }
        }
        return sequences;
    }

    static void removeNonAminoAcidOrNucleotideCharacters(StringBuilder sequence) {
        StringBuilder result = new StringBuilder();
        int writeIndex = 0;
        for (int readIndex = 0; readIndex < sequence.length(); ++readIndex) {
            char c = sequence.charAt(readIndex);
            if (SequenceType.AMINO_ACID.getState(c) == null && SequenceType.NUCLEOTIDE.getState(c) == null) continue;
            sequence.setCharAt(writeIndex, c);
            ++writeIndex;
        }
        sequence.setLength(writeIndex);
    }

    @Override
    public final List<Sequence> importSequences() throws IOException, ImportException {
        return this.read(null, ProgressListener.EMPTY);
    }

    @Override
    public void importSequences(ImmediateSequenceImporter.Callback callback, ProgressListener progressListener) throws IOException, ImportException {
        this.read(callback, progressListener);
    }
}

