/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Statistic;
import dr.inference.model.StatisticList;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class StatisticParser
extends AbstractXMLObjectParser {
    public static final String STATISTIC = "statistic";
    public static final String NAME = "name";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("name", "The name of the statistic you wish to extract from the given object"), new ElementRule(StatisticList.class)};

    @Override
    public String getParserName() {
        return STATISTIC;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        String string;
        StatisticList statisticList = (StatisticList)xMLObject.getChild(StatisticList.class);
        Statistic statistic = statisticList.getStatistic(string = xMLObject.getStringAttribute(NAME));
        if (statistic == null) {
            StringBuffer stringBuffer = new StringBuffer("Unknown statistic name, " + string + "\n");
            stringBuffer.append("Valid statistics are:");
            for (int i = 0; i < statisticList.getStatisticCount(); ++i) {
                stringBuffer.append("\n  ").append(statisticList.getStatistic(i).getStatisticName());
            }
            throw new XMLParseException(stringBuffer.toString());
        }
        return statistic;
    }

    @Override
    public String getParserDescription() {
        return "A statistic of a given name from the specified object.  ";
    }

    @Override
    public Class getReturnType() {
        return Statistic.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

