/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.eigen;

import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.EigenSystem;
import dr.evomodel.substmodel.eigen.EigenJNIWrapper;
import java.util.Arrays;

public class Eigen3EigenSystem
implements EigenSystem {
    private final int stateCount;
    private final EigenJNIWrapper eigenJNIWrapper;

    public Eigen3EigenSystem(int n) {
        this.stateCount = n;
        this.eigenJNIWrapper = new EigenJNIWrapper();
        this.eigenJNIWrapper.createInstance(1, n);
    }

    @Override
    public EigenDecomposition decomposeMatrix(double[][] dArray) {
        int n = dArray.length;
        int[] nArray = new int[2 * n * n];
        double[] dArray2 = new double[n * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = dArray[i][j];
                if (d == 0.0) continue;
                nArray[2 * n2] = i;
                nArray[2 * n2 + 1] = j;
                dArray2[n2] = d;
                ++n2;
            }
        }
        this.eigenJNIWrapper.setMatrix(0, nArray, dArray2, n2);
        double[] dArray3 = new double[2 * n];
        double[] dArray4 = new double[2 * n * n];
        double[] dArray5 = new double[2 * n * n];
        this.eigenJNIWrapper.getEigenDecomposition(0, dArray3, dArray4, dArray5);
        return new EigenDecomposition(dArray4, dArray5, dArray3);
    }

    @Override
    public void computeExponential(EigenDecomposition eigenDecomposition, double d, double[] dArray) {
        int n;
        double d2;
        int n2;
        if (eigenDecomposition == null) {
            Arrays.fill(dArray, 0.0);
            return;
        }
        double[] dArray2 = eigenDecomposition.getEigenVectors();
        double[] dArray3 = eigenDecomposition.getEigenValues();
        double[] dArray4 = new double[this.stateCount];
        System.arraycopy(dArray3, this.stateCount, dArray4, 0, this.stateCount);
        double[] dArray5 = eigenDecomposition.getInverseEigenVectors();
        double[][] dArray6 = new double[this.stateCount][this.stateCount];
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            if (dArray4[n2] == 0.0) {
                d2 = Math.exp(d * dArray3[n2]);
                for (n = 0; n < this.stateCount; ++n) {
                    dArray6[n2][n] = dArray5[n2 * this.stateCount + n] * d2;
                }
                continue;
            }
            n = n2 + 1;
            double d3 = dArray4[n2];
            double d4 = Math.exp(d * dArray3[n2]);
            double d5 = d4 * Math.cos(d * d3);
            double d6 = d4 * Math.sin(d * d3);
            for (int i = 0; i < this.stateCount; ++i) {
                dArray6[n2][i] = d5 * dArray5[n2 * this.stateCount + i] + d6 * dArray5[n * this.stateCount + i];
                dArray6[n][i] = d5 * dArray5[n * this.stateCount + i] - d6 * dArray5[n2 * this.stateCount + i];
            }
            ++n2;
        }
        n2 = 0;
        for (n = 0; n < this.stateCount; ++n) {
            for (int i = 0; i < this.stateCount; ++i) {
                d2 = 0.0;
                for (int j = 0; j < this.stateCount; ++j) {
                    d2 += dArray2[n * this.stateCount + j] * dArray6[j][i];
                }
                dArray[n2] = Math.abs(d2);
                ++n2;
            }
        }
    }

    @Override
    public double computeExponential(EigenDecomposition eigenDecomposition, double d, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }
}

