/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.IntervalList;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.CoalescentIntervalProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;

public abstract class AbstractCoalescentLikelihood
extends AbstractModelLikelihood
implements Units,
CoalescentIntervalProvider {
    protected IntervalList intervalList = null;
    protected double logLikelihood;
    protected double storedLogLikelihood;
    protected boolean likelihoodKnown = false;
    protected boolean storedLikelihoodKnown = false;
    protected boolean intervalsKnown = false;
    protected boolean storedIntervalsKnown = false;

    public AbstractCoalescentLikelihood(String string, IntervalList intervalList) {
        super(string);
        this.intervalList = intervalList;
        this.addStatistic(new DeltaStatistic());
        if (intervalList instanceof Model) {
            this.addModel((Model)((Object)intervalList));
        }
    }

    protected AbstractCoalescentLikelihood(String string) {
        super(string);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
        if (model instanceof IntervalList) {
            this.intervalsKnown = false;
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
        this.storedIntervalsKnown = this.intervalsKnown;
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        this.intervalsKnown = this.storedIntervalsKnown;
    }

    @Override
    protected final void acceptState() {
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    protected abstract double calculateLogLikelihood();

    public IntervalList getIntervalList() {
        return this.intervalList;
    }

    @Override
    public String toString() {
        return Double.toString(this.logLikelihood);
    }

    public class DeltaStatistic
    extends Statistic.Abstract {
        public DeltaStatistic() {
            super("delta");
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            throw new RuntimeException("Not implemented");
        }
    }
}

