## This demo will show you how to annotate a summary statistics file
##
##
library(seqminer)


## Step 1: Download annotate resources file, including reference genome, gene definition et al.
## In the demo, these resources will be downloaded to "~/seqminer.annotation"
pause <- readline("Hit ENTER to continue...")

download.annotation.resource("~/seqminer.annotation")
## When this step finishes, it will prompt you an R command to prepare annotation parameter, like below:
param <- makeAnnotationParameter(list(reference = "~/seqminer.annotation/hs37d5.fa", geneFile = "~/seqminer.annotation/refFlat_hg19.txt.gz", codonFile = "~/seqminer.annotation/codon.txt", priorityFile = "~/seqminer.annotation/priority.txt" ))

pause <- readline("Hit ENTER to continue...")


## Step 2: Annotate summary statistics file
## Here we assume a summary statistics files "rvtest.MetaScore.assoc.gz" generated by RVTESTS
summary.file <- system.file("rvtests/rvtest.MetaScore.assoc.gz", package = "seqminer")
## Define your output file name and start annotating:
out.file <- system.file("rvtests/rvtest.MetaScore.assoc.anno.gz", package = "seqminer")
annotatePlain(summary.file, out.file, param)
pause <- readline("Hit ENTER to continue...")

## Step 3: You can freely extract summary statistics now.
stats <- rvmeta.readScoreByRange(score.file,
                                    "1:196621000-196623000")
print(stats)
pause <- readline("Hit ENTER to quit...")


## Thanks for using seqminer
## You can send feedbacks/comments to:
##   Xiaowei Zhan <zhanxw@gmail.com> and
##   Dajiang Liu <dajiang.liu@psu.edu>
## More documentations
##   http://zhanxw.com/seqminer/

