/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import jdplus.toolkit.base.tsp.TsMeta;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;

public final class DefaultTsMeta<T>
implements TsMeta<T> {
    @NonNull
    private final String key;
    @NonNull
    private final Parser<T> parser;
    @NonNull
    private final Formatter<T> formatter;

    @Override
    public T load(@NonNull Map<String, String> meta) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        return this.load(meta::get);
    }

    @Override
    public T load(@NonNull Function<String, String> meta) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        String text = meta.apply(this.key);
        return (T)(text != null ? this.parser.parse((CharSequence)text) : null);
    }

    @Override
    public void store(@NonNull Map<String, String> meta, @NonNull T value) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.store(meta::put, value);
    }

    @Override
    public void store(@NonNull BiConsumer<String, String> meta, @NonNull T value) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String text = this.formatter.formatAsString(value);
        meta.accept(this.key, text);
    }

    @Generated
    public DefaultTsMeta(@NonNull String key, @NonNull Parser<T> parser, @NonNull Formatter<T> formatter) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        this.key = key;
        this.parser = parser;
        this.formatter = formatter;
    }

    @Override
    @NonNull
    @Generated
    public String getKey() {
        return this.key;
    }
}

