/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.Collections;
import java.util.List;
import jdplus.sa.base.api.diagnostics.CombinedSeasonalityTest;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityTests;
import jdplus.sa.base.core.diagnostics.GenericSaTests;
import jdplus.sa.base.core.tests.CombinedSeasonality;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.ProcQuality;

public class CombinedSeasonalityDiagnostics
implements Diagnostics {
    private CombinedSeasonality sa;
    private CombinedSeasonality saLast;
    private CombinedSeasonality irr;
    private CombinedSeasonality irrLast;
    private boolean strict;

    public static CombinedSeasonalityDiagnostics of(CombinedSeasonalityDiagnosticsConfiguration config, GenericSaTests data) {
        if (data == null) {
            return null;
        }
        try {
            CombinedSeasonalityDiagnostics diag = new CombinedSeasonalityDiagnostics();
            CombinedSeasonalityTests cs = data.combinedSeasonalityTests();
            if (cs == null) {
                return null;
            }
            if (config.isOnSa()) {
                diag.sa = cs.saTest(false);
            }
            if (config.isOnLastSa()) {
                diag.saLast = cs.saTest(true);
            }
            if (config.isOnI()) {
                diag.irr = cs.irrTest(false);
            }
            if (config.isOnLastI()) {
                diag.irrLast = cs.irrTest(true);
            }
            diag.strict = config.isStrict();
            return diag;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getName() {
        return "Combined seasonality tests";
    }

    public List<String> getTests() {
        return CombinedSeasonalityDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        switch (test) {
            case "Combined seasonality tests on sa": {
                return this.quality(this.sa);
            }
            case "Combined seasonality tests on sa (last years)": {
                return this.quality(this.saLast);
            }
            case "Combined seasonality tests on irregular": {
                return this.quality(this.irr);
            }
            case "Combined seasonality tests on irregular (last years)": {
                return this.quality(this.irrLast);
            }
        }
        throw new IllegalArgumentException(test);
    }

    public double getValue(String test) {
        return Double.NaN;
    }

    private ProcQuality quality(CombinedSeasonality q) {
        if (q == null) {
            return ProcQuality.Undefined;
        }
        return switch (q.getSummary()) {
            case CombinedSeasonalityTest.IdentifiableSeasonality.None -> ProcQuality.Good;
            case CombinedSeasonalityTest.IdentifiableSeasonality.ProbablyNone -> ProcQuality.Uncertain;
            default -> this.strict ? ProcQuality.Severe : ProcQuality.Bad;
        };
    }

    public List<String> getWarnings() {
        return Collections.emptyList();
    }
}

