/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.fixme;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import jdplus.toolkit.base.tsp.fixme.Strings;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class Substitutor {
    @NonNull
    private final Function<? super String, ? extends Object> mapper;
    @NonNull
    private final String prefix;
    @NonNull
    private final String suffix;

    @NonNull
    public static Substitutor of(@NonNull Map<? super String, ? extends Object> mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        return Substitutor.builder().mapper(mapper::get).build();
    }

    @NonNull
    public static Substitutor of(@NonNull Function<? super String, ? extends Object> mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        return Substitutor.builder().mapper(mapper).build();
    }

    @NonNull
    public static Substitutor ofBean(@NonNull Object bean) throws IntrospectionException {
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        return Substitutor.builder().mapper(Substitutor.mapperOfBean(bean)).build();
    }

    public static Builder builder() {
        return new Builder().prefix("${").suffix("}");
    }

    @NonNull
    public String replace(@NonNull CharSequence input) {
        Objects.requireNonNull(input);
        if (this.isBlank(input)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        try {
            this.fill(input, result);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return result.toString();
    }

    public void replaceInto(@NonNull CharSequence input, @NonNull Appendable output) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(output);
        if (this.isBlank(input)) {
            return;
        }
        this.fill(input, output);
    }

    public void replaceInto(@NonNull CharSequence input, @NonNull StringBuilder output) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(output);
        if (this.isBlank(input)) {
            return;
        }
        try {
            this.fill(input, output);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isBlank(CharSequence input) {
        return input.length() < this.prefix.length() + this.suffix.length();
    }

    private void fill(@NonNull CharSequence input, @NonNull Appendable output) throws IOException {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        int start = 0;
        int end = 0;
        State state = State.TEXT;
        Strings.CharMatcher prefixMatcher = Strings.CharMatcher.of(this.prefix);
        Strings.CharMatcher suffixMatcher = Strings.CharMatcher.of(this.suffix);
        while (end < input.length()) {
            switch (state.ordinal()) {
                case 0: {
                    if (prefixMatcher.matches(input, end)) {
                        output.append(input, start, end);
                        start = end += this.prefix.length();
                        state = State.VAR;
                        break;
                    }
                    ++end;
                    break;
                }
                case 1: {
                    if (suffixMatcher.matches(input, end)) {
                        String key = input.subSequence(start, end).toString();
                        Object value = this.mapper.apply(key);
                        output.append(value != null ? value.toString() : null);
                        start = end += this.suffix.length();
                        state = State.TEXT;
                        break;
                    }
                    ++end;
                }
            }
        }
        switch (state.ordinal()) {
            case 0: {
                if (start >= end) break;
                output.append(input, start, end);
                break;
            }
            case 1: {
                output.append(this.prefix);
                if (start >= end) break;
                output.append(input, start, end);
            }
        }
    }

    private static Function<String, Object> mapperOfBean(final Object bean) throws IntrospectionException {
        final PropertyDescriptor[] properties = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors();
        return new Function<String, Object>(){

            @Override
            public Object apply(String o) {
                for (PropertyDescriptor property : properties) {
                    if (!property.getName().equals(o)) continue;
                    Method reader = property.getReadMethod();
                    if (reader != null) {
                        try {
                            return reader.invoke(bean, new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                            return null;
                        }
                    }
                    return null;
                }
                return null;
            }
        };
    }

    @Generated
    Substitutor(@NonNull Function<? super String, ? extends Object> mapper, @NonNull String prefix, @NonNull String suffix) {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        this.mapper = mapper;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @NonNull
    @Generated
    public Function<? super String, ? extends Object> getMapper() {
        return this.mapper;
    }

    @NonNull
    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @NonNull
    @Generated
    public String getSuffix() {
        return this.suffix;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Substitutor)) {
            return false;
        }
        Substitutor other = (Substitutor)o;
        Function<? super String, ? extends Object> this$mapper = this.getMapper();
        Function<? super String, ? extends Object> other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function<? super String, ? extends Object> $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "Substitutor(mapper=" + String.valueOf(this.getMapper()) + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private Function<? super String, ? extends Object> mapper;
        @Generated
        private String prefix;
        @Generated
        private String suffix;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder mapper(@NonNull Function<? super String, ? extends Object> mapper) {
            if (mapper == null) {
                throw new NullPointerException("mapper is marked non-null but is null");
            }
            this.mapper = mapper;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder prefix(@NonNull String prefix) {
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            this.prefix = prefix;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder suffix(@NonNull String suffix) {
            if (suffix == null) {
                throw new NullPointerException("suffix is marked non-null but is null");
            }
            this.suffix = suffix;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Substitutor build() {
            return new Substitutor(this.mapper, this.prefix, this.suffix);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "Substitutor.Builder(mapper=" + String.valueOf(this.mapper) + ", prefix=" + this.prefix + ", suffix=" + this.suffix + ")";
        }
    }

    private static enum State {
        TEXT,
        VAR;

    }
}

