/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifdef H5_HAVE_C11_THREADS

#define H5TS_cond_wait(cond, mutex) (H5_UNLIKELY(cnd_wait((cond), (mutex)) != thrd_success) ? FAIL : SUCCEED)
#define H5TS_cond_signal(cond)      (H5_UNLIKELY(cnd_signal(cond) != thrd_success) ? FAIL : SUCCEED)
#define H5TS_cond_broadcast(cond)   (H5_UNLIKELY(cnd_broadcast(cond) != thrd_success) ? FAIL : SUCCEED)

#else
#ifdef H5_HAVE_WIN_THREADS

#define H5TS_cond_wait(cond, mutex)                                                                          \
    (H5_UNLIKELY(!SleepConditionVariableCS(cond, mutex, INFINITE)) ? FAIL : SUCCEED)

static inline herr_t
H5TS_cond_signal(H5TS_cond_t *cond)
{
    WakeConditionVariable(cond);

    return SUCCEED;
} 

static inline herr_t
H5TS_cond_broadcast(H5TS_cond_t *cond)
{
    WakeAllConditionVariable(cond);

    return SUCCEED;
} 
#else

#define H5TS_cond_wait(cond, mutex) (H5_UNLIKELY(pthread_cond_wait((cond), (mutex))) ? FAIL : SUCCEED)
#define H5TS_cond_signal(cond)      (H5_UNLIKELY(pthread_cond_signal(cond)) ? FAIL : SUCCEED)
#define H5TS_cond_broadcast(cond)   (H5_UNLIKELY(pthread_cond_broadcast(cond)) ? FAIL : SUCCEED)

#endif
#endif
