/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.javaGD;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.rosuda.javaGD.GDObject;
import org.rosuda.javaGD.GDState;

class GDRaster
extends GDObject {
    boolean interpolate;
    Image image;
    AffineTransform atrans;

    public GDRaster(byte[] byArray, int n, int n2, double d, double d2, double d3, double d4, double d5, boolean bl) {
        this.interpolate = bl;
        this.atrans = new AffineTransform();
        d2 += d4;
        d4 = -d4;
        double d6 = d3 / (double)n;
        double d7 = d4 / (double)n2;
        this.atrans.translate(d, d2);
        this.atrans.rotate(-d5 / 180.0 * Math.PI, 0.0, d2);
        this.atrans.scale(d6, d7);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n * n2, 0);
        int[] nArray = new int[]{0, 1, 2, 3};
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n, n2, 4, n * 4, nArray);
        WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBufferByte, null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        this.image = new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Component component, GDState gDState, Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolate ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            graphics2D.drawImage(this.image, this.atrans, null);
        }
        finally {
            if (object != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            }
        }
    }
}

