/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import java.util.Arrays;

public class FloatVariableAxis
implements FloatIAxis {
    private static final long serialVersionUID = 1L;
    protected float min;
    protected int bins;
    protected float[] edges;

    public FloatVariableAxis(float[] fArray) {
        if (fArray.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < fArray.length - 1; ++i) {
            if (!(fArray[i + 1] <= fArray[i])) continue;
            throw new IllegalArgumentException("edges must be sorted ascending and must not contain multiple identical values");
        }
        this.min = fArray[0];
        this.bins = fArray.length - 1;
        this.edges = (float[])fArray.clone();
    }

    public float binCentre(int n) {
        return (this.binLowerEdge(n) + this.binUpperEdge(n)) / 2.0f;
    }

    public float binLowerEdge(int n) {
        if (n == -2) {
            return Float.NEGATIVE_INFINITY;
        }
        if (n == -1) {
            return this.upperEdge();
        }
        return this.edges[n];
    }

    public int bins() {
        return this.bins;
    }

    public float binUpperEdge(int n) {
        if (n == -2) {
            return this.lowerEdge();
        }
        if (n == -1) {
            return Float.POSITIVE_INFINITY;
        }
        return this.edges[n + 1];
    }

    public float binWidth(int n) {
        return this.binUpperEdge(n) - this.binLowerEdge(n);
    }

    public int coordToIndex(float f) {
        if (f < this.min) {
            return -2;
        }
        int n = Arrays.binarySearch(this.edges, f);
        if (n < 0) {
            n = -n - 1 - 1;
        }
        if (n >= this.bins) {
            return -1;
        }
        return n;
    }

    public float lowerEdge() {
        return this.min;
    }

    protected static String toString(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = fArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(fArray[i]);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public float upperEdge() {
        return this.edges[this.edges.length - 1];
    }
}

