/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.ChartButton;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.style.XYStyler;

public class ChartZoom
extends MouseAdapter
implements ChartPart,
ActionListener {
    protected final XChartPanel<XYChart> xChartPanel;
    protected final XYChart xyChart;
    protected Rectangle bounds;
    protected final ChartButton resetButton;
    protected int x1 = -1;
    protected int x2 = -1;
    protected boolean filtered;

    public ChartZoom(XYChart xyChart, XChartPanel<XYChart> xChartPanel, String resetString) {
        this.xChartPanel = xChartPanel;
        this.xyChart = xyChart;
        xyChart.plot.plotContent.setChartZoom(this);
        this.resetButton = new ChartButton(xyChart, xChartPanel, resetString);
        this.resetButton.addActionListener(this);
        this.resetButton.setVisible(false);
    }

    protected void resetZoom() {
        this.resetFilter();
        this.filtered = false;
        this.resetButton.setVisible(false);
        this.x1 = -1;
        this.x2 = -1;
        this.repaint();
    }

    private void repaint() {
        this.xChartPanel.invalidate();
        this.xChartPanel.repaint();
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.resetButton.visible && (this.x1 == -1 || this.x2 == -1)) {
            this.resetButton.paint(g);
        } else {
            if (this.x1 == -1 || this.x2 == -1) {
                return;
            }
            g.setColor(((XYStyler)this.xyChart.getStyler()).getZoomSelectionColor());
            int xStart = Math.min(this.x1, this.x2);
            int width = Math.abs(this.x1 - this.x2);
            this.bounds = g.getClipBounds();
            g.fillRect(xStart, 0, width, (int)((double)this.bounds.height + this.bounds.getY()));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.x1 = e.getX();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.x2 = e.getX();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isOverlapping()) {
            this.x1 = -1;
            this.x2 = -1;
            return;
        }
        if (this.bounds != null && this.x2 != -1) {
            int bigPoint;
            int smallPoint;
            if (this.x2 < this.x1) {
                smallPoint = this.x2;
                bigPoint = this.x1;
            } else {
                smallPoint = this.x1;
                bigPoint = this.x2;
            }
            this.filtered = this.filterXByScreen(smallPoint, bigPoint);
            this.resetButton.setVisible(this.filtered && ((XYStyler)this.xyChart.getStyler()).isZoomResetByButton());
        }
        this.x1 = -1;
        this.x2 = -1;
        this.repaint();
    }

    public boolean filterXByScreen(int screenXmin, int screenXmax) {
        double minValue = this.xyChart.axisPair.getXAxis().getChartValue(screenXmin);
        double maxValue = this.xyChart.axisPair.getXAxis().getChartValue(screenXmax);
        boolean filtered = false;
        if (this.isOnePointSeleted(minValue, maxValue)) {
            for (XYSeries series : this.xyChart.getSeriesMap().values()) {
                boolean f = series.filterXByValue(minValue, maxValue);
                if (!f) continue;
                filtered = true;
            }
        } else if (!this.isAllPointsSelected()) {
            filtered = true;
        }
        return filtered;
    }

    private boolean isOnePointSeleted(double minValue, double maxValue) {
        boolean isOnePointSeleted = false;
        double[] xData = null;
        block0: for (XYSeries series : this.xyChart.getSeriesMap().values()) {
            for (double x : xData = series.getXData()) {
                if (!(x >= minValue) || !(x <= maxValue)) continue;
                isOnePointSeleted = true;
                continue block0;
            }
        }
        return isOnePointSeleted;
    }

    public void resetFilter() {
        for (XYSeries series : this.xyChart.getSeriesMap().values()) {
            series.resetFilter();
        }
    }

    public void filterXByIndex(int startIndex, int endIndex) {
        for (XYSeries series : this.xyChart.getSeriesMap().values()) {
            series.filterXByIndex(startIndex, endIndex);
        }
    }

    private boolean isAllPointsSelected() {
        boolean isAllPointsSelected = true;
        for (XYSeries series : this.xyChart.getSeriesMap().values()) {
            if (series.isAllXData()) continue;
            isAllPointsSelected = false;
            break;
        }
        return isAllPointsSelected;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.filtered) {
            return;
        }
        if (((XYStyler)this.xyChart.getStyler()).isZoomResetByDoubleClick() && e.getClickCount() == 2) {
            this.resetZoom();
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.resetZoom();
    }

    private boolean isOverlapping() {
        boolean isOverlapping = false;
        double start = this.x1;
        double end = this.x2;
        if (this.x1 > this.x2) {
            start = this.x2;
            end = this.x1;
        }
        if (Math.max(start, this.xyChart.plot.bounds.getX()) < Math.min(end, this.xyChart.plot.bounds.getX() + this.xyChart.plot.bounds.getWidth())) {
            isOverlapping = true;
        }
        return isOverlapping;
    }
}

