/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.ANR;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class ProcessDataset {
    private double[][] X = null;
    private boolean[][] missing = null;
    private double[] Y = null;
    private int[] C = null;
    private double[] iMaximum;
    private double[] iMinimum;
    private double oMaximum;
    private double oMinimum;
    private int nData;
    private int nVariables;
    private int nInputs;
    private int nClasses;
    static final boolean debug = false;
    private InstanceSet IS = new InstanceSet();

    public double[][] getX() {
        return this.X;
    }

    public double[] getY() {
        return this.Y;
    }

    public int[] getC() {
        return this.C;
    }

    public double[] getImaximum() {
        return this.iMaximum;
    }

    public double[] getIminimum() {
        return this.iMinimum;
    }

    public double getOmaximum() {
        return this.oMaximum;
    }

    public double getOminimum() {
        return this.oMinimum;
    }

    public int getNdata() {
        return this.nData;
    }

    public int getNvariables() {
        return this.nVariables;
    }

    public int getNinputs() {
        return this.nInputs;
    }

    public int getNclasses() {
        return this.nClasses;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public void processClassifierDataset(String nfejemplos, boolean train) throws IOException {
        try {
            this.IS.readSet(nfejemplos, train);
            this.nData = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nVariables = this.nInputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.C = new int[this.nData];
            this.iMaximum = new double[this.nInputs];
            this.iMinimum = new double[this.nInputs];
            this.oMaximum = 0.0;
            this.oMinimum = 0.0;
            this.nClasses = 0;
            for (int i = 0; i < this.X.length; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (this.X[i][j] > this.iMaximum[j] || i == 0) {
                        this.iMaximum[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.iMinimum[j]) && i != 0) continue;
                    this.iMinimum[j] = this.X[i][j];
                }
                this.C[i] = noOutputs ? 0 : (int)this.IS.getOutputNumericValue(i, 0);
                if (this.C[i] <= this.nClasses) continue;
                this.nClasses = this.C[i];
            }
            ++this.nClasses;
            System.out.println("Number of classes=" + this.nClasses);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    public void processModelDataset(String nfexamples, boolean train) throws IOException {
        try {
            this.IS.readSet(nfexamples, train);
            this.nData = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nVariables = this.nInputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.Y = new double[this.nData];
            this.iMaximum = new double[this.nInputs];
            this.iMinimum = new double[this.nInputs];
            this.oMaximum = 0.0;
            this.oMinimum = 0.0;
            this.nClasses = 0;
            for (int i = 0; i < this.X.length; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (this.X[i][j] > this.iMaximum[j] || i == 0) {
                        this.iMaximum[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.iMinimum[j]) && i != 0) continue;
                    this.iMinimum[j] = this.X[i][j];
                }
                this.Y[i] = noOutputs ? 0.0 : this.IS.getOutputNumericValue(i, 0);
                if (this.Y[i] > this.oMaximum || i == 0) {
                    this.oMaximum = this.Y[i];
                }
                if (!(this.Y[i] < this.oMinimum) && i != 0) continue;
                this.oMinimum = this.Y[i];
            }
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    public void processClusterDataset(String nfexamples, boolean train) throws IOException {
        try {
            this.IS.readSet(nfexamples, train);
            this.nData = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nVariables = this.nInputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() != 0) {
                System.out.println("This algorithm can not process datasets with outputs");
                System.out.println("All outputs will be removed");
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.iMaximum = new double[this.nInputs];
            this.iMinimum = new double[this.nInputs];
            this.oMaximum = 0.0;
            this.oMinimum = 0.0;
            this.nClasses = 0;
            for (int i = 0; i < this.X.length; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (this.X[i][j] > this.iMaximum[j] || i == 0) {
                        this.iMaximum[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.iMinimum[j]) && i != 0) continue;
                    this.iMinimum[j] = this.X[i][j];
                }
            }
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    public void oldClassificationProcess(String nfejemplos) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(nfejemplos));
            String line = in.readLine();
            this.nData = Integer.parseInt(line);
            line = in.readLine();
            this.nVariables = Integer.parseInt(line);
            this.nInputs = this.nVariables - 1;
            this.X = new double[this.nData][this.nInputs];
            this.Y = new double[this.nData];
            this.iMaximum = new double[this.nInputs];
            this.iMinimum = new double[this.nInputs];
            this.oMaximum = 0.0;
            this.oMinimum = 0.0;
            for (int i = 0; i < this.nData; ++i) {
                line = in.readLine();
                StringTokenizer tokens = new StringTokenizer(line, " ,\t");
                for (int j = 0; j < this.nInputs; ++j) {
                    String tmp = tokens.nextToken();
                    this.X[i][j] = Double.parseDouble(tmp);
                    if (this.X[i][j] > this.iMaximum[j] || i == 0) {
                        this.iMaximum[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.iMinimum[j]) && i != 0) continue;
                    this.iMinimum[j] = this.X[i][j];
                }
                this.Y[i] = Double.parseDouble(tokens.nextToken());
                if (this.Y[i] > this.oMaximum || i == 0) {
                    this.oMaximum = this.Y[i];
                }
                if (!(this.Y[i] < this.oMinimum) && i != 0) continue;
                this.oMinimum = this.Y[i];
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " Fichero de ejemplos no encontrado");
        }
        catch (IOException e) {
            System.err.println(e + " Error lectura");
        }
    }

    public void oldClusteringProcess(String nfejemplos) {
        try {
            int i;
            BufferedReader in = new BufferedReader(new FileReader(nfejemplos));
            String line = in.readLine();
            this.nData = Integer.parseInt(line);
            line = in.readLine();
            this.nVariables = Integer.parseInt(line);
            this.nInputs = this.nVariables - 1;
            this.X = new double[this.nData][this.nInputs];
            this.C = new int[this.nData];
            this.iMaximum = new double[this.nInputs];
            this.iMinimum = new double[this.nInputs];
            int cMaximum = 0;
            int cMinimum = 0;
            for (i = 0; i < this.nData; ++i) {
                line = in.readLine();
                StringTokenizer tokens = new StringTokenizer(line, " ,\t");
                for (int j = 0; j < this.nInputs; ++j) {
                    String tmp = tokens.nextToken();
                    this.X[i][j] = Double.parseDouble(tmp);
                    if (this.X[i][j] > this.iMaximum[j] || i == 0) {
                        this.iMaximum[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.iMinimum[j]) && i != 0) continue;
                    this.iMinimum[j] = this.X[i][j];
                }
                this.C[i] = Integer.parseInt(tokens.nextToken());
                if (this.C[i] > cMaximum || i == 0) {
                    cMaximum = this.C[i];
                }
                if (this.C[i] >= cMinimum && i != 0) continue;
                cMinimum = this.C[i];
            }
            if (cMaximum == cMinimum) {
                throw new IOException("0 clases");
            }
            this.nClasses = cMaximum - cMinimum + 1;
            for (i = 0; i < this.nData; ++i) {
                this.C[i] = (this.C[i] - cMinimum) / (cMaximum - cMinimum);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " Fichero de ejemplos no encontrado");
        }
        catch (IOException e) {
            System.err.println(e + " Error lectura");
        }
    }

    public void procesa_clustering_old(String nfejemplos) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(nfejemplos));
            String line = in.readLine();
            this.nData = Integer.parseInt(line);
            line = in.readLine();
            this.nInputs = this.nVariables = Integer.parseInt(line);
            this.X = new double[this.nData][this.nInputs];
            this.iMaximum = new double[this.nInputs];
            this.iMinimum = new double[this.nInputs];
            for (int i = 0; i < this.nData; ++i) {
                line = in.readLine();
                StringTokenizer tokens = new StringTokenizer(line, " ,\t");
                for (int j = 0; j < this.nInputs; ++j) {
                    String tmp = tokens.nextToken();
                    this.X[i][j] = Double.parseDouble(tmp);
                    if (this.X[i][j] > this.iMaximum[j] || i == 0) {
                        this.iMaximum[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.iMinimum[j]) && i != 0) continue;
                    this.iMinimum[j] = this.X[i][j];
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " Fichero de ejemplos no encontrado");
        }
        catch (IOException e) {
            System.err.println(e + " Error lectura");
        }
    }

    public void showDatasetStatistics() {
        double[] sumaX = new double[this.X[0].length];
        double sumaY = 0.0;
        for (int i = 0; i < this.X.length; ++i) {
            for (int j = 0; j < this.X[i].length; ++j) {
                int n = j;
                sumaX[n] = sumaX[n] + this.X[i][j];
            }
            if (this.Y == null) continue;
            sumaY += this.Y[i];
        }
        int j = 0;
        while (j < this.X[0].length) {
            int n = j++;
            sumaX[n] = sumaX[n] / (double)this.X.length;
        }
        if (this.Y != null) {
            sumaY /= (double)this.Y.length;
        }
        System.out.print("Mean of inputs: ");
        for (j = 0; j < this.X[0].length; ++j) {
            System.out.print(sumaX[j] + " ");
        }
        System.out.println();
        if (this.Y != null) {
            System.out.println("Mean of outputs: " + sumaY);
        }
    }
}

