/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixStorage;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.AbstractSsf;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.FilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfDataWindow;
import ec.tstoolkit.ssf.SsfException;

public class FixedPointSmoother {
    private final ISsf m_ssf;
    private final int m_fixpos;
    private final Matrix m_m;
    private Matrix m_p0;
    private double[] m_a0;
    private DataBlockStorage m_states;
    private MatrixStorage m_vstates;
    private final int m_r;

    public boolean process(ISsfData data) {
        int nm;
        SsfDataWindow d0 = new SsfDataWindow(data, data.getInitialState(), 0, this.m_fixpos + 1);
        Smoother smoother = new Smoother();
        smoother.setSsf(this.m_ssf);
        smoother.setCalcVar(true);
        smoother.setStopPosition(this.m_fixpos);
        SmoothingResults sm = new SmoothingResults(data.hasData(), true);
        sm.setSavingStart(this.m_fixpos);
        if (!smoother.process(d0, sm)) {
            return false;
        }
        DataBlock A = sm.A(this.m_fixpos);
        if (A != null) {
            if (this.m_m == null) {
                this.m_a0 = new double[2 * this.m_r];
                A.copyTo(this.m_a0, 0);
                A.copyTo(this.m_a0, this.m_r);
            } else {
                this.m_a0 = new double[this.m_r + this.m_m.getRowsCount()];
                A.copyTo(this.m_a0, 0);
                DataBlock ma = new DataBlock(this.m_a0, this.m_r, this.m_a0.length, 1);
                ma.product(this.m_m.rows(), A);
            }
        } else {
            this.m_a0 = null;
        }
        SubMatrix P = sm.P(this.m_fixpos);
        if (this.m_m == null) {
            this.m_p0 = new Matrix(2 * this.m_r, 2 * this.m_r);
            this.m_p0.subMatrix(0, this.m_r, 0, this.m_r).copy(P);
            this.m_p0.subMatrix(0, this.m_r, this.m_r, 2 * this.m_r).copy(P);
            this.m_p0.subMatrix(this.m_r, 2 * this.m_r, 0, this.m_r).copy(P);
            this.m_p0.subMatrix(this.m_r, 2 * this.m_r, this.m_r, 2 * this.m_r).copy(P);
        } else {
            int nm2 = this.m_m.getRowsCount();
            this.m_p0 = new Matrix(this.m_r + nm2, this.m_r + nm2);
            SubMatrix P00 = this.m_p0.subMatrix(0, this.m_r, 0, this.m_r);
            SubMatrix P10 = this.m_p0.subMatrix(this.m_r, this.m_r + nm2, 0, this.m_r);
            SubMatrix P01 = this.m_p0.subMatrix(0, this.m_r, this.m_r, this.m_r + nm2);
            SubMatrix P11 = this.m_p0.subMatrix(this.m_r, this.m_r + nm2, this.m_r, this.m_r + nm2);
            P00.copy(P);
            P10.product(this.m_m.subMatrix(), P);
            P01.copy(P10.transpose());
            SymmetricMatrix.quadraticFormT(P, this.m_m.subMatrix(), P11);
        }
        FilteringResults frslts = new FilteringResults();
        frslts.getVarianceFilter().setSavingP(true);
        frslts.getFilteredData().setSavingA(true);
        int nf = data.getCount() - this.m_fixpos + 1;
        SsfDataWindow d1 = new SsfDataWindow(data, this.m_a0, this.m_fixpos, nf);
        Filter<XSsf> filter = new Filter<XSsf>();
        filter.setSsf(new XSsf());
        if (!filter.process(d1, frslts)) {
            return false;
        }
        int n = nm = this.m_m == null ? this.m_r : this.m_m.getRowsCount();
        if (data.hasData()) {
            this.m_states = new DataBlockStorage(nm, nf);
        }
        this.m_vstates = new MatrixStorage(nm, nf);
        for (int i = 0; i < d1.getCount(); ++i) {
            if (data.hasData()) {
                this.m_states.save(i, frslts.getFilteredData().A(i + 1).drop(this.m_r, 0));
            }
            this.m_vstates.save(i, frslts.getVarianceFilter().P(i + 1).extract(this.m_r, this.m_r + nm, this.m_r, this.m_r + nm));
        }
        return true;
    }

    public DataBlock A(int pos) {
        return this.m_states == null ? null : this.m_states.block(pos);
    }

    public SubMatrix P(int pos) {
        return this.m_vstates.matrix(pos);
    }

    public FixedPointSmoother(ISsf ssf, int fixpos) {
        this.m_ssf = ssf;
        this.m_fixpos = fixpos;
        this.m_r = this.m_ssf.getStateDim();
        this.m_m = null;
    }

    public FixedPointSmoother(ISsf ssf, int fixpos, Matrix M) {
        if (M != null && ssf.getStateDim() != M.getColumnsCount()) {
            throw new SsfException("Invalid fixed point argument");
        }
        this.m_ssf = ssf;
        this.m_fixpos = fixpos;
        this.m_r = this.m_ssf.getStateDim();
        this.m_m = M;
    }

    public Matrix getTransformationMatrix() {
        return this.m_m;
    }

    public int getFixedPointPosition() {
        return this.m_fixpos;
    }

    private class XSsf
    extends AbstractSsf {
        private XSsf() {
        }

        @Override
        public void diffuseConstraints(SubMatrix b) {
        }

        @Override
        public void fullQ(int pos, SubMatrix qm) {
            FixedPointSmoother.this.m_ssf.fullQ(pos, qm.extract(0, FixedPointSmoother.this.m_r, 0, FixedPointSmoother.this.m_r));
        }

        @Override
        public int getNonStationaryDim() {
            return 0;
        }

        @Override
        public int getStateDim() {
            return FixedPointSmoother.this.m_m == null ? 2 * FixedPointSmoother.this.m_r : FixedPointSmoother.this.m_r + FixedPointSmoother.this.m_m.getRowsCount();
        }

        @Override
        public int getTransitionResCount() {
            return this.getStateDim();
        }

        @Override
        public int getTransitionResDim() {
            return this.getStateDim();
        }

        @Override
        public boolean hasR() {
            return false;
        }

        @Override
        public boolean hasTransitionRes(int pos) {
            return FixedPointSmoother.this.m_ssf.hasTransitionRes(pos);
        }

        @Override
        public boolean hasW() {
            return false;
        }

        @Override
        public boolean isDiffuse() {
            return false;
        }

        @Override
        public boolean isMeasurementEquationTimeInvariant() {
            return FixedPointSmoother.this.m_ssf.isMeasurementEquationTimeInvariant();
        }

        @Override
        public boolean isTimeInvariant() {
            return FixedPointSmoother.this.m_ssf.isTimeInvariant();
        }

        @Override
        public boolean isTransitionEquationTimeInvariant() {
            return FixedPointSmoother.this.m_ssf.isTransitionEquationTimeInvariant();
        }

        @Override
        public boolean isTransitionResidualTimeInvariant() {
            return FixedPointSmoother.this.m_ssf.isTransitionResidualTimeInvariant();
        }

        @Override
        public boolean isValid() {
            return FixedPointSmoother.this.m_ssf.isValid();
        }

        @Override
        public void Pf0(SubMatrix pf0) {
            pf0.copy(FixedPointSmoother.this.m_p0.subMatrix());
        }

        @Override
        public void Pi0(SubMatrix pi0) {
        }

        @Override
        public void Q(int pos, SubMatrix qm) {
            this.fullQ(pos, qm);
        }

        @Override
        public void R(int pos, SubArrayOfInt rv) {
        }

        @Override
        public void T(int pos, SubMatrix tr) {
            FixedPointSmoother.this.m_ssf.T(pos, tr.extract(0, FixedPointSmoother.this.m_r, 0, FixedPointSmoother.this.m_r));
        }

        @Override
        public void TX(int pos, DataBlock x) {
            FixedPointSmoother.this.m_ssf.TX(pos, x.range(0, FixedPointSmoother.this.m_r));
        }

        @Override
        public void VpZdZ(int pos, SubMatrix vm, double d) {
            FixedPointSmoother.this.m_ssf.VpZdZ(pos, vm.extract(0, FixedPointSmoother.this.m_r, 0, FixedPointSmoother.this.m_r), d);
        }

        @Override
        public void W(int pos, SubMatrix wv) {
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            FixedPointSmoother.this.m_ssf.XpZd(pos, x.range(0, FixedPointSmoother.this.m_r), d);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            FixedPointSmoother.this.m_ssf.XT(pos, x.range(0, FixedPointSmoother.this.m_r));
        }

        @Override
        public void Z(int pos, DataBlock x) {
            FixedPointSmoother.this.m_ssf.Z(pos, x.range(0, FixedPointSmoother.this.m_r));
        }

        @Override
        public double ZVZ(int pos, SubMatrix vm) {
            return FixedPointSmoother.this.m_ssf.ZVZ(pos, vm.extract(0, FixedPointSmoother.this.m_r, 0, FixedPointSmoother.this.m_r));
        }

        @Override
        public double ZX(int pos, DataBlock x) {
            return FixedPointSmoother.this.m_ssf.ZX(pos, x.range(0, FixedPointSmoother.this.m_r));
        }
    }
}

