## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  cache = TRUE
)

library(mrangr)
library(terra)

load("first_com.rda")
load("first_sim.rda")
K_map <- terra::rast("K_map.tif")


## ----load_mrangr, eval = FALSE------------------------------------------------
#  install.packages("mrangr")
#  library(mrangr)

## ----load_raster, eval = FALSE------------------------------------------------
#  install.packages("terra")
#  library(terra)

## ----eg_maps_help, eval=FALSE-------------------------------------------------
#  ?K_map_eg.tif
#  ?n1_map_eg.tif

## ----eg_maps_plot, eval=TRUE--------------------------------------------------
# Carrying capacity
K_map_eg <- rast(system.file("input_maps/K_map_eg.tif", package = "mrangr"))
plot(K_map_eg, main = paste0("K_", names(K_map_eg)))

# Initial abundance
n1_map_eg <- rast(system.file("input_maps/n1_map_eg.tif", package = "mrangr"))
plot(n1_map_eg ,main = paste0("n1_", names(n1_map_eg)))

## ----set_seed, include=FALSE--------------------------------------------------
# define species number
nspec <- 2
# define map dimensions
nrows <- ncols <- 100

set.seed(52)

## ----K_sim_basic, eval=FALSE--------------------------------------------------
#  # define species number
#  nspec <- 2
#  # define map dimensions
#  nrows <- ncols <- 100
#  
#  # prepare template raster
#  xmin <- 250000; xmax <- xmin + nrows * 1000
#  ymin <- 600000; ymax <- ymin + ncols * 1000
#  id <- rast(nrows = nrows, ncols = ncols, xmin = xmin, xmax = xmax, ymin = ymin, ymax = ymax)
#  crs(id) <- "epsg:2180"
#  id
#  
#  # generate autocorrelated carrying capacity maps
#  K_map <- K_sim(n = nspec, id, range = 5e5, qfun = qlnorm, meanlog = 2, sdlog = 0.5)

## ----K_sim_basic_plot---------------------------------------------------------
plot(K_map, main = paste0("K_", names(K_map)))

## ----a------------------------------------------------------------------------
a <- matrix(c(NA, -0.8, -0.8, NA), nrow = nspec, ncol = nspec)
print(a)

## ----init, eval=FALSE---------------------------------------------------------
#  first_com <- initialise_com(
#    n1_map = round(K_map / 2),
#    K_map = K_map,
#    r = 1.1,
#    a = a,
#    rate = 1 / 500)

## ----init_summary-------------------------------------------------------------
summary(first_com)

## ----sim, eval=FALSE----------------------------------------------------------
#  first_sim <- sim_com(first_com, time = 100)

## ----sim_summary--------------------------------------------------------------
summary(first_sim)

## ----maps---------------------------------------------------------------------
plot(first_sim, time = c(1, 10, 100))

## ----time_series--------------------------------------------------------------
plot_series(first_sim)
legend("bottomright", title = "Species", legend = 1:nspec, 
       lty = 1:nspec, lwd = 2, col = 1:nspec)

## ----ve_first_random_one------------------------------------------------------
ve <- virtual_ecologist(
  first_sim,
  type = "random_one_layer",
  prop = 1/100
)
head(ve)

## ----ve_first_head------------------------------------------------------------
head(ve)

