/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.graphs.Edge;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.BaseEdge;
import jebl.evolution.trees.BaseNode;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.AttributableHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableRootedTree
implements RootedTree {
    private AttributableHelper helper = null;
    protected MutableRootedNode rootNode = null;
    protected final Set<Node> internalNodes = new LinkedHashSet<Node>();
    private final Map<Taxon, Node> externalNodes = new LinkedHashMap<Taxon, Node>();
    private boolean heightsKnown = false;
    private boolean lengthsKnown = false;
    private boolean hasHeights = false;
    private boolean hasLengths = false;
    private boolean conceptuallyUnrooted = false;

    MutableRootedTree() {
    }

    public MutableRootedTree(Tree tree, Node outGroup) {
        if (!tree.isExternal(outGroup)) {
            throw new IllegalArgumentException("Outgroup must be a tip");
        }
        Node root = tree.getAdjacencies(outGroup).get(0);
        try {
            MutableRootedNode newSubtreeRoot = this.rootAdjacenciesWith(tree, root, outGroup);
            MutableRootedNode out = (MutableRootedNode)this.createExternalNode(tree.getTaxon(outGroup));
            this.setLength(out, tree.getEdgeLength(outGroup, root));
            ArrayList<MutableRootedNode> rootChildren = new ArrayList<MutableRootedNode>();
            rootChildren.add(out);
            rootChildren.add(newSubtreeRoot);
            this.createInternalNode(rootChildren);
            this.setLength(newSubtreeRoot, 0.0);
        }
        catch (Graph.NoEdgeException e) {
            // empty catch block
        }
    }

    public MutableRootedTree(RootedTree tree) {
        try {
            this.rootNode = this.rootAdjacenciesWith(tree, tree.getRootNode(), null);
        }
        catch (Graph.NoEdgeException noEdgeException) {
            // empty catch block
        }
    }

    public void removeInternalNode(Node node) {
        assert (!this.isExternal(node) && this.getRootNode() != node);
        MutableRootedNode parent = (MutableRootedNode)this.getParent(node);
        for (Node n : this.getChildren(node)) {
            parent.addChild((MutableRootedNode)n);
        }
        parent.removeChild(node);
        this.internalNodes.remove(node);
    }

    public void addChild(Node child, Node parent) {
        ((MutableRootedNode)parent).addChild((MutableRootedNode)child);
    }

    public void removeChild(Node child, Node parent) {
        ((MutableRootedNode)parent).removeChild((MutableRootedNode)child);
    }

    public void setRoot(Node root) {
        this.rootNode = (MutableRootedNode)root;
    }

    public void refineNode(Node node, int[] leftSet) {
        List<Node> allChildren = this.getChildren(node);
        ArrayList<Node> left = new ArrayList<Node>();
        ArrayList<Node> right = new ArrayList<Node>();
        for (int n : leftSet) {
            left.add(allChildren.get(n));
        }
        for (Node n : allChildren) {
            if (left.contains(n)) continue;
            right.add(n);
        }
        this.internalNodes.remove(node);
        MutableRootedNode saveRoot = this.rootNode;
        MutableRootedNode lnode = left.size() > 1 ? this.createInternalNode(left) : (MutableRootedNode)left.get(0);
        MutableRootedNode rnode = right.size() > 1 ? this.createInternalNode(right) : (MutableRootedNode)right.get(0);
        ArrayList<MutableRootedNode> nodes = new ArrayList<MutableRootedNode>(2);
        nodes.add(lnode);
        nodes.add(rnode);
        ((MutableRootedNode)node).replaceChildren(nodes);
        this.rootNode = saveRoot;
    }

    public void reRootWithOutgroup(Node outGroup, Set<String> attributeNames) {
        assert (this.isExternal(outGroup));
        this.reRoot((MutableRootedNode)this.getAdjacencies(outGroup).get(0), attributeNames);
    }

    private MutableRootedNode rootAdjacenciesWith(Tree tree, Node node, Node parent) throws Graph.NoEdgeException {
        if (tree.isExternal(node)) {
            return (MutableRootedNode)this.createExternalNode(tree.getTaxon(node));
        }
        ArrayList<MutableRootedNode> children = new ArrayList<MutableRootedNode>();
        for (Node adj : tree.getAdjacencies(node)) {
            if (adj == parent) continue;
            MutableRootedNode rootedAdj = this.rootAdjacenciesWith(tree, adj, node);
            this.setLength(rootedAdj, tree.getEdgeLength(adj, node));
            children.add(rootedAdj);
        }
        return this.createInternalNode(children);
    }

    private void reRoot(MutableRootedNode node, Set<String> attributeNames) {
        MutableRootedNode parent = (MutableRootedNode)this.getParent(node);
        if (parent == null) {
            return;
        }
        double len = this.getLength(node);
        parent.removeChild(node);
        this.reRoot(parent, attributeNames);
        if (parent == this.getRootNode()) {
            this.rootNode = node;
        }
        if (parent.getChildren().size() == 1) {
            parent = (MutableRootedNode)parent.getChildren().get(0);
            len += parent.getLength();
        }
        node.addChild(parent);
        parent.setLength(len);
        node.setParent(null);
        if (attributeNames != null) {
            for (String name : attributeNames) {
                Object s = node.getAttribute(name);
                if (s == null) continue;
                parent.setAttribute(name, s);
                node.removeAttribute(name);
            }
        }
    }

    public Node detachChildren(Node node, List<Integer> split) {
        assert (split.size() > 1);
        List<Node> allChildren = this.getChildren(node);
        ArrayList<Node> detached = new ArrayList<Node>();
        for (int n : split) {
            detached.add(allChildren.get(n));
        }
        MutableRootedNode saveRoot = this.rootNode;
        for (Node n : allChildren) {
            if (!detached.contains(n)) continue;
            ((MutableRootedNode)node).removeChild(n);
        }
        MutableRootedNode dnode = this.createInternalNode(detached);
        ((MutableRootedNode)node).addChild(dnode);
        this.rootNode = saveRoot;
        return dnode;
    }

    public Node createExternalNode(Taxon taxon) {
        MutableRootedNode node = new MutableRootedNode(taxon);
        this.externalNodes.put(taxon, node);
        return node;
    }

    public MutableRootedNode createInternalNode(List<? extends Node> children) {
        MutableRootedNode node = new MutableRootedNode(children);
        for (Node node2 : children) {
            ((MutableRootedNode)node2).setParent(node);
        }
        this.internalNodes.add(node);
        this.rootNode = node;
        return node;
    }

    public void setHeight(Node node, double height) {
        this.lengthsKnown = false;
        this.heightsKnown = true;
        this.hasLengths = true;
        this.hasHeights = true;
        ((MutableRootedNode)node).setHeight(height);
    }

    public void setLength(Node node, double length) {
        this.heightsKnown = false;
        this.lengthsKnown = true;
        this.hasLengths = true;
        this.hasHeights = true;
        ((MutableRootedNode)node).setLength(length);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return new ArrayList<Node>(((MutableRootedNode)node).getChildren());
    }

    @Override
    public boolean hasHeights() {
        return this.hasHeights;
    }

    @Override
    public double getHeight(Node node) {
        if (!this.hasHeights) {
            throw new IllegalArgumentException("This tree has no node heights");
        }
        if (!this.heightsKnown) {
            this.calculateNodeHeights();
        }
        return ((MutableRootedNode)node).getHeight();
    }

    @Override
    public boolean hasLengths() {
        return this.hasLengths;
    }

    @Override
    public double getLength(Node node) {
        if (!this.hasLengths) {
            throw new IllegalArgumentException("This tree has no branch lengths");
        }
        if (!this.lengthsKnown) {
            this.calculateBranchLengths();
        }
        return ((MutableRootedNode)node).getLength();
    }

    @Override
    public Node getParent(Node node) {
        return ((MutableRootedNode)node).getParent();
    }

    public Edge getParentEdge(Node node) {
        return ((MutableRootedNode)node).getEdge();
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public boolean isRoot(Node node) {
        return node == this.rootNode;
    }

    @Override
    public Set<Node> getExternalNodes() {
        return new LinkedHashSet<Node>(this.externalNodes.values());
    }

    @Override
    public Set<Node> getInternalNodes() {
        return new LinkedHashSet<Node>(this.internalNodes);
    }

    @Override
    public Set<Taxon> getTaxa() {
        return new LinkedHashSet<Taxon>(this.externalNodes.keySet());
    }

    @Override
    public Taxon getTaxon(Node node) {
        return ((MutableRootedNode)node).getTaxon();
    }

    @Override
    public boolean isExternal(Node node) {
        return ((MutableRootedNode)node).getChildren().size() == 0;
    }

    @Override
    public Node getNode(Taxon taxon) {
        return this.externalNodes.get(taxon);
    }

    @Override
    public void renameTaxa(Taxon from, Taxon to) {
        MutableRootedNode node = (MutableRootedNode)this.externalNodes.get(from);
        node.setTaxa(to);
        this.externalNodes.remove(from);
        this.externalNodes.put(to, node);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Node adjNode : this.getAdjacencies(node)) {
            edges.add(((MutableRootedNode)adjNode).getEdge());
        }
        return edges;
    }

    @Override
    public Node[] getNodes(Edge edge) {
        for (Node node : this.getNodes()) {
            if (((MutableRootedNode)node).getEdge() != edge) continue;
            return new Node[]{node, ((MutableRootedNode)node).getParent()};
        }
        return null;
    }

    @Override
    public List<Node> getAdjacencies(Node node) {
        return ((MutableRootedNode)node).getAdjacencies();
    }

    @Override
    public Edge getEdge(Node node1, Node node2) throws Graph.NoEdgeException {
        if (((MutableRootedNode)node1).getParent() == node2) {
            return ((MutableRootedNode)node1).getEdge();
        }
        if (((MutableRootedNode)node2).getParent() == node1) {
            return ((MutableRootedNode)node2).getEdge();
        }
        throw new Graph.NoEdgeException();
    }

    @Override
    public double getEdgeLength(Node node1, Node node2) throws Graph.NoEdgeException {
        if (((MutableRootedNode)node1).getParent() == node2) {
            if (this.heightsKnown) {
                return ((MutableRootedNode)node2).getHeight() - ((MutableRootedNode)node1).getHeight();
            }
            return ((MutableRootedNode)node1).getLength();
        }
        if (((MutableRootedNode)node2).getParent() == node1) {
            if (this.heightsKnown) {
                return ((MutableRootedNode)node1).getHeight() - ((MutableRootedNode)node2).getHeight();
            }
            return ((MutableRootedNode)node2).getLength();
        }
        throw new Graph.NoEdgeException();
    }

    @Override
    public Set<Node> getNodes() {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(this.internalNodes);
        nodes.addAll(this.externalNodes.values());
        return nodes;
    }

    @Override
    public Set<Edge> getEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getNodes()) {
            if (node == this.getRootNode()) continue;
            edges.add(((MutableRootedNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Edge> getExternalEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getExternalNodes()) {
            edges.add(((MutableRootedNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Edge> getInternalEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getInternalNodes()) {
            if (node == this.getRootNode()) continue;
            edges.add(((MutableRootedNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Node> getNodes(int degree) {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>();
        for (Node node : this.getNodes()) {
            int deg = node.getDegree();
            if (deg != degree) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private void calculateNodeHeights() {
        if (!this.lengthsKnown) {
            throw new IllegalArgumentException("Can't calculate node heights because branch lengths not known");
        }
        this.nodeLengthsToHeights(this.rootNode, 0.0);
        double maxHeight = 0.0;
        for (Node externalNode : this.getExternalNodes()) {
            if (!(((MutableRootedNode)externalNode).getHeight() > maxHeight)) continue;
            maxHeight = ((MutableRootedNode)externalNode).getHeight();
        }
        for (Node node : this.getNodes()) {
            ((MutableRootedNode)node).setHeight(maxHeight - ((MutableRootedNode)node).getHeight());
        }
        this.heightsKnown = true;
    }

    private void nodeLengthsToHeights(MutableRootedNode node, double height) {
        double newHeight = height;
        if (node.getLength() > 0.0) {
            newHeight += node.getLength();
        }
        node.setHeight(newHeight);
        for (Node child : node.getChildren()) {
            this.nodeLengthsToHeights((MutableRootedNode)child, newHeight);
        }
    }

    protected void calculateBranchLengths() {
        if (!this.hasLengths) {
            throw new IllegalArgumentException("Can't calculate branch lengths because node heights not known");
        }
        this.nodeHeightsToLengths(this.rootNode, this.getHeight(this.rootNode));
        this.lengthsKnown = true;
    }

    private void nodeHeightsToLengths(MutableRootedNode node, double height) {
        double h = node.getHeight();
        node.setLength(h >= 0.0 ? height - h : 1.0);
        for (Node child : node.getChildren()) {
            this.nodeHeightsToLengths((MutableRootedNode)child, node.getHeight());
        }
    }

    public void setConceptuallyUnrooted(boolean intent) {
        this.conceptuallyUnrooted = intent;
    }

    @Override
    public boolean conceptuallyUnrooted() {
        return this.conceptuallyUnrooted;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.helper == null) {
            this.helper = new AttributableHelper();
        }
        this.helper.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.helper == null) {
            return null;
        }
        return this.helper.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.helper != null) {
            this.helper.removeAttribute(name);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        if (this.helper == null) {
            return Collections.emptySet();
        }
        return this.helper.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        if (this.helper == null) {
            return Collections.emptyMap();
        }
        return this.helper.getAttributeMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MutableRootedNode
    extends BaseNode {
        private List<Node> children;
        private Taxon taxon;
        private Node parent;
        private double height;
        private double length;
        private Edge edge = null;

        public MutableRootedNode(Taxon taxon) {
            this.children = Collections.unmodifiableList(new ArrayList());
            this.taxon = taxon;
        }

        public MutableRootedNode(List<? extends Node> children) {
            this.children = Collections.unmodifiableList(new ArrayList<Node>(children));
            this.taxon = null;
        }

        public void removeChild(Node node) {
            ArrayList<Node> c = new ArrayList<Node>(this.children);
            c.remove(node);
            this.children = Collections.unmodifiableList(c);
        }

        public void addChild(MutableRootedNode node) {
            ArrayList<Node> c = new ArrayList<Node>(this.children);
            c.add(node);
            node.setParent(this);
            this.children = Collections.unmodifiableList(c);
        }

        public void replaceChildren(List<MutableRootedNode> nodes) {
            for (MutableRootedNode n : nodes) {
                n.setParent(this);
            }
            this.children = Collections.unmodifiableList(new ArrayList<MutableRootedNode>(nodes));
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        public double getLength() {
            return this.length;
        }

        public void setLength(double length) {
            this.length = length;
        }

        @Override
        public int getDegree() {
            return this.children.size() + (this == MutableRootedTree.this.rootNode ? 0 : 1);
        }

        public Edge getEdge() {
            if (this.edge == null) {
                this.edge = new BaseEdge(){

                    public double getLength() {
                        return MutableRootedNode.this.length;
                    }
                };
            }
            return this.edge;
        }

        public List<Node> getAdjacencies() {
            ArrayList<Node> adjacencies = new ArrayList<Node>();
            if (this.children != null) {
                adjacencies.addAll(this.children);
            }
            if (this.parent != null) {
                adjacencies.add(this.parent);
            }
            return adjacencies;
        }

        public Taxon getTaxon() {
            return this.taxon;
        }

        public void setTaxa(Taxon to) {
            this.taxon = to;
        }
    }
}

