/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class DiscreteUniformDistribution
implements Distribution {
    double lower;
    double upper;
    double n;

    public DiscreteUniformDistribution(double d, double d2) {
        this.lower = d;
        this.upper = d2;
        this.n = d2 - d + 1.0;
    }

    @Override
    public double pdf(double d) {
        if (d < this.lower) {
            return 0.0;
        }
        if (d > this.upper) {
            return 0.0;
        }
        return 1.0 / this.n;
    }

    @Override
    public double logPdf(double d) {
        if (d < this.lower) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d > this.upper) {
            return Double.NEGATIVE_INFINITY;
        }
        return -Math.log(this.n);
    }

    @Override
    public double cdf(double d) {
        return (d - this.lower + 1.0) / this.n;
    }

    @Override
    public double quantile(double d) {
        return Double.NaN;
    }

    @Override
    public double mean() {
        return (this.lower + this.upper) / 2.0;
    }

    @Override
    public double variance() {
        return (this.n * this.n - 1.0) / 12.0;
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException();
    }
}

