/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;

public class CorrelationSymmetricMatrix
extends MatrixParameter {
    private final Parameter diagonals;
    private final Parameter offDiagonals;
    private final Type type;
    private final int dim;

    public CorrelationSymmetricMatrix(Parameter parameter, Parameter parameter2) {
        this(parameter, parameter2, Type.AS_CORRELATION);
    }

    public CorrelationSymmetricMatrix(Parameter parameter, Parameter parameter2, Type type) {
        super("matrixParameter");
        this.diagonals = parameter;
        this.offDiagonals = parameter2;
        this.addParameter(parameter);
        this.addParameter(parameter2);
        this.type = type;
        this.dim = parameter.getDimension();
        if (parameter2.getDimension() != parameter.getDimension() * (parameter.getDimension() - 1) / 2) {
            throw new IllegalArgumentException("Invalid parameter dimensions");
        }
    }

    @Override
    public double[] getAttributeValue() {
        double[] dArray = new double[this.dim * this.dim];
        int n = 0;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dArray[n] = this.getParameterValue(i, j);
                ++n;
            }
        }
        return dArray;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        if (n != n2) {
            double d = this.offDiagonals.getParameterValue(CorrelationSymmetricMatrix.getOffDiagonalIndex(n, n2, this.dim));
            if (this.type == Type.AS_CORRELATION) {
                d *= Math.sqrt(this.diagonals.getParameterValue(n) * this.diagonals.getParameterValue(n2));
            }
            return d;
        }
        return this.diagonals.getParameterValue(n);
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValue(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double[][] getParameterAsMatrix() {
        double[][] dArray = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray[i][i] = this.getParameterValue(i, i);
            for (int j = i + 1; j < this.dim; ++j) {
                double d = this.getParameterValue(i, j);
                dArray[i][j] = d;
                dArray[j][i] = d;
            }
        }
        return dArray;
    }

    @Override
    public int getColumnDimension() {
        return this.diagonals.getDimension();
    }

    @Override
    public int getRowDimension() {
        return this.diagonals.getDimension();
    }

    private static int getOffDiagonalIndex(int n, int n2, int n3) {
        int n4;
        if (n2 < n) {
            n4 = n;
            n = n2;
            n2 = n4;
        }
        n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 += n3 - 1 - i;
        }
        return n4 += n2 - n - 1;
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return true;
    }

    public static enum Type {
        AS_CORRELATION,
        AS_IS;

    }
}

