/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat.list;

import cern.colt.matrix.DoubleMatrix1D;
import java.util.logging.Level;
import java.util.logging.Logger;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.stat.TallyStore;
import umontreal.iro.lecuyer.stat.list.ListOfTallies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfTalliesWithCovariance<E extends Tally>
extends ListOfTallies<E> {
    private double[] tempArray;
    private double[][] sxy;
    private boolean isStable = true;
    private double[] curAverages;
    private double[][] curSum2;
    private Logger log = Logger.getLogger("umontreal.iro.lecuyer.stat.list");

    public ListOfTalliesWithCovariance() {
    }

    public ListOfTalliesWithCovariance(String name) {
        super(name);
    }

    public static ListOfTalliesWithCovariance<Tally> createWithTally(int size) {
        ListOfTalliesWithCovariance<Tally> list = new ListOfTalliesWithCovariance<Tally>();
        for (int i = 0; i < size; ++i) {
            list.add(new Tally());
        }
        list.init();
        return list;
    }

    public static ListOfTalliesWithCovariance<TallyStore> createWithTallyStore(int size) {
        ListOfTalliesWithCovariance<TallyStore> list = new ListOfTalliesWithCovariance<TallyStore>();
        for (int i = 0; i < size; ++i) {
            list.add(new TallyStore());
        }
        list.init();
        return list;
    }

    private void createSxy() {
        int l = this.size();
        if (this.isStable) {
            this.curAverages = new double[l];
            this.curSum2 = new double[l - 1][];
            for (int i = 0; i < l - 1; ++i) {
                this.curSum2[i] = new double[l - 1 - i];
            }
        } else {
            this.sxy = new double[l - 1][];
            for (int i = 0; i < l - 1; ++i) {
                this.sxy[i] = new double[l - 1 - i];
            }
        }
        this.tempArray = new double[l];
    }

    @Override
    public void init() {
        super.init();
        if (this.isModifiable()) {
            this.setUnmodifiable();
            this.createSxy();
        }
        if (this.isStable) {
            int i;
            for (i = 0; i < this.curAverages.length; ++i) {
                this.curAverages[i] = 0.0;
            }
            for (i = 0; i < this.curSum2.length; ++i) {
                for (int j = 0; j < this.curSum2[i].length; ++j) {
                    this.curSum2[i][j] = 0.0;
                }
            }
        } else {
            for (int i = 0; i < this.sxy.length; ++i) {
                for (int j = 0; j < this.sxy[i].length; ++j) {
                    this.sxy[i][j] = 0.0;
                }
            }
        }
    }

    @Override
    public void add(double[] x) {
        int l = this.size();
        int structSize = 0;
        int n = structSize = this.isStable ? this.curSum2.length : this.sxy.length;
        if (structSize != l - 1) {
            throw new IllegalArgumentException("The structure's size mismatches the list's size");
        }
        super.add(x);
        if (this.isStable) {
            int numObs = ((Tally)this.get(0)).numberObs();
            for (int i1 = 0; i1 < l - 1; ++i1) {
                for (int i2 = i1 + 1; i2 < l; ++i2) {
                    double[] dArray = this.curSum2[i1];
                    int n2 = i2 - i1 - 1;
                    dArray[n2] = dArray[n2] + (double)(numObs - 1) * (x[i1] - this.curAverages[i1]) * (x[i2] - this.curAverages[i2]) / (double)numObs;
                }
            }
            for (int i = 0; i < l; ++i) {
                int n3 = i;
                this.curAverages[n3] = this.curAverages[n3] + (x[i] - this.curAverages[i]) / (double)numObs;
            }
        } else {
            for (int i1 = 0; i1 < l - 1; ++i1) {
                for (int i2 = i1 + 1; i2 < l; ++i2) {
                    double[] dArray = this.sxy[i1];
                    int n4 = i2 - i1 - 1;
                    dArray[n4] = dArray[n4] + x[i1] * x[i2];
                }
            }
        }
    }

    public void add(DoubleMatrix1D x) {
        x.toArray(this.tempArray);
        this.add(this.tempArray);
    }

    @Override
    public double covariance(int i, int j) {
        if (i == j) {
            return ((Tally)this.get(i)).variance();
        }
        if (i > j) {
            int tmp = i;
            i = j;
            j = tmp;
        }
        Tally tallyi = (Tally)this.get(i);
        Tally tallyj = (Tally)this.get(j);
        if (tallyi == null || tallyj == null) {
            return Double.NaN;
        }
        int n = tallyi.numberObs();
        if (n != tallyj.numberObs()) {
            this.log.logp(Level.WARNING, "ListOfTalliesWithCovariance", "covariance", "Tally " + i + ", with name " + tallyi.getName() + ", contains " + n + " observations while " + "tally " + j + ", with name " + tallyj.getName() + ", contains " + tallyj.numberObs() + "observations");
            return Double.NaN;
        }
        if (n < 2) {
            this.log.logp(Level.WARNING, "ListOfTalliesWithCovariance", "covariance", "Tally " + i + ", with name " + tallyi.getName() + ", contains " + n + " observation");
            return Double.NaN;
        }
        if (tallyi instanceof TallyStore && tallyj instanceof TallyStore) {
            return ((TallyStore)tallyi).covariance((TallyStore)tallyj);
        }
        if (this.isStable) {
            return this.curSum2[i][j - i - 1] / (double)(n - 1);
        }
        double sum1 = tallyi.sum();
        double sum2 = tallyj.sum();
        double sum12 = this.sxy[i][j - i - 1];
        return (sum12 - sum1 * sum2 / (double)n) / (double)(n - 1);
    }

    @Override
    public ListOfTalliesWithCovariance<E> clone() {
        int i;
        ListOfTalliesWithCovariance ta = (ListOfTalliesWithCovariance)super.clone();
        ta.tempArray = new double[this.size()];
        if (this.curAverages != null) {
            ta.curAverages = (double[])this.curAverages.clone();
        }
        if (this.sxy != null) {
            ta.sxy = new double[this.sxy.length][];
            for (i = 0; i < this.sxy.length; ++i) {
                ta.sxy[i] = (double[])this.sxy[i].clone();
            }
        }
        if (this.curSum2 != null) {
            ta.curSum2 = new double[this.curSum2.length][];
            for (i = 0; i < this.curSum2.length; ++i) {
                ta.curSum2[i] = (double[])this.curSum2[i].clone();
            }
        }
        return ta;
    }
}

