/*
 * Decompiled with CFR 0.152.
 */
package mrmc.gui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import mrmc.chart.BarGraph;
import mrmc.chart.ROCCurvePlot;
import mrmc.chart.StudyDesignPlot;
import mrmc.chart.WrapLayout;
import mrmc.chart.exportToFile;
import mrmc.core.DBRecord;
import mrmc.core.InputFile;
import mrmc.core.StatTest;
import mrmc.gui.GUInterface;
import org.jfree.ui.RefineryUtilities;

public class InputFileCard {
    private GUInterface GUI;
    private InputFile InputFile1;
    private DBRecord DBRecordStat;
    private DBRecord DBRecordSize;
    JTextField JTextFilename;
    public static final int USE_MLE = 1;
    public static final int NO_MLE = 0;
    public int FlagMLE = 0;
    private JCheckBox mleCheckBox;
    private JComboBox<String> chooseA;
    private JComboBox<String> chooseB;
    private JButton varAnalysisButton;
    private JButton showAUCsButton;
    static DecimalFormat fiveDecE = new DecimalFormat("0.00000E0");

    public void resetInputFileCard() {
        this.JTextFilename.setText("");
        this.FlagMLE = 0;
        this.mleCheckBox.setSelected(false);
        this.chooseA.removeAllItems();
        this.chooseB.removeAllItems();
        this.chooseA.addItem("Choose Modality A");
        this.chooseB.addItem("Choose Modality B");
    }

    public InputFileCard(JPanel CardInputModeImrmc, GUInterface GUInterface_temp) {
        this.GUI = GUInterface_temp;
        this.InputFile1 = this.GUI.InputFile1;
        this.DBRecordStat = this.GUI.DBRecordStat;
        this.DBRecordSize = this.GUI.DBRecordSize;
        JLabel studyLabel = new JLabel(".imrmc or .csv file  ");
        this.JTextFilename = new JTextField(20);
        JButton browseButton = new JButton("Browse...");
        browseButton.addActionListener(new brwsButtonListener());
        JPanel RawStudyCardRow1 = new JPanel();
        RawStudyCardRow1.add(studyLabel);
        RawStudyCardRow1.add(this.JTextFilename);
        RawStudyCardRow1.add(browseButton);
        JButton readerCasesButton = new JButton("Show Statistics Charts");
        readerCasesButton.addActionListener(new ReadersCasesButtonListener());
        JButton designButton = new JButton("Show Study Design");
        designButton.addActionListener(new designButtonListener());
        JButton ROCcurveButton = new JButton("Show ROC Curve");
        ROCcurveButton.addActionListener(new ROCButtonListener());
        JPanel RawStudyCardRow2 = new JPanel();
        RawStudyCardRow2.add(readerCasesButton);
        RawStudyCardRow2.add(designButton);
        RawStudyCardRow2.add(ROCcurveButton);
        this.mleCheckBox = new JCheckBox("MLE (avoid negatives)");
        this.mleCheckBox.setSelected(false);
        this.mleCheckBox.addItemListener(new UseMLEListener());
        this.chooseA = new JComboBox();
        this.chooseB = new JComboBox();
        this.chooseA.addItemListener(new ModalitySelectListener());
        this.chooseB.addItemListener(new ModalitySelectListener());
        JPanel RawStudyCardRow3 = new JPanel();
        RawStudyCardRow3.add(this.mleCheckBox);
        RawStudyCardRow3.add(this.chooseA);
        RawStudyCardRow3.add(this.chooseB);
        this.varAnalysisButton = new JButton("MRMC Variance Analysis");
        this.varAnalysisButton.addActionListener(new varAnalysisListener());
        this.showAUCsButton = new JButton("Show Reader AUCs");
        this.showAUCsButton.addActionListener(new showAUCsButtonListener());
        JPanel RawStudyCardRow4 = new JPanel();
        RawStudyCardRow4.add(this.varAnalysisButton);
        RawStudyCardRow4.add(this.showAUCsButton);
        this.resetInputFileCard();
        GroupLayout layout = new GroupLayout(CardInputModeImrmc);
        CardInputModeImrmc.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(RawStudyCardRow1)).addGroup(layout.createSequentialGroup().addComponent(RawStudyCardRow2)).addGroup(layout.createSequentialGroup().addComponent(RawStudyCardRow3)).addGroup(layout.createSequentialGroup().addComponent(RawStudyCardRow4))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(RawStudyCardRow1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(RawStudyCardRow2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(RawStudyCardRow3)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(RawStudyCardRow4)));
    }

    class ModalitySelectListener
    implements ItemListener {
        ModalitySelectListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean modB;
            if (e.getStateChange() != 2) {
                return;
            }
            if (InputFileCard.this.chooseA.getSelectedItem() == null || InputFileCard.this.chooseB.getSelectedItem() == null) {
                return;
            }
            ((InputFileCard)InputFileCard.this).GUI.StatPanel1.resetStatPanel();
            ((InputFileCard)InputFileCard.this).GUI.StatPanel1.resetTable1();
            ((InputFileCard)InputFileCard.this).GUI.SizePanel1.resetSizePanel();
            boolean modA = !InputFileCard.this.chooseA.getSelectedItem().equals("Choose Modality A");
            boolean bl = modB = !InputFileCard.this.chooseB.getSelectedItem().equals("Choose Modality B");
            if (modA && !modB) {
                ((InputFileCard)InputFileCard.this).DBRecordStat.selectedMod = 0;
                ((InputFileCard)InputFileCard.this).DBRecordStat.modalityA = (String)InputFileCard.this.chooseA.getSelectedItem();
                ((InputFileCard)InputFileCard.this).DBRecordStat.modalityB = "NO_MOD";
                InputFileCard.this.varAnalysisButton.setText("MRMC Variance Analysis (A)");
            } else if (!modA && modB) {
                ((InputFileCard)InputFileCard.this).DBRecordStat.selectedMod = 1;
                ((InputFileCard)InputFileCard.this).DBRecordStat.modalityA = "NO_MOD";
                ((InputFileCard)InputFileCard.this).DBRecordStat.modalityB = (String)InputFileCard.this.chooseB.getSelectedItem();
                InputFileCard.this.varAnalysisButton.setText("MRMC Variance Analysis (B)");
            } else if (modA && modB) {
                ((InputFileCard)InputFileCard.this).DBRecordStat.selectedMod = 3;
                ((InputFileCard)InputFileCard.this).DBRecordStat.modalityA = (String)InputFileCard.this.chooseA.getSelectedItem();
                ((InputFileCard)InputFileCard.this).DBRecordStat.modalityB = (String)InputFileCard.this.chooseB.getSelectedItem();
                InputFileCard.this.varAnalysisButton.setText("MRMC Variance Analysis (Difference)");
            } else {
                InputFileCard.this.varAnalysisButton.setText("MRMC Variance Analysis");
                ((InputFileCard)InputFileCard.this).DBRecordStat.modalityA = "NO_MOD";
                ((InputFileCard)InputFileCard.this).DBRecordStat.modalityB = "NO_MOD";
                return;
            }
            ((InputFileCard)InputFileCard.this).DBRecordSize.selectedMod = ((InputFileCard)InputFileCard.this).DBRecordStat.selectedMod;
            ((InputFileCard)InputFileCard.this).DBRecordSize.modalityA = ((InputFileCard)InputFileCard.this).DBRecordStat.modalityA;
            ((InputFileCard)InputFileCard.this).DBRecordSize.modalityB = ((InputFileCard)InputFileCard.this).DBRecordStat.modalityB;
        }
    }

    class ROCButtonListener
    implements ActionListener {
        ROCButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InputFileCard.this.InputFile1.isLoaded()) {
                JPanel panel = new JPanel();
                int modalitynum = InputFileCard.this.InputFile1.getModalityIDs().size();
                JCheckBox[] jCheckboxArray = new JCheckBox[modalitynum];
                int i = 0;
                while (i < modalitynum) {
                    String modID = InputFileCard.this.InputFile1.getModalityIDs().get(i);
                    jCheckboxArray[i] = new JCheckBox(modID);
                    panel.add(jCheckboxArray[i]);
                    ++i;
                }
                Object[] message = new Object[]{"Which modality would you like view?\n", panel};
                JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), message, "Choose Modality", 1, null);
                int checkedmod = 0;
                int i2 = 0;
                while (i2 < modalitynum) {
                    if (jCheckboxArray[i2].isSelected()) {
                        ++checkedmod;
                    }
                    ++i2;
                }
                String[] rocMod = new String[checkedmod];
                String roctitle = "";
                int selectmod = 0;
                int i3 = 0;
                while (i3 < modalitynum) {
                    if (jCheckboxArray[i3].isSelected()) {
                        String modID;
                        rocMod[selectmod] = modID = InputFileCard.this.InputFile1.getModalityIDs().get(i3);
                        roctitle = String.valueOf(roctitle) + modID + " ";
                        ++selectmod;
                    }
                    ++i3;
                }
                if (selectmod > 0) {
                    ROCCurvePlot roc = new ROCCurvePlot("ROC Curve: Modality " + roctitle, "FPF (1 - Specificity), legend shows symbols for each modalityID:readerID", "TPF (Sensitivity)", InputFileCard.this.InputFile1.generateROCpoints(rocMod), ((InputFileCard)InputFileCard.this).InputFile1.filePathAndName, ((InputFileCard)InputFileCard.this).InputFile1.fileName);
                    roc.addData(InputFileCard.this.InputFile1.generatePooledROC(rocMod), "Pooled Average");
                    roc.pack();
                    RefineryUtilities.centerFrameOnScreen(roc);
                    roc.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), "Please choose at list one Modality.", "Error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), "Pilot study data has not yet been input.", "Error", 0);
            }
        }
    }

    class ReadersCasesButtonListener
    implements ActionListener {
        ReadersCasesButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InputFileCard.this.InputFile1 != null && InputFileCard.this.InputFile1.isLoaded()) {
                BarGraph cpr = new BarGraph("Cases per Reader", "Readers", "Cases", InputFileCard.this.InputFile1.casesPerReader());
                cpr.pack();
                RefineryUtilities.centerFrameOnScreen(cpr);
                cpr.setVisible(true);
                BarGraph rpc = new BarGraph("Readers per Case", "Cases", "Readers", InputFileCard.this.InputFile1.readersPerCase());
                rpc.pack();
                RefineryUtilities.centerFrameOnScreen(rpc);
                RefineryUtilities.positionFrameOnScreen(rpc, 0.6, 0.6);
                rpc.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), "Pilot study data has not yet been input.", "Error", 0);
            }
        }
    }

    class UseMLEListener
    implements ItemListener {
        UseMLEListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            InputFileCard.this.FlagMLE = InputFileCard.this.mleCheckBox.isSelected() ? 1 : 0;
            ((InputFileCard)InputFileCard.this).DBRecordStat.flagMLE = InputFileCard.this.FlagMLE;
            ((InputFileCard)InputFileCard.this).GUI.StatPanel1.resetStatPanel();
            ((InputFileCard)InputFileCard.this).GUI.StatPanel1.resetTable1();
            ((InputFileCard)InputFileCard.this).GUI.SizePanel1.resetSizePanel();
        }
    }

    class brwsButtonListener
    implements ActionListener {
        brwsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InputFileCard.this.GUI.resetGUI();
            if (GUInterface.selectedInput == "Please choose input file mode") {
                JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), "Please choose one kind of input file.", "Error", 0);
                return;
            }
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("iMRMC Input Files (.imrmc or csv)", "csv", "imrmc");
            if (((InputFileCard)InputFileCard.this).GUI.inputfileDirectory != null) {
                fc.setCurrentDirectory(((InputFileCard)InputFileCard.this).GUI.inputfileDirectory);
            }
            fc.setFileFilter(filter);
            int returnVal = fc.showOpenDialog((Component)e.getSource());
            if (returnVal == 1 || returnVal == -1) {
                return;
            }
            ((InputFileCard)InputFileCard.this).GUI.inputfileDirectory = fc.getCurrentDirectory();
            File f = fc.getSelectedFile();
            if (f == null) {
                return;
            }
            ((InputFileCard)InputFileCard.this).InputFile1.fileName = f.getName();
            ((InputFileCard)InputFileCard.this).InputFile1.filePath = f.getParent();
            ((InputFileCard)InputFileCard.this).InputFile1.filePathAndName = f.getPath();
            InputFileCard.this.JTextFilename.setText(f.getPath());
            try {
                InputFileCard.this.InputFile1.ReadInputFile(InputFileCard.this.GUI);
            }
            catch (IOException except) {
                except.printStackTrace();
                JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), except.getMessage(), "Error", 0);
                InputFileCard.this.GUI.resetGUI();
                InputFileCard.this.JTextFilename.setText("");
                return;
            }
            if (!((InputFileCard)InputFileCard.this).InputFile1.dataCheckResults.isEmpty()) {
                JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), ((InputFileCard)InputFileCard.this).InputFile1.dataCheckResults, "Warning: Input Header Values Do Not Match Actual Values", 2);
            } else {
                JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), "NR = " + ((InputFileCard)InputFileCard.this).InputFile1.Nreader + " N0 = " + ((InputFileCard)InputFileCard.this).InputFile1.Nnormal + " N1 = " + ((InputFileCard)InputFileCard.this).InputFile1.Ndisease + " NM = " + ((InputFileCard)InputFileCard.this).InputFile1.Nmodality, "Study Info", 1);
            }
            for (String ModalityID : InputFileCard.this.InputFile1.getModalityIDs()) {
                InputFileCard.this.chooseA.addItem(ModalityID);
                InputFileCard.this.chooseB.addItem(ModalityID);
            }
            ((InputFileCard)InputFileCard.this).DBRecordStat.modalityA = "NO_MOD";
            ((InputFileCard)InputFileCard.this).DBRecordStat.modalityB = "NO_MOD";
        }
    }

    class designButtonListener
    implements ActionListener {
        String designMod1 = "empty";

        designButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InputFileCard.this.InputFile1.isLoaded()) {
                JComboBox<String> choose1 = new JComboBox<String>();
                for (String Modality : InputFileCard.this.InputFile1.getModalityIDs()) {
                    choose1.addItem(Modality);
                }
                choose1.setSelectedIndex(0);
                Object[] message = new Object[]{"Which modality would you like view?\n", choose1};
                JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), message, "Choose Modality", 1, null);
                this.designMod1 = (String)choose1.getSelectedItem();
                TreeMap<String, String[][]> StudyDesignData = InputFileCard.this.InputFile1.getStudyDesign((String)choose1.getSelectedItem());
                StudyDesignPlot chart = new StudyDesignPlot("Study Design: Modality " + this.designMod1, this.designMod1, "Case Index", "Reader", StudyDesignData, ((InputFileCard)InputFileCard.this).InputFile1.filePathAndName, ((InputFileCard)InputFileCard.this).InputFile1.fileName);
                chart.pack();
                RefineryUtilities.centerFrameOnScreen(chart);
                chart.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), "Pilot study data has not yet been input.", "Error", 0);
            }
        }
    }

    class exportreaderresult
    implements ActionListener {
        exportreaderresult() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String head = "inputFile,date,iMRMCversion,NR,N0,N1,modalityA,modalityB,AUCA,varAUCA,AUCB,varAUCB,AUCAminusAUCB,varAUCAminusAUCB,pValueNormal,botCInormal,topCInormal,rejectNormal,dfBDG,pValueBDG,botCIBDG,topCIBDG,rejectBDG,dfHillis,pValueHillis,botCIHillis,topCIHillis,rejectHillis";
            String report = String.valueOf(head) + "\r\n";
            SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmm");
            Date currDate = new Date();
            String fileTime = dateForm.format(currDate);
            String inputFileName = ((InputFileCard)InputFileCard.this).InputFile1.fileName;
            String inputFilePathAndName = ((InputFileCard)InputFileCard.this).InputFile1.filePathAndName;
            String readerFilenamewithpath = String.valueOf(inputFilePathAndName.substring(0, inputFilePathAndName.lastIndexOf("."))) + "MRMCStatReaders" + fileTime + ".csv";
            String readerFilename = String.valueOf(inputFileName.substring(0, inputFileName.lastIndexOf("."))) + "MRMCStatReaders" + fileTime + ".csv";
            try {
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("iMRMC Summary Files (.csv)", "csv");
                fc.setFileFilter(filter);
                if (GUInterface.outputfileDirectory != null) {
                    fc.setSelectedFile(new File(GUInterface.outputfileDirectory + "//" + readerFilename));
                } else {
                    fc.setSelectedFile(new File(readerFilenamewithpath));
                }
                int fcReturn = fc.showSaveDialog((Component)e.getSource());
                if (fcReturn == 0) {
                    File f = fc.getSelectedFile();
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    String savedFileName = f.getPath();
                    report = exportToFile.exportReaders(report, InputFileCard.this.DBRecordStat, InputFileCard.this.InputFile1, fileTime);
                    FileWriter fw = new FileWriter(f.getAbsoluteFile());
                    BufferedWriter bw = new BufferedWriter(fw);
                    bw.write(report);
                    bw.close();
                    GUInterface.outputfileDirectory = fc.getCurrentDirectory();
                    String savedfilename = fc.getSelectedFile().getName();
                    JFrame frame = new JFrame();
                    JOptionPane.showMessageDialog(frame, "The size result has been succeed export to " + GUInterface.outputfileDirectory + " !\n" + "Filename = " + savedfilename, "Exported", 1);
                }
            }
            catch (HeadlessException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    class showAUCsButtonListener
    implements ActionListener {
        showAUCsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((InputFileCard)InputFileCard.this).DBRecordStat.totalVar > 0.0) {
                JFrame JFrameAUC = new JFrame("AUCs for each reader and modality");
                RefineryUtilities.centerFrameOnScreen(JFrameAUC);
                JFrameAUC.setDefaultCloseOperation(2);
                Object[] colNames = new Object[]{"ReaderID", "AUC " + ((InputFileCard)InputFileCard.this).DBRecordStat.modalityA, "AUC_STD " + ((InputFileCard)InputFileCard.this).DBRecordStat.modalityA, "AUC " + ((InputFileCard)InputFileCard.this).DBRecordStat.modalityB, "AUC_STD " + ((InputFileCard)InputFileCard.this).DBRecordStat.modalityB, "AUC difference", "AUC differencce STD"};
                Object[][] rowContent = new String[(int)((InputFileCard)InputFileCard.this).DBRecordStat.Nreader][7];
                int i = 0;
                for (String desc_temp : ((InputFileCard)InputFileCard.this).InputFile1.readerIDs.keySet()) {
                    rowContent[i][0] = desc_temp;
                    rowContent[i][1] = Double.toString(((InputFileCard)InputFileCard.this).DBRecordStat.AUCs[i][0]);
                    rowContent[i][2] = fiveDecE.format(Math.sqrt(((InputFileCard)InputFileCard.this).DBRecordStat.readerVarA[i]));
                    rowContent[i][3] = Double.toString(((InputFileCard)InputFileCard.this).DBRecordStat.AUCs[i][1]);
                    rowContent[i][4] = fiveDecE.format(Math.sqrt(((InputFileCard)InputFileCard.this).DBRecordStat.readerVarB[i]));
                    rowContent[i][5] = Double.toString(((InputFileCard)InputFileCard.this).DBRecordStat.AUCs[i][0] - ((InputFileCard)InputFileCard.this).DBRecordStat.AUCs[i][1]);
                    rowContent[i][6] = fiveDecE.format(Math.sqrt(((InputFileCard)InputFileCard.this).DBRecordStat.readerTotalVar[i]));
                    if (((InputFileCard)InputFileCard.this).DBRecordStat.selectedMod == 0) {
                        rowContent[i][3] = "N/A";
                        rowContent[i][4] = "N/A";
                        rowContent[i][5] = "N/A";
                        rowContent[i][6] = "N/A";
                    } else if (((InputFileCard)InputFileCard.this).DBRecordStat.selectedMod == 1) {
                        rowContent[i][1] = "N/A";
                        rowContent[i][2] = "N/A";
                        rowContent[i][5] = "N/A";
                        rowContent[i][6] = "N/A";
                    }
                    ++i;
                }
                JTable tableAUC = new JTable(rowContent, colNames);
                JScrollPane scrollPaneAUC = new JScrollPane(tableAUC);
                JFrameAUC.add((Component)scrollPaneAUC, "Center");
                JFrameAUC.setSize(800, 300);
                JFrameAUC.setVisible(true);
                JButton exportreader = new JButton("Export");
                exportreader.addActionListener(new exportreaderresult());
                JPanel exportPanel = new JPanel(new WrapLayout());
                exportPanel.add(exportreader);
                JFrameAUC.add((Component)exportPanel, "Last");
            } else {
                JOptionPane.showMessageDialog(((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame(), "Pilot study data has not yet been analyzed.", "Error", 0);
            }
        }
    }

    class varAnalysisListener
    implements ActionListener {
        varAnalysisListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("MRMC Variance analysis button clicked. RawStudyCard.varAnalysisListener");
            String name = InputFileCard.this.JTextFilename.getText();
            System.out.println("name=" + name);
            if (name.equals(null) || name.equals("")) {
                JFrame frame = ((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame();
                JOptionPane.showMessageDialog(frame, "Please browse for .imrmc or.csv input file", " Error", 0);
                return;
            }
            if (((InputFileCard)InputFileCard.this).DBRecordStat.modalityA == "NO_MOD" && ((InputFileCard)InputFileCard.this).DBRecordStat.modalityB == "NO_MOD") {
                JFrame frame = ((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame();
                JOptionPane.showMessageDialog(frame, "You must select at least one modality", "Error", 0);
                return;
            }
            if (((InputFileCard)InputFileCard.this).DBRecordStat.modalityA.compareTo(((InputFileCard)InputFileCard.this).DBRecordStat.modalityB) == 0) {
                JFrame frame = ((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame();
                JOptionPane.showMessageDialog(frame, "Modalities must be different", " Error", 0);
                return;
            }
            InputFileCard.this.DBRecordStat.DBRecordStatFill(InputFileCard.this.InputFile1, InputFileCard.this.DBRecordStat);
            ((InputFileCard)InputFileCard.this).GUI.hasNegative = !(((InputFileCard)InputFileCard.this).DBRecordStat.totalVar > 0.0);
            if (((InputFileCard)InputFileCard.this).GUI.hasNegative && InputFileCard.this.FlagMLE == 0) {
                JFrame frame = ((InputFileCard)InputFileCard.this).GUI.MRMCobject.getFrame();
                int result = JOptionPane.showConfirmDialog(frame, "The total variance estimate is negative.\nPlease report to the program developers. This is not expected.\nDo you want to proceed with MLE estimates to avoid negatives?");
                if (2 == result) {
                    System.out.println("cancel");
                } else if (result == 0) {
                    ((InputFileCard)InputFileCard.this).DBRecordStat.flagMLE = InputFileCard.this.FlagMLE = 1;
                    InputFileCard.this.mleCheckBox.setSelected(true);
                    ((InputFileCard)InputFileCard.this).DBRecordStat.totalVar = ((InputFileCard)InputFileCard.this).DBRecordStat.totalVarMLE;
                    ((InputFileCard)InputFileCard.this).DBRecordStat.varA = ((InputFileCard)InputFileCard.this).DBRecordStat.varAMLE;
                    ((InputFileCard)InputFileCard.this).DBRecordStat.varB = ((InputFileCard)InputFileCard.this).DBRecordStat.varBMLE;
                    ((InputFileCard)InputFileCard.this).DBRecordStat.readerTotalVar = ((InputFileCard)InputFileCard.this).DBRecordStat.readerTotalVarMLE;
                    ((InputFileCard)InputFileCard.this).DBRecordStat.readerVarA = ((InputFileCard)InputFileCard.this).DBRecordStat.readerVarAMLE;
                    ((InputFileCard)InputFileCard.this).DBRecordStat.readerVarB = ((InputFileCard)InputFileCard.this).DBRecordStat.readerVarBMLE;
                    ((InputFileCard)InputFileCard.this).DBRecordStat.SE = Math.sqrt(((InputFileCard)InputFileCard.this).DBRecordStat.totalVar);
                    ((InputFileCard)InputFileCard.this).DBRecordStat.testStat = new StatTest(InputFileCard.this.DBRecordStat);
                } else if (1 == result) {
                    InputFileCard.this.FlagMLE = 0;
                }
            }
            ((InputFileCard)InputFileCard.this).DBRecordStat.flagMLE = InputFileCard.this.FlagMLE;
            ((InputFileCard)InputFileCard.this).GUI.StatPanel1.setStatPanel();
            ((InputFileCard)InputFileCard.this).GUI.StatPanel1.setTable1();
            ((InputFileCard)InputFileCard.this).DBRecordSize.Nreader = ((InputFileCard)InputFileCard.this).DBRecordStat.Nreader;
            ((InputFileCard)InputFileCard.this).DBRecordSize.Nnormal = ((InputFileCard)InputFileCard.this).DBRecordStat.Nnormal;
            ((InputFileCard)InputFileCard.this).DBRecordSize.Ndisease = ((InputFileCard)InputFileCard.this).DBRecordStat.Ndisease;
            ((InputFileCard)InputFileCard.this).GUI.SizePanel1.NreaderJTextField.setText(Long.toString(((InputFileCard)InputFileCard.this).DBRecordStat.NreaderDB));
            ((InputFileCard)InputFileCard.this).GUI.SizePanel1.NnormalJTextField.setText(Long.toString(((InputFileCard)InputFileCard.this).DBRecordStat.NnormalDB));
            ((InputFileCard)InputFileCard.this).GUI.SizePanel1.NdiseaseJTextField.setText(Long.toString(((InputFileCard)InputFileCard.this).DBRecordStat.NdiseaseDB));
        }
    }
}

