/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.ISsf;

public class RwExtendedSsf
implements ISsf {
    private final int mr_;
    private final int r_;
    private final SubMatrix X_;
    private final double[] cvar_;
    private ISsf ssf_;
    private DataBlock tmp_;

    public RwExtendedSsf(ISsf ssf, SubMatrix X, DataBlock var) {
        this.ssf_ = ssf;
        this.X_ = X;
        this.mr_ = ssf.getStateDim();
        this.r_ = this.mr_ + X.getColumnsCount();
        this.tmp_ = new DataBlock(this.r_);
        this.cvar_ = new double[this.X_.getColumnsCount()];
        var.copyTo(this.cvar_, 0);
    }

    public RwExtendedSsf(ISsf ssf, SubMatrix X, double var) {
        this.ssf_ = ssf;
        this.X_ = X;
        this.mr_ = ssf.getStateDim();
        this.r_ = this.mr_ + X.getColumnsCount();
        this.tmp_ = new DataBlock(this.r_);
        this.cvar_ = new double[X.getColumnsCount()];
        for (int i = 0; i < this.cvar_.length; ++i) {
            this.cvar_[i] = var;
        }
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        int nd = this.ssf_.getNonStationaryDim();
        if (nd > 0) {
            this.ssf_.diffuseConstraints(b.extract(0, this.mr_, 0, nd));
        }
        b.extract(this.mr_, this.r_, nd, nd + this.X_.getColumnsCount()).diagonal().set(1.0);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        this.ssf_.fullQ(pos, qm.extract(0, this.mr_, 0, this.mr_));
        if (this.cvar_.length == 1) {
            qm.diagonal().drop(this.mr_, 0).set(this.cvar_[0]);
        } else {
            qm.diagonal().drop(this.mr_, 0).copyFrom(this.cvar_, 0);
        }
    }

    public int getFinalPosition() {
        return this.X_.getRowsCount();
    }

    @Override
    public int getNonStationaryDim() {
        return this.ssf_.getNonStationaryDim() + this.X_.getColumnsCount();
    }

    @Override
    public int getStateDim() {
        return this.r_;
    }

    @Override
    public int getTransitionResCount() {
        return this.ssf_.getTransitionResCount() + this.X_.getColumnsCount();
    }

    @Override
    public int getTransitionResDim() {
        return this.ssf_.getTransitionResDim() + this.cvar_.length;
    }

    public SubMatrix getX() {
        return this.X_;
    }

    @Override
    public boolean hasR() {
        return this.ssf_.hasR();
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return this.ssf_.hasW() || this.cvar_.length != this.X_.getColumnsCount();
    }

    @Override
    public boolean isDiffuse() {
        return true;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return this.ssf_.isTransitionEquationTimeInvariant();
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return this.ssf_.isTransitionResidualTimeInvariant();
    }

    @Override
    public boolean isValid() {
        return this.ssf_.isValid();
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        this.T(pos, lm);
        this.tmp_.set(0.0);
        this.Z(pos, this.tmp_);
        DataBlockIterator cols = lm.columns();
        DataBlock col = cols.getData();
        do {
            double w;
            if ((w = this.tmp_.get(cols.getPosition())) == 0.0) continue;
            col.addAY(-w, k);
        } while (cols.next());
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        this.ssf_.Pf0(pf0.extract(0, this.mr_, 0, this.mr_));
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        this.ssf_.Pi0(pi0.extract(0, this.mr_, 0, this.mr_));
        pi0.extract(this.mr_, this.r_, this.mr_, this.r_).diagonal().set(1.0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        int n = this.ssf_.getTransitionResDim();
        this.ssf_.Q(pos, qm.extract(0, n, 0, n));
        qm.diagonal().drop(n, 0).copyFrom(this.cvar_, 0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        int n = this.ssf_.getTransitionResCount();
        this.ssf_.R(pos, rv);
        this.ssf_.R(pos, rv.range(0, n));
        for (int i = 0; i < this.X_.getColumnsCount(); ++i) {
            rv.set(n + i, this.mr_ + i);
        }
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        this.ssf_.T(pos, tr.extract(0, this.mr_, 0, this.mr_));
        tr.extract(this.mr_, this.r_, this.mr_, this.r_).diagonal().set(1.0);
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        this.ssf_.TVT(pos, vm.extract(0, this.mr_, 0, this.mr_));
        SubMatrix v01 = vm.extract(0, this.mr_, this.mr_, this.r_);
        SubMatrix v10 = vm.extract(this.mr_, this.r_, 0, this.mr_);
        DataBlockIterator cols = v01.columns();
        DataBlockIterator rows = v10.rows();
        DataBlock col = cols.getData();
        DataBlock row = rows.getData();
        do {
            this.ssf_.TX(pos, col);
            row.copy(col);
        } while (cols.next() && rows.next());
    }

    @Override
    public void TX(int pos, DataBlock x) {
        this.ssf_.TX(pos, x.range(0, this.mr_));
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        this.tmp_.set(0.0);
        this.Z(pos, this.tmp_);
        DataBlockIterator cols = vm.columns();
        DataBlock col = cols.getData();
        do {
            double w;
            if ((w = d * this.tmp_.get(cols.getPosition())) == 0.0) continue;
            col.addAY(w, this.tmp_);
        } while (cols.next());
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        int nr = this.ssf_.getTransitionResCount();
        int dr = this.ssf_.getTransitionResDim();
        this.ssf_.W(pos, wv.extract(0, nr, 0, dr));
        if (this.cvar_.length == 1) {
            wv.column(dr).drop(nr, 0).set(1.0);
        } else {
            for (int i = 0; i < this.X_.getColumnsCount(); ++i) {
                wv.set(nr + i, dr + i, 1.0);
            }
        }
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        DataBlock xm = x.range(0, this.mr_);
        this.ssf_.XpZd(pos, xm, d);
        DataBlock xx = x.range(this.mr_, this.r_);
        DataBlock X = this.X_.row(pos);
        xx.addAY(d, X);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        this.ssf_.XT(pos, x.range(0, this.mr_));
    }

    @Override
    public void Z(int pos, DataBlock x) {
        this.ssf_.Z(pos, x.range(0, this.mr_));
        x.range(this.mr_, this.r_).copy(this.X_.row(pos));
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        DataBlockIterator cols = m.columns();
        DataBlock col = cols.getData();
        for (int i = 0; i < m.getColumnsCount(); ++i) {
            x.set(i, this.ZX(pos, col));
            cols.next();
        }
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        double v00 = this.ssf_.ZVZ(pos, vm.extract(0, this.mr_, 0, this.mr_));
        double v11 = SymmetricMatrix.quadraticForm(vm.extract(this.mr_, this.r_, this.mr_, this.r_), this.X_.row(pos));
        DataBlock tmp = this.tmp_.range(this.mr_, this.r_);
        this.ssf_.ZM(pos, vm.extract(0, this.mr_, this.mr_, this.r_), tmp);
        double v01 = tmp.dot(this.X_.row(pos));
        return v00 + 2.0 * v01 + v11;
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        return this.ssf_.ZX(pos, x.range(0, this.mr_)) + x.range(this.mr_, this.r_).dot(this.X_.row(pos));
    }
}

