/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.ArmaKF;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.Likelihood;

public class RegArimaEstimation<M extends IArimaModel> {
    public final RegArimaModel<M> model;
    public final ConcentratedLikelihood likelihood;

    public RegArimaEstimation(RegArimaModel<M> model, ConcentratedLikelihood likelihood) {
        this.model = model;
        this.likelihood = likelihood;
    }

    public LikelihoodStatistics statistics(int nparams, double adj) {
        LikelihoodStatistics stats = new LikelihoodStatistics();
        stats.observationsCount = this.model.getObsCount();
        stats.effectiveObservationsCount = stats.observationsCount - this.model.getArima().getNonStationaryARCount();
        stats.logLikelihood = this.likelihood.getLogLikelihood();
        stats.estimatedParametersCount = this.model.getVarsCount() + nparams + 1;
        if (Double.isNaN(adj)) {
            adj = 0.0;
        }
        stats.transformationAdjustment = adj;
        stats.adjustedLogLikelihood = adj == 0.0 ? stats.logLikelihood : stats.logLikelihood + stats.transformationAdjustment;
        stats.SsqErr = this.likelihood.getSsqErr();
        stats.adjustForMissing(this.model.getMissingsCount());
        stats.calc();
        return stats;
    }

    public double[] fullResiduals() {
        if (this.model.getVarsCount() == 0) {
            return this.likelihood.getResiduals();
        }
        DataBlock e = this.model.getDModel().calcRes(new DataBlock(this.likelihood.getB()));
        ArmaKF kf = new ArmaKF((IArimaModel)this.model.getArma());
        Likelihood tmp = new Likelihood();
        kf.process(e, tmp);
        return tmp.getResiduals();
    }
}

