/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jd2.workspace.io.IO;
import jd2.workspace.io.Xml;
import lombok.Generated;
import lombok.NonNull;

public final class Stax {
    private Stax() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void preventXXE(@org.checkerframework.checker.nullness.qual.NonNull XMLInputFactory factory) {
        Stax.setFeature(factory, "javax.xml.stream.supportDTD", false);
        Stax.setFeature(factory, "javax.xml.stream.isSupportingExternalEntities", false);
    }

    private static void setFeature(XMLInputFactory factory, String feature, boolean value) {
        if (factory.isPropertySupported(feature) && (Boolean)factory.getProperty(feature) != value) {
            factory.setProperty(feature, value);
        }
    }

    @FunctionalInterface
    private static interface XSupplier<T> {
        public T create(XMLInputFactory var1) throws XMLStreamException;
    }

    public static final class EventParser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final FlowHandler<XMLEventReader, T> handler;
        @NonNull
        private final IO.Supplier<? extends XMLInputFactory> factory;
        private boolean preventXXE;

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> flowOf(@org.checkerframework.checker.nullness.qual.NonNull FlowHandler<XMLEventReader, T> handler) {
            return EventParser.builder().handler(handler).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull EventParser<T> valueOf(@org.checkerframework.checker.nullness.qual.NonNull ValueHandler<XMLEventReader, T> handler) {
            return EventParser.builder().handler(handler.asFlow()).build();
        }

        @Override
        public T parseReader(IO.Supplier<? extends Reader> source) throws IOException {
            Reader resource = source.getWithIO();
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), (Closeable)resource);
        }

        @Override
        public T parseStream(IO.Supplier<? extends InputStream> source) throws IOException {
            InputStream resource = source.getWithIO();
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), (Closeable)resource);
        }

        @Override
        public T parseReader(Reader resource) throws IOException {
            Objects.requireNonNull(resource);
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), IO.Runnable.noOp().asCloseable());
        }

        @Override
        public T parseStream(InputStream resource) throws IOException {
            Objects.requireNonNull(resource);
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), IO.Runnable.noOp().asCloseable());
        }

        private T parse(XSupplier<XMLEventReader> supplier, Closeable onClose) throws IOException {
            try {
                XMLEventReader input = supplier.create(this.getEngine());
                return this.parse(input, () -> EventParser.closeBoth(input, onClose));
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (IOException | Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
        }

        private T parse(XMLEventReader input, Closeable onClose) throws IOException {
            try {
                return this.handler.parse(input, onClose);
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (IOException | Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
        }

        private XMLInputFactory getEngine() throws IOException {
            XMLInputFactory result = this.factory.getWithIO();
            if (this.preventXXE) {
                Stax.preventXXE(result);
            }
            return result;
        }

        private static void closeBoth(XMLEventReader input, Closeable onClose) throws IOException {
            try {
                input.close();
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
            onClose.close();
        }

        @Generated
        private static <T> IO.Supplier<? extends XMLInputFactory> $default$factory() {
            return XMLInputFactory::newFactory;
        }

        @Generated
        private static <T> boolean $default$preventXXE() {
            return true;
        }

        @Generated
        EventParser(@NonNull FlowHandler<XMLEventReader, T> handler, @NonNull IO.Supplier<? extends XMLInputFactory> factory, boolean preventXXE) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.handler = handler;
            this.factory = factory;
            this.preventXXE = preventXXE;
        }

        @Generated
        public static <T> Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public Builder<T> toBuilder() {
            return new Builder<T>().handler(this.handler).factory(this.factory).preventXXE(this.preventXXE);
        }

        @Generated
        public static class Builder<T> {
            @Generated
            private FlowHandler<XMLEventReader, T> handler;
            @Generated
            private boolean factory$set;
            @Generated
            private IO.Supplier<? extends XMLInputFactory> factory$value;
            @Generated
            private boolean preventXXE$set;
            @Generated
            private boolean preventXXE$value;

            @Generated
            Builder() {
            }

            @Generated
            public Builder<T> handler(@NonNull FlowHandler<XMLEventReader, T> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is marked non-null but is null");
                }
                this.handler = handler;
                return this;
            }

            @Generated
            public Builder<T> factory(@NonNull IO.Supplier<? extends XMLInputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory$value = factory;
                this.factory$set = true;
                return this;
            }

            @Generated
            public Builder<T> preventXXE(boolean preventXXE) {
                this.preventXXE$value = preventXXE;
                this.preventXXE$set = true;
                return this;
            }

            @Generated
            public EventParser<T> build() {
                IO.Supplier factory$value = this.factory$value;
                if (!this.factory$set) {
                    factory$value = EventParser.$default$factory();
                }
                boolean preventXXE$value = this.preventXXE$value;
                if (!this.preventXXE$set) {
                    preventXXE$value = EventParser.$default$preventXXE();
                }
                return new EventParser<T>(this.handler, factory$value, preventXXE$value);
            }

            @Generated
            public String toString() {
                return "Stax.EventParser.Builder(handler=" + this.handler + ", factory$value=" + this.factory$value + ", preventXXE$value=" + this.preventXXE$value + ")";
            }
        }
    }

    public static final class StreamParser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final FlowHandler<XMLStreamReader, T> handler;
        @NonNull
        private final IO.Supplier<? extends XMLInputFactory> factory;
        private boolean preventXXE;

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> flowOf(@org.checkerframework.checker.nullness.qual.NonNull FlowHandler<XMLStreamReader, T> handler) {
            return StreamParser.builder().handler(handler).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull StreamParser<T> valueOf(@org.checkerframework.checker.nullness.qual.NonNull ValueHandler<XMLStreamReader, T> handler) {
            return StreamParser.builder().handler(handler.asFlow()).build();
        }

        @Override
        public T parseReader(IO.Supplier<? extends Reader> source) throws IOException {
            Reader resource = source.getWithIO();
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), (Closeable)resource);
        }

        @Override
        public T parseStream(IO.Supplier<? extends InputStream> source) throws IOException {
            InputStream resource = source.getWithIO();
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), (Closeable)resource);
        }

        @Override
        public T parseReader(Reader resource) throws IOException {
            Objects.requireNonNull(resource);
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), IO.Runnable.noOp().asCloseable());
        }

        @Override
        public T parseStream(InputStream resource) throws IOException {
            Objects.requireNonNull(resource);
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), IO.Runnable.noOp().asCloseable());
        }

        public @org.checkerframework.checker.nullness.qual.NonNull T parse(@org.checkerframework.checker.nullness.qual.NonNull XMLStreamReader input, @org.checkerframework.checker.nullness.qual.NonNull Closeable onClose) throws IOException {
            try {
                return this.handler.parse(input, onClose);
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (IOException | Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
        }

        private T parse(XSupplier<XMLStreamReader> supplier, Closeable onClose) throws IOException {
            try {
                XMLStreamReader input = supplier.create(this.getEngine());
                return this.parse(input, () -> StreamParser.closeBoth(input, onClose));
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (IOException | Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
        }

        private XMLInputFactory getEngine() throws IOException {
            XMLInputFactory result = this.factory.getWithIO();
            if (this.preventXXE) {
                Stax.preventXXE(result);
            }
            return result;
        }

        private static void closeBoth(XMLStreamReader input, Closeable onClose) throws IOException {
            try {
                input.close();
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
            onClose.close();
        }

        @Generated
        private static <T> IO.Supplier<? extends XMLInputFactory> $default$factory() {
            return XMLInputFactory::newFactory;
        }

        @Generated
        private static <T> boolean $default$preventXXE() {
            return true;
        }

        @Generated
        StreamParser(@NonNull FlowHandler<XMLStreamReader, T> handler, @NonNull IO.Supplier<? extends XMLInputFactory> factory, boolean preventXXE) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.handler = handler;
            this.factory = factory;
            this.preventXXE = preventXXE;
        }

        @Generated
        public static <T> Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public Builder<T> toBuilder() {
            return new Builder<T>().handler(this.handler).factory(this.factory).preventXXE(this.preventXXE);
        }

        @Generated
        public static class Builder<T> {
            @Generated
            private FlowHandler<XMLStreamReader, T> handler;
            @Generated
            private boolean factory$set;
            @Generated
            private IO.Supplier<? extends XMLInputFactory> factory$value;
            @Generated
            private boolean preventXXE$set;
            @Generated
            private boolean preventXXE$value;

            @Generated
            Builder() {
            }

            @Generated
            public Builder<T> handler(@NonNull FlowHandler<XMLStreamReader, T> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is marked non-null but is null");
                }
                this.handler = handler;
                return this;
            }

            @Generated
            public Builder<T> factory(@NonNull IO.Supplier<? extends XMLInputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory$value = factory;
                this.factory$set = true;
                return this;
            }

            @Generated
            public Builder<T> preventXXE(boolean preventXXE) {
                this.preventXXE$value = preventXXE;
                this.preventXXE$set = true;
                return this;
            }

            @Generated
            public StreamParser<T> build() {
                IO.Supplier factory$value = this.factory$value;
                if (!this.factory$set) {
                    factory$value = StreamParser.$default$factory();
                }
                boolean preventXXE$value = this.preventXXE$value;
                if (!this.preventXXE$set) {
                    preventXXE$value = StreamParser.$default$preventXXE();
                }
                return new StreamParser<T>(this.handler, factory$value, preventXXE$value);
            }

            @Generated
            public String toString() {
                return "Stax.StreamParser.Builder(handler=" + this.handler + ", factory$value=" + this.factory$value + ", preventXXE$value=" + this.preventXXE$value + ")";
            }
        }
    }

    @FunctionalInterface
    public static interface ValueHandler<I, T> {
        public @org.checkerframework.checker.nullness.qual.NonNull T parse(@org.checkerframework.checker.nullness.qual.NonNull I var1) throws XMLStreamException;

        default public @org.checkerframework.checker.nullness.qual.NonNull FlowHandler<I, T> asFlow() {
            return (input, onClose) -> {
                try (Closeable c = onClose;){
                    T t = this.parse(input);
                    return t;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface FlowHandler<I, T> {
        public @org.checkerframework.checker.nullness.qual.NonNull T parse(@org.checkerframework.checker.nullness.qual.NonNull I var1, @org.checkerframework.checker.nullness.qual.NonNull Closeable var2) throws IOException, XMLStreamException;

        public static <I, T> @org.checkerframework.checker.nullness.qual.NonNull FlowHandler<I, T> of(@org.checkerframework.checker.nullness.qual.NonNull ValueHandler<I, T> handler) {
            return handler.asFlow();
        }
    }
}

