/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import dr.geo.contouring.ContourAttrib;
import dr.geo.contouring.ContourGenerator;
import dr.geo.contouring.ContourMaker;
import dr.geo.contouring.ContourPath;
import dr.math.distributions.NormalDistribution;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;
import dr.stats.DiscreteStatistics;
import java.util.Arrays;

public class KernelDensityEstimator2D
implements ContourMaker {
    private double margin = 0.1;
    private final double[] x;
    private final double[] y;
    private double[] h;
    private final int n;
    private double[] lims;
    private int nx;
    private double[] gx;
    private double[] gy;
    private double[][] z;
    private final boolean limitBandwidth;

    public KernelDensityEstimator2D(double[] dArray, double[] dArray2, double[] dArray3, int n, double[] dArray4) {
        this(dArray, dArray2, dArray3, n, dArray4, false);
    }

    public KernelDensityEstimator2D(double[] dArray, double[] dArray2, double[] dArray3, int n, double[] dArray4, boolean bl) {
        this.x = dArray;
        this.y = dArray2;
        if (dArray.length != dArray2.length) {
            throw new RuntimeException("data vectors must be the same length");
        }
        this.nx = dArray.length;
        if (n <= 0) {
            throw new RuntimeException("must have a positive number of grid points");
        }
        this.n = n;
        if (dArray4 != null) {
            this.lims = dArray4;
        } else {
            this.setupLims();
        }
        this.limitBandwidth = bl;
        if (dArray3 != null) {
            this.h = dArray3;
        } else {
            this.setupH();
        }
        this.doKDE2D();
    }

    public KernelDensityEstimator2D(double[] dArray, double[] dArray2, boolean bl) {
        this(dArray, dArray2, null, 50, null, bl);
    }

    public KernelDensityEstimator2D(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, null, 50, null);
    }

    public KernelDensityEstimator2D(double[] dArray, double[] dArray2, int n) {
        this(dArray, dArray2, null, n, null);
    }

    public void doKDE2D() {
        this.gx = this.makeSequence(this.lims[0], this.lims[1], this.n);
        this.gy = this.makeSequence(this.lims[2], this.lims[3], this.n);
        double[][] dArray = this.outerMinusScaled(this.gx, this.x, this.h[0]);
        double[][] dArray2 = this.outerMinusScaled(this.gy, this.y, this.h[1]);
        this.normalize(dArray);
        this.normalize(dArray2);
        this.z = new double[this.n][this.n];
        double d = (double)this.nx * this.h[0] * this.h[1];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                double d2 = 0.0;
                for (int k = 0; k < this.nx; ++k) {
                    d2 += dArray[i][k] * dArray2[j][k];
                }
                this.z[i][j] = d2 / d;
            }
        }
    }

    public double findLevelCorrespondingToMass(double d) {
        double d2 = 0.0;
        double[] dArray = new double[this.n * this.n];
        double[] dArray2 = new double[this.n * this.n];
        for (int i = 0; i < this.n; ++i) {
            System.arraycopy(this.z[i], 0, dArray, i * this.n, this.n);
        }
        Arrays.sort(dArray);
        double d3 = this.gx[1] - this.gx[0];
        double d4 = this.gy[1] - this.gy[0];
        double d5 = d3 * d4;
        dArray2[0] = dArray[0] * d5;
        double d6 = 1.0 - d;
        if (d6 < dArray2[0] || d6 >= 1.0) {
            throw new RuntimeException();
        }
        for (int i = 1; i < this.n * this.n; ++i) {
            dArray2[i] = dArray[i] * d5 + dArray2[i - 1];
            if (!(dArray2[i] > d6)) continue;
            double d7 = dArray2[i] - dArray2[i - 1];
            double d8 = dArray[i] - dArray[i - 1];
            d2 = dArray[i] - (dArray2[i] - d6) / d7 * d8;
            break;
        }
        return d2;
    }

    @Override
    public ContourPath[] getContourPaths(double d) {
        double d2 = this.findLevelCorrespondingToMass(d);
        ContourGenerator contourGenerator = new ContourGenerator(this.getXGrid(), this.getYGrid(), this.getKDE(), new ContourAttrib[]{new ContourAttrib(d2)});
        ContourPath[] contourPathArray = null;
        try {
            contourPathArray = contourGenerator.getContours();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return contourPathArray;
    }

    public double[][] getKDE() {
        return this.z;
    }

    public double[] getXGrid() {
        return this.gx;
    }

    public double[] getYGrid() {
        return this.gy;
    }

    public void normalize(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray[i][j] = NormalDistribution.pdf(dArray[i][j], 0.0, 1.0);
            }
        }
    }

    public double[][] outerMinusScaled(double[] dArray, double[] dArray2, double d) {
        double[][] dArray3 = new double[dArray.length][dArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                dArray3[i][j] = (dArray[i] - dArray2[j]) / d;
            }
        }
        return dArray3;
    }

    public double[] makeSequence(double d, double d2, int n) {
        double[] dArray = new double[n];
        double d3 = (d2 - d) / (double)(n - 1);
        double d4 = d;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = d4;
            ++n2;
            d4 += d3;
        }
        return dArray;
    }

    private void setupLims() {
        this.lims = new double[4];
        this.lims[0] = DiscreteStatistics.min(this.x);
        this.lims[1] = DiscreteStatistics.max(this.x);
        this.lims[2] = DiscreteStatistics.min(this.y);
        this.lims[3] = DiscreteStatistics.max(this.y);
        double d = (this.lims[1] - this.lims[0]) * this.margin;
        double d2 = (this.lims[3] - this.lims[2]) * this.margin;
        this.lims[0] = this.lims[0] - d;
        this.lims[1] = this.lims[1] + d;
        this.lims[2] = this.lims[2] - d2;
        this.lims[3] = this.lims[3] + d2;
    }

    private void setupH() {
        this.h = new double[2];
        this.h[0] = this.bandwidthNRD(this.x) / 4.0;
        this.h[1] = this.bandwidthNRD(this.y) / 4.0;
        if (this.limitBandwidth) {
            if (this.h[0] > 0.5) {
                this.h[0] = 0.5;
            }
            if (this.h[1] > 0.5) {
                this.h[1] = 0.5;
            }
        }
    }

    public double bandwidthNRD(double[] dArray) {
        DoubleArrayList doubleArrayList = new DoubleArrayList(dArray.length);
        for (double d : dArray) {
            doubleArrayList.add(d);
        }
        doubleArrayList.sort();
        double d = (Descriptive.quantile(doubleArrayList, 0.75) - Descriptive.quantile(doubleArrayList, 0.25)) / 1.34;
        return 4.24 * Math.min(Math.sqrt(DiscreteStatistics.variance(dArray)), d) * Math.pow(dArray.length, -0.2);
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{3.4, 1.2, 5.6, 2.2, 3.1};
        double[] dArray2 = new double[]{1.0, 2.0, 1.0, 2.0, 1.0};
        KernelDensityEstimator2D kernelDensityEstimator2D = new KernelDensityEstimator2D(dArray, dArray2, 4);
        System.out.println(new Vector(kernelDensityEstimator2D.getXGrid()));
        System.out.println(new Vector(kernelDensityEstimator2D.getYGrid()));
        System.out.println(new Matrix(kernelDensityEstimator2D.getKDE()));
        System.exit(-1);
    }

    public double[] getLims() {
        return this.lims;
    }
}

