/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous.cdi;

public enum CDIFlag {
    PRECISION_SINGLE(1L, "double precision computation"),
    PRECISION_DOUBLE(2L, "single precision computation"),
    COMPUTATION_SYNCH(4L, "synchronous computation (blocking"),
    COMPUTATION_ASYNCH(8L, "asynchronous computation (non-blocking)"),
    VECTOR_SSE(2048L, "SSE vector computation"),
    VECTOR_NONE(4096L, "no vector computation"),
    THREADING_TBB(8192L, "TBB threading"),
    THREADING_NONE(16384L, "no threading"),
    PROCESSOR_CPU(32768L, "use CPU as main processor"),
    PROCESSOR_GPU(65536L, "use GPU as main processor"),
    PROCESSOR_FPGA(131072L, "use FPGA as main processor"),
    PROCESSOR_CELL(262144L, "use CELL as main processor"),
    FRAMEWORK_CUDA(0x400000L, "use CUDA implementation with GPU resources"),
    FRAMEWORK_OPENCL(0x800000L, "use OpenCL implementation with CPU or GPU resources"),
    FRAMEWORK_CPU(0x8000000L, "use CPU implementation");

    private final long mask;
    private final String meaning;

    private CDIFlag(long l, String string2) {
        this.mask = l;
        this.meaning = string2;
    }

    public long getMask() {
        return this.mask;
    }

    public String getMeaning() {
        return this.meaning;
    }

    public boolean isSet(long l) {
        return (l & this.mask) != 0L;
    }

    public static String toString(long l) {
        CDIFlag[] cDIFlagArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (CDIFlag cDIFlag : cDIFlagArray = CDIFlag.values()) {
            if (!cDIFlag.isSet(l)) continue;
            stringBuilder.append(" ").append(cDIFlag.name());
        }
        return stringBuilder.toString();
    }
}

