/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.TreeTraversal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LikelihoodTreeTraversal
extends TreeTraversal {
    private final List<ProcessOnTreeDelegate.BranchOperation> branchOperations = new ArrayList<ProcessOnTreeDelegate.BranchOperation>();
    private final List<ProcessOnTreeDelegate.NodeOperation> nodeOperations = new ArrayList<ProcessOnTreeDelegate.NodeOperation>();
    private List<ProcessOnTreeDelegate.BranchNodeOperation> savedWholeTreeBranchOperations;
    private List<ProcessOnTreeDelegate.NodeOperation> savedWholeTreeNodeOperations;

    public LikelihoodTreeTraversal(Tree tree, BranchRateModel branchRateModel, TreeTraversal.TraversalType traversalType) {
        super(tree, branchRateModel, traversalType);
    }

    @Override
    public final void dispatchTreeTraversalCollectBranchAndNodeOperations() {
        this.branchOperations.clear();
        this.nodeOperations.clear();
        switch (this.traversalType) {
            case POST_ORDER: {
                this.traversePostOrder(this.treeModel);
                break;
            }
            case REVERSE_LEVEL_ORDER: {
                this.traverseReverseLevelOrder(this.treeModel);
                break;
            }
            default: {
                assert (false) : "Unknown traversal type";
                break;
            }
        }
    }

    public final List<ProcessOnTreeDelegate.BranchOperation> getBranchOperations() {
        return this.branchOperations;
    }

    public final List<ProcessOnTreeDelegate.NodeOperation> getNodeOperations() {
        return this.nodeOperations;
    }

    private void traversePostOrder(Tree tree) {
        this.traversePostOrder(tree, tree.getRoot());
    }

    private boolean traversePostOrder(Tree tree, NodeRef nodeRef) {
        boolean bl = false;
        int n = nodeRef.getNumber();
        if (tree.getParent(nodeRef) != null && this.updateNode[n]) {
            this.addBranchUpdateOperation(tree, nodeRef);
            bl = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, 0);
            boolean bl2 = this.traversePostOrder(tree, nodeRef2);
            NodeRef nodeRef3 = tree.getChild(nodeRef, 1);
            boolean bl3 = this.traversePostOrder(tree, nodeRef3);
            if (bl2 || bl3) {
                this.nodeOperations.add(new ProcessOnTreeDelegate.NodeOperation(n, nodeRef2.getNumber(), nodeRef3.getNumber()));
                bl = true;
            }
        }
        return bl;
    }

    private void traverseReverseLevelOrder(Tree tree) {
        HashMap<Integer, List<ProcessOnTreeDelegate.NodeOperation>> hashMap = new HashMap<Integer, List<ProcessOnTreeDelegate.NodeOperation>>();
        this.traverseLevelOrder(tree, tree.getRoot(), 0, hashMap);
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList, Collections.reverseOrder());
        for (Integer n : arrayList) {
            List list = (List)hashMap.get(n);
            for (ProcessOnTreeDelegate.NodeOperation nodeOperation : list) {
                this.nodeOperations.add(nodeOperation);
            }
        }
    }

    private boolean traverseLevelOrder(Tree tree, NodeRef nodeRef, int n, Map<Integer, List<ProcessOnTreeDelegate.NodeOperation>> map) {
        boolean bl = false;
        int n2 = nodeRef.getNumber();
        if (tree.getParent(nodeRef) != null && this.updateNode[n2]) {
            this.addBranchUpdateOperation(tree, nodeRef);
            bl = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, 0);
            boolean bl2 = this.traverseLevelOrder(tree, nodeRef2, n + 1, map);
            NodeRef nodeRef3 = tree.getChild(nodeRef, 1);
            boolean bl3 = this.traverseLevelOrder(tree, nodeRef3, n + 1, map);
            if (bl2 || bl3) {
                List<ProcessOnTreeDelegate.NodeOperation> list = map.get(n);
                if (list == null) {
                    list = new ArrayList<ProcessOnTreeDelegate.NodeOperation>();
                    map.put(n, list);
                }
                list.add(new ProcessOnTreeDelegate.NodeOperation(n2, nodeRef2.getNumber(), nodeRef3.getNumber()));
                bl = true;
            }
        }
        return bl;
    }

    private void addBranchUpdateOperation(Tree tree, NodeRef nodeRef) {
        this.branchOperations.add(new ProcessOnTreeDelegate.BranchOperation(nodeRef.getNumber(), this.computeBranchLength(tree, nodeRef)));
    }
}

