/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.thorney;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.bigfasttree.thorney.BranchLengthLikelihoodDelegate;
import dr.evomodel.bigfasttree.thorney.MutationBranchMap;
import dr.evomodel.bigfasttree.thorney.MutationList;
import dr.evomodel.treedatalikelihood.DataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.PreOrderSettings;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.RateRescalingScheme;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.TreeTraversal;
import dr.evomodel.treelikelihood.PartialsRescalingScheme;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.Arrays;
import java.util.List;

public class ThorneyDataLikelihoodDelegate
extends AbstractModel
implements DataLikelihoodDelegate {
    static final String NAME = "ThorneyDataLikelihoodDelegate";
    private long totalCalculationCount;
    private final MutationBranchMap mutationMap;
    private final Tree tree;
    private BranchLengthLikelihoodDelegate branchLengthLikelihoodDelegate;
    protected boolean[] updateNode;
    protected boolean[] storedUpdateNode;
    private double[] branchLengths;
    private double[] storedBranchLengths;
    private double[] branchLogL;
    private double[] storedBranchLogL;

    public ThorneyDataLikelihoodDelegate(Tree tree, MutationBranchMap mutationBranchMap, BranchLengthLikelihoodDelegate branchLengthLikelihoodDelegate) {
        super(NAME);
        this.tree = tree;
        this.mutationMap = mutationBranchMap;
        this.branchLengthLikelihoodDelegate = branchLengthLikelihoodDelegate;
        this.totalCalculationCount = 0L;
        this.updateNode = new boolean[tree.getNodeCount()];
        Arrays.fill(this.updateNode, true);
        this.storedUpdateNode = new boolean[tree.getNodeCount()];
        this.branchLengths = new double[tree.getNodeCount()];
        this.storedBranchLengths = new double[tree.getNodeCount()];
        this.branchLogL = new double[tree.getNodeCount()];
        this.storedBranchLogL = new double[tree.getNodeCount()];
    }

    @Override
    public TreeTraversal.TraversalType getOptimalTraversalType() {
        return TreeTraversal.TraversalType.POST_ORDER;
    }

    @Override
    public long getTotalCalculationCount() {
        return this.totalCalculationCount;
    }

    @Override
    public String getReport() {
        throw new UnsupportedOperationException("Unimplemented method 'getReport'");
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public void storeState() {
        System.arraycopy(this.branchLogL, 0, this.storedBranchLogL, 0, this.branchLogL.length);
        System.arraycopy(this.branchLengths, 0, this.storedBranchLengths, 0, this.storedBranchLengths.length);
    }

    @Override
    public void restoreState() {
        double[] dArray = this.storedBranchLogL;
        this.storedBranchLogL = this.branchLogL;
        this.branchLogL = dArray;
        double[] dArray2 = this.storedBranchLengths;
        this.storedBranchLengths = this.branchLengths;
        this.branchLengths = dArray2;
    }

    @Override
    public double calculateLikelihood(List<ProcessOnTreeDelegate.BranchOperation> list, List<ProcessOnTreeDelegate.NodeOperation> list2, int n) throws DataLikelihoodDelegate.LikelihoodException {
        for (ProcessOnTreeDelegate.BranchOperation branchOperation : list) {
            NodeRef nodeRef = this.tree.getNode(branchOperation.getBranchNumber());
            this.updateNode(nodeRef);
            this.branchLengths[nodeRef.getNumber()] = branchOperation.getBranchLength();
        }
        NodeRef nodeRef = this.tree.getNode(n);
        int n2 = this.tree.getChild(nodeRef, 0).getNumber();
        int n3 = this.tree.getChild(nodeRef, 1).getNumber();
        this.updateNode[n2] = this.updateNode[n2] || this.updateNode[n3];
        ++this.totalCalculationCount;
        return this.calculateLogLikelihood(nodeRef, n, n2, n3);
    }

    public double calculateLogLikelihood(NodeRef nodeRef, int n, int n2, int n3) {
        int n4 = nodeRef.getNumber();
        if (this.updateNode[n4]) {
            double d;
            if (n4 == n) {
                d = 0.0;
            } else {
                MutationList mutationList = this.mutationMap.getMutations(nodeRef);
                double d2 = this.branchLengths[n4];
                d = this.branchLengthLikelihoodDelegate.getLogLikelihood(mutationList, d2);
            }
            for (int i = 0; i < this.tree.getChildCount(nodeRef); ++i) {
                d += this.calculateLogLikelihood(this.tree.getChild(nodeRef, i), n, n2, n3);
            }
            this.branchLogL[n4] = d;
            this.updateNode[n4] = false;
        }
        return this.branchLogL[n4];
    }

    protected void updateNode(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
        NodeRef nodeRef2 = this.tree.getParent(nodeRef);
        if (nodeRef2 != null && !this.updateNode[nodeRef2.getNumber()]) {
            this.updateNode(nodeRef2);
        }
    }

    @Override
    public int getTraitCount() {
        return 1;
    }

    @Override
    public int getTraitDim() {
        return this.tree.getNodeCount();
    }

    @Override
    public RateRescalingScheme getRateRescalingScheme() {
        return RateRescalingScheme.NONE;
    }

    @Override
    public void setCallback(TreeDataLikelihood treeDataLikelihood) {
    }

    @Override
    public int vectorizeNodeOperations(List<ProcessOnTreeDelegate.NodeOperation> list, int[] nArray) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setComputePostOrderStatisticsOnly(boolean bl) {
    }

    @Override
    public boolean providesPostOrderStatisticsOnly() {
        return false;
    }

    @Override
    public int getPartitionCat() {
        return 0;
    }

    @Override
    public double[] getSiteLogLikelihoods() {
        throw new RuntimeException("getSiteLogLikelihoods() not implemented");
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        throw new UnsupportedOperationException("Unimplemented method 'handleModelChangedEvent'");
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        throw new UnsupportedOperationException("Unimplemented method 'handleVariableChangedEvent'");
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public PreOrderSettings getPreOrderSettings() {
        return null;
    }

    @Override
    public boolean getPreferGPU() {
        return true;
    }

    @Override
    public boolean getUseAmbiguities() {
        return true;
    }

    @Override
    public PartialsRescalingScheme getRescalingScheme() {
        return null;
    }

    @Override
    public boolean getDelayRescalingUntilUnderflow() {
        return true;
    }

    protected MutationBranchMap getMutationMap() {
        return this.mutationMap;
    }

    protected BranchLengthLikelihoodDelegate getBranchLengthLikelihoodDelegate() {
        return this.branchLengthLikelihoodDelegate;
    }
}

