/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SiteList;
import dr.evolution.datatype.DataType;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Patterns
implements PatternList {
    public static final int COUNT_INCREMENT = 100;
    protected int patternCount = 0;
    protected int patternLength = 0;
    protected double[] weights = new double[100];
    protected int[][] patterns = new int[100][];
    protected DataType dataType = null;
    protected TaxonList taxonList = null;
    protected String id = null;
    protected Set<Integer> maskSet = new HashSet<Integer>();
    private boolean areUnique = true;

    public Patterns(DataType dataType) {
        this.dataType = dataType;
    }

    public Patterns(DataType dataType, TaxonList taxonList) {
        this.dataType = dataType;
        this.taxonList = taxonList;
        this.patternLength = taxonList.getTaxonCount();
    }

    public Patterns(SiteList siteList) {
        this.addPatterns(siteList, 0, 0, 1);
    }

    public Patterns(List<SiteList> list) {
        for (SiteList siteList : list) {
            this.addPatterns(siteList, 0, 0, 1);
        }
    }

    public Patterns(SiteList siteList, int n, int n2, int n3) {
        this.addPatterns(siteList, n, n2, n3);
    }

    public Patterns(SiteList siteList, int n, int n2, int n3, int n4, int n5) {
        this.addPatterns(siteList, n, n2, n3);
        this.subSetPatterns(n4, n5);
    }

    public Patterns(PatternList patternList) {
        this.addPatterns(patternList);
    }

    public Patterns(PatternList patternList, boolean bl) {
        this.addPatterns(patternList, bl);
    }

    public Patterns(PatternList patternList, int n, int n2) {
        this.addPatterns(patternList);
        this.subSetPatterns(n, n2);
    }

    private void subSetPatterns(int n, int n2) {
        if (n2 > 0) {
            int n3;
            int n4 = this.patternCount / n2;
            int n5 = this.patternCount % n2;
            int n6 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                n6 += n4 + (n3 < n5 ? 1 : 0);
            }
            n3 = n4;
            if (n < n5) {
                ++n3;
            }
            int[][] nArrayArray = new int[n3][];
            double[] dArray = new double[n3];
            for (int i = 0; i < n3; ++i) {
                nArrayArray[i] = this.patterns[n6 + i];
                dArray[i] = this.weights[n6 + i];
            }
            this.patterns = nArrayArray;
            this.weights = dArray;
            this.patternCount = n3;
        }
    }

    public void addPatterns(SiteList siteList, int n, int n2, int n3) {
        if (siteList == null) {
            return;
        }
        if (this.taxonList == null) {
            this.taxonList = siteList;
            this.patternLength = this.taxonList.getTaxonCount();
        }
        if (this.dataType == null) {
            this.dataType = siteList.getDataType();
        } else if (this.dataType != siteList.getDataType()) {
            throw new IllegalArgumentException("Patterns' existing DataType does not match that of added SiteList");
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 <= 0) {
            n2 = siteList.getSiteCount() - 1;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        this.areUnique = siteList.areUnique();
        for (int i = n; i <= n2; i += n3) {
            int[] nArray = siteList.getSitePattern(i);
            if (nArray == null || Patterns.isInvariant(nArray) && (this.isGapped(nArray) || this.isAmbiguous(nArray) || this.isUnknown(nArray))) continue;
            this.addPattern(nArray, 1.0, this.areUnique);
        }
    }

    public void addPatterns(PatternList patternList) {
        this.areUnique = patternList.areUnique();
        this.addPatterns(patternList, this.areUnique);
    }

    public void trimWeights() {
        double[] dArray = new double[this.patternCount];
        System.arraycopy(this.weights, 0, dArray, 0, this.patternCount);
        this.weights = dArray;
    }

    public void addPatterns(PatternList patternList, boolean bl) {
        if (patternList == null) {
            return;
        }
        if (this.taxonList == null) {
            this.taxonList = patternList;
            this.patternLength = this.taxonList.getTaxonCount();
        }
        if (this.dataType == null) {
            this.dataType = patternList.getDataType();
        } else if (this.dataType != patternList.getDataType()) {
            throw new IllegalArgumentException("Patterns' existing DataType does not match that of added PatternList");
        }
        for (int i = 0; i < patternList.getPatternCount(); ++i) {
            int[] nArray = patternList.getPattern(i);
            if (!bl) {
                this.addPattern(nArray, 1.0, false);
                continue;
            }
            if (Patterns.isInvariant(nArray) && (this.isGapped(nArray) || this.isAmbiguous(nArray) || this.isUnknown(nArray))) continue;
            this.addPattern(nArray, patternList.getPatternWeight(i), true);
        }
    }

    public void addPattern(int[] nArray) {
        this.addPattern(nArray, 1.0);
    }

    public void addPattern(int[] nArray, double d) {
        this.addPattern(nArray, d, true);
    }

    private void addPattern(int[] nArray, double d, boolean bl) {
        if (this.patternLength == 0) {
            this.patternLength = nArray.length;
        }
        if (this.patternLength != 0 && nArray.length != this.patternLength) {
            throw new IllegalArgumentException("Added pattern's length (" + nArray.length + ") does not match those of existing patterns (" + this.patternLength + ")");
        }
        if (bl && this.patternExists(nArray, d)) {
            return;
        }
        if (this.patternCount == this.patterns.length) {
            int[][] nArrayArray = new int[this.patternCount + 100][];
            double[] dArray = new double[this.patternCount + 100];
            for (int i = 0; i < this.patternCount; ++i) {
                nArrayArray[i] = this.patterns[i];
                dArray[i] = this.weights[i];
            }
            this.patterns = nArrayArray;
            this.weights = dArray;
        }
        this.patterns[this.patternCount] = nArray;
        this.weights[this.patternCount] = d;
        ++this.patternCount;
    }

    private boolean patternExists(int[] nArray, double d) {
        for (int i = 0; i < this.patternCount; ++i) {
            if (!this.comparePatterns(this.patterns[i], nArray)) continue;
            int n = i;
            this.weights[n] = this.weights[n] + d;
            return true;
        }
        return false;
    }

    public void removePattern(int[] nArray) {
        int n = -1;
        for (int i = 0; i < this.patternCount; ++i) {
            if (!this.comparePatterns(this.patterns[i], nArray)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException("Pattern not found");
        }
        int n2 = n;
        this.weights[n2] = this.weights[n2] - 1.0;
        if (this.weights[n] == 0.0 && this.patternCount > 1) {
            this.patterns[n] = this.patterns[this.patternCount - 1];
            this.patterns[this.patternCount - 1] = null;
            this.weights[n] = this.weights[this.patternCount - 1];
            --this.patternCount;
        }
    }

    public void removeAllPatterns() {
        this.patternCount = 0;
        for (int i = 0; i < this.patterns.length; ++i) {
            this.patterns[i] = null;
        }
    }

    protected boolean isGapped(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isGapState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isAmbiguous(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isAmbiguousState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isUnknown(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.getDataType().isUnknownState(nArray[i])) continue;
            return true;
        }
        return false;
    }

    protected static boolean isInvariant(int[] nArray) {
        int n = nArray.length;
        int n2 = nArray[0];
        for (int i = 1; i < n; ++i) {
            if (nArray[i] == n2) continue;
            return false;
        }
        return true;
    }

    protected boolean comparePatterns(int[] nArray, int[] nArray2) {
        return Arrays.equals(nArray, nArray2);
    }

    @Override
    public int getPatternCount() {
        return this.patternCount;
    }

    @Override
    public int getStateCount() {
        return this.dataType.getStateCount();
    }

    @Override
    public int getPatternLength() {
        return this.patternLength;
    }

    @Override
    public int[] getPattern(int n) {
        return this.patterns[n];
    }

    @Override
    public int getPatternIndex(int n) {
        return -1;
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public int getPatternState(int n, int n2) {
        return this.patterns[n2][n];
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public double getPatternWeight(int n) {
        return this.weights[n];
    }

    @Override
    public double[] getPatternWeights() {
        double[] dArray = new double[this.weights.length];
        for (int i = 0; i < this.weights.length; ++i) {
            dArray[i] = this.weights[i];
        }
        return dArray;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public double[] getStateFrequencies() {
        return PatternList.Utils.empiricalStateFrequencies(this);
    }

    @Override
    public boolean areUnique() {
        return this.areUnique;
    }

    @Override
    public boolean areUncertain() {
        return false;
    }

    @Override
    public int getTaxonCount() {
        if (this.taxonList == null) {
            throw new RuntimeException("Patterns has no TaxonList");
        }
        return this.taxonList.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        if (this.taxonList == null) {
            throw new RuntimeException("Patterns has no TaxonList");
        }
        return this.taxonList.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        if (this.taxonList == null) {
            throw new RuntimeException("Patterns has no TaxonList");
        }
        return this.taxonList.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        if (this.taxonList == null) {
            throw new RuntimeException("Patterns has no TaxonList");
        }
        return this.taxonList.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        if (this.taxonList == null) {
            throw new RuntimeException("Patterns has no TaxonList");
        }
        return this.taxonList.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        if (this.taxonList == null) {
            throw new RuntimeException("Patterns has no TaxonList");
        }
        return this.taxonList.asList();
    }

    @Override
    public Iterator<Taxon> iterator() {
        if (this.taxonList == null) {
            throw new RuntimeException("Patterns has no TaxonList");
        }
        return this.taxonList.iterator();
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        if (this.taxonList == null) {
            throw new RuntimeException("Patterns has no TaxonList");
        }
        return this.taxonList.getTaxonAttribute(n, string);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public boolean addMask(int n) {
        return this.maskSet.add(n);
    }

    public boolean isMasked(int n) {
        return this.maskSet.contains(n);
    }

    public boolean hasMask() {
        return this.maskSet.size() > 0;
    }

    public void clearMask() {
        this.maskSet.clear();
    }

    public Set<Integer> getMaskSet() {
        return this.maskSet;
    }

    public Taxon getTaxonMasked(int n) {
        if (this.taxonList == null) {
            throw new RuntimeException("Patterns has no TaxonList");
        }
        if (this.isMasked(n)) {
            return null;
        }
        return this.taxonList.getTaxon(n);
    }
}

