




<!-- NEWS.md was auto-generated by NEWS.Rmd. Please DO NOT edit by hand!-->

# BayLum 0.3.2 (2024-06-16)

**This version of `'BayLum'` requires R\>=4.1.x!**

## New functions

### `create_DataFile()`

This function attempts to ease the very pain-stacking process of input
data processing (BIN/BINX files) so that it can be used in the
`'BayLum'` modelling. The function is an entirely new development and
will replace the functions `Generate_DataFile_MG()` and
`Generate_DataFile()` in future versions of `'BayLum'`. Key features:

- Only one function for single-grain and multiple-grain data
- Support for BIN/BINX and XSYG files and `RLum.Analysis-class` objects,
  i.e. the data can be imported independently of the data file creation
- A new single-file configuration based on the YAML format. This makes
  the old error-prone folder structure obsolete
- Various internal consistency checks to avoid input data are
  erroneousness; which may lead to very hard to-track-down error
  messages
- Carries information about the number of samples and the sample names

### `plot_RegDosePoints()`

- The function will replace the deprecated fucntion `LT_RegenDose()`,
  which was too error-prone and complicated to maintain.

### `write_YAMLConfigFile()`

This function supplements `create_DataFile()` supporting auto-generated
YAML config template files

## Bugfixes and changes

### `Age_OSLC14()`

- Determines the sample name automatically by default.

### `Age_Computation()`

- Determines the sample name automatically by default.

### `AgeS_Computation()`

- Determines the sample name automatically by default.

### `combine_DataFiles()`

- Now preserves the originator attribute

### `SCMatrix()`

- Interactive mode is now more beautiful and consistently
- Can now extract information from an object created by
  `create_DataFile()`

### `SC_Ordered()`

- Can handle objects created by `create_DataFile()` for easier usage.

### Miscellaneous

- Drop dependency to deprecated package `'ArchaeoPhases'` and make
  corresponding code an internal function (PR \#33, @nfrerebeau)

- Add dependencies to the packages `'yaml'` and `'cli'`

- Bump version requirement for `'Luminescence'` to \>= v0.9.22

- Add new external files `example.yml` and `yaml_config_reference.yml`

- Internal datasets `DATA1`, `DATA2`, `DATA3` were updated to be
  consistent with the new function `create_DataFile()`

## Deprecated functions

The following functions are deprecated and will be removed in future
versions of BayLum

- `Generate_DataFile()`
- `Generate_DataFile_MG()`
- `LT_RegenDose()`
