/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.jdbc;

import com.qarks.util.jdbc.TransactionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class Transaction {
    private Connection connection;
    private TransactionPool pool;

    public Transaction(TransactionPool transactionPool, Connection connection) {
        this.connection = connection;
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.pool = transactionPool;
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public void commitOrRollback() throws SQLException {
        SQLException sQLException = null;
        try {
            this.connection.commit();
        }
        catch (SQLException sQLException2) {
            this.connection.rollback();
            sQLException = sQLException2;
        }
        this.pool.releaseTransaction(this);
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public void rollback() throws SQLException {
        SQLException sQLException = null;
        try {
            this.connection.rollback();
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        this.pool.releaseTransaction(this);
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public PreparedStatement createPreparedStatement(String string) throws SQLException {
        return this.connection.prepareStatement(string);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.connection.createStatement(n, n2);
    }
}

