## ----include=FALSE------------------------------------------------------------
library(equatiomatic)
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## ----iris---------------------------------------------------------------------
data(iris)
# Attach `label` and `units` attributes to the variables
# Note, this is done manually, but there are functions in various packages to
# ease the process (see packages {Hmisc}, {labelled}, {LabelR}, {labelVector})
attr(iris$Sepal.Length, "label") <- "Sepal length"
attr(iris$Sepal.Length, "units") <- "cm"
attr(iris$Sepal.Width, "label") <- "Sepal width"
attr(iris$Sepal.Width, "units") <- "cm"
attr(iris$Petal.Length, "label") <- "Petal length"
attr(iris$Petal.Length, "units") <- "cm"
attr(iris$Petal.Width, "label") <- "Petal width"
attr(iris$Petal.Width, "units") <- "cm"

str(iris)

## -----------------------------------------------------------------------------
lm1 <- lm(Sepal.Length ~ Sepal.Width, data = iris)
lm1

## ----extracteq----------------------------------------------------------------
extract_eq(lm1)

## ----equation-iris------------------------------------------------------------
equation(lm1)

## -----------------------------------------------------------------------------
equation(lm1, var_colors = c(Sepal.Width  = "red"),
  ital_vars = TRUE, use_coefs = TRUE, coef_digits = 3)

