library(CARMS)

# usage carms.make<-function(title, diagram_grid=c(12,12),...)
SiFEHM<-carms.make(title="Single element        Fault/error handling model", diagram_grid=c(9,13))
#usage carms.state<-function(x, prob,  name, size=4, h2w=21/24, position, plot.color=NULL,  description="")
SiFEHM<-carms.state(SiFEHM, prob=1, name="Initial state", size=5, h2w=14/20, position=c(3,4) )
SiFEHM<-carms.state(SiFEHM, prob=0, name="Benign fault", size=5, h2w=14/20, position=c(3,8) )
SiFEHM<-carms.state(SiFEHM, prob=0, name="Active error", size=5, h2w=14/20, position=c(7,4) )
SiFEHM<-carms.state(SiFEHM, prob=0, name="Benign error", size=5, h2w=14/20, position=c(7,8) )
SiFEHM<-carms.state(SiFEHM, prob=0, name="Detected fault/error", size=5, h2w=14/22, position=c(5,2) )
SiFEHM<-carms.state(SiFEHM, prob=0, name="Undetected: failure", size=5, h2w=14/22, position=c(11,6) )


# carms.base(x, value, time_units=NULL, base_label=NULL, description="")
SiFEHM<-carms.base(SiFEHM, 1, time_units="hours", description="active to benign error rate")
SiFEHM<-carms.base(SiFEHM, 2, time_units="hours", description="benign to active error rate")
SiFEHM<-carms.base(SiFEHM, 3, time_units="hours", description="error production rate")
SiFEHM<-carms.base(SiFEHM, 4, time_units="hours", description="error propogation rate")
SiFEHM<-carms.base(SiFEHM, 9e-1, time_units="hours", base_label="coverage", description="coverage")
SiFEHM<-carms.base(SiFEHM, 6, time_units="hours", description="fault detection rate")

# carms.arrow(x, from, to, rate, arc=0.35, arrow.position=0.5, label="")
SiFEHM<-carms.arrow(SiFEHM, from=1, to=5, rate="B6", arc=.2, label="B6")
SiFEHM<-carms.arrow(SiFEHM, from=3, to=5, rate="B4*coverage", arc=-.2, label="B4*coverage")
SiFEHM<-carms.arrow(SiFEHM, from=1, to=3, rate="B3", arc=0, label="B3")
SiFEHM<-carms.arrow(SiFEHM, from=1, to=2, rate="B1", arc=.13, label="B1")
SiFEHM<-carms.arrow(SiFEHM, from=2, to=1, rate="B2", arc=.13, label="B2")
SiFEHM<-carms.arrow(SiFEHM, from=4, to=2, rate="B4*coverage", arc=.2, label="B4*coverage")
SiFEHM<-carms.arrow(SiFEHM, from=3, to=4, rate="B1", arc=.13, label="B1")
SiFEHM<-carms.arrow(SiFEHM, from=4, to=3, rate="B2", arc=.13, label="B2")
SiFEHM<-carms.arrow(SiFEHM, from=3, to=6, rate="B4*(1-coverage)", arc=.35, label="B4*(1-coverage)")
SiFEHM<-carms.arrow(SiFEHM, from=4, to=6, rate="B4*(1-coverage)", arc=-.35, label="B4*(1-coverage)")
	dev.new(width=15, height=7, unit="in")
	diagram(SiFEHM, rate.text.y.shift=1.0)
# usage: simulate.carms(x, solution, mission_time, intervals=50, cycles=2000)
SiFEHM<- simulate.carms(SiFEHM,solution="chain", mission_time=0.5)
# usage: (x, spline_curve=TRUE, knots=10, ...)
#	plot(SiFEHM, spline_curve=FALSE)
	plot(SiFEHM)
