/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.analysis.SmoothedPeriodogram;
import jdplus.toolkit.base.core.data.analysis.WindowFunction;
import jdplus.toolkit.base.core.dstats.SpecialFunctions;

public class TukeySpectrumPeaksTest {
    private double[] sinc;
    private double[] dfpeaks;
    private double tdinc;
    private double spi;

    double getTdInc() {
        return this.tdinc;
    }

    public boolean isTdSignificant(double eps) {
        return SpecialFunctions.FProbability((double)this.tdinc, (double)this.dfpeaks[0], (double)this.dfpeaks[1]) < eps;
    }

    public double getTdProb() {
        return SpecialFunctions.FProbability((double)this.tdinc, (double)this.dfpeaks[0], (double)this.dfpeaks[1]);
    }

    public boolean hasSeasonalPeak(int ifreq, double prob) {
        if (ifreq <= 0) {
            return false;
        }
        if (ifreq <= this.sinc.length) {
            return SpecialFunctions.FProbability((double)this.sinc[ifreq - 1], (double)this.dfpeaks[0], (double)this.dfpeaks[1]) < 1.0 - prob;
        }
        if (ifreq == this.sinc.length + 1 && !Double.isNaN(this.spi)) {
            return SpecialFunctions.FProbability((double)this.spi, (double)this.dfpeaks[2], (double)this.dfpeaks[3]) < 1.0 - prob;
        }
        return false;
    }

    public int getSignificantSeasonalPeaks(double eps) {
        int n = 0;
        for (int i = 0; i < this.sinc.length; ++i) {
            if (!(this.sinc[i] > 0.0) || !(SpecialFunctions.FProbability((double)this.sinc[i], (double)this.dfpeaks[0], (double)this.dfpeaks[1]) < eps)) continue;
            ++n;
        }
        if (!Double.isNaN(this.spi) && SpecialFunctions.FProbability((double)this.spi, (double)this.dfpeaks[2], (double)this.dfpeaks[3]) < eps) {
            ++n;
        }
        return n;
    }

    public double[] getSeasonalProbs() {
        double[] p = new double[this.sinc.length + (Double.isNaN(this.spi) ? 0 : 1)];
        for (int i = 0; i < this.sinc.length; ++i) {
            if (!(this.sinc[i] > 0.0)) continue;
            p[i] = SpecialFunctions.FProbability((double)this.sinc[i], (double)this.dfpeaks[0], (double)this.dfpeaks[1]);
        }
        if (!Double.isNaN(this.spi)) {
            p[this.sinc.length] = SpecialFunctions.FProbability((double)this.spi, (double)this.dfpeaks[2], (double)this.dfpeaks[3]);
        }
        return p;
    }

    public int[] seasonalPeaks(double plow, double phigh) {
        int[] rslt = new int[this.sinc.length + (Double.isNaN(this.spi) ? 0 : 1)];
        for (int i = 0; i < this.sinc.length; ++i) {
            if (!(this.sinc[i] > 0.0)) continue;
            double p = 1.0 - SpecialFunctions.FProbability((double)this.sinc[i], (double)this.dfpeaks[0], (double)this.dfpeaks[1]);
            if (p > phigh) {
                rslt[i] = 2;
                continue;
            }
            if (!(p > plow)) continue;
            rslt[i] = 1;
        }
        if (!Double.isNaN(this.spi)) {
            double p = 1.0 - SpecialFunctions.FProbability((double)this.spi, (double)this.dfpeaks[2], (double)this.dfpeaks[3]);
            if (p > phigh) {
                rslt[this.sinc.length] = 2;
            } else if (p > plow) {
                rslt[this.sinc.length] = 1;
            }
        }
        return rslt;
    }

    private void calcPeaks(SmoothedPeriodogram spectrum, int windowLength, int freq) {
        int[] indSmid;
        this.spi = Double.NaN;
        this.sinc = new double[0];
        int indTD = -1;
        int indPI = -1;
        DoubleSeq s = spectrum.spectrumValues();
        block0 : switch (windowLength) {
            case 112: {
                indSmid = new int[]{9, 19, 28, 37, 47};
                indTD = 39;
                indPI = 56;
                break;
            }
            case 79: {
                indSmid = new int[]{7, 13, 20, 26, 33};
                indTD = 28;
                indPI = 39;
                break;
            }
            default: {
                switch (freq) {
                    case 6: {
                        indSmid = new int[]{7, 14};
                        indPI = 21;
                        break block0;
                    }
                    case 4: {
                        indTD = 13;
                        indSmid = new int[]{11};
                        indPI = 21;
                        break block0;
                    }
                    case 3: {
                        indSmid = new int[]{14};
                        break block0;
                    }
                }
                indSmid = new int[]{};
            }
        }
        if (indTD > 0) {
            this.tdinc = 2.0 * s.get(indTD - 1) / (s.get(indTD) + s.get(indTD - 2));
        }
        this.sinc = new double[indSmid.length];
        for (int i = 0; i < indSmid.length; ++i) {
            double incH = 2.0 * s.get(indSmid[i]);
            this.sinc[i] = incH / (s.get(indSmid[i] + 1) + s.get(indSmid[i] - 1));
        }
        if (indPI > 0) {
            double denom = s.get(indPI - 1);
            this.spi = denom != 0.0 ? s.get(indPI) / s.get(indPI - 1) : s.get(indPI);
        }
    }

    private double[] calcDfPeaks(SmoothedPeriodogram spectrum, int ndata, int windowLength) {
        double[] retVal = new double[]{0.0, 0.0, 0.0, 0.0};
        switch (windowLength) {
            case 112: {
                double[][] df = new double[][]{{0.5463, 2.9303, 2.2042}, {1.1329, 7.6924, 10.8795}, {-0.3492, 1.533, 2.7696}, {0.9829, 3.8217, 6.9345}};
                double n100 = (double)ndata / 100.0;
                double n_100 = 100.0 / (double)ndata;
                retVal[0] = df[0][0] + df[0][1] * n100 + df[0][2] * n_100;
                retVal[1] = df[1][0] + df[1][1] * n100 + df[1][2] * n_100;
                retVal[2] = df[2][0] + df[2][1] * n100 + df[2][2] * n_100;
                retVal[3] = df[3][0] + df[3][1] * n100 + df[3][2] * n_100;
                break;
            }
            case 44: {
                double n100 = (double)ndata / 100.0;
                double n_100 = 100.0 / (double)ndata;
                double[][] df = new double[][]{{1.3779, 7.262, 0.3725}, {3.1495, 18.0654, 3.5564}, {0.2504, 3.6616, 0.7929}, {0.504, 9.7201, 3.0605}};
                retVal[0] = df[0][0] + df[0][1] * n100 + df[0][2] * n_100;
                retVal[1] = df[1][0] + df[1][1] * n100 + df[1][2] * n_100;
                retVal[2] = df[2][0] + df[2][1] * n100 + df[2][2] * n_100;
                retVal[3] = df[3][0] + df[3][1] * n100 + df[3][2] * n_100;
                break;
            }
            case 79: {
                retVal[0] = 6.35251;
                retVal[1] = 19.6308;
                retVal[2] = 2.29316;
                retVal[3] = 6.55412;
                break;
            }
        }
        return retVal;
    }

    public boolean test(DoubleSeq s, int period) {
        this.clear();
        int n = s.length();
        int windowLength = this.windowLength(n, period);
        if (windowLength < 0) {
            return false;
        }
        SmoothedPeriodogram tukey = SmoothedPeriodogram.builder().data(s).windowLength(windowLength).windowFunction(WindowFunction.Tukey).taper(null).build();
        if (tukey == null) {
            return false;
        }
        this.computeStatistics(tukey, n, windowLength, period);
        return true;
    }

    private void computeStatistics(SmoothedPeriodogram periodogram, int ndata, int windowLength, int freq) {
        this.dfpeaks = this.calcDfPeaks(periodogram, ndata, windowLength);
        this.calcPeaks(periodogram, windowLength, freq);
    }

    private int windowLength(int ndata, int period) {
        if (period != 12 && ndata >= 45) {
            return 44;
        }
        if (period == 12 && ndata >= 120) {
            return 112;
        }
        if (period == 12 && ndata >= 80) {
            return 79;
        }
        return -1;
    }

    private void clear() {
        this.sinc = null;
        this.dfpeaks = null;
        this.spi = Double.NaN;
        this.tdinc = 0.0;
    }
}

