## Ragnar Store Inspector

This Shiny app is used to inspect a `RagnarStore` object.

### Updating the CSS

The app uses [TailwindCSS](https://tailwindcss.com). The css is generated by
the TailwindCLI that parses the classes used in the app and generating the
`app.out.css` file.

To update the css file, first download the TailwindCLI. It's recommended to
use the [standalone install](https://tailwindcss.com/blog/standalone-cli), so
you don't need to manage a npm installation.

For arm macs, you can do:

```
# Example for macOS arm64
curl -sLO https://github.com/tailwindlabs/tailwindcss/releases/latest/download/tailwindcss-macos-arm64
chmod +x tailwindcss-macos-arm64
mv tailwindcss-macos-arm64 tailwindcss
```

You can then run the below to update the css.

```
./tailwindcss -i www/app.css -o www/app.out.css
```

During development, it's useful to run. So the file watcher keeps re-compiling
the css as you edit the R sources.

```
./tailwindcss -i www/app.css -o www/app.out.css --watch
```
