## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include = FALSE---------------------------------------------------
library(Rnaught)

## -----------------------------------------------------------------------------
# Case counts.
cases <- c(1, 4, 10, 5, 3, 4, 19, 3, 3, 14, 4)

estimate <- wp(cases, mu = 3.333, serial = TRUE)

# `supp` is the support of the distribution, and `pmf` is its probability mass
# function.
sum(estimate$supp * estimate$pmf)

## -----------------------------------------------------------------------------
# The grid search parameters specified below are the default values.
estimate <- wp(cases, serial = TRUE,
  grid_length = 100, max_shape = 10, max_scale = 10
)

serial_mean <- sum(estimate$supp * estimate$pmf)
serial_mean

# Compute the (discrete) median for an alternative estimate of the serial
# interval.
cdf <- cumsum(estimate$pmf)
serial_med <- estimate$supp[which(cdf >= 0.5 & estimate$pmf - cdf + 1 >= 0.5)]
serial_med

## ----dpi = 192, echo = FALSE--------------------------------------------------
old_par <- par(mar = c(4.1, 4.1, 0.5, 0.5))

# Serial distribution.
plot(estimate$supp, estimate$pmf, xlab = "x", ylab = "p(x)",
  col = "black", lty = 1, type = "l"
)

# Serial mean.
abline(v = serial_mean, col = "blue", lty = 2)
# Serial median.
abline(v = serial_med, col = "red", lty = 2)

legend("topright",
  legend = c("Serial distribution", "Serial mean", "Serial median"),
  col = c("black", "blue", "red"),
  lty = c(1, 2, 2), cex = 0.5
)

par(old_par)

