data{
  int N;                                 // number of patients (M(T1))
  int p;                                 // number of covariates (J)
  real<lower=0> t[N];                    // observed time (t^*_{ci} in the paper)
  int<lower=0, upper=1> status[N];       // censoring status (corresponds to 1-delta_{ci}, 0 = random censored, 1 = not)
  real<lower=0> a;                       // 1st parameter of the gamma prior (shape) for lambda_0c (= alpha_c)
  real<lower=0> b;                       // 2nd parameter of the gamma prior (rate / inverse scale) for lambda_0c (= beta_c)
  real<lower=0> c;                       // 1st parameter of the gamma prior (shape) for rho_c (= alpha_rc)
  real<lower=0> d;                       // 2nd parameter of the gamma prior (rate / inverse scale) for rho_c (= beta_rc)
  real m1;                       // 1st (mean) parameter of the normal prior for beta_cj
  real<lower=0> se1;                       // 2nd (sd) parameter of the normal prior for beta_cj (= sigma_bc)
  matrix[N,p] cov;                        // covariates (each row is a covariate vector for a patient)
}

parameters{
  real<lower=0> rho;            // shape of weibull (rho_c) ## (I removed the hard upper bound of 2)
  real<lower=0> lambda;                  // hazard scale of Weibull (lambda_0c) -- warning: this is not the time scale sigma used in stan
  vector[p] beta;                        // regression coefficients for covariates (beta_c)
}

model{
 rho ~ gamma(c,d);   // rho_c
 lambda ~ gamma(a,b); // lambda_0c
 beta ~ normal(m1, se1);
    for (i in 1:N){
    real hazard_scale = lambda * exp(dot_product(beta, cov[i]));   // λ0c * exp(βZ)
    // Stan Weibull uses time-scale sigma; we set sigma = (lambda * exp(X beta))^(-1/rho)
    // so that S(t|X) = exp(-lambda * t^rho * exp(X beta)).
    real time_scale   = pow(hazard_scale, -1.0 / rho);             // (hazard_scale)^(-1/rho)

    if (status[i] == 0){ // δ_ci=1: censoring observed
      target += weibull_lpdf(t[i] | rho, time_scale);
    } else {             // status[i] == 1 => δ_ci=0: not censored up to t
      target += weibull_lccdf(t[i] | rho, time_scale);
    }
  }
}

