/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public class PolynomialComputer {
    private final double[] p;
    private Complex f;
    private Complex df;

    public PolynomialComputer(Polynomial x) {
        this.p = x.toArray();
    }

    public int getPolynomialDegree() {
        return this.p.length - 1;
    }

    public PolynomialComputer compute(Complex x) {
        double xr = x.getRe();
        double xi = x.getIm();
        if (Math.abs(xi) < Constants.getEpsilon()) {
            return this.compute(xr);
        }
        this.df = null;
        int n = this.p.length - 1;
        double re = this.p[n];
        double im = 0.0;
        for (int i = n - 1; i >= 0; --i) {
            double rtmp = xr * re - xi * im + this.p[i];
            double itmp = xr * im + re * xi;
            re = rtmp;
            im = itmp;
        }
        this.f = Complex.cart((double)re, (double)im);
        return this;
    }

    public PolynomialComputer computeAll(Complex x) {
        double xr = x.getRe();
        double xi = x.getIm();
        if (Math.abs(xi) < Constants.getEpsilon()) {
            return this.computeAll(xr);
        }
        int n = this.p.length - 1;
        double fr2 = this.p[n];
        double fi = 0.0;
        double dfr2 = 0.0;
        double dfi = 0.0;
        for (int i = n - 1; i >= 0; --i) {
            double tr = xr * dfr2 - xi * dfi + fr2;
            double ti = xr * dfi + dfr2 * xi + fi;
            dfr2 = tr;
            dfi = ti;
            tr = xr * fr2 - xi * fi + this.p[i];
            ti = xr * fi + fr2 * xi;
            fr2 = tr;
            fi = ti;
        }
        this.df = Complex.cart((double)dfr2, (double)dfi);
        this.f = Complex.cart((double)fr2, (double)fi);
        return this;
    }

    public PolynomialComputer compute(double x) {
        this.df = null;
        int n = this.p.length - 1;
        double r = this.p[n];
        for (int i = n - 1; i >= 0; --i) {
            r = x * r + this.p[i];
        }
        this.f = Complex.cart((double)r);
        return this;
    }

    public PolynomialComputer computeAll(double x) {
        int n = this.p.length - 1;
        double fr2 = this.p[n];
        double dfr2 = 0.0;
        for (int i = n - 1; i >= 0; --i) {
            dfr2 = x * dfr2 + fr2;
            fr2 = x * fr2 + this.p[i];
        }
        this.df = Complex.cart((double)dfr2);
        this.f = Complex.cart((double)fr2);
        return this;
    }

    public Complex f() {
        return this.f;
    }

    public Complex df() {
        return this.df;
    }

    public double df(int n, double x) {
        if (n >= this.p.length - 0) {
            return 0.0;
        }
        Polynomial P = this.D(n);
        return P.evaluateAt(x);
    }

    public Complex df(int n, Complex x) {
        if (n >= this.p.length - 0) {
            return Complex.ZERO;
        }
        Polynomial P = this.D(n);
        return P.evaluateAt(x);
    }

    public Polynomial D(int n) {
        Polynomial P = Polynomial.ofInternal(this.p);
        int d = 0;
        while (d++ < n) {
            P = P.derivate();
        }
        return P;
    }
}

