/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data;

import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import lombok.Generated;

public final class Coefficients {
    public static final double EPSILON = 1.0E-9;
    public static final double[] C_ZERO = new double[]{0.0};
    public static final double[] C_ONE = new double[]{1.0};
    public static final double[] C_POSINF = new double[]{Double.POSITIVE_INFINITY};
    public static final double[] C_NEGINF = new double[]{Double.NEGATIVE_INFINITY};
    public static final double[] C_NAN = new double[]{Double.NaN};

    public static double[] of(double[] c, double eps) {
        int nd = Coefficients.getUsedCoefficients(c, eps);
        if (nd == 1) {
            if (c[0] == 0.0) {
                return C_ZERO;
            }
            if (c[0] == 1.0) {
                return C_ONE;
            }
        }
        if (nd == 0) {
            return C_ZERO;
        }
        if (nd == c.length) {
            return c;
        }
        return Arrays.copyOf(c, nd);
    }

    public static double[] of(double[] c) {
        if (c.length == 1) {
            if (c[0] == 0.0) {
                return C_ZERO;
            }
            if (c[0] == 1.0) {
                return C_ONE;
            }
        }
        return c;
    }

    public static double[] zero() {
        return C_ZERO;
    }

    public static double[] one() {
        return C_ONE;
    }

    public static double[] positiveInfinity() {
        return C_POSINF;
    }

    public static double[] negativeInfinity() {
        return C_NEGINF;
    }

    public static double[] nan() {
        return C_NAN;
    }

    public static int getUsedCoefficients(double[] coefficients, double eps) {
        int n;
        for (n = coefficients.length; n > 0 && Math.abs(coefficients[n - 1]) <= eps; --n) {
        }
        return n;
    }

    public static double[] add(double[] coefficients, double d) {
        if (d == 0.0) {
            return coefficients;
        }
        double[] result = (double[])coefficients.clone();
        result[0] = result[0] + d;
        return Coefficients.of(result);
    }

    public static double[] add(double d, double[] coefficients) {
        return Coefficients.add(coefficients, d);
    }

    public static double[] chs(double[] coefficients) {
        double[] result = new double[coefficients.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = -coefficients[i];
        }
        return Coefficients.of(result);
    }

    public static double[] multiply(double[] coefficients, double d) {
        if (d == 0.0) {
            return C_ZERO;
        }
        if (d == 1.0) {
            return coefficients;
        }
        if (d == -1.0) {
            return Coefficients.chs(coefficients);
        }
        double[] result = new double[coefficients.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = coefficients[i] * d;
        }
        return Coefficients.of(result);
    }

    public static double[] multiply(double d, double[] coefficients) {
        return Coefficients.multiply(coefficients, d);
    }

    public static double[] add(double[] l, double[] r) {
        if (r == C_ZERO) {
            return l;
        }
        if (l == C_ZERO) {
            return r;
        }
        int n = Math.max(l.length, r.length);
        double[] result = new double[n];
        System.arraycopy(l, 0, result, 0, l.length);
        for (int i = 0; i < r.length; ++i) {
            int n2 = i;
            result[n2] = result[n2] + r[i];
        }
        return Coefficients.of(result);
    }

    public static double[] subtract(double[] l, double[] r) {
        if (r == C_ZERO) {
            return l;
        }
        if (l == C_ZERO) {
            return r;
        }
        int n = Math.max(l.length, r.length);
        double[] result = new double[n];
        System.arraycopy(l, 0, result, 0, l.length);
        for (int i = 0; i < r.length; ++i) {
            int n2 = i;
            result[n2] = result[n2] - r[i];
        }
        return Coefficients.of(result);
    }

    public static double[] subtract(double d, double[] r) {
        double[] result = new double[r.length];
        result[0] = d - r[0];
        for (int i = 1; i < r.length; ++i) {
            int n = i;
            result[n] = result[n] - r[i];
        }
        return Coefficients.of(result);
    }

    public static double[] subtract(double[] l, double d) {
        return Coefficients.add(l, -d);
    }

    public static double[] multiply(double[] l, double[] r) {
        if (r == C_ZERO || l == C_ZERO) {
            return C_ZERO;
        }
        if (r == C_ONE) {
            return l;
        }
        if (l == C_ONE) {
            return r;
        }
        int d = l.length + r.length - 1;
        double[] result = new double[d];
        for (int u = 0; u < l.length; ++u) {
            if (l[u] == 0.0) continue;
            for (int v = 0; v < r.length; ++v) {
                if (r[v] == 0.0) continue;
                int n = u + v;
                result[n] = result[n] + l[u] * r[v];
            }
        }
        return Coefficients.of(result);
    }

    public static double[] divide(double[] num, double[] denom) {
        int n;
        int nv = denom.length - 1;
        for (n = num.length - 1; n >= 0 && !(Math.abs(num[n]) > 1.0E-9); --n) {
        }
        if (n < 0) {
            return C_ZERO;
        }
        while (nv >= 0 && !(Math.abs(denom[nv]) > 1.0E-9)) {
            --nv;
        }
        if (nv < 0) {
            if (num[n] > 0.0) {
                return C_POSINF;
            }
            if (num[n] < 0.0) {
                return C_NEGINF;
            }
            return C_NAN;
        }
        if (nv > n) {
            return C_ZERO;
        }
        double[] r = (double[])num.clone();
        double[] q = new double[n + 1];
        for (int k = n - nv; k >= 0; --k) {
            q[k] = r[nv + k] / denom[nv];
            for (int j = nv + k - 1; j >= k; --j) {
                int n2 = j;
                r[n2] = r[n2] - q[k] * denom[j - k];
            }
        }
        return Arrays.copyOf(q, n - nv + 1);
    }

    public static String toString(double[] c, String fmt, char var, boolean smooth) {
        StringBuilder sb = new StringBuilder(512);
        boolean sign = false;
        int n = c.length;
        if (n == 1) {
            sb.append(new Formatter(Locale.ROOT).format(fmt, Coefficients.coef(c[0], smooth)));
        } else {
            for (int i = 0; i < n; ++i) {
                double v = Coefficients.coef(c[i], smooth);
                if (v == 0.0) continue;
                if (v < 0.0) {
                    sb.append(" - ");
                } else if (sign) {
                    sb.append(" + ");
                }
                if (v != 1.0 || i == 0) {
                    sb.append(new Formatter(Locale.ROOT).format(fmt, v).toString());
                }
                sign = true;
                if (i > 0) {
                    sb.append(' ').append(var);
                }
                if (i <= 1) continue;
                sb.append('^').append(i);
            }
        }
        return sb.toString();
    }

    private static double coef(double c, boolean smooth) {
        if (smooth && Math.abs(c) < 1.0E-9) {
            return 0.0;
        }
        return c;
    }

    @Generated
    private Coefficients() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

