/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.model.visitors.Resettable;

public class FunctionDictionaryCleaner
extends AbstractVisitor
implements Resettable {
    public Set<String> functions = new HashSet<String>();

    public void reset() {
        this.functions.clear();
    }

    public void pushParent(PMMLObject parent) {
        super.pushParent(parent);
    }

    public PMMLObject popParent() {
        PMML pmml;
        TransformationDictionary transformationDictionary;
        PMMLObject parent = super.popParent();
        if (parent instanceof PMML && (transformationDictionary = (pmml = (PMML)parent).getTransformationDictionary()) != null) {
            this.processDefineFunctions(transformationDictionary);
        }
        return parent;
    }

    public VisitorAction visit(Apply apply) {
        this.processApply(apply);
        return super.visit(apply);
    }

    private void processDefineFunctions(TransformationDictionary transformationDictionary) {
        if (transformationDictionary.hasDefineFunctions()) {
            List defineFunctions = transformationDictionary.getDefineFunctions();
            Iterator it = defineFunctions.iterator();
            while (it.hasNext()) {
                DefineFunction defineFunction = (DefineFunction)it.next();
                boolean retain = this.functions.contains(defineFunction.requireName());
                if (retain) continue;
                it.remove();
            }
        }
    }

    private void processApply(Apply apply) {
        String function = apply.requireFunction();
        this.functions.add(function);
    }
}

