## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)


## ----setup--------------------------------------------------------------------
library(blockr.dag)


## -----------------------------------------------------------------------------
# Context menu entry
entry <- new_context_menu_entry(
  name = "Custom Action",
  js = function(ns) "alert('Custom action')",
  action = function(board, update, ...) {
    # Server-side logic
  },
  condition = function(board, target) {
    target$type == "node"
  }
)


## -----------------------------------------------------------------------------
# Add custom context menu items to an extension
context_menu_items.dag_extension <- function(x) {
  list(
    new_context_menu_entry(
      name = "My Action",
      js = function(ns) {
        sprintf("Shiny.setInputValue('%s', true)", ns("my_action"))
      },
      action = my_custom_action("my_action"),
      condition = function(board, target) TRUE
    )
  )
}

