/*
 * Copyright(c) 2012-2021 Intel Corporation
 * SPDX-License-Identifier: BSD-3-Clause-Clear
 */

#ifndef __OCF_H__
#define __OCF_H__

/**
 * @file
 * @brief Main OCF header
 * This file doesn't contain any functions or structures.
 * It's simply collective include file to allow OCF user include
 * everything at once.
 */

#include "ocf_def.h"
#include "ocf_types.h"
#include "ocf_io.h"
#include "ocf_volume.h"
#include "ocf_cache.h"
#include "ocf_core.h"
#include "ocf_queue.h"
#include "ocf_cleaner.h"
#include "cleaning/alru.h"
#include "cleaning/acp.h"
#include "promotion/nhit.h"
#include "ocf_metadata.h"
#include "ocf_io_class.h"
#include "ocf_stats.h"
#include "ocf_mngt.h"
#include "ocf_ctx.h"
#include "ocf_err.h"
#include "ocf_trace.h"

#endif /* __OCF_H__ */
