// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAM3U4C.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsam3u4c

/*
// Atmel ATSAM3U4C Microcontroller
*/

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAM3U4C"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Power Management Controller
	IRQ_PMC = 5

	// Embedded Flash Controller 0
	IRQ_EFC0 = 6

	// Embedded Flash Controller 1
	IRQ_EFC1 = 7

	// Universal Asynchronous Receiver Transmitter
	IRQ_UART = 8

	// Parallel Input/Output Controller A
	IRQ_PIOA = 10

	// Parallel Input/Output Controller B
	IRQ_PIOB = 11

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 13

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 14

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 15

	// High Speed MultiMedia Card Interface
	IRQ_HSMCI = 17

	// Two-wire Interface 0
	IRQ_TWI0 = 18

	// Two-wire Interface 1
	IRQ_TWI1 = 19

	// Serial Peripheral Interface
	IRQ_SPI = 20

	// Synchronous Serial Controller
	IRQ_SSC = 21

	// Timer Counter 0
	IRQ_TC0 = 22

	// Timer Counter 0
	IRQ_TC1 = 23

	// Timer Counter 0
	IRQ_TC2 = 24

	// Pulse Width Modulation Controller
	IRQ_PWM = 25

	// Analog-to-Digital Converter 12bits
	IRQ_ADC12B = 26

	// Analog-to-Digital Converter
	IRQ_ADC = 27

	// DMA Controller
	IRQ_DMAC = 28

	// USB High Speed Device Port
	IRQ_UDPHS = 29

	// Highest interrupt number on this device.
	IRQ_max = 29
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export PMC_IRQHandler
func interruptPMC() {
	callHandlers(IRQ_PMC)
}

//export EFC0_IRQHandler
func interruptEFC0() {
	callHandlers(IRQ_EFC0)
}

//export EFC1_IRQHandler
func interruptEFC1() {
	callHandlers(IRQ_EFC1)
}

//export UART_IRQHandler
func interruptUART() {
	callHandlers(IRQ_UART)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export HSMCI_IRQHandler
func interruptHSMCI() {
	callHandlers(IRQ_HSMCI)
}

//export TWI0_IRQHandler
func interruptTWI0() {
	callHandlers(IRQ_TWI0)
}

//export TWI1_IRQHandler
func interruptTWI1() {
	callHandlers(IRQ_TWI1)
}

//export SPI_IRQHandler
func interruptSPI() {
	callHandlers(IRQ_SPI)
}

//export SSC_IRQHandler
func interruptSSC() {
	callHandlers(IRQ_SSC)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export PWM_IRQHandler
func interruptPWM() {
	callHandlers(IRQ_PWM)
}

//export ADC12B_IRQHandler
func interruptADC12B() {
	callHandlers(IRQ_ADC12B)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export DMAC_IRQHandler
func interruptDMAC() {
	callHandlers(IRQ_DMAC)
}

//export UDPHS_IRQHandler
func interruptUDPHS() {
	callHandlers(IRQ_UDPHS)
}

// Peripherals.
var (
	// High Speed MultiMedia Card Interface
	HSMCI = (*HSMCI_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial Peripheral Interface
	SPI = (*SPI_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40084000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0x4008c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40090000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40094000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40098000)))

	// USB High Speed Device Port
	UDPHS = (*UDPHS_Type)(unsafe.Pointer(uintptr(0x400a4000)))

	// Analog-to-Digital Converter 12bits
	ADC12B = (*ADC12B_Type)(unsafe.Pointer(uintptr(0x400a8000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x400ac000)))

	// DMA Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0x400b0000)))

	// Static Memory Controller
	SMC = (*EBI_Type)(unsafe.Pointer(uintptr(0x400e0000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x400e0200)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0400)))

	// Universal Asynchronous Receiver Transmitter
	UART = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0600)))

	// Chip Identifier
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0740)))

	// Embedded Flash Controller 0
	EFC0 = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0800)))

	// Embedded Flash Controller 1
	EFC1 = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0a00)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0c00)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1200)))

	// Supply Controller
	SUPC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1210)))

	// Real-time Timer
	RTT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1230)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1250)))

	// Real-time Clock
	RTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1260)))

	// General Purpose Backup Registers
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1290)))
)

// High Speed MultiMedia Card Interface
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [276]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// HSMCI.CR: Control Register
func (o *HSMCI_Type) SetCR_MCIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCR_MCIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *HSMCI_Type) SetCR_MCIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetCR_MCIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetCR_PWSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetCR_PWSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetCR_PWSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetCR_PWSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// HSMCI.MR: Mode Register
func (o *HSMCI_Type) SetMR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *HSMCI_Type) GetMR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *HSMCI_Type) SetMR_PWSDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetMR_PWSDIV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetMR_RDPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetMR_RDPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetMR_WRPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetMR_WRPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetMR_FBYTE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetMR_FBYTE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetMR_PADV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetMR_PADV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}

// HSMCI.DTOR: Data Timeout Register
func (o *HSMCI_Type) SetDTOR_DTOCYC(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetDTOR_DTOCYC() uint32 {
	return volatile.LoadUint32(&o.DTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetDTOR_DTOMUL(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetDTOR_DTOMUL() uint32 {
	return (volatile.LoadUint32(&o.DTOR.Reg) & 0x70) >> 4
}

// HSMCI.SDCR: SD/SDIO Card Register
func (o *HSMCI_Type) SetSDCR_SDCSEL(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetSDCR_SDCSEL() uint32 {
	return volatile.LoadUint32(&o.SDCR.Reg) & 0x3
}
func (o *HSMCI_Type) SetSDCR_SDCBUS(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetSDCR_SDCBUS() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc0) >> 6
}

// HSMCI.ARGR: Argument Register
func (o *HSMCI_Type) SetARGR(value uint32) {
	volatile.StoreUint32(&o.ARGR.Reg, value)
}
func (o *HSMCI_Type) GetARGR() uint32 {
	return volatile.LoadUint32(&o.ARGR.Reg)
}

// HSMCI.CMDR: Command Register
func (o *HSMCI_Type) SetCMDR_CMDNB(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3f)|value)
}
func (o *HSMCI_Type) GetCMDR_CMDNB() uint32 {
	return volatile.LoadUint32(&o.CMDR.Reg) & 0x3f
}
func (o *HSMCI_Type) SetCMDR_RSPTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetCMDR_RSPTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0xc0) >> 6
}
func (o *HSMCI_Type) SetCMDR_SPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetCMDR_SPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetCMDR_OPDCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetCMDR_OPDCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetCMDR_MAXLAT(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCMDR_MAXLAT() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetCMDR_TRCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x30000)|value<<16)
}
func (o *HSMCI_Type) GetCMDR_TRCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x30000) >> 16
}
func (o *HSMCI_Type) SetCMDR_TRDIR(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetCMDR_TRDIR() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetCMDR_TRTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x380000)|value<<19)
}
func (o *HSMCI_Type) GetCMDR_TRTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x380000) >> 19
}
func (o *HSMCI_Type) SetCMDR_IOSPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3000000)|value<<24)
}
func (o *HSMCI_Type) GetCMDR_IOSPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x3000000) >> 24
}
func (o *HSMCI_Type) SetCMDR_ATACS(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetCMDR_ATACS() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetCMDR_BOOT_ACK(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetCMDR_BOOT_ACK() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x8000000) >> 27
}

// HSMCI.BLKR: Block Register
func (o *HSMCI_Type) SetBLKR_BCNT(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetBLKR_BCNT() uint32 {
	return volatile.LoadUint32(&o.BLKR.Reg) & 0xffff
}
func (o *HSMCI_Type) SetBLKR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSMCI_Type) GetBLKR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.BLKR.Reg) & 0xffff0000) >> 16
}

// HSMCI.CSTOR: Completion Signal Timeout Register
func (o *HSMCI_Type) SetCSTOR_CSTOCYC(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetCSTOR_CSTOCYC() uint32 {
	return volatile.LoadUint32(&o.CSTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetCSTOR_CSTOMUL(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetCSTOR_CSTOMUL() uint32 {
	return (volatile.LoadUint32(&o.CSTOR.Reg) & 0x70) >> 4
}

// HSMCI.RSPR: Response Register
func (o *HSMCI_Type) SetRSPR(idx int, value uint32) {
	volatile.StoreUint32(&o.RSPR[idx].Reg, value)
}
func (o *HSMCI_Type) GetRSPR(idx int) uint32 {
	return volatile.LoadUint32(&o.RSPR[idx].Reg)
}

// HSMCI.RDR: Receive Data Register
func (o *HSMCI_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *HSMCI_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// HSMCI.TDR: Transmit Data Register
func (o *HSMCI_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *HSMCI_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// HSMCI.SR: Status Register
func (o *HSMCI_Type) SetSR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetSR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *HSMCI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetSR_BLKE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetSR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetSR_DTIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetSR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetSR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetSR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetSR_MCI_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetSR_MCI_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetSR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetSR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetSR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetSR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetSR_RINDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetSR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetSR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetSR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetSR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetSR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetSR_RENDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetSR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetSR_RTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetSR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetSR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetSR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetSR_DTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetSR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetSR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetSR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetSR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetSR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetSR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetSR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetSR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetSR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetSR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetSR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetSR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetSR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetSR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetSR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetSR_UNRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetSR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// HSMCI.IER: Interrupt Enable Register
func (o *HSMCI_Type) SetIER_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIER_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *HSMCI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIER_BLKE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIER_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIER_DTIP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIER_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIER_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIER_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIER_MCI_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIER_MCI_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIER_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIER_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIER_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIER_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIER_RINDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIER_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIER_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIER_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIER_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIER_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIER_RENDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIER_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIER_RTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIER_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIER_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIER_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIER_DTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIER_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIER_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIER_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIER_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIER_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIER_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIER_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIER_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIER_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIER_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIER_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIER_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIER_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIER_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIER_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIER_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIER_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// HSMCI.IDR: Interrupt Disable Register
func (o *HSMCI_Type) SetIDR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIDR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIDR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIDR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIDR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIDR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIDR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIDR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIDR_MCI_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIDR_MCI_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIDR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIDR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIDR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIDR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIDR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIDR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIDR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIDR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIDR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIDR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIDR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIDR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIDR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIDR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIDR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIDR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIDR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIDR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIDR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIDR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIDR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIDR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIDR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIDR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIDR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIDR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIDR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIDR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIDR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIDR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIDR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIDR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIDR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIDR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// HSMCI.IMR: Interrupt Mask Register
func (o *HSMCI_Type) SetIMR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIMR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIMR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIMR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIMR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIMR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIMR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIMR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIMR_MCI_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIMR_MCI_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIMR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIMR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIMR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIMR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIMR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIMR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIMR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIMR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIMR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIMR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIMR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIMR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIMR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIMR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIMR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIMR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIMR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIMR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIMR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIMR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIMR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIMR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIMR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIMR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIMR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIMR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIMR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIMR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIMR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIMR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIMR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIMR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIMR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIMR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// HSMCI.DMA: DMA Configuration Register
func (o *HSMCI_Type) SetDMA_OFFSET(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetDMA_OFFSET() uint32 {
	return volatile.LoadUint32(&o.DMA.Reg) & 0x3
}
func (o *HSMCI_Type) SetDMA_CHKSIZE(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetDMA_CHKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x70) >> 4
}
func (o *HSMCI_Type) SetDMA_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetDMA_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetDMA_ROPT(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetDMA_ROPT() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x1000) >> 12
}

// HSMCI.CFG: Configuration Register
func (o *HSMCI_Type) SetCFG_FIFOMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCFG_FIFOMODE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *HSMCI_Type) SetCFG_FERRCTRL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetCFG_FERRCTRL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetCFG_HSMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetCFG_HSMODE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetCFG_LSYNC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCFG_LSYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}

// HSMCI.WPMR: Write Protection Mode Register
func (o *HSMCI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// HSMCI.WPSR: Write Protection Status Register
func (o *HSMCI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0xf
}
func (o *HSMCI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// HSMCI.FIFO: FIFO Memory Aperture0
func (o *HSMCI_Type) SetFIFO(idx int, value uint32) {
	volatile.StoreUint32(&o.FIFO[idx].Reg, value)
}
func (o *HSMCI_Type) GetFIFO(idx int) uint32 {
	return volatile.LoadUint32(&o.FIFO[idx].Reg)
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SSC.CR: Control Register
func (o *SSC_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetCR_RXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SSC_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *SSC_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// SSC.CMR: Clock Mode Register
func (o *SSC_Type) SetCMR_DIV(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xfff)|value)
}
func (o *SSC_Type) GetCMR_DIV() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xfff
}

// SSC.RCMR: Receive Clock Mode Register
func (o *SSC_Type) SetRCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetRCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.RCMR.Reg) & 0x3
}
func (o *SSC_Type) SetRCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetRCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetRCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetRCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetRCMR_START(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRCMR_START() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRCMR_STOP(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1000)|value<<12)
}
func (o *SSC_Type) GetRCMR_STOP() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1000) >> 12
}
func (o *SSC_Type) SetRCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetRCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetRCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetRCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff000000) >> 24
}

// SSC.RFMR: Receive Frame Mode Register
func (o *SSC_Type) SetRFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetRFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.RFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetRFMR_LOOP(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRFMR_LOOP() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetRFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetRFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetRFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetRFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetRFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetRFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetRFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetRFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetRFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000000) >> 28
}

// SSC.TCMR: Transmit Clock Mode Register
func (o *SSC_Type) SetTCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetTCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.TCMR.Reg) & 0x3
}
func (o *SSC_Type) SetTCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetTCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetTCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetTCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetTCMR_START(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTCMR_START() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetTCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetTCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetTCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff000000) >> 24
}

// SSC.TFMR: Transmit Frame Mode Register
func (o *SSC_Type) SetTFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetTFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.TFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetTFMR_DATDEF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTFMR_DATDEF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetTFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetTFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetTFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetTFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetTFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetTFMR_FSDEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x800000)|value<<23)
}
func (o *SSC_Type) GetTFMR_FSDEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x800000) >> 23
}
func (o *SSC_Type) SetTFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetTFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetTFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetTFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000000) >> 28
}

// SSC.RHR: Receive Holding Register
func (o *SSC_Type) SetRHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, value)
}
func (o *SSC_Type) GetRHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg)
}

// SSC.THR: Transmit Holding Register
func (o *SSC_Type) SetTHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, value)
}
func (o *SSC_Type) GetTHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg)
}

// SSC.RSHR: Receive Sync. Holding Register
func (o *SSC_Type) SetRSHR_RSDAT(value uint32) {
	volatile.StoreUint32(&o.RSHR.Reg, volatile.LoadUint32(&o.RSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRSHR_RSDAT() uint32 {
	return volatile.LoadUint32(&o.RSHR.Reg) & 0xffff
}

// SSC.TSHR: Transmit Sync. Holding Register
func (o *SSC_Type) SetTSHR_TSDAT(value uint32) {
	volatile.StoreUint32(&o.TSHR.Reg, volatile.LoadUint32(&o.TSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTSHR_TSDAT() uint32 {
	return volatile.LoadUint32(&o.TSHR.Reg) & 0xffff
}

// SSC.RC0R: Receive Compare 0 Register
func (o *SSC_Type) SetRC0R_CP0(value uint32) {
	volatile.StoreUint32(&o.RC0R.Reg, volatile.LoadUint32(&o.RC0R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC0R_CP0() uint32 {
	return volatile.LoadUint32(&o.RC0R.Reg) & 0xffff
}

// SSC.RC1R: Receive Compare 1 Register
func (o *SSC_Type) SetRC1R_CP1(value uint32) {
	volatile.StoreUint32(&o.RC1R.Reg, volatile.LoadUint32(&o.RC1R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC1R_CP1() uint32 {
	return volatile.LoadUint32(&o.RC1R.Reg) & 0xffff
}

// SSC.SR: Status Register
func (o *SSC_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSC_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetSR_CP0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetSR_CP0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetSR_CP1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetSR_CP1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetSR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetSR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetSR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetSR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SSC_Type) SetSR_TXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SSC_Type) GetSR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SSC_Type) SetSR_RXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SSC_Type) GetSR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SSC.IER: Interrupt Enable Register
func (o *SSC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SSC_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIER_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIER_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIER_CP0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIER_CP0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIER_CP1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIER_CP1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIER_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIER_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIER_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIER_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// SSC.IDR: Interrupt Disable Register
func (o *SSC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SSC_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIDR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIDR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIDR_CP0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIDR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIDR_CP1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIDR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIDR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIDR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIDR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIDR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// SSC.IMR: Interrupt Mask Register
func (o *SSC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SSC_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIMR_CP0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIMR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIMR_CP1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIMR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIMR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIMR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIMR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIMR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// SSC.WPMR: Write Protect Mode Register
func (o *SSC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SSC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Serial Peripheral Interface
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SPI.CR: Control Register
func (o *SPI_Type) SetCR_SPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR_SPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SPI_Type) SetCR_SPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR_SPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// SPI.MR: Mode Register
func (o *SPI_Type) SetMR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMR_MSTR() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SPI_Type) SetMR_PS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetMR_PS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetMR_PCSDEC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetMR_PCSDEC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetMR_MODFDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetMR_MODFDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetMR_PCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetMR_PCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetMR_DLYBCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetMR_DLYBCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SPI.RDR: Receive Data Register
func (o *SPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}
func (o *SPI_Type) SetRDR_PCS(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetRDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.RDR.Reg) & 0xf0000) >> 16
}

// SPI.TDR: Transmit Data Register
func (o *SPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}
func (o *SPI_Type) SetTDR_PCS(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetTDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetTDR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetTDR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0x1000000) >> 24
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_NSSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetSR_UNDES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetSR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetSR_SPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetSR_SPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// SPI.IER: Interrupt Enable Register
func (o *SPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIER_MODF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIER_MODF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIER_NSSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIER_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIER_UNDES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIER_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}

// SPI.IDR: Interrupt Disable Register
func (o *SPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIDR_MODF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIDR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIDR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIDR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIDR_UNDES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIDR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}

// SPI.IMR: Interrupt Mask Register
func (o *SPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIMR_MODF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIMR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIMR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIMR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIMR_UNDES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIMR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}

// SPI.CSR: Chip Select Register
func (o *SPI_Type) SetCSR_CPOL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCSR_CPOL(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *SPI_Type) SetCSR_NCPHA(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCSR_NCPHA(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCSR_CSNAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCSR_CSNAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCSR_CSAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCSR_CSAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCSR_BITS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCSR_BITS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCSR_SCBR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetCSR_SCBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff00) >> 8
}
func (o *SPI_Type) SetCSR_DLYBS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *SPI_Type) GetCSR_DLYBS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff0000) >> 16
}
func (o *SPI_Type) SetCSR_DLYBCT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetCSR_DLYBCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff000000) >> 24
}

// SPI.WPMR: Write Protection Control Register
func (o *SPI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SPI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SPI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// SPI.WPSR: Write Protection Status Register
func (o *SPI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *SPI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// Timer Counter 0
type TC_Type struct {
	CCR0 volatile.Register32 // 0x0
	CMR0 volatile.Register32 // 0x4
	_    [8]byte
	CV0  volatile.Register32 // 0x10
	RA0  volatile.Register32 // 0x14
	RB0  volatile.Register32 // 0x18
	RC0  volatile.Register32 // 0x1C
	SR0  volatile.Register32 // 0x20
	IER0 volatile.Register32 // 0x24
	IDR0 volatile.Register32 // 0x28
	IMR0 volatile.Register32 // 0x2C
	_    [16]byte
	CCR1 volatile.Register32 // 0x40
	CMR1 volatile.Register32 // 0x44
	_    [8]byte
	CV1  volatile.Register32 // 0x50
	RA1  volatile.Register32 // 0x54
	RB1  volatile.Register32 // 0x58
	RC1  volatile.Register32 // 0x5C
	SR1  volatile.Register32 // 0x60
	IER1 volatile.Register32 // 0x64
	IDR1 volatile.Register32 // 0x68
	IMR1 volatile.Register32 // 0x6C
	_    [16]byte
	CCR2 volatile.Register32 // 0x80
	CMR2 volatile.Register32 // 0x84
	_    [8]byte
	CV2  volatile.Register32 // 0x90
	RA2  volatile.Register32 // 0x94
	RB2  volatile.Register32 // 0x98
	RC2  volatile.Register32 // 0x9C
	SR2  volatile.Register32 // 0xA0
	IER2 volatile.Register32 // 0xA4
	IDR2 volatile.Register32 // 0xA8
	IMR2 volatile.Register32 // 0xAC
	_    [16]byte
	BCR  volatile.Register32 // 0xC0
	BMR  volatile.Register32 // 0xC4
	QIER volatile.Register32 // 0xC8
	QIDR volatile.Register32 // 0xCC
	QIMR volatile.Register32 // 0xD0
	QISR volatile.Register32 // 0xD4
}

// TC.CCR0: Channel Control Register (channel = 0)
func (o *TC_Type) SetCCR0_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR0_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0x1
}
func (o *TC_Type) SetCCR0_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR0_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR0_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR0_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x4) >> 2
}

// TC.CMR0: Channel Mode Register (channel = 0)
func (o *TC_Type) SetCMR0_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR0_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0x7
}
func (o *TC_Type) SetCMR0_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR0_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR0_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR0_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR0_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR0_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR0_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR0_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR0_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR0_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR0_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR0_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR0_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR0_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR0_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR0_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR0_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR0_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR0_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR0_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0xc0000) >> 18
}

// TC.CV0: Counter Value (channel = 0)
func (o *TC_Type) SetCV0(value uint32) {
	volatile.StoreUint32(&o.CV0.Reg, value)
}
func (o *TC_Type) GetCV0() uint32 {
	return volatile.LoadUint32(&o.CV0.Reg)
}

// TC.RA0: Register A (channel = 0)
func (o *TC_Type) SetRA0(value uint32) {
	volatile.StoreUint32(&o.RA0.Reg, value)
}
func (o *TC_Type) GetRA0() uint32 {
	return volatile.LoadUint32(&o.RA0.Reg)
}

// TC.RB0: Register B (channel = 0)
func (o *TC_Type) SetRB0(value uint32) {
	volatile.StoreUint32(&o.RB0.Reg, value)
}
func (o *TC_Type) GetRB0() uint32 {
	return volatile.LoadUint32(&o.RB0.Reg)
}

// TC.RC0: Register C (channel = 0)
func (o *TC_Type) SetRC0(value uint32) {
	volatile.StoreUint32(&o.RC0.Reg, value)
}
func (o *TC_Type) GetRC0() uint32 {
	return volatile.LoadUint32(&o.RC0.Reg)
}

// TC.SR0: Status Register (channel = 0)
func (o *TC_Type) SetSR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR0.Reg) & 0x1
}
func (o *TC_Type) SetSR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR0_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR0_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR0_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR0_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR0_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR0_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40000) >> 18
}

// TC.IER0: Interrupt Enable Register (channel = 0)
func (o *TC_Type) SetIER0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER0.Reg) & 0x1
}
func (o *TC_Type) SetIER0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x80) >> 7
}

// TC.IDR0: Interrupt Disable Register (channel = 0)
func (o *TC_Type) SetIDR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR0.Reg) & 0x1
}
func (o *TC_Type) SetIDR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x80) >> 7
}

// TC.IMR0: Interrupt Mask Register (channel = 0)
func (o *TC_Type) SetIMR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR0.Reg) & 0x1
}
func (o *TC_Type) SetIMR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x80) >> 7
}

// TC.CCR1: Channel Control Register (channel = 1)
func (o *TC_Type) SetCCR1_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR1_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}
func (o *TC_Type) SetCCR1_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR1_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR1_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR1_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}

// TC.CMR1: Channel Mode Register (channel = 1)
func (o *TC_Type) SetCMR1_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR1_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0x7
}
func (o *TC_Type) SetCMR1_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR1_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR1_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR1_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR1_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR1_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR1_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR1_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR1_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR1_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR1_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR1_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR1_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR1_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR1_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR1_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR1_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR1_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR1_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR1_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0xc0000) >> 18
}

// TC.CV1: Counter Value (channel = 1)
func (o *TC_Type) SetCV1(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, value)
}
func (o *TC_Type) GetCV1() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg)
}

// TC.RA1: Register A (channel = 1)
func (o *TC_Type) SetRA1(value uint32) {
	volatile.StoreUint32(&o.RA1.Reg, value)
}
func (o *TC_Type) GetRA1() uint32 {
	return volatile.LoadUint32(&o.RA1.Reg)
}

// TC.RB1: Register B (channel = 1)
func (o *TC_Type) SetRB1(value uint32) {
	volatile.StoreUint32(&o.RB1.Reg, value)
}
func (o *TC_Type) GetRB1() uint32 {
	return volatile.LoadUint32(&o.RB1.Reg)
}

// TC.RC1: Register C (channel = 1)
func (o *TC_Type) SetRC1(value uint32) {
	volatile.StoreUint32(&o.RC1.Reg, value)
}
func (o *TC_Type) GetRC1() uint32 {
	return volatile.LoadUint32(&o.RC1.Reg)
}

// TC.SR1: Status Register (channel = 1)
func (o *TC_Type) SetSR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}
func (o *TC_Type) SetSR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR1_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR1_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR1_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR1_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR1_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR1_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40000) >> 18
}

// TC.IER1: Interrupt Enable Register (channel = 1)
func (o *TC_Type) SetIER1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *TC_Type) SetIER1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}

// TC.IDR1: Interrupt Disable Register (channel = 1)
func (o *TC_Type) SetIDR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *TC_Type) SetIDR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80) >> 7
}

// TC.IMR1: Interrupt Mask Register (channel = 1)
func (o *TC_Type) SetIMR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *TC_Type) SetIMR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}

// TC.CCR2: Channel Control Register (channel = 2)
func (o *TC_Type) SetCCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR2_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}
func (o *TC_Type) SetCCR2_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR2_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR2_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR2_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}

// TC.CMR2: Channel Mode Register (channel = 2)
func (o *TC_Type) SetCMR2_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR2_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0x7
}
func (o *TC_Type) SetCMR2_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR2_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR2_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR2_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR2_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR2_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR2_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR2_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR2_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR2_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR2_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR2_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR2_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR2_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR2_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR2_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR2_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR2_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR2_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR2_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0xc0000) >> 18
}

// TC.CV2: Counter Value (channel = 2)
func (o *TC_Type) SetCV2(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, value)
}
func (o *TC_Type) GetCV2() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg)
}

// TC.RA2: Register A (channel = 2)
func (o *TC_Type) SetRA2(value uint32) {
	volatile.StoreUint32(&o.RA2.Reg, value)
}
func (o *TC_Type) GetRA2() uint32 {
	return volatile.LoadUint32(&o.RA2.Reg)
}

// TC.RB2: Register B (channel = 2)
func (o *TC_Type) SetRB2(value uint32) {
	volatile.StoreUint32(&o.RB2.Reg, value)
}
func (o *TC_Type) GetRB2() uint32 {
	return volatile.LoadUint32(&o.RB2.Reg)
}

// TC.RC2: Register C (channel = 2)
func (o *TC_Type) SetRC2(value uint32) {
	volatile.StoreUint32(&o.RC2.Reg, value)
}
func (o *TC_Type) GetRC2() uint32 {
	return volatile.LoadUint32(&o.RC2.Reg)
}

// TC.SR2: Status Register (channel = 2)
func (o *TC_Type) SetSR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}
func (o *TC_Type) SetSR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR2_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR2_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR2_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR2_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR2_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR2_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40000) >> 18
}

// TC.IER2: Interrupt Enable Register (channel = 2)
func (o *TC_Type) SetIER2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *TC_Type) SetIER2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80) >> 7
}

// TC.IDR2: Interrupt Disable Register (channel = 2)
func (o *TC_Type) SetIDR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *TC_Type) SetIDR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80) >> 7
}

// TC.IMR2: Interrupt Mask Register (channel = 2)
func (o *TC_Type) SetIMR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *TC_Type) SetIMR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}

// TC.BCR: Block Control Register
func (o *TC_Type) SetBCR_SYNC(value uint32) {
	volatile.StoreUint32(&o.BCR.Reg, volatile.LoadUint32(&o.BCR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetBCR_SYNC() uint32 {
	return volatile.LoadUint32(&o.BCR.Reg) & 0x1
}

// TC.BMR: Block Mode Register
func (o *TC_Type) SetBMR_TC0XC0S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3)|value)
}
func (o *TC_Type) GetBMR_TC0XC0S() uint32 {
	return volatile.LoadUint32(&o.BMR.Reg) & 0x3
}
func (o *TC_Type) SetBMR_TC1XC1S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0xc)|value<<2)
}
func (o *TC_Type) GetBMR_TC1XC1S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0xc) >> 2
}
func (o *TC_Type) SetBMR_TC2XC2S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetBMR_TC2XC2S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetBMR_QDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetBMR_QDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x100) >> 8
}
func (o *TC_Type) SetBMR_POSEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x200)|value<<9)
}
func (o *TC_Type) GetBMR_POSEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x200) >> 9
}
func (o *TC_Type) SetBMR_SPEEDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetBMR_SPEEDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetBMR_QDTRANS(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x800)|value<<11)
}
func (o *TC_Type) GetBMR_QDTRANS() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x800) >> 11
}
func (o *TC_Type) SetBMR_EDGPHA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x1000)|value<<12)
}
func (o *TC_Type) GetBMR_EDGPHA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x1000) >> 12
}
func (o *TC_Type) SetBMR_INVA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x2000)|value<<13)
}
func (o *TC_Type) GetBMR_INVA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x2000) >> 13
}
func (o *TC_Type) SetBMR_INVB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetBMR_INVB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetBMR_INVIDX(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetBMR_INVIDX() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetBMR_SWAP(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetBMR_SWAP() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetBMR_IDXPHB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetBMR_IDXPHB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetBMR_MAXFILT(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3f00000)|value<<20)
}
func (o *TC_Type) GetBMR_MAXFILT() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x3f00000) >> 20
}

// TC.QIER: QDEC Interrupt Enable Register
func (o *TC_Type) SetQIER_IDX(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIER_IDX() uint32 {
	return volatile.LoadUint32(&o.QIER.Reg) & 0x1
}
func (o *TC_Type) SetQIER_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIER_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIER_QERR(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIER_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x4) >> 2
}

// TC.QIDR: QDEC Interrupt Disable Register
func (o *TC_Type) SetQIDR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIDR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIDR.Reg) & 0x1
}
func (o *TC_Type) SetQIDR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIDR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIDR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIDR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x4) >> 2
}

// TC.QIMR: QDEC Interrupt Mask Register
func (o *TC_Type) SetQIMR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIMR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIMR.Reg) & 0x1
}
func (o *TC_Type) SetQIMR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIMR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIMR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIMR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x4) >> 2
}

// TC.QISR: QDEC Interrupt Status Register
func (o *TC_Type) SetQISR_IDX(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQISR_IDX() uint32 {
	return volatile.LoadUint32(&o.QISR.Reg) & 0x1
}
func (o *TC_Type) SetQISR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQISR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQISR_QERR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQISR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetQISR_DIR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetQISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x100) >> 8
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
	_    [200]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// TWI.CR: Control Register
func (o *TWI_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TWI_Type) SetCR_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetCR_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetCR_MSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetCR_MSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetCR_MSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetCR_MSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetCR_SVEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetCR_SVEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetCR_SVDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetCR_SVDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetCR_QUICK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetCR_QUICK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// TWI.MMR: Master Mode Register
func (o *TWI_Type) SetMMR_IADRSZ(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x300)|value<<8)
}
func (o *TWI_Type) GetMMR_IADRSZ() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x300) >> 8
}
func (o *TWI_Type) SetMMR_MREAD(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetMMR_MREAD() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetMMR_DADR(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetMMR_DADR() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x7f0000) >> 16
}

// TWI.SMR: Slave Mode Register
func (o *TWI_Type) SetSMR_SADR(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetSMR_SADR() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f0000) >> 16
}

// TWI.IADR: Internal Address Register
func (o *TWI_Type) SetIADR(value uint32) {
	volatile.StoreUint32(&o.IADR.Reg, volatile.LoadUint32(&o.IADR.Reg)&^(0xffffff)|value)
}
func (o *TWI_Type) GetIADR() uint32 {
	return volatile.LoadUint32(&o.IADR.Reg) & 0xffffff
}

// TWI.CWGR: Clock Waveform Generator Register
func (o *TWI_Type) SetCWGR_CLDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetCWGR_CLDIV() uint32 {
	return volatile.LoadUint32(&o.CWGR.Reg) & 0xff
}
func (o *TWI_Type) SetCWGR_CHDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff00)|value<<8)
}
func (o *TWI_Type) GetCWGR_CHDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0xff00) >> 8
}
func (o *TWI_Type) SetCWGR_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x70000)|value<<16)
}
func (o *TWI_Type) GetCWGR_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x70000) >> 16
}

// TWI.SR: Status Register
func (o *TWI_Type) SetSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetSR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TWI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetSR_SVREAD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetSR_SVREAD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetSR_SVACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetSR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetSR_GACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetSR_GACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetSR_NACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetSR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetSR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetSR_SCLWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetSR_SCLWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetSR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetSR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}

// TWI.IER: Interrupt Enable Register
func (o *TWI_Type) SetIER_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIER_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TWI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIER_SVACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIER_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIER_GACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIER_GACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIER_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIER_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIER_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIER_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIER_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIER_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}

// TWI.IDR: Interrupt Disable Register
func (o *TWI_Type) SetIDR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIDR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TWI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIDR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIDR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIDR_GACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIDR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIDR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIDR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIDR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIDR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIDR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIDR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}

// TWI.IMR: Interrupt Mask Register
func (o *TWI_Type) SetIMR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIMR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TWI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIMR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIMR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIMR_GACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIMR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIMR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIMR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIMR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIMR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIMR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIMR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}

// TWI.RHR: Receive Holding Register
func (o *TWI_Type) SetRHR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetRHR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// TWI.THR: Transmit Holding Register
func (o *TWI_Type) SetTHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetTHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// TWI.RPR: Receive Pointer Register
func (o *TWI_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *TWI_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// TWI.RCR: Receive Counter Register
func (o *TWI_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// TWI.TPR: Transmit Pointer Register
func (o *TWI_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *TWI_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// TWI.TCR: Transmit Counter Register
func (o *TWI_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// TWI.RNPR: Receive Next Pointer Register
func (o *TWI_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *TWI_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// TWI.RNCR: Receive Next Counter Register
func (o *TWI_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// TWI.TNPR: Transmit Next Pointer Register
func (o *TWI_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *TWI_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// TWI.TNCR: Transmit Next Counter Register
func (o *TWI_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// TWI.PTCR: Transfer Control Register
func (o *TWI_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *TWI_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// TWI.PTSR: Transfer Status Register
func (o *TWI_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *TWI_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	CLK      volatile.Register32 // 0x0
	ENA      volatile.Register32 // 0x4
	DIS      volatile.Register32 // 0x8
	SR       volatile.Register32 // 0xC
	IER1     volatile.Register32 // 0x10
	IDR1     volatile.Register32 // 0x14
	IMR1     volatile.Register32 // 0x18
	ISR1     volatile.Register32 // 0x1C
	SCM      volatile.Register32 // 0x20
	_        [4]byte
	SCUC     volatile.Register32 // 0x28
	SCUP     volatile.Register32 // 0x2C
	SCUPUPD  volatile.Register32 // 0x30
	IER2     volatile.Register32 // 0x34
	IDR2     volatile.Register32 // 0x38
	IMR2     volatile.Register32 // 0x3C
	ISR2     volatile.Register32 // 0x40
	OOV      volatile.Register32 // 0x44
	OS       volatile.Register32 // 0x48
	OSS      volatile.Register32 // 0x4C
	OSC      volatile.Register32 // 0x50
	OSSUPD   volatile.Register32 // 0x54
	OSCUPD   volatile.Register32 // 0x58
	FMR      volatile.Register32 // 0x5C
	FSR      volatile.Register32 // 0x60
	FCR      volatile.Register32 // 0x64
	FPV      volatile.Register32 // 0x68
	FPE      volatile.Register32 // 0x6C
	_        [12]byte
	ELMR     [2]volatile.Register32 // 0x7C
	_        [44]byte
	SMMR     volatile.Register32 // 0xB0
	_        [48]byte
	WPCR     volatile.Register32 // 0xE4
	WPSR     volatile.Register32 // 0xE8
	_        [28]byte
	TPR      volatile.Register32 // 0x108
	TCR      volatile.Register32 // 0x10C
	_        [8]byte
	TNPR     volatile.Register32 // 0x118
	TNCR     volatile.Register32 // 0x11C
	PTCR     volatile.Register32 // 0x120
	PTSR     volatile.Register32 // 0x124
	_        [8]byte
	CMPV0    volatile.Register32 // 0x130
	CMPVUPD0 volatile.Register32 // 0x134
	CMPM0    volatile.Register32 // 0x138
	CMPMUPD0 volatile.Register32 // 0x13C
	CMPV1    volatile.Register32 // 0x140
	CMPVUPD1 volatile.Register32 // 0x144
	CMPM1    volatile.Register32 // 0x148
	CMPMUPD1 volatile.Register32 // 0x14C
	CMPV2    volatile.Register32 // 0x150
	CMPVUPD2 volatile.Register32 // 0x154
	CMPM2    volatile.Register32 // 0x158
	CMPMUPD2 volatile.Register32 // 0x15C
	CMPV3    volatile.Register32 // 0x160
	CMPVUPD3 volatile.Register32 // 0x164
	CMPM3    volatile.Register32 // 0x168
	CMPMUPD3 volatile.Register32 // 0x16C
	CMPV4    volatile.Register32 // 0x170
	CMPVUPD4 volatile.Register32 // 0x174
	CMPM4    volatile.Register32 // 0x178
	CMPMUPD4 volatile.Register32 // 0x17C
	CMPV5    volatile.Register32 // 0x180
	CMPVUPD5 volatile.Register32 // 0x184
	CMPM5    volatile.Register32 // 0x188
	CMPMUPD5 volatile.Register32 // 0x18C
	CMPV6    volatile.Register32 // 0x190
	CMPVUPD6 volatile.Register32 // 0x194
	CMPM6    volatile.Register32 // 0x198
	CMPMUPD6 volatile.Register32 // 0x19C
	CMPV7    volatile.Register32 // 0x1A0
	CMPVUPD7 volatile.Register32 // 0x1A4
	CMPM7    volatile.Register32 // 0x1A8
	CMPMUPD7 volatile.Register32 // 0x1AC
	_        [80]byte
	CMR0     volatile.Register32 // 0x200
	CDTY0    volatile.Register32 // 0x204
	CDTYUPD0 volatile.Register32 // 0x208
	CPRD0    volatile.Register32 // 0x20C
	CPRDUPD0 volatile.Register32 // 0x210
	CCNT0    volatile.Register32 // 0x214
	DT0      volatile.Register32 // 0x218
	DTUPD0   volatile.Register32 // 0x21C
	CMR1     volatile.Register32 // 0x220
	CDTY1    volatile.Register32 // 0x224
	CDTYUPD1 volatile.Register32 // 0x228
	CPRD1    volatile.Register32 // 0x22C
	CPRDUPD1 volatile.Register32 // 0x230
	CCNT1    volatile.Register32 // 0x234
	DT1      volatile.Register32 // 0x238
	DTUPD1   volatile.Register32 // 0x23C
	CMR2     volatile.Register32 // 0x240
	CDTY2    volatile.Register32 // 0x244
	CDTYUPD2 volatile.Register32 // 0x248
	CPRD2    volatile.Register32 // 0x24C
	CPRDUPD2 volatile.Register32 // 0x250
	CCNT2    volatile.Register32 // 0x254
	DT2      volatile.Register32 // 0x258
	DTUPD2   volatile.Register32 // 0x25C
	CMR3     volatile.Register32 // 0x260
	CDTY3    volatile.Register32 // 0x264
	CDTYUPD3 volatile.Register32 // 0x268
	CPRD3    volatile.Register32 // 0x26C
	CPRDUPD3 volatile.Register32 // 0x270
	CCNT3    volatile.Register32 // 0x274
	DT3      volatile.Register32 // 0x278
	DTUPD3   volatile.Register32 // 0x27C
}

// PWM.CLK: PWM Clock Register
func (o *PWM_Type) SetCLK_DIVA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetCLK_DIVA() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0xff
}
func (o *PWM_Type) SetCLK_PREA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCLK_PREA() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCLK_DIVB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetCLK_DIVB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetCLK_PREB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf000000)|value<<24)
}
func (o *PWM_Type) GetCLK_PREB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf000000) >> 24
}

// PWM.ENA: PWM Enable Register
func (o *PWM_Type) SetENA_CHID0(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENA_CHID0() uint32 {
	return volatile.LoadUint32(&o.ENA.Reg) & 0x1
}
func (o *PWM_Type) SetENA_CHID1(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetENA_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetENA_CHID2(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetENA_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetENA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetENA_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x8) >> 3
}

// PWM.DIS: PWM Disable Register
func (o *PWM_Type) SetDIS_CHID0(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetDIS_CHID0() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}
func (o *PWM_Type) SetDIS_CHID1(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetDIS_CHID1() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetDIS_CHID2(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetDIS_CHID2() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetDIS_CHID3(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetDIS_CHID3() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x8) >> 3
}

// PWM.SR: PWM Status Register
func (o *PWM_Type) SetSR_CHID0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSR_CHID0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PWM_Type) SetSR_CHID1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSR_CHID2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSR_CHID3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}

// PWM.IER1: PWM Interrupt Enable Register 1
func (o *PWM_Type) SetIER1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *PWM_Type) SetIER1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80000) >> 19
}

// PWM.IDR1: PWM Interrupt Disable Register 1
func (o *PWM_Type) SetIDR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *PWM_Type) SetIDR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80000) >> 19
}

// PWM.IMR1: PWM Interrupt Mask Register 1
func (o *PWM_Type) SetIMR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *PWM_Type) SetIMR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}

// PWM.ISR1: PWM Interrupt Status Register 1
func (o *PWM_Type) SetISR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.ISR1.Reg) & 0x1
}
func (o *PWM_Type) SetISR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x80000) >> 19
}

// PWM.SCM: PWM Sync Channels Mode Register
func (o *PWM_Type) SetSCM_SYNC0(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCM_SYNC0() uint32 {
	return volatile.LoadUint32(&o.SCM.Reg) & 0x1
}
func (o *PWM_Type) SetSCM_SYNC1(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSCM_SYNC1() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSCM_SYNC2(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSCM_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSCM_SYNC3(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSCM_SYNC3() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSCM_UPDM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x30000)|value<<16)
}
func (o *PWM_Type) GetSCM_UPDM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x30000) >> 16
}
func (o *PWM_Type) SetSCM_PTRM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetSCM_PTRM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetSCM_PTRCS(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0xe00000)|value<<21)
}
func (o *PWM_Type) GetSCM_PTRCS() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0xe00000) >> 21
}

// PWM.SCUC: PWM Sync Channels Update Control Register
func (o *PWM_Type) SetSCUC_UPDULOCK(value uint32) {
	volatile.StoreUint32(&o.SCUC.Reg, volatile.LoadUint32(&o.SCUC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCUC_UPDULOCK() uint32 {
	return volatile.LoadUint32(&o.SCUC.Reg) & 0x1
}

// PWM.SCUP: PWM Sync Channels Update Period Register
func (o *PWM_Type) SetSCUP_UPR(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUP_UPR() uint32 {
	return volatile.LoadUint32(&o.SCUP.Reg) & 0xf
}
func (o *PWM_Type) SetSCUP_UPRCNT(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetSCUP_UPRCNT() uint32 {
	return (volatile.LoadUint32(&o.SCUP.Reg) & 0xf0) >> 4
}

// PWM.SCUPUPD: PWM Sync Channels Update Period Update Register
func (o *PWM_Type) SetSCUPUPD_UPRUPD(value uint32) {
	volatile.StoreUint32(&o.SCUPUPD.Reg, volatile.LoadUint32(&o.SCUPUPD.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUPUPD_UPRUPD() uint32 {
	return volatile.LoadUint32(&o.SCUPUPD.Reg) & 0xf
}

// PWM.IER2: PWM Interrupt Enable Register 2
func (o *PWM_Type) SetIER2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *PWM_Type) SetIER2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIER2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIER2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIER2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIER2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIER2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIER2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIER2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIER2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIER2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIER2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIER2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIER2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIER2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIER2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIER2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIER2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIER2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIER2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIER2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIER2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIER2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIER2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIER2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIER2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800000) >> 23
}

// PWM.IDR2: PWM Interrupt Disable Register 2
func (o *PWM_Type) SetIDR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *PWM_Type) SetIDR2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIDR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIDR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIDR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIDR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIDR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIDR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIDR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIDR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIDR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIDR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIDR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIDR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIDR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIDR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIDR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIDR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIDR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIDR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIDR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIDR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIDR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIDR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIDR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIDR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800000) >> 23
}

// PWM.IMR2: PWM Interrupt Mask Register 2
func (o *PWM_Type) SetIMR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *PWM_Type) SetIMR2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIMR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIMR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIMR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIMR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIMR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIMR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIMR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIMR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIMR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIMR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIMR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIMR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIMR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIMR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIMR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIMR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIMR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIMR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIMR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIMR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIMR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIMR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIMR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIMR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800000) >> 23
}

// PWM.ISR2: PWM Interrupt Status Register 2
func (o *PWM_Type) SetISR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.ISR2.Reg) & 0x1
}
func (o *PWM_Type) SetISR2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetISR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetISR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetISR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetISR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetISR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetISR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetISR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetISR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetISR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetISR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetISR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetISR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetISR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetISR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetISR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetISR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetISR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetISR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetISR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetISR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetISR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetISR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetISR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetISR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800000) >> 23
}

// PWM.OOV: PWM Output Override Value Register
func (o *PWM_Type) SetOOV_OOVH0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOOV_OOVH0() uint32 {
	return volatile.LoadUint32(&o.OOV.Reg) & 0x1
}
func (o *PWM_Type) SetOOV_OOVH1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOOV_OOVH1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOOV_OOVH2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOOV_OOVH2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOOV_OOVH3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOOV_OOVH3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOOV_OOVL0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOOV_OOVL0() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOOV_OOVL1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOOV_OOVL1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOOV_OOVL2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOOV_OOVL2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOOV_OOVL3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOOV_OOVL3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x80000) >> 19
}

// PWM.OS: PWM Output Selection Register
func (o *PWM_Type) SetOS_OSH0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOS_OSH0() uint32 {
	return volatile.LoadUint32(&o.OS.Reg) & 0x1
}
func (o *PWM_Type) SetOS_OSH1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOS_OSH1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOS_OSH2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOS_OSH2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOS_OSH3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOS_OSH3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOS_OSL0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOS_OSL0() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOS_OSL1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOS_OSL1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOS_OSL2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOS_OSL2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOS_OSL3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOS_OSL3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x80000) >> 19
}

// PWM.OSS: PWM Output Selection Set Register
func (o *PWM_Type) SetOSS_OSSH0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSS_OSSH0() uint32 {
	return volatile.LoadUint32(&o.OSS.Reg) & 0x1
}
func (o *PWM_Type) SetOSS_OSSH1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSS_OSSH1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSS_OSSH2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSS_OSSH2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSS_OSSH3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSS_OSSH3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSS_OSSL0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSS_OSSL0() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSS_OSSL1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSS_OSSL1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSS_OSSL2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSS_OSSL2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSS_OSSL3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSS_OSSL3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x80000) >> 19
}

// PWM.OSC: PWM Output Selection Clear Register
func (o *PWM_Type) SetOSC_OSCH0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSC_OSCH0() uint32 {
	return volatile.LoadUint32(&o.OSC.Reg) & 0x1
}
func (o *PWM_Type) SetOSC_OSCH1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSC_OSCH1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSC_OSCH2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSC_OSCH2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSC_OSCH3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSC_OSCH3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSC_OSCL0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSC_OSCL0() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSC_OSCL1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSC_OSCL1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSC_OSCL2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSC_OSCL2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSC_OSCL3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSC_OSCL3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x80000) >> 19
}

// PWM.OSSUPD: PWM Output Selection Set Update Register
func (o *PWM_Type) SetOSSUPD_OSSUPH0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH0() uint32 {
	return volatile.LoadUint32(&o.OSSUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSSUPD_OSSUPH3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSSUPD_OSSUPL0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSSUPD_OSSUPL1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSSUPD_OSSUPL2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSSUPD_OSSUPL3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x80000) >> 19
}

// PWM.OSCUPD: PWM Output Selection Clear Update Register
func (o *PWM_Type) SetOSCUPD_OSCUPH0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH0() uint32 {
	return volatile.LoadUint32(&o.OSCUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSCUPD_OSCUPH3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSCUPD_OSCUPL0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSCUPD_OSCUPL1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSCUPD_OSCUPL2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSCUPD_OSCUPL3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x80000) >> 19
}

// PWM.FMR: PWM Fault Mode Register
func (o *PWM_Type) SetFMR_FPOL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFMR_FPOL() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0xff
}
func (o *PWM_Type) SetFMR_FMOD(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFMR_FMOD() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFMR_FFIL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFMR_FFIL() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff0000) >> 16
}

// PWM.FSR: PWM Fault Status Register
func (o *PWM_Type) SetFSR_FIV(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFSR_FIV() uint32 {
	return volatile.LoadUint32(&o.FSR.Reg) & 0xff
}
func (o *PWM_Type) SetFSR_FS(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFSR_FS() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0xff00) >> 8
}

// PWM.FCR: PWM Fault Clear Register
func (o *PWM_Type) SetFCR_FCLR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFCR_FCLR() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}

// PWM.FPV: PWM Fault Protection Value Register
func (o *PWM_Type) SetFPV_FPVH0(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetFPV_FPVH0() uint32 {
	return volatile.LoadUint32(&o.FPV.Reg) & 0x1
}
func (o *PWM_Type) SetFPV_FPVH1(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetFPV_FPVH1() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetFPV_FPVH2(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetFPV_FPVH2() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetFPV_FPVH3(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetFPV_FPVH3() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetFPV_FPVL0(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetFPV_FPVL0() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetFPV_FPVL1(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetFPV_FPVL1() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetFPV_FPVL2(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetFPV_FPVL2() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetFPV_FPVL3(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetFPV_FPVL3() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x80000) >> 19
}

// PWM.FPE: PWM Fault Protection Enable Register
func (o *PWM_Type) SetFPE_FPE0(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFPE_FPE0() uint32 {
	return volatile.LoadUint32(&o.FPE.Reg) & 0xff
}
func (o *PWM_Type) SetFPE_FPE1(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFPE_FPE1() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFPE_FPE2(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFPE_FPE2() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetFPE_FPE3(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff000000)|value<<24)
}
func (o *PWM_Type) GetFPE_FPE3() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff000000) >> 24
}

// PWM.ELMR: PWM Event Line 0 Mode Register
func (o *PWM_Type) SetELMR_CSEL0(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetELMR_CSEL0(idx int) uint32 {
	return volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x1
}
func (o *PWM_Type) SetELMR_CSEL1(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetELMR_CSEL1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetELMR_CSEL2(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetELMR_CSEL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetELMR_CSEL3(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetELMR_CSEL3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetELMR_CSEL4(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetELMR_CSEL4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetELMR_CSEL5(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetELMR_CSEL5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetELMR_CSEL6(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetELMR_CSEL6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetELMR_CSEL7(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetELMR_CSEL7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x80) >> 7
}

// PWM.SMMR: PWM Stepper Motor Mode Register
func (o *PWM_Type) SetSMMR_GCEN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSMMR_GCEN0() uint32 {
	return volatile.LoadUint32(&o.SMMR.Reg) & 0x1
}
func (o *PWM_Type) SetSMMR_GCEN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSMMR_GCEN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSMMR_DOWN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetSMMR_DOWN0() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetSMMR_DOWN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetSMMR_DOWN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x20000) >> 17
}

// PWM.WPCR: PWM Write Protect Control Register
func (o *PWM_Type) SetWPCR_WPCMD(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetWPCR_WPCMD() uint32 {
	return volatile.LoadUint32(&o.WPCR.Reg) & 0x3
}
func (o *PWM_Type) SetWPCR_WPRG0(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPCR_WPRG0() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPCR_WPRG1(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPCR_WPRG1() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPCR_WPRG2(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPCR_WPRG2() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPCR_WPRG3(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPCR_WPRG3() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPCR_WPRG4(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetWPCR_WPRG4() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetWPCR_WPRG5(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPCR_WPRG5() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPCR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PWM_Type) GetWPCR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0xffffff00) >> 8
}

// PWM.WPSR: PWM Write Protect Status Register
func (o *PWM_Type) SetWPSR_WPSWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetWPSR_WPSWS0() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PWM_Type) SetWPSR_WPSWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetWPSR_WPSWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetWPSR_WPSWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPSR_WPSWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPSR_WPSWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPSR_WPSWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPSR_WPSWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPSR_WPSWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPSR_WPSWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPSR_WPSWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPSR_WPVS() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPSR_WPHWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetWPSR_WPHWS0() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetWPSR_WPHWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetWPSR_WPHWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetWPSR_WPHWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetWPSR_WPHWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetWPSR_WPHWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetWPSR_WPHWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetWPSR_WPHWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetWPSR_WPHWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetWPSR_WPHWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetWPSR_WPHWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff0000) >> 16
}

// PWM.TPR: Transmit Pointer Register
func (o *PWM_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *PWM_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// PWM.TCR: Transmit Counter Register
func (o *PWM_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// PWM.TNPR: Transmit Next Pointer Register
func (o *PWM_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *PWM_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// PWM.TNCR: Transmit Next Counter Register
func (o *PWM_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// PWM.PTCR: Transfer Control Register
func (o *PWM_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *PWM_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// PWM.PTSR: Transfer Status Register
func (o *PWM_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *PWM_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// PWM.CMPV0: PWM Comparison 0 Value Register
func (o *PWM_Type) SetCMPV0_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV0.Reg, volatile.LoadUint32(&o.CMPV0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV0_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV0.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV0_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV0.Reg, volatile.LoadUint32(&o.CMPV0.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV0_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV0.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD0: PWM Comparison 0 Value Update Register
func (o *PWM_Type) SetCMPVUPD0_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD0.Reg, volatile.LoadUint32(&o.CMPVUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD0_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD0.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD0_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD0.Reg, volatile.LoadUint32(&o.CMPVUPD0.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD0_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD0.Reg) & 0x1000000) >> 24
}

// PWM.CMPM0: PWM Comparison 0 Mode Register
func (o *PWM_Type) SetCMPM0_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM0_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM0.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM0_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM0_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM0_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM0_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM0_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM0_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM0_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM0_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM0_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM0_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD0: PWM Comparison 0 Mode Update Register
func (o *PWM_Type) SetCMPMUPD0_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD0_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD0_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD0_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD0_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD0_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD0_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD0_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf0000) >> 16
}

// PWM.CMPV1: PWM Comparison 1 Value Register
func (o *PWM_Type) SetCMPV1_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV1.Reg, volatile.LoadUint32(&o.CMPV1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV1_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV1.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV1_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV1.Reg, volatile.LoadUint32(&o.CMPV1.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV1_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV1.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD1: PWM Comparison 1 Value Update Register
func (o *PWM_Type) SetCMPVUPD1_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD1.Reg, volatile.LoadUint32(&o.CMPVUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD1_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD1.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD1_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD1.Reg, volatile.LoadUint32(&o.CMPVUPD1.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD1_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD1.Reg) & 0x1000000) >> 24
}

// PWM.CMPM1: PWM Comparison 1 Mode Register
func (o *PWM_Type) SetCMPM1_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM1_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM1.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM1_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM1_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM1_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM1_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM1_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM1_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM1_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM1_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM1_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM1_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD1: PWM Comparison 1 Mode Update Register
func (o *PWM_Type) SetCMPMUPD1_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD1_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD1_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD1_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD1_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD1_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD1_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD1_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf0000) >> 16
}

// PWM.CMPV2: PWM Comparison 2 Value Register
func (o *PWM_Type) SetCMPV2_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV2.Reg, volatile.LoadUint32(&o.CMPV2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV2_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV2.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV2_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV2.Reg, volatile.LoadUint32(&o.CMPV2.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV2_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV2.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD2: PWM Comparison 2 Value Update Register
func (o *PWM_Type) SetCMPVUPD2_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD2.Reg, volatile.LoadUint32(&o.CMPVUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD2_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD2.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD2_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD2.Reg, volatile.LoadUint32(&o.CMPVUPD2.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD2_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD2.Reg) & 0x1000000) >> 24
}

// PWM.CMPM2: PWM Comparison 2 Mode Register
func (o *PWM_Type) SetCMPM2_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM2_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM2.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM2_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM2_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM2_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM2_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM2_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM2_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM2_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM2_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM2_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM2_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD2: PWM Comparison 2 Mode Update Register
func (o *PWM_Type) SetCMPMUPD2_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD2_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD2_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD2_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD2_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD2_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD2_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD2_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf0000) >> 16
}

// PWM.CMPV3: PWM Comparison 3 Value Register
func (o *PWM_Type) SetCMPV3_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV3.Reg, volatile.LoadUint32(&o.CMPV3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV3_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV3.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV3_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV3.Reg, volatile.LoadUint32(&o.CMPV3.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV3_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV3.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD3: PWM Comparison 3 Value Update Register
func (o *PWM_Type) SetCMPVUPD3_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD3.Reg, volatile.LoadUint32(&o.CMPVUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD3_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD3.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD3_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD3.Reg, volatile.LoadUint32(&o.CMPVUPD3.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD3_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD3.Reg) & 0x1000000) >> 24
}

// PWM.CMPM3: PWM Comparison 3 Mode Register
func (o *PWM_Type) SetCMPM3_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM3_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM3.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM3_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM3_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM3_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM3_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM3_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM3_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM3_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM3_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM3_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM3_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD3: PWM Comparison 3 Mode Update Register
func (o *PWM_Type) SetCMPMUPD3_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD3_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD3_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD3_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD3_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD3_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD3_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD3_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf0000) >> 16
}

// PWM.CMPV4: PWM Comparison 4 Value Register
func (o *PWM_Type) SetCMPV4_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV4.Reg, volatile.LoadUint32(&o.CMPV4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV4_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV4.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV4_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV4.Reg, volatile.LoadUint32(&o.CMPV4.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV4_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV4.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD4: PWM Comparison 4 Value Update Register
func (o *PWM_Type) SetCMPVUPD4_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD4.Reg, volatile.LoadUint32(&o.CMPVUPD4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD4_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD4.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD4_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD4.Reg, volatile.LoadUint32(&o.CMPVUPD4.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD4_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD4.Reg) & 0x1000000) >> 24
}

// PWM.CMPM4: PWM Comparison 4 Mode Register
func (o *PWM_Type) SetCMPM4_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM4_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM4.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM4_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM4_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM4_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM4_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM4_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM4_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM4_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM4_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM4_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM4_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD4: PWM Comparison 4 Mode Update Register
func (o *PWM_Type) SetCMPMUPD4_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD4_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD4_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD4_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD4_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD4_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD4_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD4_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf0000) >> 16
}

// PWM.CMPV5: PWM Comparison 5 Value Register
func (o *PWM_Type) SetCMPV5_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV5.Reg, volatile.LoadUint32(&o.CMPV5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV5_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV5.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV5_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV5.Reg, volatile.LoadUint32(&o.CMPV5.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV5_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV5.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD5: PWM Comparison 5 Value Update Register
func (o *PWM_Type) SetCMPVUPD5_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD5.Reg, volatile.LoadUint32(&o.CMPVUPD5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD5_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD5.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD5_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD5.Reg, volatile.LoadUint32(&o.CMPVUPD5.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD5_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD5.Reg) & 0x1000000) >> 24
}

// PWM.CMPM5: PWM Comparison 5 Mode Register
func (o *PWM_Type) SetCMPM5_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM5_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM5.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM5_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM5_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM5_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM5_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM5_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM5_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM5_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM5_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM5_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM5_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD5: PWM Comparison 5 Mode Update Register
func (o *PWM_Type) SetCMPMUPD5_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD5_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD5_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD5_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD5_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD5_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD5_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD5_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf0000) >> 16
}

// PWM.CMPV6: PWM Comparison 6 Value Register
func (o *PWM_Type) SetCMPV6_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV6.Reg, volatile.LoadUint32(&o.CMPV6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV6_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV6.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV6_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV6.Reg, volatile.LoadUint32(&o.CMPV6.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV6_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV6.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD6: PWM Comparison 6 Value Update Register
func (o *PWM_Type) SetCMPVUPD6_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD6.Reg, volatile.LoadUint32(&o.CMPVUPD6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD6_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD6.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD6_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD6.Reg, volatile.LoadUint32(&o.CMPVUPD6.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD6_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD6.Reg) & 0x1000000) >> 24
}

// PWM.CMPM6: PWM Comparison 6 Mode Register
func (o *PWM_Type) SetCMPM6_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM6_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM6.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM6_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM6_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM6_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM6_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM6_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM6_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM6_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM6_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM6_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM6_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD6: PWM Comparison 6 Mode Update Register
func (o *PWM_Type) SetCMPMUPD6_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD6_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD6_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD6_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD6_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD6_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD6_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD6_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf0000) >> 16
}

// PWM.CMPV7: PWM Comparison 7 Value Register
func (o *PWM_Type) SetCMPV7_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV7.Reg, volatile.LoadUint32(&o.CMPV7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV7_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV7.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV7_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV7.Reg, volatile.LoadUint32(&o.CMPV7.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV7_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV7.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD7: PWM Comparison 7 Value Update Register
func (o *PWM_Type) SetCMPVUPD7_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD7.Reg, volatile.LoadUint32(&o.CMPVUPD7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD7_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD7.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD7_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD7.Reg, volatile.LoadUint32(&o.CMPVUPD7.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD7_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD7.Reg) & 0x1000000) >> 24
}

// PWM.CMPM7: PWM Comparison 7 Mode Register
func (o *PWM_Type) SetCMPM7_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM7_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM7.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM7_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM7_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM7_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM7_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM7_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM7_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM7_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM7_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM7_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM7_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD7: PWM Comparison 7 Mode Update Register
func (o *PWM_Type) SetCMPMUPD7_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD7_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD7_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD7_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD7_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD7_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD7_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD7_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf0000) >> 16
}

// PWM.CMR0: PWM Channel Mode Register (ch_num = 0)
func (o *PWM_Type) SetCMR0_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR0_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0xf
}
func (o *PWM_Type) SetCMR0_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR0_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR0_CES(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR0_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR0_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR0_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR0_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR0_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR0_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR0_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40000) >> 18
}

// PWM.CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
func (o *PWM_Type) SetCDTY0_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY0.Reg, volatile.LoadUint32(&o.CDTY0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY0_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY0.Reg) & 0xffffff
}

// PWM.CDTYUPD0: PWM Channel Duty Cycle Update Register (ch_num = 0)
func (o *PWM_Type) SetCDTYUPD0_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD0.Reg, volatile.LoadUint32(&o.CDTYUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD0_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD0.Reg) & 0xffffff
}

// PWM.CPRD0: PWM Channel Period Register (ch_num = 0)
func (o *PWM_Type) SetCPRD0_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD0.Reg, volatile.LoadUint32(&o.CPRD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD0_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD0.Reg) & 0xffffff
}

// PWM.CPRDUPD0: PWM Channel Period Update Register (ch_num = 0)
func (o *PWM_Type) SetCPRDUPD0_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD0.Reg, volatile.LoadUint32(&o.CPRDUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD0_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD0.Reg) & 0xffffff
}

// PWM.CCNT0: PWM Channel Counter Register (ch_num = 0)
func (o *PWM_Type) SetCCNT0_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT0.Reg, volatile.LoadUint32(&o.CCNT0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT0_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT0.Reg) & 0xffffff
}

// PWM.DT0: PWM Channel Dead Time Register (ch_num = 0)
func (o *PWM_Type) SetDT0_DTH(value uint32) {
	volatile.StoreUint32(&o.DT0.Reg, volatile.LoadUint32(&o.DT0.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT0_DTH() uint32 {
	return volatile.LoadUint32(&o.DT0.Reg) & 0xffff
}
func (o *PWM_Type) SetDT0_DTL(value uint32) {
	volatile.StoreUint32(&o.DT0.Reg, volatile.LoadUint32(&o.DT0.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT0_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT0.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD0: PWM Channel Dead Time Update Register (ch_num = 0)
func (o *PWM_Type) SetDTUPD0_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD0.Reg, volatile.LoadUint32(&o.DTUPD0.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD0_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD0.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD0_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD0.Reg, volatile.LoadUint32(&o.DTUPD0.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD0_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD0.Reg) & 0xffff0000) >> 16
}

// PWM.CMR1: PWM Channel Mode Register (ch_num = 1)
func (o *PWM_Type) SetCMR1_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR1_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0xf
}
func (o *PWM_Type) SetCMR1_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR1_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR1_CES(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR1_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR1_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR1_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR1_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR1_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR1_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR1_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40000) >> 18
}

// PWM.CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
func (o *PWM_Type) SetCDTY1_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY1.Reg, volatile.LoadUint32(&o.CDTY1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY1_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY1.Reg) & 0xffffff
}

// PWM.CDTYUPD1: PWM Channel Duty Cycle Update Register (ch_num = 1)
func (o *PWM_Type) SetCDTYUPD1_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD1.Reg, volatile.LoadUint32(&o.CDTYUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD1_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD1.Reg) & 0xffffff
}

// PWM.CPRD1: PWM Channel Period Register (ch_num = 1)
func (o *PWM_Type) SetCPRD1_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD1.Reg, volatile.LoadUint32(&o.CPRD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD1_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD1.Reg) & 0xffffff
}

// PWM.CPRDUPD1: PWM Channel Period Update Register (ch_num = 1)
func (o *PWM_Type) SetCPRDUPD1_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD1.Reg, volatile.LoadUint32(&o.CPRDUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD1_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD1.Reg) & 0xffffff
}

// PWM.CCNT1: PWM Channel Counter Register (ch_num = 1)
func (o *PWM_Type) SetCCNT1_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT1.Reg, volatile.LoadUint32(&o.CCNT1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT1_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT1.Reg) & 0xffffff
}

// PWM.DT1: PWM Channel Dead Time Register (ch_num = 1)
func (o *PWM_Type) SetDT1_DTH(value uint32) {
	volatile.StoreUint32(&o.DT1.Reg, volatile.LoadUint32(&o.DT1.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT1_DTH() uint32 {
	return volatile.LoadUint32(&o.DT1.Reg) & 0xffff
}
func (o *PWM_Type) SetDT1_DTL(value uint32) {
	volatile.StoreUint32(&o.DT1.Reg, volatile.LoadUint32(&o.DT1.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT1_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT1.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD1: PWM Channel Dead Time Update Register (ch_num = 1)
func (o *PWM_Type) SetDTUPD1_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD1.Reg, volatile.LoadUint32(&o.DTUPD1.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD1_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD1.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD1_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD1.Reg, volatile.LoadUint32(&o.DTUPD1.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD1_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD1.Reg) & 0xffff0000) >> 16
}

// PWM.CMR2: PWM Channel Mode Register (ch_num = 2)
func (o *PWM_Type) SetCMR2_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR2_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0xf
}
func (o *PWM_Type) SetCMR2_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR2_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR2_CES(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR2_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR2_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR2_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR2_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR2_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR2_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR2_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40000) >> 18
}

// PWM.CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
func (o *PWM_Type) SetCDTY2_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY2.Reg, volatile.LoadUint32(&o.CDTY2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY2_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY2.Reg) & 0xffffff
}

// PWM.CDTYUPD2: PWM Channel Duty Cycle Update Register (ch_num = 2)
func (o *PWM_Type) SetCDTYUPD2_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD2.Reg, volatile.LoadUint32(&o.CDTYUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD2_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD2.Reg) & 0xffffff
}

// PWM.CPRD2: PWM Channel Period Register (ch_num = 2)
func (o *PWM_Type) SetCPRD2_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD2.Reg, volatile.LoadUint32(&o.CPRD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD2_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD2.Reg) & 0xffffff
}

// PWM.CPRDUPD2: PWM Channel Period Update Register (ch_num = 2)
func (o *PWM_Type) SetCPRDUPD2_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD2.Reg, volatile.LoadUint32(&o.CPRDUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD2_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD2.Reg) & 0xffffff
}

// PWM.CCNT2: PWM Channel Counter Register (ch_num = 2)
func (o *PWM_Type) SetCCNT2_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT2.Reg, volatile.LoadUint32(&o.CCNT2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT2_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT2.Reg) & 0xffffff
}

// PWM.DT2: PWM Channel Dead Time Register (ch_num = 2)
func (o *PWM_Type) SetDT2_DTH(value uint32) {
	volatile.StoreUint32(&o.DT2.Reg, volatile.LoadUint32(&o.DT2.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT2_DTH() uint32 {
	return volatile.LoadUint32(&o.DT2.Reg) & 0xffff
}
func (o *PWM_Type) SetDT2_DTL(value uint32) {
	volatile.StoreUint32(&o.DT2.Reg, volatile.LoadUint32(&o.DT2.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT2_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT2.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD2: PWM Channel Dead Time Update Register (ch_num = 2)
func (o *PWM_Type) SetDTUPD2_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD2.Reg, volatile.LoadUint32(&o.DTUPD2.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD2_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD2.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD2_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD2.Reg, volatile.LoadUint32(&o.DTUPD2.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD2_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD2.Reg) & 0xffff0000) >> 16
}

// PWM.CMR3: PWM Channel Mode Register (ch_num = 3)
func (o *PWM_Type) SetCMR3_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR3_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR3.Reg) & 0xf
}
func (o *PWM_Type) SetCMR3_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR3_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR3_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR3_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR3_CES(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR3_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR3_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR3_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR3_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR3_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR3_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR3_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x40000) >> 18
}

// PWM.CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
func (o *PWM_Type) SetCDTY3_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY3.Reg, volatile.LoadUint32(&o.CDTY3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY3_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY3.Reg) & 0xffffff
}

// PWM.CDTYUPD3: PWM Channel Duty Cycle Update Register (ch_num = 3)
func (o *PWM_Type) SetCDTYUPD3_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD3.Reg, volatile.LoadUint32(&o.CDTYUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD3_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD3.Reg) & 0xffffff
}

// PWM.CPRD3: PWM Channel Period Register (ch_num = 3)
func (o *PWM_Type) SetCPRD3_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD3.Reg, volatile.LoadUint32(&o.CPRD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD3_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD3.Reg) & 0xffffff
}

// PWM.CPRDUPD3: PWM Channel Period Update Register (ch_num = 3)
func (o *PWM_Type) SetCPRDUPD3_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD3.Reg, volatile.LoadUint32(&o.CPRDUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD3_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD3.Reg) & 0xffffff
}

// PWM.CCNT3: PWM Channel Counter Register (ch_num = 3)
func (o *PWM_Type) SetCCNT3_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT3.Reg, volatile.LoadUint32(&o.CCNT3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT3_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT3.Reg) & 0xffffff
}

// PWM.DT3: PWM Channel Dead Time Register (ch_num = 3)
func (o *PWM_Type) SetDT3_DTH(value uint32) {
	volatile.StoreUint32(&o.DT3.Reg, volatile.LoadUint32(&o.DT3.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT3_DTH() uint32 {
	return volatile.LoadUint32(&o.DT3.Reg) & 0xffff
}
func (o *PWM_Type) SetDT3_DTL(value uint32) {
	volatile.StoreUint32(&o.DT3.Reg, volatile.LoadUint32(&o.DT3.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT3_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT3.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD3: PWM Channel Dead Time Update Register (ch_num = 3)
func (o *PWM_Type) SetDTUPD3_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD3.Reg, volatile.LoadUint32(&o.DTUPD3.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD3_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD3.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD3_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD3.Reg, volatile.LoadUint32(&o.DTUPD3.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD3_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD3.Reg) & 0xffff0000) >> 16
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	MAN  volatile.Register32 // 0x50
	_    [144]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// USART.CR: Control Register
func (o *USART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR_STTBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR_STTBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR_STPBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR_STPBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR_STTTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR_STTTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR_SENDA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR_SENDA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR_RSTIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR_RSTIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR_RSTNACK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR_RSTNACK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR_RETTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR_RETTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR_DTREN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR_DTREN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR_DTRDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR_DTRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR_RTSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR_RTSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}

// USART.MR: Mode Register
func (o *USART_Type) SetMR_USART_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMR_USART_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xf
}
func (o *USART_Type) SetMR_USCLKS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetMR_USCLKS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetMR_CHRL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetMR_CHRL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetMR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetMR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *USART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *USART_Type) SetMR_NBSTOP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetMR_NBSTOP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *USART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}
func (o *USART_Type) SetMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetMR_MODE9(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetMR_MODE9() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetMR_CLKO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetMR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetMR_OVER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetMR_OVER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetMR_INACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetMR_INACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetMR_DSNACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetMR_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetMR_VAR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetMR_VAR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetMR_INVDATA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetMR_INVDATA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetMR_MAX_ITERATION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *USART_Type) GetMR_MAX_ITERATION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *USART_Type) SetMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMR_MAN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMR_MAN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMR_MODSYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMR_MODSYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetMR_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetMR_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// USART.IER: Interrupt Enable Register
func (o *USART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *USART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIER_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIER_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIER_ITER(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIER_ITER() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIER_RIIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetIER_RIIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetIER_DSRIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetIER_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetIER_DCDIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetIER_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetIER_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIER_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIER_MANE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIER_MANE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}

// USART.IDR: Interrupt Disable Register
func (o *USART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *USART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIDR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIDR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIDR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIDR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIDR_ITER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIDR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIDR_RIIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetIDR_RIIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetIDR_DSRIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetIDR_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetIDR_DCDIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetIDR_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetIDR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIDR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIDR_MANE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIDR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}

// USART.IMR: Interrupt Mask Register
func (o *USART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *USART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIMR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIMR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIMR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIMR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIMR_ITER(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIMR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIMR_RIIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetIMR_RIIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetIMR_DSRIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetIMR_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetIMR_DCDIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetIMR_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetIMR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIMR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIMR_MANE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIMR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}

// USART.CSR: Channel Status Register
func (o *USART_Type) SetCSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *USART_Type) SetCSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCSR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCSR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCSR_PARE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCSR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCSR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCSR_ITER(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCSR_ITER() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCSR_NACK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCSR_RIIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCSR_RIIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCSR_DSRIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCSR_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCSR_DCDIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCSR_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCSR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCSR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCSR_RI(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCSR_RI() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCSR_DSR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetCSR_DSR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetCSR_DCD(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCSR_DCD() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCSR_CTS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCSR_MANERR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCSR_MANERR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}

// USART.RHR: Receiver Holding Register
func (o *USART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0x1ff
}
func (o *USART_Type) SetRHR_RXSYNH(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetRHR_RXSYNH() uint32 {
	return (volatile.LoadUint32(&o.RHR.Reg) & 0x8000) >> 15
}

// USART.THR: Transmitter Holding Register
func (o *USART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0x1ff
}
func (o *USART_Type) SetTHR_TXSYNH(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetTHR_TXSYNH() uint32 {
	return (volatile.LoadUint32(&o.THR.Reg) & 0x8000) >> 15
}

// USART.BRGR: Baud Rate Generator Register
func (o *USART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}
func (o *USART_Type) SetBRGR_FP(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetBRGR_FP() uint32 {
	return (volatile.LoadUint32(&o.BRGR.Reg) & 0x70000) >> 16
}

// USART.RTOR: Receiver Time-out Register
func (o *USART_Type) SetRTOR_TO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRTOR_TO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffff
}

// USART.TTGR: Transmitter Timeguard Register
func (o *USART_Type) SetTTGR_TG(value uint32) {
	volatile.StoreUint32(&o.TTGR.Reg, volatile.LoadUint32(&o.TTGR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetTTGR_TG() uint32 {
	return volatile.LoadUint32(&o.TTGR.Reg) & 0xff
}

// USART.FIDI: FI DI Ratio Register
func (o *USART_Type) SetFIDI_FI_DI_RATIO(value uint32) {
	volatile.StoreUint32(&o.FIDI.Reg, volatile.LoadUint32(&o.FIDI.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetFIDI_FI_DI_RATIO() uint32 {
	return volatile.LoadUint32(&o.FIDI.Reg) & 0xffff
}

// USART.NER: Number of Errors Register
func (o *USART_Type) SetNER_NB_ERRORS(value uint32) {
	volatile.StoreUint32(&o.NER.Reg, volatile.LoadUint32(&o.NER.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetNER_NB_ERRORS() uint32 {
	return volatile.LoadUint32(&o.NER.Reg) & 0xff
}

// USART.IF: IrDA Filter Register
func (o *USART_Type) SetIF_IRDA_FILTER(value uint32) {
	volatile.StoreUint32(&o.IF.Reg, volatile.LoadUint32(&o.IF.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetIF_IRDA_FILTER() uint32 {
	return volatile.LoadUint32(&o.IF.Reg) & 0xff
}

// USART.MAN: Manchester Encoder Decoder Register
func (o *USART_Type) SetMAN_TX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMAN_TX_PL() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xf
}
func (o *USART_Type) SetMAN_TX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x300)|value<<8)
}
func (o *USART_Type) GetMAN_TX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x300) >> 8
}
func (o *USART_Type) SetMAN_TX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetMAN_TX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetMAN_RX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf0000)|value<<16)
}
func (o *USART_Type) GetMAN_RX_PL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf0000) >> 16
}
func (o *USART_Type) SetMAN_RX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x3000000)|value<<24)
}
func (o *USART_Type) GetMAN_RX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x3000000) >> 24
}
func (o *USART_Type) SetMAN_RX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMAN_RX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMAN_ONE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMAN_ONE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMAN_DRIFT(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMAN_DRIFT() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x40000000) >> 30
}

// USART.WPMR: Write Protect Mode Register
func (o *USART_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *USART_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// USART.WPSR: Write Protect Status Register
func (o *USART_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *USART_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *USART_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// USART.RPR: Receive Pointer Register
func (o *USART_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *USART_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// USART.RCR: Receive Counter Register
func (o *USART_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// USART.TPR: Transmit Pointer Register
func (o *USART_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *USART_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// USART.TCR: Transmit Counter Register
func (o *USART_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// USART.RNPR: Receive Next Pointer Register
func (o *USART_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *USART_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// USART.RNCR: Receive Next Counter Register
func (o *USART_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// USART.TNPR: Transmit Next Pointer Register
func (o *USART_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *USART_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// USART.TNCR: Transmit Next Counter Register
func (o *USART_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// USART.PTCR: Transfer Control Register
func (o *USART_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *USART_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// USART.PTSR: Transfer Status Register
func (o *USART_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *USART_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// USB High Speed Device Port
type UDPHS_Type struct {
	CTRL        volatile.Register32 // 0x0
	FNUM        volatile.Register32 // 0x4
	_           [8]byte
	IEN         volatile.Register32 // 0x10
	INTSTA      volatile.Register32 // 0x14
	CLRINT      volatile.Register32 // 0x18
	EPTRST      volatile.Register32 // 0x1C
	_           [192]byte
	TST         volatile.Register32 // 0xE0
	_           [28]byte
	EPTCFG0     volatile.Register32 // 0x100
	EPTCTLENB0  volatile.Register32 // 0x104
	EPTCTLDIS0  volatile.Register32 // 0x108
	EPTCTL0     volatile.Register32 // 0x10C
	_           [4]byte
	EPTSETSTA0  volatile.Register32 // 0x114
	EPTCLRSTA0  volatile.Register32 // 0x118
	EPTSTA0     volatile.Register32 // 0x11C
	EPTCFG1     volatile.Register32 // 0x120
	EPTCTLENB1  volatile.Register32 // 0x124
	EPTCTLDIS1  volatile.Register32 // 0x128
	EPTCTL1     volatile.Register32 // 0x12C
	_           [4]byte
	EPTSETSTA1  volatile.Register32 // 0x134
	EPTCLRSTA1  volatile.Register32 // 0x138
	EPTSTA1     volatile.Register32 // 0x13C
	EPTCFG2     volatile.Register32 // 0x140
	EPTCTLENB2  volatile.Register32 // 0x144
	EPTCTLDIS2  volatile.Register32 // 0x148
	EPTCTL2     volatile.Register32 // 0x14C
	_           [4]byte
	EPTSETSTA2  volatile.Register32 // 0x154
	EPTCLRSTA2  volatile.Register32 // 0x158
	EPTSTA2     volatile.Register32 // 0x15C
	EPTCFG3     volatile.Register32 // 0x160
	EPTCTLENB3  volatile.Register32 // 0x164
	EPTCTLDIS3  volatile.Register32 // 0x168
	EPTCTL3     volatile.Register32 // 0x16C
	_           [4]byte
	EPTSETSTA3  volatile.Register32 // 0x174
	EPTCLRSTA3  volatile.Register32 // 0x178
	EPTSTA3     volatile.Register32 // 0x17C
	EPTCFG4     volatile.Register32 // 0x180
	EPTCTLENB4  volatile.Register32 // 0x184
	EPTCTLDIS4  volatile.Register32 // 0x188
	EPTCTL4     volatile.Register32 // 0x18C
	_           [4]byte
	EPTSETSTA4  volatile.Register32 // 0x194
	EPTCLRSTA4  volatile.Register32 // 0x198
	EPTSTA4     volatile.Register32 // 0x19C
	EPTCFG5     volatile.Register32 // 0x1A0
	EPTCTLENB5  volatile.Register32 // 0x1A4
	EPTCTLDIS5  volatile.Register32 // 0x1A8
	EPTCTL5     volatile.Register32 // 0x1AC
	_           [4]byte
	EPTSETSTA5  volatile.Register32 // 0x1B4
	EPTCLRSTA5  volatile.Register32 // 0x1B8
	EPTSTA5     volatile.Register32 // 0x1BC
	EPTCFG6     volatile.Register32 // 0x1C0
	EPTCTLENB6  volatile.Register32 // 0x1C4
	EPTCTLDIS6  volatile.Register32 // 0x1C8
	EPTCTL6     volatile.Register32 // 0x1CC
	_           [4]byte
	EPTSETSTA6  volatile.Register32 // 0x1D4
	EPTCLRSTA6  volatile.Register32 // 0x1D8
	EPTSTA6     volatile.Register32 // 0x1DC
	_           [288]byte
	DMANXTDSC0  volatile.Register32 // 0x300
	DMAADDRESS0 volatile.Register32 // 0x304
	DMACONTROL0 volatile.Register32 // 0x308
	DMASTATUS0  volatile.Register32 // 0x30C
	DMANXTDSC1  volatile.Register32 // 0x310
	DMAADDRESS1 volatile.Register32 // 0x314
	DMACONTROL1 volatile.Register32 // 0x318
	DMASTATUS1  volatile.Register32 // 0x31C
	DMANXTDSC2  volatile.Register32 // 0x320
	DMAADDRESS2 volatile.Register32 // 0x324
	DMACONTROL2 volatile.Register32 // 0x328
	DMASTATUS2  volatile.Register32 // 0x32C
	DMANXTDSC3  volatile.Register32 // 0x330
	DMAADDRESS3 volatile.Register32 // 0x334
	DMACONTROL3 volatile.Register32 // 0x338
	DMASTATUS3  volatile.Register32 // 0x33C
	DMANXTDSC4  volatile.Register32 // 0x340
	DMAADDRESS4 volatile.Register32 // 0x344
	DMACONTROL4 volatile.Register32 // 0x348
	DMASTATUS4  volatile.Register32 // 0x34C
	DMANXTDSC5  volatile.Register32 // 0x350
	DMAADDRESS5 volatile.Register32 // 0x354
	DMACONTROL5 volatile.Register32 // 0x358
	DMASTATUS5  volatile.Register32 // 0x35C
}

// UDPHS.CTRL: UDPHS Control Register
func (o *UDPHS_Type) SetCTRL_DEV_ADDR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7f)|value)
}
func (o *UDPHS_Type) GetCTRL_DEV_ADDR() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x7f
}
func (o *UDPHS_Type) SetCTRL_FADDR_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetCTRL_FADDR_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetCTRL_EN_UDPHS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetCTRL_EN_UDPHS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetCTRL_DETACH(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetCTRL_DETACH() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetCTRL_REWAKEUP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetCTRL_REWAKEUP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetCTRL_PULLD_DIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetCTRL_PULLD_DIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800) >> 11
}

// UDPHS.FNUM: UDPHS Frame Number Register
func (o *UDPHS_Type) SetFNUM_MICRO_FRAME_NUM(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetFNUM_MICRO_FRAME_NUM() uint32 {
	return volatile.LoadUint32(&o.FNUM.Reg) & 0x7
}
func (o *UDPHS_Type) SetFNUM_FRAME_NUMBER(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x3ff8)|value<<3)
}
func (o *UDPHS_Type) GetFNUM_FRAME_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.FNUM.Reg) & 0x3ff8) >> 3
}
func (o *UDPHS_Type) SetFNUM_FNUM_ERR(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetFNUM_FNUM_ERR() uint32 {
	return (volatile.LoadUint32(&o.FNUM.Reg) & 0x80000000) >> 31
}

// UDPHS.IEN: UDPHS Interrupt Enable Register
func (o *UDPHS_Type) SetIEN_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetIEN_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetIEN_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetIEN_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetIEN_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetIEN_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetIEN_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetIEN_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetIEN_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetIEN_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetIEN_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetIEN_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetIEN_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetIEN_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetIEN_EPT_0(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetIEN_EPT_0() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetIEN_EPT_1(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetIEN_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetIEN_EPT_2(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetIEN_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetIEN_EPT_3(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetIEN_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetIEN_EPT_4(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetIEN_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetIEN_EPT_5(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetIEN_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetIEN_EPT_6(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetIEN_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetIEN_DMA_1(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2000000)|value<<25)
}
func (o *UDPHS_Type) GetIEN_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2000000) >> 25
}
func (o *UDPHS_Type) SetIEN_DMA_2(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4000000)|value<<26)
}
func (o *UDPHS_Type) GetIEN_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4000000) >> 26
}
func (o *UDPHS_Type) SetIEN_DMA_3(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x8000000)|value<<27)
}
func (o *UDPHS_Type) GetIEN_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x8000000) >> 27
}
func (o *UDPHS_Type) SetIEN_DMA_4(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x10000000)|value<<28)
}
func (o *UDPHS_Type) GetIEN_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x10000000) >> 28
}
func (o *UDPHS_Type) SetIEN_DMA_5(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x20000000)|value<<29)
}
func (o *UDPHS_Type) GetIEN_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x20000000) >> 29
}
func (o *UDPHS_Type) SetIEN_DMA_6(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x40000000)|value<<30)
}
func (o *UDPHS_Type) GetIEN_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x40000000) >> 30
}

// UDPHS.INTSTA: UDPHS Interrupt Status Register
func (o *UDPHS_Type) SetINTSTA_SPEED(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetINTSTA_SPEED() uint32 {
	return volatile.LoadUint32(&o.INTSTA.Reg) & 0x1
}
func (o *UDPHS_Type) SetINTSTA_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetINTSTA_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetINTSTA_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetINTSTA_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetINTSTA_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetINTSTA_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetINTSTA_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetINTSTA_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetINTSTA_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetINTSTA_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetINTSTA_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetINTSTA_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetINTSTA_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetINTSTA_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetINTSTA_EPT_0(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetINTSTA_EPT_0() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetINTSTA_EPT_1(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetINTSTA_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetINTSTA_EPT_2(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetINTSTA_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetINTSTA_EPT_3(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetINTSTA_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetINTSTA_EPT_4(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetINTSTA_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetINTSTA_EPT_5(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetINTSTA_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetINTSTA_EPT_6(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetINTSTA_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetINTSTA_DMA_1(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2000000)|value<<25)
}
func (o *UDPHS_Type) GetINTSTA_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2000000) >> 25
}
func (o *UDPHS_Type) SetINTSTA_DMA_2(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4000000)|value<<26)
}
func (o *UDPHS_Type) GetINTSTA_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4000000) >> 26
}
func (o *UDPHS_Type) SetINTSTA_DMA_3(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x8000000)|value<<27)
}
func (o *UDPHS_Type) GetINTSTA_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x8000000) >> 27
}
func (o *UDPHS_Type) SetINTSTA_DMA_4(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x10000000)|value<<28)
}
func (o *UDPHS_Type) GetINTSTA_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x10000000) >> 28
}
func (o *UDPHS_Type) SetINTSTA_DMA_5(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x20000000)|value<<29)
}
func (o *UDPHS_Type) GetINTSTA_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x20000000) >> 29
}
func (o *UDPHS_Type) SetINTSTA_DMA_6(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x40000000)|value<<30)
}
func (o *UDPHS_Type) GetINTSTA_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x40000000) >> 30
}

// UDPHS.CLRINT: UDPHS Clear Interrupt Register
func (o *UDPHS_Type) SetCLRINT_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetCLRINT_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetCLRINT_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetCLRINT_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetCLRINT_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetCLRINT_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetCLRINT_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetCLRINT_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetCLRINT_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetCLRINT_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetCLRINT_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetCLRINT_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetCLRINT_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetCLRINT_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x80) >> 7
}

// UDPHS.EPTRST: UDPHS Endpoints Reset Register
func (o *UDPHS_Type) SetEPTRST_EPT_0(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTRST_EPT_0() uint32 {
	return volatile.LoadUint32(&o.EPTRST.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTRST_EPT_1(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTRST_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTRST_EPT_2(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetEPTRST_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetEPTRST_EPT_3(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTRST_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTRST_EPT_4(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTRST_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTRST_EPT_5(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTRST_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTRST_EPT_6(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTRST_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x40) >> 6
}

// UDPHS.TST: UDPHS Test Register
func (o *UDPHS_Type) SetTST_SPEED_CFG(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x3)|value)
}
func (o *UDPHS_Type) GetTST_SPEED_CFG() uint32 {
	return volatile.LoadUint32(&o.TST.Reg) & 0x3
}
func (o *UDPHS_Type) SetTST_TST_J(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetTST_TST_J() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetTST_TST_K(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetTST_TST_K() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetTST_TST_PKT(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetTST_TST_PKT() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetTST_OPMODE2(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetTST_OPMODE2() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x20) >> 5
}

// UDPHS.EPTCFG0: UDPHS Endpoint Configuration Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCFG0_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG0_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG0_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG0_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG0_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB0: UDPHS Endpoint Control Enable Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTLENB0_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB0_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS0: UDPHS Endpoint Control Disable Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTLDIS0_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL0: UDPHS Endpoint Control Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTL0_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL0_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA0: UDPHS Endpoint Set Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTSETSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA0: UDPHS Endpoint Clear Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCLRSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA0_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA0: UDPHS Endpoint Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA0_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA0_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA0_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA0_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA0_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA0_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA0_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA0_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG1: UDPHS Endpoint Configuration Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCFG1_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG1_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG1_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG1_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG1_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB1: UDPHS Endpoint Control Enable Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTLENB1_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB1_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS1: UDPHS Endpoint Control Disable Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTLDIS1_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL1: UDPHS Endpoint Control Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTL1_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL1_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA1: UDPHS Endpoint Set Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTSETSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA1: UDPHS Endpoint Clear Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCLRSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA1_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA1: UDPHS Endpoint Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA1_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA1_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA1_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA1_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA1_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA1_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA1_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA1_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG2: UDPHS Endpoint Configuration Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCFG2_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG2_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG2_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG2_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG2_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB2: UDPHS Endpoint Control Enable Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTLENB2_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB2_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS2: UDPHS Endpoint Control Disable Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTLDIS2_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL2: UDPHS Endpoint Control Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTL2_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL2_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA2: UDPHS Endpoint Set Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTSETSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA2: UDPHS Endpoint Clear Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCLRSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA2_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA2: UDPHS Endpoint Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA2_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA2_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA2_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA2_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA2_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA2_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA2_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA2_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG3: UDPHS Endpoint Configuration Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCFG3_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG3_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG3_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG3_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG3_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB3: UDPHS Endpoint Control Enable Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTLENB3_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB3_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS3: UDPHS Endpoint Control Disable Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTLDIS3_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL3: UDPHS Endpoint Control Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTL3_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL3_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA3: UDPHS Endpoint Set Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTSETSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA3: UDPHS Endpoint Clear Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCLRSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA3_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA3: UDPHS Endpoint Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA3_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA3_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA3_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA3_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA3_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA3_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA3_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA3_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG4: UDPHS Endpoint Configuration Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCFG4_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG4_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG4_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG4_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG4_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB4: UDPHS Endpoint Control Enable Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTLENB4_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB4_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS4: UDPHS Endpoint Control Disable Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTLDIS4_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL4: UDPHS Endpoint Control Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTL4_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL4_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA4: UDPHS Endpoint Set Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTSETSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA4: UDPHS Endpoint Clear Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCLRSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA4_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA4: UDPHS Endpoint Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA4_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA4_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA4_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA4_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA4_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA4_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA4_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA4_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG5: UDPHS Endpoint Configuration Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCFG5_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG5_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG5_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG5_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG5_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB5: UDPHS Endpoint Control Enable Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTLENB5_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB5_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS5: UDPHS Endpoint Control Disable Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTLDIS5_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL5: UDPHS Endpoint Control Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTL5_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL5_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA5: UDPHS Endpoint Set Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTSETSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA5: UDPHS Endpoint Clear Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCLRSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA5_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA5: UDPHS Endpoint Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA5_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA5_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA5_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA5_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA5_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA5_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA5_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA5_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG6: UDPHS Endpoint Configuration Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCFG6_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG6_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG6_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG6_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG6_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB6: UDPHS Endpoint Control Enable Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTLENB6_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB6_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS6: UDPHS Endpoint Control Disable Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTLDIS6_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL6: UDPHS Endpoint Control Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTL6_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL6_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA6: UDPHS Endpoint Set Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTSETSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA6: UDPHS Endpoint Clear Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCLRSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA6_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA6: UDPHS Endpoint Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA6_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA6_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA6_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA6_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA6_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA6_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA6_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA6_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x80000000) >> 31
}

// UDPHS.DMANXTDSC0: UDPHS DMA Next Descriptor Address Register (channel = 0)
func (o *UDPHS_Type) SetDMANXTDSC0(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC0.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC0() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC0.Reg)
}

// UDPHS.DMAADDRESS0: UDPHS DMA Channel Address Register (channel = 0)
func (o *UDPHS_Type) SetDMAADDRESS0(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS0.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS0() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS0.Reg)
}

// UDPHS.DMACONTROL0: UDPHS DMA Channel Control Register (channel = 0)
func (o *UDPHS_Type) SetDMACONTROL0_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL0_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL0_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL0_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL0_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL0_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL0_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL0_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL0_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL0_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL0_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL0_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL0_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL0_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS0: UDPHS DMA Channel Status Register (channel = 0)
func (o *UDPHS_Type) SetDMASTATUS0_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS0_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS0_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS0_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS0_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS0_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS0_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS0_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS0_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS0_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS0_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS0_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC1: UDPHS DMA Next Descriptor Address Register (channel = 1)
func (o *UDPHS_Type) SetDMANXTDSC1(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC1.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC1() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC1.Reg)
}

// UDPHS.DMAADDRESS1: UDPHS DMA Channel Address Register (channel = 1)
func (o *UDPHS_Type) SetDMAADDRESS1(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS1.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS1() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS1.Reg)
}

// UDPHS.DMACONTROL1: UDPHS DMA Channel Control Register (channel = 1)
func (o *UDPHS_Type) SetDMACONTROL1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL1_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL1_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL1_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL1_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL1_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL1_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL1_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL1_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL1_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL1_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL1_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL1_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS1: UDPHS DMA Channel Status Register (channel = 1)
func (o *UDPHS_Type) SetDMASTATUS1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS1_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS1_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS1_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS1_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS1_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS1_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS1_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS1_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS1_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS1_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC2: UDPHS DMA Next Descriptor Address Register (channel = 2)
func (o *UDPHS_Type) SetDMANXTDSC2(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC2.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC2() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC2.Reg)
}

// UDPHS.DMAADDRESS2: UDPHS DMA Channel Address Register (channel = 2)
func (o *UDPHS_Type) SetDMAADDRESS2(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS2.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS2() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS2.Reg)
}

// UDPHS.DMACONTROL2: UDPHS DMA Channel Control Register (channel = 2)
func (o *UDPHS_Type) SetDMACONTROL2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL2_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL2_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL2_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL2_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL2_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL2_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL2_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL2_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL2_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL2_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL2_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL2_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS2: UDPHS DMA Channel Status Register (channel = 2)
func (o *UDPHS_Type) SetDMASTATUS2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS2_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS2_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS2_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS2_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS2_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS2_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS2_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS2_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS2_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS2_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC3: UDPHS DMA Next Descriptor Address Register (channel = 3)
func (o *UDPHS_Type) SetDMANXTDSC3(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC3.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC3() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC3.Reg)
}

// UDPHS.DMAADDRESS3: UDPHS DMA Channel Address Register (channel = 3)
func (o *UDPHS_Type) SetDMAADDRESS3(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS3.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS3() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS3.Reg)
}

// UDPHS.DMACONTROL3: UDPHS DMA Channel Control Register (channel = 3)
func (o *UDPHS_Type) SetDMACONTROL3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL3_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL3_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL3_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL3_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL3_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL3_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL3_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL3_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL3_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL3_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL3_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL3_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS3: UDPHS DMA Channel Status Register (channel = 3)
func (o *UDPHS_Type) SetDMASTATUS3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS3_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS3_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS3_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS3_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS3_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS3_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS3_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS3_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS3_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS3_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC4: UDPHS DMA Next Descriptor Address Register (channel = 4)
func (o *UDPHS_Type) SetDMANXTDSC4(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC4.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC4() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC4.Reg)
}

// UDPHS.DMAADDRESS4: UDPHS DMA Channel Address Register (channel = 4)
func (o *UDPHS_Type) SetDMAADDRESS4(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS4.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS4() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS4.Reg)
}

// UDPHS.DMACONTROL4: UDPHS DMA Channel Control Register (channel = 4)
func (o *UDPHS_Type) SetDMACONTROL4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL4_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL4_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL4_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL4_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL4_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL4_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL4_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL4_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL4_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL4_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL4_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL4_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS4: UDPHS DMA Channel Status Register (channel = 4)
func (o *UDPHS_Type) SetDMASTATUS4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS4_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS4_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS4_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS4_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS4_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS4_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS4_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS4_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS4_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS4_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC5: UDPHS DMA Next Descriptor Address Register (channel = 5)
func (o *UDPHS_Type) SetDMANXTDSC5(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC5.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC5() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC5.Reg)
}

// UDPHS.DMAADDRESS5: UDPHS DMA Channel Address Register (channel = 5)
func (o *UDPHS_Type) SetDMAADDRESS5(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS5.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS5() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS5.Reg)
}

// UDPHS.DMACONTROL5: UDPHS DMA Channel Control Register (channel = 5)
func (o *UDPHS_Type) SetDMACONTROL5_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL5_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL5_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL5_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL5_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL5_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL5_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL5_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL5_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL5_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL5_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL5_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL5_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL5_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS5: UDPHS DMA Channel Status Register (channel = 5)
func (o *UDPHS_Type) SetDMASTATUS5_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS5_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS5_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS5_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS5_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS5_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS5_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS5_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS5_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS5_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS5_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS5_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0xffff0000) >> 16
}

// Analog-to-Digital Converter 12bits
type ADC12B_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [8]byte
	CHER volatile.Register32    // 0x10
	CHDR volatile.Register32    // 0x14
	CHSR volatile.Register32    // 0x18
	SR   volatile.Register32    // 0x1C
	LCDR volatile.Register32    // 0x20
	IER  volatile.Register32    // 0x24
	IDR  volatile.Register32    // 0x28
	IMR  volatile.Register32    // 0x2C
	CDR  [8]volatile.Register32 // 0x30
	_    [20]byte
	ACR  volatile.Register32 // 0x64
	EMR  volatile.Register32 // 0x68
	_    [148]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	_    [8]byte
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	_    [8]byte
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// ADC12B.CR: Control Register
func (o *ADC12B_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ADC12B_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC12B_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}

// ADC12B.MR: Mode Register
func (o *ADC12B_Type) SetMR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetMR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *ADC12B_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *ADC12B_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *ADC12B_Type) SetMR_LOWRES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *ADC12B_Type) GetMR_LOWRES() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *ADC12B_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *ADC12B_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *ADC12B_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *ADC12B_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *ADC12B_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC12B_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff0000) >> 16
}
func (o *ADC12B_Type) SetMR_SHTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC12B_Type) GetMR_SHTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}

// ADC12B.CHER: Channel Enable Register
func (o *ADC12B_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *ADC12B_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *ADC12B_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *ADC12B_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *ADC12B_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *ADC12B_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *ADC12B_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *ADC12B_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *ADC12B_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *ADC12B_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *ADC12B_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *ADC12B_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *ADC12B_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *ADC12B_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *ADC12B_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}

// ADC12B.CHDR: Channel Disable Register
func (o *ADC12B_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *ADC12B_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC12B_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *ADC12B_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC12B_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *ADC12B_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC12B_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *ADC12B_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC12B_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *ADC12B_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC12B_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *ADC12B_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC12B_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *ADC12B_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC12B_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}

// ADC12B.CHSR: Channel Status Register
func (o *ADC12B_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *ADC12B_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC12B_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *ADC12B_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *ADC12B_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *ADC12B_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *ADC12B_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *ADC12B_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *ADC12B_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *ADC12B_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *ADC12B_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *ADC12B_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC12B_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *ADC12B_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC12B_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}

// ADC12B.SR: Status Register
func (o *ADC12B_Type) SetSR_EOC0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetSR_EOC0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *ADC12B_Type) SetSR_EOC1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *ADC12B_Type) GetSR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *ADC12B_Type) SetSR_EOC2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *ADC12B_Type) GetSR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *ADC12B_Type) SetSR_EOC3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *ADC12B_Type) GetSR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *ADC12B_Type) SetSR_EOC4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *ADC12B_Type) GetSR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *ADC12B_Type) SetSR_EOC5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *ADC12B_Type) GetSR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *ADC12B_Type) SetSR_EOC6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *ADC12B_Type) GetSR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *ADC12B_Type) SetSR_EOC7(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *ADC12B_Type) GetSR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *ADC12B_Type) SetSR_OVRE0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *ADC12B_Type) GetSR_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *ADC12B_Type) SetSR_OVRE1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *ADC12B_Type) GetSR_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *ADC12B_Type) SetSR_OVRE2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *ADC12B_Type) GetSR_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *ADC12B_Type) SetSR_OVRE3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *ADC12B_Type) GetSR_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *ADC12B_Type) SetSR_OVRE4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC12B_Type) GetSR_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *ADC12B_Type) SetSR_OVRE5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC12B_Type) GetSR_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *ADC12B_Type) SetSR_OVRE6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC12B_Type) GetSR_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *ADC12B_Type) SetSR_OVRE7(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC12B_Type) GetSR_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *ADC12B_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC12B_Type) GetSR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *ADC12B_Type) SetSR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC12B_Type) GetSR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *ADC12B_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC12B_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *ADC12B_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC12B_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}

// ADC12B.LCDR: Last Converted Data Register
func (o *ADC12B_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xfff)|value)
}
func (o *ADC12B_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0xfff
}

// ADC12B.IER: Interrupt Enable Register
func (o *ADC12B_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *ADC12B_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC12B_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC12B_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC12B_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC12B_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC12B_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC12B_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC12B_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC12B_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC12B_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC12B_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC12B_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC12B_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC12B_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC12B_Type) SetIER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC12B_Type) GetIER_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC12B_Type) SetIER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC12B_Type) GetIER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC12B_Type) SetIER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC12B_Type) GetIER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC12B_Type) SetIER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *ADC12B_Type) GetIER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *ADC12B_Type) SetIER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC12B_Type) GetIER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *ADC12B_Type) SetIER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC12B_Type) GetIER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *ADC12B_Type) SetIER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC12B_Type) GetIER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *ADC12B_Type) SetIER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC12B_Type) GetIER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *ADC12B_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *ADC12B_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *ADC12B_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *ADC12B_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *ADC12B_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *ADC12B_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *ADC12B_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *ADC12B_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}

// ADC12B.IDR: Interrupt Disable Register
func (o *ADC12B_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *ADC12B_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC12B_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ADC12B_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC12B_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ADC12B_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC12B_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *ADC12B_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC12B_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *ADC12B_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC12B_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *ADC12B_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC12B_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *ADC12B_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC12B_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *ADC12B_Type) SetIDR_OVRE0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC12B_Type) GetIDR_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *ADC12B_Type) SetIDR_OVRE1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC12B_Type) GetIDR_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *ADC12B_Type) SetIDR_OVRE2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC12B_Type) GetIDR_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ADC12B_Type) SetIDR_OVRE3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC12B_Type) GetIDR_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *ADC12B_Type) SetIDR_OVRE4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC12B_Type) GetIDR_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *ADC12B_Type) SetIDR_OVRE5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC12B_Type) GetIDR_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *ADC12B_Type) SetIDR_OVRE6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC12B_Type) GetIDR_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *ADC12B_Type) SetIDR_OVRE7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC12B_Type) GetIDR_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *ADC12B_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC12B_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *ADC12B_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC12B_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *ADC12B_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC12B_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *ADC12B_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC12B_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}

// ADC12B.IMR: Interrupt Mask Register
func (o *ADC12B_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *ADC12B_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ADC12B_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ADC12B_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ADC12B_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ADC12B_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *ADC12B_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *ADC12B_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *ADC12B_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *ADC12B_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *ADC12B_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *ADC12B_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *ADC12B_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *ADC12B_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *ADC12B_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *ADC12B_Type) SetIMR_OVRE0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *ADC12B_Type) GetIMR_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *ADC12B_Type) SetIMR_OVRE1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC12B_Type) GetIMR_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *ADC12B_Type) SetIMR_OVRE2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ADC12B_Type) GetIMR_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ADC12B_Type) SetIMR_OVRE3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *ADC12B_Type) GetIMR_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *ADC12B_Type) SetIMR_OVRE4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC12B_Type) GetIMR_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *ADC12B_Type) SetIMR_OVRE5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC12B_Type) GetIMR_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *ADC12B_Type) SetIMR_OVRE6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC12B_Type) GetIMR_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *ADC12B_Type) SetIMR_OVRE7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC12B_Type) GetIMR_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *ADC12B_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC12B_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *ADC12B_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC12B_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *ADC12B_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC12B_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *ADC12B_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC12B_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}

// ADC12B.CDR: Channel Data Register
func (o *ADC12B_Type) SetCDR_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xfff)|value)
}
func (o *ADC12B_Type) GetCDR_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0xfff
}

// ADC12B.ACR: Analog Control Register
func (o *ADC12B_Type) SetACR_GAIN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x3)|value)
}
func (o *ADC12B_Type) GetACR_GAIN() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x3
}
func (o *ADC12B_Type) SetACR_IBCTL(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x300)|value<<8)
}
func (o *ADC12B_Type) GetACR_IBCTL() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x300) >> 8
}
func (o *ADC12B_Type) SetACR_DIFF(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC12B_Type) GetACR_DIFF() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x10000) >> 16
}
func (o *ADC12B_Type) SetACR_OFFSET(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC12B_Type) GetACR_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x20000) >> 17
}

// ADC12B.EMR: Extended Mode Register
func (o *ADC12B_Type) SetEMR_OFFMODES(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetEMR_OFFMODES() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *ADC12B_Type) SetEMR_OFF_MODE_STARTUP_TIME(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC12B_Type) GetEMR_OFF_MODE_STARTUP_TIME() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xff0000) >> 16
}

// ADC12B.RPR: Receive Pointer Register
func (o *ADC12B_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *ADC12B_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// ADC12B.RCR: Receive Counter Register
func (o *ADC12B_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *ADC12B_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// ADC12B.RNPR: Receive Next Pointer Register
func (o *ADC12B_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *ADC12B_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// ADC12B.RNCR: Receive Next Counter Register
func (o *ADC12B_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *ADC12B_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// ADC12B.PTCR: Transfer Control Register
func (o *ADC12B_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *ADC12B_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *ADC12B_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *ADC12B_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *ADC12B_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *ADC12B_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *ADC12B_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// ADC12B.PTSR: Transfer Status Register
func (o *ADC12B_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *ADC12B_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *ADC12B_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC12B_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [8]byte
	CHER volatile.Register32    // 0x10
	CHDR volatile.Register32    // 0x14
	CHSR volatile.Register32    // 0x18
	SR   volatile.Register32    // 0x1C
	LCDR volatile.Register32    // 0x20
	IER  volatile.Register32    // 0x24
	IDR  volatile.Register32    // 0x28
	IMR  volatile.Register32    // 0x2C
	CDR  [8]volatile.Register32 // 0x30
	_    [176]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	_    [8]byte
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	_    [8]byte
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// ADC.CR: Control Register
func (o *ADC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ADC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}

// ADC.MR: Mode Register
func (o *ADC_Type) SetMR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetMR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *ADC_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *ADC_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *ADC_Type) SetMR_LOWRES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetMR_LOWRES() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7f0000)|value<<16)
}
func (o *ADC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7f0000) >> 16
}
func (o *ADC_Type) SetMR_SHTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetMR_SHTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}

// ADC.CHER: Channel Enable Register
func (o *ADC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *ADC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}

// ADC.CHDR: Channel Disable Register
func (o *ADC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *ADC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}

// ADC.CHSR: Channel Status Register
func (o *ADC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *ADC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}

// ADC.SR: Status Register
func (o *ADC_Type) SetSR_EOC0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSR_EOC0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *ADC_Type) SetSR_EOC1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetSR_EOC2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSR_EOC3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSR_EOC4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetSR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetSR_EOC5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSR_EOC6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSR_EOC7(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetSR_OVRE0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetSR_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetSR_OVRE1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetSR_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetSR_OVRE2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetSR_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetSR_OVRE3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetSR_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetSR_OVRE4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetSR_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetSR_OVRE5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetSR_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetSR_OVRE6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetSR_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetSR_OVRE7(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetSR_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetSR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetSR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetSR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}

// ADC.LCDR: Last Converted Data Register
func (o *ADC_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0x3ff)|value)
}
func (o *ADC_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0x3ff
}

// ADC.IER: Interrupt Enable Register
func (o *ADC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *ADC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}

// ADC.IDR: Interrupt Disable Register
func (o *ADC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *ADC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIDR_OVRE0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIDR_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIDR_OVRE1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIDR_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIDR_OVRE2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIDR_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIDR_OVRE3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIDR_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIDR_OVRE4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIDR_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIDR_OVRE5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIDR_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIDR_OVRE6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIDR_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIDR_OVRE7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIDR_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}

// ADC.IMR: Interrupt Mask Register
func (o *ADC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *ADC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIMR_OVRE0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIMR_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIMR_OVRE1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIMR_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIMR_OVRE2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIMR_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIMR_OVRE3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIMR_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIMR_OVRE4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIMR_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIMR_OVRE5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIMR_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIMR_OVRE6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIMR_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIMR_OVRE7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIMR_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}

// ADC.CDR: Channel Data Register
func (o *ADC_Type) SetCDR_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0x3ff)|value)
}
func (o *ADC_Type) GetCDR_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0x3ff
}

// ADC.RPR: Receive Pointer Register
func (o *ADC_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *ADC_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// ADC.RCR: Receive Counter Register
func (o *ADC_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// ADC.RNPR: Receive Next Pointer Register
func (o *ADC_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *ADC_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// ADC.RNCR: Receive Next Counter Register
func (o *ADC_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// ADC.PTCR: Transfer Control Register
func (o *ADC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *ADC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// ADC.PTSR: Transfer Status Register
func (o *ADC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *ADC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// DMA Controller
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	_      [16]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	_      [16]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	_      [16]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	_      [280]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// DMAC.GCFG: DMAC Global Configuration Register
func (o *DMAC_Type) SetGCFG_ARB_CFG(value uint32) {
	volatile.StoreUint32(&o.GCFG.Reg, volatile.LoadUint32(&o.GCFG.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetGCFG_ARB_CFG() uint32 {
	return (volatile.LoadUint32(&o.GCFG.Reg) & 0x10) >> 4
}

// DMAC.EN: DMAC Enable Register
func (o *DMAC_Type) SetEN_ENABLE(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEN_ENABLE() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// DMAC.SREQ: DMAC Software Single Request Register
func (o *DMAC_Type) SetSREQ_SSREQ0(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetSREQ_SSREQ0() uint32 {
	return volatile.LoadUint32(&o.SREQ.Reg) & 0x1
}
func (o *DMAC_Type) SetSREQ_DSREQ0(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetSREQ_DSREQ0() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetSREQ_SSREQ1(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetSREQ_SSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetSREQ_DSREQ1(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetSREQ_DSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetSREQ_SSREQ2(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetSREQ_SSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetSREQ_DSREQ2(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetSREQ_DSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetSREQ_SSREQ3(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetSREQ_SSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetSREQ_DSREQ3(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetSREQ_DSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x80) >> 7
}

// DMAC.CREQ: DMAC Software Chunk Transfer Request Register
func (o *DMAC_Type) SetCREQ_SCREQ0(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCREQ_SCREQ0() uint32 {
	return volatile.LoadUint32(&o.CREQ.Reg) & 0x1
}
func (o *DMAC_Type) SetCREQ_DCREQ0(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCREQ_DCREQ0() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCREQ_SCREQ1(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCREQ_SCREQ1() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCREQ_DCREQ1(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCREQ_DCREQ1() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCREQ_SCREQ2(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCREQ_SCREQ2() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCREQ_DCREQ2(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCREQ_DCREQ2() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCREQ_SCREQ3(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCREQ_SCREQ3() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCREQ_DCREQ3(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCREQ_DCREQ3() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x80) >> 7
}

// DMAC.LAST: DMAC Software Last Transfer Flag Register
func (o *DMAC_Type) SetLAST_SLAST0(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetLAST_SLAST0() uint32 {
	return volatile.LoadUint32(&o.LAST.Reg) & 0x1
}
func (o *DMAC_Type) SetLAST_DLAST0(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetLAST_DLAST0() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetLAST_SLAST1(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetLAST_SLAST1() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetLAST_DLAST1(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetLAST_DLAST1() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetLAST_SLAST2(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetLAST_SLAST2() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetLAST_DLAST2(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetLAST_DLAST2() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetLAST_SLAST3(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetLAST_SLAST3() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetLAST_DLAST3(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetLAST_DLAST3() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x80) >> 7
}

// DMAC.EBCIER: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Enable register.
func (o *DMAC_Type) SetEBCIER_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIER_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIER.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIER_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIER_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIER_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIER_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIER_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIER_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIER_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIER_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIER_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIER_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIER_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIER_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIER_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIER_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIER_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIER_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIER_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIER_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIER_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIER_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIER_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIER_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x80000) >> 19
}

// DMAC.EBCIDR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Disable register.
func (o *DMAC_Type) SetEBCIDR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIDR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIDR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIDR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIDR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIDR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIDR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIDR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIDR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIDR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIDR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIDR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIDR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIDR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIDR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIDR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIDR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIDR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIDR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIDR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIDR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIDR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIDR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIDR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIDR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x80000) >> 19
}

// DMAC.EBCIMR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Mask Register.
func (o *DMAC_Type) SetEBCIMR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIMR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIMR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIMR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIMR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIMR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIMR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIMR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIMR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIMR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIMR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIMR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIMR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIMR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIMR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIMR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIMR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIMR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIMR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIMR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIMR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIMR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIMR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIMR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIMR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x80000) >> 19
}

// DMAC.EBCISR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Status Register.
func (o *DMAC_Type) SetEBCISR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCISR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCISR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCISR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCISR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCISR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCISR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCISR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCISR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCISR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCISR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCISR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCISR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCISR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCISR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCISR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCISR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCISR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCISR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCISR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCISR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCISR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCISR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCISR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCISR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x80000) >> 19
}

// DMAC.CHER: DMAC Channel Handler Enable Register
func (o *DMAC_Type) SetCHER_ENA0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHER_ENA0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *DMAC_Type) SetCHER_ENA1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHER_ENA1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHER_ENA2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHER_ENA2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHER_ENA3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHER_ENA3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHER_SUSP0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHER_SUSP0() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHER_SUSP1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHER_SUSP1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHER_SUSP2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHER_SUSP2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHER_SUSP3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHER_SUSP3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHER_KEEP0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHER_KEEP0() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHER_KEEP1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetCHER_KEEP1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetCHER_KEEP2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetCHER_KEEP2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetCHER_KEEP3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetCHER_KEEP3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000000) >> 27
}

// DMAC.CHDR: DMAC Channel Handler Disable Register
func (o *DMAC_Type) SetCHDR_DIS0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHDR_DIS0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHDR_DIS1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHDR_DIS1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHDR_DIS2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHDR_DIS2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHDR_DIS3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHDR_DIS3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHDR_RES0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHDR_RES0() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHDR_RES1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHDR_RES1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHDR_RES2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHDR_RES2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHDR_RES3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHDR_RES3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}

// DMAC.CHSR: DMAC Channel Handler Status Register
func (o *DMAC_Type) SetCHSR_ENA0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHSR_ENA0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHSR_ENA1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHSR_ENA1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHSR_ENA2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHSR_ENA2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHSR_ENA3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHSR_ENA3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHSR_SUSP0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHSR_SUSP0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHSR_SUSP1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHSR_SUSP1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHSR_SUSP2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHSR_SUSP2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHSR_SUSP3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHSR_SUSP3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHSR_EMPT0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCHSR_EMPT0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCHSR_EMPT1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetCHSR_EMPT1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetCHSR_EMPT2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetCHSR_EMPT2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetCHSR_EMPT3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetCHSR_EMPT3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetCHSR_STAL0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHSR_STAL0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHSR_STAL1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetCHSR_STAL1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetCHSR_STAL2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetCHSR_STAL2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetCHSR_STAL3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetCHSR_STAL3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000000) >> 27
}

// DMAC.SADDR0: DMAC Channel Source Address Register (ch_num = 0)
func (o *DMAC_Type) SetSADDR0(value uint32) {
	volatile.StoreUint32(&o.SADDR0.Reg, value)
}
func (o *DMAC_Type) GetSADDR0() uint32 {
	return volatile.LoadUint32(&o.SADDR0.Reg)
}

// DMAC.DADDR0: DMAC Channel Destination Address Register (ch_num = 0)
func (o *DMAC_Type) SetDADDR0(value uint32) {
	volatile.StoreUint32(&o.DADDR0.Reg, value)
}
func (o *DMAC_Type) GetDADDR0() uint32 {
	return volatile.LoadUint32(&o.DADDR0.Reg)
}

// DMAC.DSCR0: DMAC Channel Descriptor Address Register (ch_num = 0)
func (o *DMAC_Type) SetDSCR0_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR0.Reg, volatile.LoadUint32(&o.DSCR0.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR0_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR0.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA0: DMAC Channel Control A Register (ch_num = 0)
func (o *DMAC_Type) SetCTRLA0_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA0_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA0.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA0_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA0_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA0_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA0_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA0_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA0_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB0: DMAC Channel Control B Register (ch_num = 0)
func (o *DMAC_Type) SetCTRLB0_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB0_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB0_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB0_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB0_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x600000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB0_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x600000) >> 21
}
func (o *DMAC_Type) SetCTRLB0_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB0_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB0_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB0_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB0_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB0_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x40000000) >> 30
}

// DMAC.CFG0: DMAC Channel Configuration Register (ch_num = 0)
func (o *DMAC_Type) SetCFG0_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG0_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG0.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG0_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG0_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG0_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG0_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG0_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG0_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG0_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG0_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG0_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG0_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG0_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG0_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG0_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG0_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG0_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG0_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG0_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG0_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR1: DMAC Channel Source Address Register (ch_num = 1)
func (o *DMAC_Type) SetSADDR1(value uint32) {
	volatile.StoreUint32(&o.SADDR1.Reg, value)
}
func (o *DMAC_Type) GetSADDR1() uint32 {
	return volatile.LoadUint32(&o.SADDR1.Reg)
}

// DMAC.DADDR1: DMAC Channel Destination Address Register (ch_num = 1)
func (o *DMAC_Type) SetDADDR1(value uint32) {
	volatile.StoreUint32(&o.DADDR1.Reg, value)
}
func (o *DMAC_Type) GetDADDR1() uint32 {
	return volatile.LoadUint32(&o.DADDR1.Reg)
}

// DMAC.DSCR1: DMAC Channel Descriptor Address Register (ch_num = 1)
func (o *DMAC_Type) SetDSCR1_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR1.Reg, volatile.LoadUint32(&o.DSCR1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR1_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR1.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA1: DMAC Channel Control A Register (ch_num = 1)
func (o *DMAC_Type) SetCTRLA1_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA1_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA1.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA1_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA1_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA1_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA1_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA1_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA1_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB1: DMAC Channel Control B Register (ch_num = 1)
func (o *DMAC_Type) SetCTRLB1_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB1_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB1_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB1_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB1_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x600000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB1_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x600000) >> 21
}
func (o *DMAC_Type) SetCTRLB1_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB1_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB1_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB1_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB1_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB1_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x40000000) >> 30
}

// DMAC.CFG1: DMAC Channel Configuration Register (ch_num = 1)
func (o *DMAC_Type) SetCFG1_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG1_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG1_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG1_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG1_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG1_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG1_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG1_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG1_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG1_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG1_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG1_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG1_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG1_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG1_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG1_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG1_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG1_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG1_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG1_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR2: DMAC Channel Source Address Register (ch_num = 2)
func (o *DMAC_Type) SetSADDR2(value uint32) {
	volatile.StoreUint32(&o.SADDR2.Reg, value)
}
func (o *DMAC_Type) GetSADDR2() uint32 {
	return volatile.LoadUint32(&o.SADDR2.Reg)
}

// DMAC.DADDR2: DMAC Channel Destination Address Register (ch_num = 2)
func (o *DMAC_Type) SetDADDR2(value uint32) {
	volatile.StoreUint32(&o.DADDR2.Reg, value)
}
func (o *DMAC_Type) GetDADDR2() uint32 {
	return volatile.LoadUint32(&o.DADDR2.Reg)
}

// DMAC.DSCR2: DMAC Channel Descriptor Address Register (ch_num = 2)
func (o *DMAC_Type) SetDSCR2_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR2.Reg, volatile.LoadUint32(&o.DSCR2.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR2_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR2.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA2: DMAC Channel Control A Register (ch_num = 2)
func (o *DMAC_Type) SetCTRLA2_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA2_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA2.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA2_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA2_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA2_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA2_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA2_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA2_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB2: DMAC Channel Control B Register (ch_num = 2)
func (o *DMAC_Type) SetCTRLB2_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB2_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB2_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB2_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB2_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x600000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB2_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x600000) >> 21
}
func (o *DMAC_Type) SetCTRLB2_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB2_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB2_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB2_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB2_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB2_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x40000000) >> 30
}

// DMAC.CFG2: DMAC Channel Configuration Register (ch_num = 2)
func (o *DMAC_Type) SetCFG2_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG2_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG2_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG2_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG2_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG2_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG2_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG2_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG2_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG2_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG2_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG2_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG2_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG2_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG2_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG2_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG2_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG2_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG2_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG2_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR3: DMAC Channel Source Address Register (ch_num = 3)
func (o *DMAC_Type) SetSADDR3(value uint32) {
	volatile.StoreUint32(&o.SADDR3.Reg, value)
}
func (o *DMAC_Type) GetSADDR3() uint32 {
	return volatile.LoadUint32(&o.SADDR3.Reg)
}

// DMAC.DADDR3: DMAC Channel Destination Address Register (ch_num = 3)
func (o *DMAC_Type) SetDADDR3(value uint32) {
	volatile.StoreUint32(&o.DADDR3.Reg, value)
}
func (o *DMAC_Type) GetDADDR3() uint32 {
	return volatile.LoadUint32(&o.DADDR3.Reg)
}

// DMAC.DSCR3: DMAC Channel Descriptor Address Register (ch_num = 3)
func (o *DMAC_Type) SetDSCR3_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR3.Reg, volatile.LoadUint32(&o.DSCR3.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR3_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR3.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA3: DMAC Channel Control A Register (ch_num = 3)
func (o *DMAC_Type) SetCTRLA3_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA3_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA3.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA3_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA3_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA3_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA3_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA3_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA3_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB3: DMAC Channel Control B Register (ch_num = 3)
func (o *DMAC_Type) SetCTRLB3_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB3_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB3_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB3_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB3_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x600000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB3_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x600000) >> 21
}
func (o *DMAC_Type) SetCTRLB3_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB3_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB3_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB3_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB3_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB3_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x40000000) >> 30
}

// DMAC.CFG3: DMAC Channel Configuration Register (ch_num = 3)
func (o *DMAC_Type) SetCFG3_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG3_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG3.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG3_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG3_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG3_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG3_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG3_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG3_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG3_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG3_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG3_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG3_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG3_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG3_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG3_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG3_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG3_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG3_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG3_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG3_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x30000000) >> 28
}

// DMAC.WPMR: DMAC Write Protect Mode Register
func (o *DMAC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DMAC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DMAC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DMAC.WPSR: DMAC Write Protect Status Register
func (o *DMAC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DMAC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *DMAC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Static Memory Controller
type EBI_Type struct {
	CFG      volatile.Register32 // 0x0
	CTRL     volatile.Register32 // 0x4
	SR       volatile.Register32 // 0x8
	IER      volatile.Register32 // 0xC
	IDR      volatile.Register32 // 0x10
	IMR      volatile.Register32 // 0x14
	ADDR     volatile.Register32 // 0x18
	BANK     volatile.Register32 // 0x1C
	ECC_CTRL volatile.Register32 // 0x20
	ECC_MD   volatile.Register32 // 0x24
	ECC_SR1  volatile.Register32 // 0x28
	ECC_PR0  volatile.Register32 // 0x2C
	ECC_PR1  volatile.Register32 // 0x30
	ECC_SR2  volatile.Register32 // 0x34
	ECC_PR2  volatile.Register32 // 0x38
	ECC_PR3  volatile.Register32 // 0x3C
	ECC_PR4  volatile.Register32 // 0x40
	ECC_PR5  volatile.Register32 // 0x44
	ECC_PR6  volatile.Register32 // 0x48
	ECC_PR7  volatile.Register32 // 0x4C
	ECC_PR8  volatile.Register32 // 0x50
	ECC_PR9  volatile.Register32 // 0x54
	ECC_PR10 volatile.Register32 // 0x58
	ECC_PR11 volatile.Register32 // 0x5C
	ECC_PR12 volatile.Register32 // 0x60
	ECC_PR13 volatile.Register32 // 0x64
	ECC_PR14 volatile.Register32 // 0x68
	ECC_PR15 volatile.Register32 // 0x6C
	SETUP0   volatile.Register32 // 0x70
	PULSE0   volatile.Register32 // 0x74
	CYCLE0   volatile.Register32 // 0x78
	TIMINGS0 volatile.Register32 // 0x7C
	MODE0    volatile.Register32 // 0x80
	SETUP1   volatile.Register32 // 0x84
	PULSE1   volatile.Register32 // 0x88
	CYCLE1   volatile.Register32 // 0x8C
	TIMINGS1 volatile.Register32 // 0x90
	MODE1    volatile.Register32 // 0x94
	SETUP2   volatile.Register32 // 0x98
	PULSE2   volatile.Register32 // 0x9C
	CYCLE2   volatile.Register32 // 0xA0
	TIMINGS2 volatile.Register32 // 0xA4
	MODE2    volatile.Register32 // 0xA8
	SETUP3   volatile.Register32 // 0xAC
	PULSE3   volatile.Register32 // 0xB0
	CYCLE3   volatile.Register32 // 0xB4
	TIMINGS3 volatile.Register32 // 0xB8
	MODE3    volatile.Register32 // 0xBC
	_        [80]byte
	OCMS     volatile.Register32 // 0x110
	KEY1     volatile.Register32 // 0x114
	KEY2     volatile.Register32 // 0x118
	_        [200]byte
	WPCR     volatile.Register32 // 0x1E4
	WPSR     volatile.Register32 // 0x1E8
}

// EBI.CFG: SMC NFC Configuration Register
func (o *EBI_Type) SetCFG_PAGESIZE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x3)|value)
}
func (o *EBI_Type) GetCFG_PAGESIZE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x3
}
func (o *EBI_Type) SetCFG_WSPARE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *EBI_Type) GetCFG_WSPARE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *EBI_Type) SetCFG_RSPARE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x200)|value<<9)
}
func (o *EBI_Type) GetCFG_RSPARE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x200) >> 9
}
func (o *EBI_Type) SetCFG_EDGECTRL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetCFG_EDGECTRL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetCFG_RBEDGE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2000)|value<<13)
}
func (o *EBI_Type) GetCFG_RBEDGE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2000) >> 13
}
func (o *EBI_Type) SetCFG_DTOCYC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetCFG_DTOCYC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetCFG_DTOMUL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x700000)|value<<20)
}
func (o *EBI_Type) GetCFG_DTOMUL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x700000) >> 20
}

// EBI.CTRL: SMC NFC Control Register
func (o *EBI_Type) SetCTRL_NFCEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetCTRL_NFCEN() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *EBI_Type) SetCTRL_NFCDIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetCTRL_NFCDIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}

// EBI.SR: SMC NFC Status Register
func (o *EBI_Type) SetSR_SMCSTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetSR_SMCSTS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *EBI_Type) SetSR_RB_RISE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetSR_RB_RISE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetSR_RB_FALL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *EBI_Type) GetSR_RB_FALL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *EBI_Type) SetSR_NFCBUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *EBI_Type) GetSR_NFCBUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *EBI_Type) SetSR_NFCWR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *EBI_Type) GetSR_NFCWR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *EBI_Type) SetSR_NFCSID(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7000)|value<<12)
}
func (o *EBI_Type) GetSR_NFCSID() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7000) >> 12
}
func (o *EBI_Type) SetSR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetSR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetSR_CMDDONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *EBI_Type) GetSR_CMDDONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *EBI_Type) SetSR_DTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetSR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *EBI_Type) SetSR_UNDEF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *EBI_Type) GetSR_UNDEF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *EBI_Type) SetSR_AWB(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *EBI_Type) GetSR_AWB() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *EBI_Type) SetSR_NFCASE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *EBI_Type) GetSR_NFCASE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *EBI_Type) SetSR_RB_EDGE0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *EBI_Type) GetSR_RB_EDGE0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}

// EBI.IER: SMC NFC Interrupt Enable Register
func (o *EBI_Type) SetIER_RB_RISE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetIER_RB_RISE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetIER_RB_FALL(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *EBI_Type) GetIER_RB_FALL() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *EBI_Type) SetIER_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetIER_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetIER_CMDDONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *EBI_Type) GetIER_CMDDONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *EBI_Type) SetIER_DTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetIER_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *EBI_Type) SetIER_UNDEF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *EBI_Type) GetIER_UNDEF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *EBI_Type) SetIER_AWB(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *EBI_Type) GetIER_AWB() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *EBI_Type) SetIER_NFCASE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *EBI_Type) GetIER_NFCASE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *EBI_Type) SetIER_RB_EDGE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *EBI_Type) GetIER_RB_EDGE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}

// EBI.IDR: SMC NFC Interrupt Disable Register
func (o *EBI_Type) SetIDR_RB_RISE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetIDR_RB_RISE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetIDR_RB_FALL(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *EBI_Type) GetIDR_RB_FALL() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *EBI_Type) SetIDR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetIDR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetIDR_CMDDONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *EBI_Type) GetIDR_CMDDONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *EBI_Type) SetIDR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetIDR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *EBI_Type) SetIDR_UNDEF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *EBI_Type) GetIDR_UNDEF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *EBI_Type) SetIDR_AWB(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *EBI_Type) GetIDR_AWB() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *EBI_Type) SetIDR_NFCASE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *EBI_Type) GetIDR_NFCASE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *EBI_Type) SetIDR_RB_EDGE0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *EBI_Type) GetIDR_RB_EDGE0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}

// EBI.IMR: SMC NFC Interrupt Mask Register
func (o *EBI_Type) SetIMR_RB_RISE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetIMR_RB_RISE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetIMR_RB_FALL(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EBI_Type) GetIMR_RB_FALL() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EBI_Type) SetIMR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetIMR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetIMR_CMDDONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *EBI_Type) GetIMR_CMDDONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *EBI_Type) SetIMR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetIMR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *EBI_Type) SetIMR_UNDEF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *EBI_Type) GetIMR_UNDEF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *EBI_Type) SetIMR_AWB(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *EBI_Type) GetIMR_AWB() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *EBI_Type) SetIMR_NFCASE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *EBI_Type) GetIMR_NFCASE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *EBI_Type) SetIMR_RB_EDGE0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *EBI_Type) GetIMR_RB_EDGE0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}

// EBI.ADDR: SMC NFC Address Cycle Zero Register
func (o *EBI_Type) SetADDR_ADDR_CYCLE0(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff)|value)
}
func (o *EBI_Type) GetADDR_ADDR_CYCLE0() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0xff
}

// EBI.BANK: SMC Bank Address Register
func (o *EBI_Type) SetBANK(value uint32) {
	volatile.StoreUint32(&o.BANK.Reg, volatile.LoadUint32(&o.BANK.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetBANK() uint32 {
	return volatile.LoadUint32(&o.BANK.Reg) & 0x7
}

// EBI.ECC_CTRL: SMC ECC Control Register
func (o *EBI_Type) SetECC_CTRL_RST(value uint32) {
	volatile.StoreUint32(&o.ECC_CTRL.Reg, volatile.LoadUint32(&o.ECC_CTRL.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetECC_CTRL_RST() uint32 {
	return volatile.LoadUint32(&o.ECC_CTRL.Reg) & 0x1
}
func (o *EBI_Type) SetECC_CTRL_SWRST(value uint32) {
	volatile.StoreUint32(&o.ECC_CTRL.Reg, volatile.LoadUint32(&o.ECC_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetECC_CTRL_SWRST() uint32 {
	return (volatile.LoadUint32(&o.ECC_CTRL.Reg) & 0x2) >> 1
}

// EBI.ECC_MD: SMC ECC Mode Register
func (o *EBI_Type) SetECC_MD_ECC_PAGESIZE(value uint32) {
	volatile.StoreUint32(&o.ECC_MD.Reg, volatile.LoadUint32(&o.ECC_MD.Reg)&^(0x3)|value)
}
func (o *EBI_Type) GetECC_MD_ECC_PAGESIZE() uint32 {
	return volatile.LoadUint32(&o.ECC_MD.Reg) & 0x3
}
func (o *EBI_Type) SetECC_MD_TYPCORREC(value uint32) {
	volatile.StoreUint32(&o.ECC_MD.Reg, volatile.LoadUint32(&o.ECC_MD.Reg)&^(0x30)|value<<4)
}
func (o *EBI_Type) GetECC_MD_TYPCORREC() uint32 {
	return (volatile.LoadUint32(&o.ECC_MD.Reg) & 0x30) >> 4
}

// EBI.ECC_SR1: SMC ECC Status 1 Register
func (o *EBI_Type) SetECC_SR1_RECERR0(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetECC_SR1_RECERR0() uint32 {
	return volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x1
}
func (o *EBI_Type) SetECC_SR1_ECCERR0(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x6)|value<<1)
}
func (o *EBI_Type) GetECC_SR1_ECCERR0() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x6) >> 1
}
func (o *EBI_Type) SetECC_SR1_RECERR1(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetECC_SR1_RECERR1() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetECC_SR1_ECCERR1(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x20)|value<<5)
}
func (o *EBI_Type) GetECC_SR1_ECCERR1() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x20) >> 5
}
func (o *EBI_Type) SetECC_SR1_MULERR1(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x40)|value<<6)
}
func (o *EBI_Type) GetECC_SR1_MULERR1() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x40) >> 6
}
func (o *EBI_Type) SetECC_SR1_RECERR2(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x100)|value<<8)
}
func (o *EBI_Type) GetECC_SR1_RECERR2() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x100) >> 8
}
func (o *EBI_Type) SetECC_SR1_ECCERR2(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x200)|value<<9)
}
func (o *EBI_Type) GetECC_SR1_ECCERR2() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x200) >> 9
}
func (o *EBI_Type) SetECC_SR1_MULERR2(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x400)|value<<10)
}
func (o *EBI_Type) GetECC_SR1_MULERR2() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x400) >> 10
}
func (o *EBI_Type) SetECC_SR1_RECERR3(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetECC_SR1_RECERR3() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetECC_SR1_ECCERR3(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x2000)|value<<13)
}
func (o *EBI_Type) GetECC_SR1_ECCERR3() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x2000) >> 13
}
func (o *EBI_Type) SetECC_SR1_MULERR3(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x4000)|value<<14)
}
func (o *EBI_Type) GetECC_SR1_MULERR3() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x4000) >> 14
}
func (o *EBI_Type) SetECC_SR1_RECERR4(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetECC_SR1_RECERR4() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetECC_SR1_ECCERR4(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x60000)|value<<17)
}
func (o *EBI_Type) GetECC_SR1_ECCERR4() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x60000) >> 17
}
func (o *EBI_Type) SetECC_SR1_RECERR5(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetECC_SR1_RECERR5() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x100000) >> 20
}
func (o *EBI_Type) SetECC_SR1_ECCERR5(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x600000)|value<<21)
}
func (o *EBI_Type) GetECC_SR1_ECCERR5() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x600000) >> 21
}
func (o *EBI_Type) SetECC_SR1_RECERR6(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EBI_Type) GetECC_SR1_RECERR6() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x1000000) >> 24
}
func (o *EBI_Type) SetECC_SR1_ECCERR6(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x6000000)|value<<25)
}
func (o *EBI_Type) GetECC_SR1_ECCERR6() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x6000000) >> 25
}
func (o *EBI_Type) SetECC_SR1_RECERR7(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EBI_Type) GetECC_SR1_RECERR7() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x10000000) >> 28
}
func (o *EBI_Type) SetECC_SR1_ECCERR7(value uint32) {
	volatile.StoreUint32(&o.ECC_SR1.Reg, volatile.LoadUint32(&o.ECC_SR1.Reg)&^(0x60000000)|value<<29)
}
func (o *EBI_Type) GetECC_SR1_ECCERR7() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR1.Reg) & 0x60000000) >> 29
}

// EBI.ECC_PR0: SMC ECC Parity 0 Register
func (o *EBI_Type) SetECC_PR0_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR0.Reg, volatile.LoadUint32(&o.ECC_PR0.Reg)&^(0xf)|value)
}
func (o *EBI_Type) GetECC_PR0_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR0.Reg) & 0xf
}
func (o *EBI_Type) SetECC_PR0_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR0.Reg, volatile.LoadUint32(&o.ECC_PR0.Reg)&^(0xfff0)|value<<4)
}
func (o *EBI_Type) GetECC_PR0_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR0.Reg) & 0xfff0) >> 4
}

// EBI.ECC_PR1: SMC ECC parity 1 Register
func (o *EBI_Type) SetECC_PR1_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR1.Reg, volatile.LoadUint32(&o.ECC_PR1.Reg)&^(0xffff)|value)
}
func (o *EBI_Type) GetECC_PR1_NPARITY() uint32 {
	return volatile.LoadUint32(&o.ECC_PR1.Reg) & 0xffff
}

// EBI.ECC_SR2: SMC ECC status 2 Register
func (o *EBI_Type) SetECC_SR2_RECERR8(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetECC_SR2_RECERR8() uint32 {
	return volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x1
}
func (o *EBI_Type) SetECC_SR2_ECCERR8(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x6)|value<<1)
}
func (o *EBI_Type) GetECC_SR2_ECCERR8() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x6) >> 1
}
func (o *EBI_Type) SetECC_SR2_RECERR9(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetECC_SR2_RECERR9() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetECC_SR2_ECCERR9(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x20)|value<<5)
}
func (o *EBI_Type) GetECC_SR2_ECCERR9() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x20) >> 5
}
func (o *EBI_Type) SetECC_SR2_MULERR9(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x40)|value<<6)
}
func (o *EBI_Type) GetECC_SR2_MULERR9() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x40) >> 6
}
func (o *EBI_Type) SetECC_SR2_RECERR10(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x100)|value<<8)
}
func (o *EBI_Type) GetECC_SR2_RECERR10() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x100) >> 8
}
func (o *EBI_Type) SetECC_SR2_ECCERR10(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x200)|value<<9)
}
func (o *EBI_Type) GetECC_SR2_ECCERR10() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x200) >> 9
}
func (o *EBI_Type) SetECC_SR2_MULERR10(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x400)|value<<10)
}
func (o *EBI_Type) GetECC_SR2_MULERR10() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x400) >> 10
}
func (o *EBI_Type) SetECC_SR2_RECERR11(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetECC_SR2_RECERR11() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetECC_SR2_ECCERR11(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x2000)|value<<13)
}
func (o *EBI_Type) GetECC_SR2_ECCERR11() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x2000) >> 13
}
func (o *EBI_Type) SetECC_SR2_MULERR11(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x4000)|value<<14)
}
func (o *EBI_Type) GetECC_SR2_MULERR11() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x4000) >> 14
}
func (o *EBI_Type) SetECC_SR2_RECERR12(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetECC_SR2_RECERR12() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetECC_SR2_ECCERR12(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x60000)|value<<17)
}
func (o *EBI_Type) GetECC_SR2_ECCERR12() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x60000) >> 17
}
func (o *EBI_Type) SetECC_SR2_RECERR13(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetECC_SR2_RECERR13() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x100000) >> 20
}
func (o *EBI_Type) SetECC_SR2_ECCERR13(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x600000)|value<<21)
}
func (o *EBI_Type) GetECC_SR2_ECCERR13() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x600000) >> 21
}
func (o *EBI_Type) SetECC_SR2_RECERR14(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x1000000)|value<<24)
}
func (o *EBI_Type) GetECC_SR2_RECERR14() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x1000000) >> 24
}
func (o *EBI_Type) SetECC_SR2_ECCERR14(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x6000000)|value<<25)
}
func (o *EBI_Type) GetECC_SR2_ECCERR14() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x6000000) >> 25
}
func (o *EBI_Type) SetECC_SR2_RECERR15(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x10000000)|value<<28)
}
func (o *EBI_Type) GetECC_SR2_RECERR15() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x10000000) >> 28
}
func (o *EBI_Type) SetECC_SR2_ECCERR15(value uint32) {
	volatile.StoreUint32(&o.ECC_SR2.Reg, volatile.LoadUint32(&o.ECC_SR2.Reg)&^(0x60000000)|value<<29)
}
func (o *EBI_Type) GetECC_SR2_ECCERR15() uint32 {
	return (volatile.LoadUint32(&o.ECC_SR2.Reg) & 0x60000000) >> 29
}

// EBI.ECC_PR2: SMC ECC parity 2 Register
func (o *EBI_Type) SetECC_PR2_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR2.Reg, volatile.LoadUint32(&o.ECC_PR2.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR2_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR2.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR2_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR2.Reg, volatile.LoadUint32(&o.ECC_PR2.Reg)&^(0xff8)|value<<3)
}
func (o *EBI_Type) GetECC_PR2_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR2.Reg) & 0xff8) >> 3
}
func (o *EBI_Type) SetECC_PR2_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR2.Reg, volatile.LoadUint32(&o.ECC_PR2.Reg)&^(0xfff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR2_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR2.Reg) & 0xfff000) >> 12
}

// EBI.ECC_PR3: SMC ECC parity 3 Register
func (o *EBI_Type) SetECC_PR3_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR3.Reg, volatile.LoadUint32(&o.ECC_PR3.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR3_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR3.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR3_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR3.Reg, volatile.LoadUint32(&o.ECC_PR3.Reg)&^(0xff8)|value<<3)
}
func (o *EBI_Type) GetECC_PR3_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR3.Reg) & 0xff8) >> 3
}
func (o *EBI_Type) SetECC_PR3_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR3.Reg, volatile.LoadUint32(&o.ECC_PR3.Reg)&^(0xfff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR3_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR3.Reg) & 0xfff000) >> 12
}

// EBI.ECC_PR4: SMC ECC parity 4 Register
func (o *EBI_Type) SetECC_PR4_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR4.Reg, volatile.LoadUint32(&o.ECC_PR4.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR4_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR4.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR4_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR4.Reg, volatile.LoadUint32(&o.ECC_PR4.Reg)&^(0xff8)|value<<3)
}
func (o *EBI_Type) GetECC_PR4_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR4.Reg) & 0xff8) >> 3
}
func (o *EBI_Type) SetECC_PR4_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR4.Reg, volatile.LoadUint32(&o.ECC_PR4.Reg)&^(0xfff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR4_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR4.Reg) & 0xfff000) >> 12
}

// EBI.ECC_PR5: SMC ECC parity 5 Register
func (o *EBI_Type) SetECC_PR5_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR5.Reg, volatile.LoadUint32(&o.ECC_PR5.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR5_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR5.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR5_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR5.Reg, volatile.LoadUint32(&o.ECC_PR5.Reg)&^(0xff8)|value<<3)
}
func (o *EBI_Type) GetECC_PR5_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR5.Reg) & 0xff8) >> 3
}
func (o *EBI_Type) SetECC_PR5_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR5.Reg, volatile.LoadUint32(&o.ECC_PR5.Reg)&^(0xfff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR5_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR5.Reg) & 0xfff000) >> 12
}

// EBI.ECC_PR6: SMC ECC parity 6 Register
func (o *EBI_Type) SetECC_PR6_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR6.Reg, volatile.LoadUint32(&o.ECC_PR6.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR6_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR6.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR6_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR6.Reg, volatile.LoadUint32(&o.ECC_PR6.Reg)&^(0xff8)|value<<3)
}
func (o *EBI_Type) GetECC_PR6_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR6.Reg) & 0xff8) >> 3
}
func (o *EBI_Type) SetECC_PR6_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR6.Reg, volatile.LoadUint32(&o.ECC_PR6.Reg)&^(0xfff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR6_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR6.Reg) & 0xfff000) >> 12
}

// EBI.ECC_PR7: SMC ECC parity 7 Register
func (o *EBI_Type) SetECC_PR7_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR7.Reg, volatile.LoadUint32(&o.ECC_PR7.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR7_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR7.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR7_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR7.Reg, volatile.LoadUint32(&o.ECC_PR7.Reg)&^(0xff8)|value<<3)
}
func (o *EBI_Type) GetECC_PR7_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR7.Reg) & 0xff8) >> 3
}
func (o *EBI_Type) SetECC_PR7_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR7.Reg, volatile.LoadUint32(&o.ECC_PR7.Reg)&^(0xfff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR7_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR7.Reg) & 0xfff000) >> 12
}

// EBI.ECC_PR8: SMC ECC parity 8 Register
func (o *EBI_Type) SetECC_PR8_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR8.Reg, volatile.LoadUint32(&o.ECC_PR8.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR8_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR8.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR8_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR8.Reg, volatile.LoadUint32(&o.ECC_PR8.Reg)&^(0x7f8)|value<<3)
}
func (o *EBI_Type) GetECC_PR8_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR8.Reg) & 0x7f8) >> 3
}
func (o *EBI_Type) SetECC_PR8_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR8.Reg, volatile.LoadUint32(&o.ECC_PR8.Reg)&^(0x7ff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR8_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR8.Reg) & 0x7ff000) >> 12
}

// EBI.ECC_PR9: SMC ECC parity 9 Register
func (o *EBI_Type) SetECC_PR9_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR9.Reg, volatile.LoadUint32(&o.ECC_PR9.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR9_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR9.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR9_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR9.Reg, volatile.LoadUint32(&o.ECC_PR9.Reg)&^(0x7f8)|value<<3)
}
func (o *EBI_Type) GetECC_PR9_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR9.Reg) & 0x7f8) >> 3
}
func (o *EBI_Type) SetECC_PR9_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR9.Reg, volatile.LoadUint32(&o.ECC_PR9.Reg)&^(0x7ff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR9_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR9.Reg) & 0x7ff000) >> 12
}

// EBI.ECC_PR10: SMC ECC parity 10 Register
func (o *EBI_Type) SetECC_PR10_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR10.Reg, volatile.LoadUint32(&o.ECC_PR10.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR10_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR10.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR10_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR10.Reg, volatile.LoadUint32(&o.ECC_PR10.Reg)&^(0x7f8)|value<<3)
}
func (o *EBI_Type) GetECC_PR10_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR10.Reg) & 0x7f8) >> 3
}
func (o *EBI_Type) SetECC_PR10_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR10.Reg, volatile.LoadUint32(&o.ECC_PR10.Reg)&^(0x7ff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR10_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR10.Reg) & 0x7ff000) >> 12
}

// EBI.ECC_PR11: SMC ECC parity 11 Register
func (o *EBI_Type) SetECC_PR11_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR11.Reg, volatile.LoadUint32(&o.ECC_PR11.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR11_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR11.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR11_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR11.Reg, volatile.LoadUint32(&o.ECC_PR11.Reg)&^(0x7f8)|value<<3)
}
func (o *EBI_Type) GetECC_PR11_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR11.Reg) & 0x7f8) >> 3
}
func (o *EBI_Type) SetECC_PR11_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR11.Reg, volatile.LoadUint32(&o.ECC_PR11.Reg)&^(0x7ff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR11_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR11.Reg) & 0x7ff000) >> 12
}

// EBI.ECC_PR12: SMC ECC parity 12 Register
func (o *EBI_Type) SetECC_PR12_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR12.Reg, volatile.LoadUint32(&o.ECC_PR12.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR12_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR12.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR12_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR12.Reg, volatile.LoadUint32(&o.ECC_PR12.Reg)&^(0x7f8)|value<<3)
}
func (o *EBI_Type) GetECC_PR12_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR12.Reg) & 0x7f8) >> 3
}
func (o *EBI_Type) SetECC_PR12_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR12.Reg, volatile.LoadUint32(&o.ECC_PR12.Reg)&^(0x7ff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR12_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR12.Reg) & 0x7ff000) >> 12
}

// EBI.ECC_PR13: SMC ECC parity 13 Register
func (o *EBI_Type) SetECC_PR13_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR13.Reg, volatile.LoadUint32(&o.ECC_PR13.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR13_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR13.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR13_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR13.Reg, volatile.LoadUint32(&o.ECC_PR13.Reg)&^(0x7f8)|value<<3)
}
func (o *EBI_Type) GetECC_PR13_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR13.Reg) & 0x7f8) >> 3
}
func (o *EBI_Type) SetECC_PR13_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR13.Reg, volatile.LoadUint32(&o.ECC_PR13.Reg)&^(0x7ff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR13_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR13.Reg) & 0x7ff000) >> 12
}

// EBI.ECC_PR14: SMC ECC parity 14 Register
func (o *EBI_Type) SetECC_PR14_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR14.Reg, volatile.LoadUint32(&o.ECC_PR14.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR14_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR14.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR14_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR14.Reg, volatile.LoadUint32(&o.ECC_PR14.Reg)&^(0x7f8)|value<<3)
}
func (o *EBI_Type) GetECC_PR14_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR14.Reg) & 0x7f8) >> 3
}
func (o *EBI_Type) SetECC_PR14_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR14.Reg, volatile.LoadUint32(&o.ECC_PR14.Reg)&^(0x7ff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR14_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR14.Reg) & 0x7ff000) >> 12
}

// EBI.ECC_PR15: SMC ECC parity 15 Register
func (o *EBI_Type) SetECC_PR15_BITADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR15.Reg, volatile.LoadUint32(&o.ECC_PR15.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetECC_PR15_BITADDR() uint32 {
	return volatile.LoadUint32(&o.ECC_PR15.Reg) & 0x7
}
func (o *EBI_Type) SetECC_PR15_WORDADDR(value uint32) {
	volatile.StoreUint32(&o.ECC_PR15.Reg, volatile.LoadUint32(&o.ECC_PR15.Reg)&^(0x7f8)|value<<3)
}
func (o *EBI_Type) GetECC_PR15_WORDADDR() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR15.Reg) & 0x7f8) >> 3
}
func (o *EBI_Type) SetECC_PR15_NPARITY(value uint32) {
	volatile.StoreUint32(&o.ECC_PR15.Reg, volatile.LoadUint32(&o.ECC_PR15.Reg)&^(0x7ff000)|value<<12)
}
func (o *EBI_Type) GetECC_PR15_NPARITY() uint32 {
	return (volatile.LoadUint32(&o.ECC_PR15.Reg) & 0x7ff000) >> 12
}

// EBI.SETUP0: SMC Setup Register (CS_number = 0)
func (o *EBI_Type) SetSETUP0_NWE_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP0.Reg, volatile.LoadUint32(&o.SETUP0.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetSETUP0_NWE_SETUP() uint32 {
	return volatile.LoadUint32(&o.SETUP0.Reg) & 0x3f
}
func (o *EBI_Type) SetSETUP0_NCS_WR_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP0.Reg, volatile.LoadUint32(&o.SETUP0.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetSETUP0_NCS_WR_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP0.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetSETUP0_NRD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP0.Reg, volatile.LoadUint32(&o.SETUP0.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetSETUP0_NRD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP0.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetSETUP0_NCS_RD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP0.Reg, volatile.LoadUint32(&o.SETUP0.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetSETUP0_NCS_RD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP0.Reg) & 0x3f000000) >> 24
}

// EBI.PULSE0: SMC Pulse Register (CS_number = 0)
func (o *EBI_Type) SetPULSE0_NWE_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE0.Reg, volatile.LoadUint32(&o.PULSE0.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetPULSE0_NWE_PULSE() uint32 {
	return volatile.LoadUint32(&o.PULSE0.Reg) & 0x3f
}
func (o *EBI_Type) SetPULSE0_NCS_WR_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE0.Reg, volatile.LoadUint32(&o.PULSE0.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetPULSE0_NCS_WR_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE0.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetPULSE0_NRD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE0.Reg, volatile.LoadUint32(&o.PULSE0.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetPULSE0_NRD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE0.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetPULSE0_NCS_RD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE0.Reg, volatile.LoadUint32(&o.PULSE0.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetPULSE0_NCS_RD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE0.Reg) & 0x3f000000) >> 24
}

// EBI.CYCLE0: SMC Cycle Register (CS_number = 0)
func (o *EBI_Type) SetCYCLE0_NWE_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE0.Reg, volatile.LoadUint32(&o.CYCLE0.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetCYCLE0_NWE_CYCLE() uint32 {
	return volatile.LoadUint32(&o.CYCLE0.Reg) & 0x1ff
}
func (o *EBI_Type) SetCYCLE0_NRD_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE0.Reg, volatile.LoadUint32(&o.CYCLE0.Reg)&^(0x1ff0000)|value<<16)
}
func (o *EBI_Type) GetCYCLE0_NRD_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CYCLE0.Reg) & 0x1ff0000) >> 16
}

// EBI.TIMINGS0: SMC Timings Register (CS_number = 0)
func (o *EBI_Type) SetTIMINGS0_TCLR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS0.Reg, volatile.LoadUint32(&o.TIMINGS0.Reg)&^(0xf)|value)
}
func (o *EBI_Type) GetTIMINGS0_TCLR() uint32 {
	return volatile.LoadUint32(&o.TIMINGS0.Reg) & 0xf
}
func (o *EBI_Type) SetTIMINGS0_TADL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS0.Reg, volatile.LoadUint32(&o.TIMINGS0.Reg)&^(0xf0)|value<<4)
}
func (o *EBI_Type) GetTIMINGS0_TADL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS0.Reg) & 0xf0) >> 4
}
func (o *EBI_Type) SetTIMINGS0_TAR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS0.Reg, volatile.LoadUint32(&o.TIMINGS0.Reg)&^(0xf00)|value<<8)
}
func (o *EBI_Type) GetTIMINGS0_TAR() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS0.Reg) & 0xf00) >> 8
}
func (o *EBI_Type) SetTIMINGS0_OCMS(value uint32) {
	volatile.StoreUint32(&o.TIMINGS0.Reg, volatile.LoadUint32(&o.TIMINGS0.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetTIMINGS0_OCMS() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS0.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetTIMINGS0_TRR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS0.Reg, volatile.LoadUint32(&o.TIMINGS0.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetTIMINGS0_TRR() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS0.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetTIMINGS0_TWB(value uint32) {
	volatile.StoreUint32(&o.TIMINGS0.Reg, volatile.LoadUint32(&o.TIMINGS0.Reg)&^(0xf000000)|value<<24)
}
func (o *EBI_Type) GetTIMINGS0_TWB() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS0.Reg) & 0xf000000) >> 24
}
func (o *EBI_Type) SetTIMINGS0_RBNSEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS0.Reg, volatile.LoadUint32(&o.TIMINGS0.Reg)&^(0x70000000)|value<<28)
}
func (o *EBI_Type) GetTIMINGS0_RBNSEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS0.Reg) & 0x70000000) >> 28
}
func (o *EBI_Type) SetTIMINGS0_NFSEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS0.Reg, volatile.LoadUint32(&o.TIMINGS0.Reg)&^(0x80000000)|value<<31)
}
func (o *EBI_Type) GetTIMINGS0_NFSEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS0.Reg) & 0x80000000) >> 31
}

// EBI.MODE0: SMC Mode Register (CS_number = 0)
func (o *EBI_Type) SetMODE0_READ_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetMODE0_READ_MODE() uint32 {
	return volatile.LoadUint32(&o.MODE0.Reg) & 0x1
}
func (o *EBI_Type) SetMODE0_WRITE_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetMODE0_WRITE_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetMODE0_EXNW_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x30)|value<<4)
}
func (o *EBI_Type) GetMODE0_EXNW_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0x30) >> 4
}
func (o *EBI_Type) SetMODE0_BAT(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x100)|value<<8)
}
func (o *EBI_Type) GetMODE0_BAT() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0x100) >> 8
}
func (o *EBI_Type) SetMODE0_DBW(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetMODE0_DBW() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetMODE0_TDF_CYCLES(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetMODE0_TDF_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetMODE0_TDF_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE0.Reg, volatile.LoadUint32(&o.MODE0.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetMODE0_TDF_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE0.Reg) & 0x100000) >> 20
}

// EBI.SETUP1: SMC Setup Register (CS_number = 1)
func (o *EBI_Type) SetSETUP1_NWE_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP1.Reg, volatile.LoadUint32(&o.SETUP1.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetSETUP1_NWE_SETUP() uint32 {
	return volatile.LoadUint32(&o.SETUP1.Reg) & 0x3f
}
func (o *EBI_Type) SetSETUP1_NCS_WR_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP1.Reg, volatile.LoadUint32(&o.SETUP1.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetSETUP1_NCS_WR_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP1.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetSETUP1_NRD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP1.Reg, volatile.LoadUint32(&o.SETUP1.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetSETUP1_NRD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP1.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetSETUP1_NCS_RD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP1.Reg, volatile.LoadUint32(&o.SETUP1.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetSETUP1_NCS_RD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP1.Reg) & 0x3f000000) >> 24
}

// EBI.PULSE1: SMC Pulse Register (CS_number = 1)
func (o *EBI_Type) SetPULSE1_NWE_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE1.Reg, volatile.LoadUint32(&o.PULSE1.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetPULSE1_NWE_PULSE() uint32 {
	return volatile.LoadUint32(&o.PULSE1.Reg) & 0x3f
}
func (o *EBI_Type) SetPULSE1_NCS_WR_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE1.Reg, volatile.LoadUint32(&o.PULSE1.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetPULSE1_NCS_WR_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE1.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetPULSE1_NRD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE1.Reg, volatile.LoadUint32(&o.PULSE1.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetPULSE1_NRD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE1.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetPULSE1_NCS_RD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE1.Reg, volatile.LoadUint32(&o.PULSE1.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetPULSE1_NCS_RD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE1.Reg) & 0x3f000000) >> 24
}

// EBI.CYCLE1: SMC Cycle Register (CS_number = 1)
func (o *EBI_Type) SetCYCLE1_NWE_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE1.Reg, volatile.LoadUint32(&o.CYCLE1.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetCYCLE1_NWE_CYCLE() uint32 {
	return volatile.LoadUint32(&o.CYCLE1.Reg) & 0x1ff
}
func (o *EBI_Type) SetCYCLE1_NRD_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE1.Reg, volatile.LoadUint32(&o.CYCLE1.Reg)&^(0x1ff0000)|value<<16)
}
func (o *EBI_Type) GetCYCLE1_NRD_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CYCLE1.Reg) & 0x1ff0000) >> 16
}

// EBI.TIMINGS1: SMC Timings Register (CS_number = 1)
func (o *EBI_Type) SetTIMINGS1_TCLR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS1.Reg, volatile.LoadUint32(&o.TIMINGS1.Reg)&^(0xf)|value)
}
func (o *EBI_Type) GetTIMINGS1_TCLR() uint32 {
	return volatile.LoadUint32(&o.TIMINGS1.Reg) & 0xf
}
func (o *EBI_Type) SetTIMINGS1_TADL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS1.Reg, volatile.LoadUint32(&o.TIMINGS1.Reg)&^(0xf0)|value<<4)
}
func (o *EBI_Type) GetTIMINGS1_TADL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS1.Reg) & 0xf0) >> 4
}
func (o *EBI_Type) SetTIMINGS1_TAR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS1.Reg, volatile.LoadUint32(&o.TIMINGS1.Reg)&^(0xf00)|value<<8)
}
func (o *EBI_Type) GetTIMINGS1_TAR() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS1.Reg) & 0xf00) >> 8
}
func (o *EBI_Type) SetTIMINGS1_OCMS(value uint32) {
	volatile.StoreUint32(&o.TIMINGS1.Reg, volatile.LoadUint32(&o.TIMINGS1.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetTIMINGS1_OCMS() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS1.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetTIMINGS1_TRR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS1.Reg, volatile.LoadUint32(&o.TIMINGS1.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetTIMINGS1_TRR() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS1.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetTIMINGS1_TWB(value uint32) {
	volatile.StoreUint32(&o.TIMINGS1.Reg, volatile.LoadUint32(&o.TIMINGS1.Reg)&^(0xf000000)|value<<24)
}
func (o *EBI_Type) GetTIMINGS1_TWB() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS1.Reg) & 0xf000000) >> 24
}
func (o *EBI_Type) SetTIMINGS1_RBNSEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS1.Reg, volatile.LoadUint32(&o.TIMINGS1.Reg)&^(0x70000000)|value<<28)
}
func (o *EBI_Type) GetTIMINGS1_RBNSEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS1.Reg) & 0x70000000) >> 28
}
func (o *EBI_Type) SetTIMINGS1_NFSEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS1.Reg, volatile.LoadUint32(&o.TIMINGS1.Reg)&^(0x80000000)|value<<31)
}
func (o *EBI_Type) GetTIMINGS1_NFSEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS1.Reg) & 0x80000000) >> 31
}

// EBI.MODE1: SMC Mode Register (CS_number = 1)
func (o *EBI_Type) SetMODE1_READ_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetMODE1_READ_MODE() uint32 {
	return volatile.LoadUint32(&o.MODE1.Reg) & 0x1
}
func (o *EBI_Type) SetMODE1_WRITE_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetMODE1_WRITE_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetMODE1_EXNW_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x30)|value<<4)
}
func (o *EBI_Type) GetMODE1_EXNW_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0x30) >> 4
}
func (o *EBI_Type) SetMODE1_BAT(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x100)|value<<8)
}
func (o *EBI_Type) GetMODE1_BAT() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0x100) >> 8
}
func (o *EBI_Type) SetMODE1_DBW(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetMODE1_DBW() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetMODE1_TDF_CYCLES(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetMODE1_TDF_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetMODE1_TDF_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE1.Reg, volatile.LoadUint32(&o.MODE1.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetMODE1_TDF_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE1.Reg) & 0x100000) >> 20
}

// EBI.SETUP2: SMC Setup Register (CS_number = 2)
func (o *EBI_Type) SetSETUP2_NWE_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP2.Reg, volatile.LoadUint32(&o.SETUP2.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetSETUP2_NWE_SETUP() uint32 {
	return volatile.LoadUint32(&o.SETUP2.Reg) & 0x3f
}
func (o *EBI_Type) SetSETUP2_NCS_WR_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP2.Reg, volatile.LoadUint32(&o.SETUP2.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetSETUP2_NCS_WR_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP2.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetSETUP2_NRD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP2.Reg, volatile.LoadUint32(&o.SETUP2.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetSETUP2_NRD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP2.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetSETUP2_NCS_RD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP2.Reg, volatile.LoadUint32(&o.SETUP2.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetSETUP2_NCS_RD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP2.Reg) & 0x3f000000) >> 24
}

// EBI.PULSE2: SMC Pulse Register (CS_number = 2)
func (o *EBI_Type) SetPULSE2_NWE_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE2.Reg, volatile.LoadUint32(&o.PULSE2.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetPULSE2_NWE_PULSE() uint32 {
	return volatile.LoadUint32(&o.PULSE2.Reg) & 0x3f
}
func (o *EBI_Type) SetPULSE2_NCS_WR_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE2.Reg, volatile.LoadUint32(&o.PULSE2.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetPULSE2_NCS_WR_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE2.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetPULSE2_NRD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE2.Reg, volatile.LoadUint32(&o.PULSE2.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetPULSE2_NRD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE2.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetPULSE2_NCS_RD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE2.Reg, volatile.LoadUint32(&o.PULSE2.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetPULSE2_NCS_RD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE2.Reg) & 0x3f000000) >> 24
}

// EBI.CYCLE2: SMC Cycle Register (CS_number = 2)
func (o *EBI_Type) SetCYCLE2_NWE_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE2.Reg, volatile.LoadUint32(&o.CYCLE2.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetCYCLE2_NWE_CYCLE() uint32 {
	return volatile.LoadUint32(&o.CYCLE2.Reg) & 0x1ff
}
func (o *EBI_Type) SetCYCLE2_NRD_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE2.Reg, volatile.LoadUint32(&o.CYCLE2.Reg)&^(0x1ff0000)|value<<16)
}
func (o *EBI_Type) GetCYCLE2_NRD_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CYCLE2.Reg) & 0x1ff0000) >> 16
}

// EBI.TIMINGS2: SMC Timings Register (CS_number = 2)
func (o *EBI_Type) SetTIMINGS2_TCLR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS2.Reg, volatile.LoadUint32(&o.TIMINGS2.Reg)&^(0xf)|value)
}
func (o *EBI_Type) GetTIMINGS2_TCLR() uint32 {
	return volatile.LoadUint32(&o.TIMINGS2.Reg) & 0xf
}
func (o *EBI_Type) SetTIMINGS2_TADL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS2.Reg, volatile.LoadUint32(&o.TIMINGS2.Reg)&^(0xf0)|value<<4)
}
func (o *EBI_Type) GetTIMINGS2_TADL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS2.Reg) & 0xf0) >> 4
}
func (o *EBI_Type) SetTIMINGS2_TAR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS2.Reg, volatile.LoadUint32(&o.TIMINGS2.Reg)&^(0xf00)|value<<8)
}
func (o *EBI_Type) GetTIMINGS2_TAR() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS2.Reg) & 0xf00) >> 8
}
func (o *EBI_Type) SetTIMINGS2_OCMS(value uint32) {
	volatile.StoreUint32(&o.TIMINGS2.Reg, volatile.LoadUint32(&o.TIMINGS2.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetTIMINGS2_OCMS() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS2.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetTIMINGS2_TRR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS2.Reg, volatile.LoadUint32(&o.TIMINGS2.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetTIMINGS2_TRR() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS2.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetTIMINGS2_TWB(value uint32) {
	volatile.StoreUint32(&o.TIMINGS2.Reg, volatile.LoadUint32(&o.TIMINGS2.Reg)&^(0xf000000)|value<<24)
}
func (o *EBI_Type) GetTIMINGS2_TWB() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS2.Reg) & 0xf000000) >> 24
}
func (o *EBI_Type) SetTIMINGS2_RBNSEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS2.Reg, volatile.LoadUint32(&o.TIMINGS2.Reg)&^(0x70000000)|value<<28)
}
func (o *EBI_Type) GetTIMINGS2_RBNSEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS2.Reg) & 0x70000000) >> 28
}
func (o *EBI_Type) SetTIMINGS2_NFSEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS2.Reg, volatile.LoadUint32(&o.TIMINGS2.Reg)&^(0x80000000)|value<<31)
}
func (o *EBI_Type) GetTIMINGS2_NFSEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS2.Reg) & 0x80000000) >> 31
}

// EBI.MODE2: SMC Mode Register (CS_number = 2)
func (o *EBI_Type) SetMODE2_READ_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetMODE2_READ_MODE() uint32 {
	return volatile.LoadUint32(&o.MODE2.Reg) & 0x1
}
func (o *EBI_Type) SetMODE2_WRITE_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetMODE2_WRITE_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetMODE2_EXNW_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x30)|value<<4)
}
func (o *EBI_Type) GetMODE2_EXNW_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0x30) >> 4
}
func (o *EBI_Type) SetMODE2_BAT(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x100)|value<<8)
}
func (o *EBI_Type) GetMODE2_BAT() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0x100) >> 8
}
func (o *EBI_Type) SetMODE2_DBW(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetMODE2_DBW() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetMODE2_TDF_CYCLES(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetMODE2_TDF_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetMODE2_TDF_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE2.Reg, volatile.LoadUint32(&o.MODE2.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetMODE2_TDF_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE2.Reg) & 0x100000) >> 20
}

// EBI.SETUP3: SMC Setup Register (CS_number = 3)
func (o *EBI_Type) SetSETUP3_NWE_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP3.Reg, volatile.LoadUint32(&o.SETUP3.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetSETUP3_NWE_SETUP() uint32 {
	return volatile.LoadUint32(&o.SETUP3.Reg) & 0x3f
}
func (o *EBI_Type) SetSETUP3_NCS_WR_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP3.Reg, volatile.LoadUint32(&o.SETUP3.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetSETUP3_NCS_WR_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP3.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetSETUP3_NRD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP3.Reg, volatile.LoadUint32(&o.SETUP3.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetSETUP3_NRD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP3.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetSETUP3_NCS_RD_SETUP(value uint32) {
	volatile.StoreUint32(&o.SETUP3.Reg, volatile.LoadUint32(&o.SETUP3.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetSETUP3_NCS_RD_SETUP() uint32 {
	return (volatile.LoadUint32(&o.SETUP3.Reg) & 0x3f000000) >> 24
}

// EBI.PULSE3: SMC Pulse Register (CS_number = 3)
func (o *EBI_Type) SetPULSE3_NWE_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE3.Reg, volatile.LoadUint32(&o.PULSE3.Reg)&^(0x3f)|value)
}
func (o *EBI_Type) GetPULSE3_NWE_PULSE() uint32 {
	return volatile.LoadUint32(&o.PULSE3.Reg) & 0x3f
}
func (o *EBI_Type) SetPULSE3_NCS_WR_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE3.Reg, volatile.LoadUint32(&o.PULSE3.Reg)&^(0x3f00)|value<<8)
}
func (o *EBI_Type) GetPULSE3_NCS_WR_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE3.Reg) & 0x3f00) >> 8
}
func (o *EBI_Type) SetPULSE3_NRD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE3.Reg, volatile.LoadUint32(&o.PULSE3.Reg)&^(0x3f0000)|value<<16)
}
func (o *EBI_Type) GetPULSE3_NRD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE3.Reg) & 0x3f0000) >> 16
}
func (o *EBI_Type) SetPULSE3_NCS_RD_PULSE(value uint32) {
	volatile.StoreUint32(&o.PULSE3.Reg, volatile.LoadUint32(&o.PULSE3.Reg)&^(0x3f000000)|value<<24)
}
func (o *EBI_Type) GetPULSE3_NCS_RD_PULSE() uint32 {
	return (volatile.LoadUint32(&o.PULSE3.Reg) & 0x3f000000) >> 24
}

// EBI.CYCLE3: SMC Cycle Register (CS_number = 3)
func (o *EBI_Type) SetCYCLE3_NWE_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE3.Reg, volatile.LoadUint32(&o.CYCLE3.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetCYCLE3_NWE_CYCLE() uint32 {
	return volatile.LoadUint32(&o.CYCLE3.Reg) & 0x1ff
}
func (o *EBI_Type) SetCYCLE3_NRD_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CYCLE3.Reg, volatile.LoadUint32(&o.CYCLE3.Reg)&^(0x1ff0000)|value<<16)
}
func (o *EBI_Type) GetCYCLE3_NRD_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CYCLE3.Reg) & 0x1ff0000) >> 16
}

// EBI.TIMINGS3: SMC Timings Register (CS_number = 3)
func (o *EBI_Type) SetTIMINGS3_TCLR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS3.Reg, volatile.LoadUint32(&o.TIMINGS3.Reg)&^(0xf)|value)
}
func (o *EBI_Type) GetTIMINGS3_TCLR() uint32 {
	return volatile.LoadUint32(&o.TIMINGS3.Reg) & 0xf
}
func (o *EBI_Type) SetTIMINGS3_TADL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS3.Reg, volatile.LoadUint32(&o.TIMINGS3.Reg)&^(0xf0)|value<<4)
}
func (o *EBI_Type) GetTIMINGS3_TADL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS3.Reg) & 0xf0) >> 4
}
func (o *EBI_Type) SetTIMINGS3_TAR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS3.Reg, volatile.LoadUint32(&o.TIMINGS3.Reg)&^(0xf00)|value<<8)
}
func (o *EBI_Type) GetTIMINGS3_TAR() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS3.Reg) & 0xf00) >> 8
}
func (o *EBI_Type) SetTIMINGS3_OCMS(value uint32) {
	volatile.StoreUint32(&o.TIMINGS3.Reg, volatile.LoadUint32(&o.TIMINGS3.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetTIMINGS3_OCMS() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS3.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetTIMINGS3_TRR(value uint32) {
	volatile.StoreUint32(&o.TIMINGS3.Reg, volatile.LoadUint32(&o.TIMINGS3.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetTIMINGS3_TRR() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS3.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetTIMINGS3_TWB(value uint32) {
	volatile.StoreUint32(&o.TIMINGS3.Reg, volatile.LoadUint32(&o.TIMINGS3.Reg)&^(0xf000000)|value<<24)
}
func (o *EBI_Type) GetTIMINGS3_TWB() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS3.Reg) & 0xf000000) >> 24
}
func (o *EBI_Type) SetTIMINGS3_RBNSEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS3.Reg, volatile.LoadUint32(&o.TIMINGS3.Reg)&^(0x70000000)|value<<28)
}
func (o *EBI_Type) GetTIMINGS3_RBNSEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS3.Reg) & 0x70000000) >> 28
}
func (o *EBI_Type) SetTIMINGS3_NFSEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGS3.Reg, volatile.LoadUint32(&o.TIMINGS3.Reg)&^(0x80000000)|value<<31)
}
func (o *EBI_Type) GetTIMINGS3_NFSEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGS3.Reg) & 0x80000000) >> 31
}

// EBI.MODE3: SMC Mode Register (CS_number = 3)
func (o *EBI_Type) SetMODE3_READ_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetMODE3_READ_MODE() uint32 {
	return volatile.LoadUint32(&o.MODE3.Reg) & 0x1
}
func (o *EBI_Type) SetMODE3_WRITE_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetMODE3_WRITE_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetMODE3_EXNW_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x30)|value<<4)
}
func (o *EBI_Type) GetMODE3_EXNW_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0x30) >> 4
}
func (o *EBI_Type) SetMODE3_BAT(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x100)|value<<8)
}
func (o *EBI_Type) GetMODE3_BAT() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0x100) >> 8
}
func (o *EBI_Type) SetMODE3_DBW(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetMODE3_DBW() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetMODE3_TDF_CYCLES(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetMODE3_TDF_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetMODE3_TDF_MODE(value uint32) {
	volatile.StoreUint32(&o.MODE3.Reg, volatile.LoadUint32(&o.MODE3.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetMODE3_TDF_MODE() uint32 {
	return (volatile.LoadUint32(&o.MODE3.Reg) & 0x100000) >> 20
}

// EBI.OCMS: SMC OCMS Register
func (o *EBI_Type) SetOCMS_SMSE(value uint32) {
	volatile.StoreUint32(&o.OCMS.Reg, volatile.LoadUint32(&o.OCMS.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetOCMS_SMSE() uint32 {
	return volatile.LoadUint32(&o.OCMS.Reg) & 0x1
}
func (o *EBI_Type) SetOCMS_SRSE(value uint32) {
	volatile.StoreUint32(&o.OCMS.Reg, volatile.LoadUint32(&o.OCMS.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetOCMS_SRSE() uint32 {
	return (volatile.LoadUint32(&o.OCMS.Reg) & 0x2) >> 1
}

// EBI.KEY1: SMC OCMS KEY1 Register
func (o *EBI_Type) SetKEY1(value uint32) {
	volatile.StoreUint32(&o.KEY1.Reg, value)
}
func (o *EBI_Type) GetKEY1() uint32 {
	return volatile.LoadUint32(&o.KEY1.Reg)
}

// EBI.KEY2: SMC OCMS KEY2 Register
func (o *EBI_Type) SetKEY2(value uint32) {
	volatile.StoreUint32(&o.KEY2.Reg, value)
}
func (o *EBI_Type) GetKEY2() uint32 {
	return volatile.LoadUint32(&o.KEY2.Reg)
}

// EBI.WPCR: Write Protection Control Register
func (o *EBI_Type) SetWPCR_WP_EN(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetWPCR_WP_EN() uint32 {
	return volatile.LoadUint32(&o.WPCR.Reg) & 0x1
}
func (o *EBI_Type) SetWPCR_WP_KEY(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *EBI_Type) GetWPCR_WP_KEY() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0xffffff00) >> 8
}

// EBI.WPSR: Write Protection Status Register
func (o *EBI_Type) SetWPSR_WP_VS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xf)|value)
}
func (o *EBI_Type) GetWPSR_WP_VS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0xf
}
func (o *EBI_Type) SetWPSR_WP_VSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *EBI_Type) GetWPSR_WP_VSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG  [5]volatile.Register32 // 0x0
	_     [44]byte
	SCFG  [10]volatile.Register32 // 0x40
	_     [24]byte
	PRAS0 volatile.Register32 // 0x80
	_     [4]byte
	PRAS1 volatile.Register32 // 0x88
	_     [4]byte
	PRAS2 volatile.Register32 // 0x90
	_     [4]byte
	PRAS3 volatile.Register32 // 0x98
	_     [4]byte
	PRAS4 volatile.Register32 // 0xA0
	_     [4]byte
	PRAS5 volatile.Register32 // 0xA8
	_     [4]byte
	PRAS6 volatile.Register32 // 0xB0
	_     [4]byte
	PRAS7 volatile.Register32 // 0xB8
	_     [4]byte
	PRAS8 volatile.Register32 // 0xC0
	_     [4]byte
	PRAS9 volatile.Register32 // 0xC8
	_     [52]byte
	MRCR  volatile.Register32 // 0x100
	_     [224]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// MATRIX.MCFG: Master Configuration Register
func (o *MATRIX_Type) SetMCFG_ULBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MCFG[idx].Reg, volatile.LoadUint32(&o.MCFG[idx].Reg)&^(0x7)|value)
}
func (o *MATRIX_Type) GetMCFG_ULBT(idx int) uint32 {
	return volatile.LoadUint32(&o.MCFG[idx].Reg) & 0x7
}

// MATRIX.SCFG: Slave Configuration Register
func (o *MATRIX_Type) SetSCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0xff)|value)
}
func (o *MATRIX_Type) GetSCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.SCFG[idx].Reg) & 0xff
}
func (o *MATRIX_Type) SetSCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetSCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetSCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x1c0000)|value<<18)
}
func (o *MATRIX_Type) GetSCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x1c0000) >> 18
}
func (o *MATRIX_Type) SetSCFG_ARBT(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetSCFG_ARBT(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x3000000) >> 24
}

// MATRIX.PRAS0: Priority Register A for Slave 0
func (o *MATRIX_Type) SetPRAS0_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS0_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS0.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS0_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS0_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS0_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS0_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS0_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS0_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS0_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS0_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x30000) >> 16
}

// MATRIX.PRAS1: Priority Register A for Slave 1
func (o *MATRIX_Type) SetPRAS1_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS1_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS1.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS1_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS1_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS1_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS1_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS1_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS1_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS1_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS1_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x30000) >> 16
}

// MATRIX.PRAS2: Priority Register A for Slave 2
func (o *MATRIX_Type) SetPRAS2_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS2_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS2.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS2_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS2_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS2_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS2_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS2_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS2_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS2_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS2_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x30000) >> 16
}

// MATRIX.PRAS3: Priority Register A for Slave 3
func (o *MATRIX_Type) SetPRAS3_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS3_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS3.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS3_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS3_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS3_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS3_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS3_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS3_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS3_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS3_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x30000) >> 16
}

// MATRIX.PRAS4: Priority Register A for Slave 4
func (o *MATRIX_Type) SetPRAS4_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS4_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS4.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS4_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS4_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS4_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS4_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS4_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS4_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS4_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS4_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x30000) >> 16
}

// MATRIX.PRAS5: Priority Register A for Slave 5
func (o *MATRIX_Type) SetPRAS5_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS5_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS5.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS5_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS5_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS5_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS5_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS5_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS5_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS5_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS5_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x30000) >> 16
}

// MATRIX.PRAS6: Priority Register A for Slave 6
func (o *MATRIX_Type) SetPRAS6_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS6_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS6.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS6_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS6_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS6_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS6_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS6_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS6_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS6_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS6_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x30000) >> 16
}

// MATRIX.PRAS7: Priority Register A for Slave 7
func (o *MATRIX_Type) SetPRAS7_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS7_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS7.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS7_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS7_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS7_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS7_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS7_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS7_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS7_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS7_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x30000) >> 16
}

// MATRIX.PRAS8: Priority Register A for Slave 8
func (o *MATRIX_Type) SetPRAS8_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS8_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS8.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS8_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS8_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS8_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS8_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS8_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS8_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS8_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS8.Reg, volatile.LoadUint32(&o.PRAS8.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS8_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS8.Reg) & 0x30000) >> 16
}

// MATRIX.PRAS9: Priority Register A for Slave 9
func (o *MATRIX_Type) SetPRAS9_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS9_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS9.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS9_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS9_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS9_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS9_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS9_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS9_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS9_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS9.Reg, volatile.LoadUint32(&o.PRAS9.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS9_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS9.Reg) & 0x30000) >> 16
}

// MATRIX.MRCR: Master Remap Control Register
func (o *MATRIX_Type) SetMRCR_RCB0(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMRCR_RCB0() uint32 {
	return volatile.LoadUint32(&o.MRCR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMRCR_RCB1(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetMRCR_RCB1() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetMRCR_RCB2(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetMRCR_RCB2() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetMRCR_RCB3(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetMRCR_RCB3() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetMRCR_RCB4(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetMRCR_RCB4() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x10) >> 4
}

// MATRIX.WPMR: Write Protect Mode Register
func (o *MATRIX_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// MATRIX.WPSR: Write Protect Status Register
func (o *MATRIX_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER   volatile.Register32 // 0x0
	PMC_SCDR   volatile.Register32 // 0x4
	PMC_SCSR   volatile.Register32 // 0x8
	_          [4]byte
	PMC_PCER0  volatile.Register32 // 0x10
	PMC_PCDR0  volatile.Register32 // 0x14
	PMC_PCSR0  volatile.Register32 // 0x18
	CKGR_UCKR  volatile.Register32 // 0x1C
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	_          [4]byte
	PMC_MCKR   volatile.Register32 // 0x30
	_          [12]byte
	PMC_PCK    [3]volatile.Register32 // 0x40
	_          [20]byte
	PMC_IER    volatile.Register32 // 0x60
	PMC_IDR    volatile.Register32 // 0x64
	PMC_SR     volatile.Register32 // 0x68
	PMC_IMR    volatile.Register32 // 0x6C
	PMC_FSMR   volatile.Register32 // 0x70
	PMC_FSPR   volatile.Register32 // 0x74
	PMC_FOCR   volatile.Register32 // 0x78
	_          [104]byte
	PMC_WPMR   volatile.Register32 // 0xE4
	PMC_WPSR   volatile.Register32 // 0xE8
}

// PMC.PMC_SCER: System Clock Enable Register
func (o *PMC_Type) SetPMC_SCER_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCER_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCER_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCER_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCER_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCER_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x400) >> 10
}

// PMC.PMC_SCDR: System Clock Disable Register
func (o *PMC_Type) SetPMC_SCDR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCDR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCDR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCDR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCDR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCDR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x400) >> 10
}

// PMC.PMC_SCSR: System Clock Status Register
func (o *PMC_Type) SetPMC_SCSR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCSR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCSR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCSR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCSR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCSR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x400) >> 10
}

// PMC.PMC_PCER0: Peripheral Clock Enable Register 0
func (o *PMC_Type) SetPMC_PCER0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCER0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCER0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCER0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCER0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCER0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCER0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCER0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCER0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCER0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCER0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCER0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCER0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCER0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCER0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCER0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCER0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCER0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCER0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCER0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCER0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCER0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCER0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCER0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCER0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCER0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCER0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCER0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCER0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCER0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCER0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCER0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCER0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCER0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCER0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCER0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCER0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCER0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCER0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCER0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCER0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCER0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x20000000) >> 29
}

// PMC.PMC_PCDR0: Peripheral Clock Disable Register 0
func (o *PMC_Type) SetPMC_PCDR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCDR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCDR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCDR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCDR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCDR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCDR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCDR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCDR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCDR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCDR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCDR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCDR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCDR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCDR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCDR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCDR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCDR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCDR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCDR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCDR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCDR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCDR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCDR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCDR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCDR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCDR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCDR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCDR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCDR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCDR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCDR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCDR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCDR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCDR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCDR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCDR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCDR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCDR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCDR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCDR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCDR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x20000000) >> 29
}

// PMC.PMC_PCSR0: Peripheral Clock Status Register 0
func (o *PMC_Type) SetPMC_PCSR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCSR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCSR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCSR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCSR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCSR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCSR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCSR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCSR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCSR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCSR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCSR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCSR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCSR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCSR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCSR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCSR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCSR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCSR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCSR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCSR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCSR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCSR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCSR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCSR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCSR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCSR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCSR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCSR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCSR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCSR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCSR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCSR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCSR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCSR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCSR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCSR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCSR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCSR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCSR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCSR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCSR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x20000000) >> 29
}

// PMC.CKGR_UCKR: UTMI Clock Register
func (o *PMC_Type) SetCKGR_UCKR_UPLLEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_UCKR.Reg, volatile.LoadUint32(&o.CKGR_UCKR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_UCKR_UPLLEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_UCKR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetCKGR_UCKR_UPLLCOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_UCKR.Reg, volatile.LoadUint32(&o.CKGR_UCKR.Reg)&^(0xf00000)|value<<20)
}
func (o *PMC_Type) GetCKGR_UCKR_UPLLCOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_UCKR.Reg) & 0xf00000) >> 20
}

// PMC.CKGR_MOR: Main Oscillator Register
func (o *PMC_Type) SetCKGR_MOR_MOSCXTEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTEN() uint32 {
	return volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTBY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTBY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCF() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTST(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff00)|value<<8)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTST() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff00) >> 8
}
func (o *PMC_Type) SetCKGR_MOR_KEY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MOR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff0000) >> 16
}
func (o *PMC_Type) SetCKGR_MOR_MOSCSEL(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCSEL() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetCKGR_MOR_CFDEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetCKGR_MOR_CFDEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2000000) >> 25
}

// PMC.CKGR_MCFR: Main Clock Frequency Register
func (o *PMC_Type) SetCKGR_MCFR_MAINF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0xffff)|value)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINF() uint32 {
	return volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0xffff
}
func (o *PMC_Type) SetCKGR_MCFR_MAINFRDY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINFRDY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x10000) >> 16
}

// PMC.CKGR_PLLAR: PLLA Register
func (o *PMC_Type) SetCKGR_PLLAR_DIVA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0xff)|value)
}
func (o *PMC_Type) GetCKGR_PLLAR_DIVA() uint32 {
	return volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0xff
}
func (o *PMC_Type) SetCKGR_PLLAR_PLLACOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x3f00)|value<<8)
}
func (o *PMC_Type) GetCKGR_PLLAR_PLLACOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x3f00) >> 8
}
func (o *PMC_Type) SetCKGR_PLLAR_MULA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_PLLAR_MULA() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x7ff0000) >> 16
}
func (o *PMC_Type) SetCKGR_PLLAR_ONE(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetCKGR_PLLAR_ONE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x20000000) >> 29
}

// PMC.PMC_MCKR: Master Clock Register
func (o *PMC_Type) SetPMC_MCKR_CSS(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetPMC_MCKR_CSS() uint32 {
	return volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x3
}
func (o *PMC_Type) SetPMC_MCKR_PRES(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetPMC_MCKR_PRES() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetPMC_MCKR_PLLADIV2(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_MCKR_PLLADIV2() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_MCKR_UPLLDIV2(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_MCKR_UPLLDIV2() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x2000) >> 13
}

// PMC.PMC_PCK: Programmable Clock 0 Register
func (o *PMC_Type) SetPMC_PCK_CSS(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x7)|value)
}
func (o *PMC_Type) GetPMC_PCK_CSS(idx int) uint32 {
	return volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x7
}
func (o *PMC_Type) SetPMC_PCK_PRES(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetPMC_PCK_PRES(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x70) >> 4
}

// PMC.PMC_IER: Interrupt Enable Register
func (o *PMC_Type) SetPMC_IER_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IER_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IER.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IER_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IER_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IER_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IER_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IER_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_IER_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_IER_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IER_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IER_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IER_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IER_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IER_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IER_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IER_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IER_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x40000) >> 18
}

// PMC.PMC_IDR: Interrupt Disable Register
func (o *PMC_Type) SetPMC_IDR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IDR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IDR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IDR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IDR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IDR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IDR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_IDR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IDR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IDR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IDR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IDR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IDR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IDR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x40000) >> 18
}

// PMC.PMC_SR: Status Register
func (o *PMC_Type) SetPMC_SR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_SR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_SR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_SR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_SR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_SR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_SR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_SR_OSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SR_OSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SR_CFDS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SR_CFDS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SR_FOS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SR_FOS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100000) >> 20
}

// PMC.PMC_IMR: Interrupt Mask Register
func (o *PMC_Type) SetPMC_IMR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IMR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IMR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IMR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IMR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IMR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IMR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_IMR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IMR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IMR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IMR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IMR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IMR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IMR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x40000) >> 18
}

// PMC.PMC_FSMR: Fast Start-up Mode Register
func (o *PMC_Type) SetPMC_FSMR_FSTT0(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT0() uint32 {
	return volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_FSMR_FSTT1(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT1() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_FSMR_FSTT2(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT2() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_FSMR_FSTT3(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT3() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_FSMR_FSTT4(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT4() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_FSMR_FSTT5(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT5() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_FSMR_FSTT6(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT6() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_FSMR_FSTT7(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT7() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_FSMR_FSTT8(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT8() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_FSMR_FSTT9(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT9() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_FSMR_FSTT10(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT10() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_FSMR_FSTT11(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT11() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_FSMR_FSTT12(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT12() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_FSMR_FSTT13(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT13() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_FSMR_FSTT14(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT14() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_FSMR_FSTT15(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT15() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_FSMR_RTTAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_FSMR_RTTAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_FSMR_RTCAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_FSMR_RTCAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_FSMR_USBAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_FSMR_USBAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_FSMR_LPM(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_FSMR_LPM() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x100000) >> 20
}

// PMC.PMC_FSPR: Fast Start-up Polarity Register
func (o *PMC_Type) SetPMC_FSPR_FSTP0(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP0() uint32 {
	return volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_FSPR_FSTP1(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP1() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_FSPR_FSTP2(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP2() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_FSPR_FSTP3(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP3() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_FSPR_FSTP4(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP4() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_FSPR_FSTP5(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP5() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_FSPR_FSTP6(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP6() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_FSPR_FSTP7(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP7() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_FSPR_FSTP8(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP8() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_FSPR_FSTP9(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP9() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_FSPR_FSTP10(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP10() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_FSPR_FSTP11(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP11() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_FSPR_FSTP12(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP12() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_FSPR_FSTP13(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP13() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_FSPR_FSTP14(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP14() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_FSPR_FSTP15(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP15() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x8000) >> 15
}

// PMC.PMC_FOCR: Fault Output Clear Register
func (o *PMC_Type) SetPMC_FOCR_FOCLR(value uint32) {
	volatile.StoreUint32(&o.PMC_FOCR.Reg, volatile.LoadUint32(&o.PMC_FOCR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FOCR_FOCLR() uint32 {
	return volatile.LoadUint32(&o.PMC_FOCR.Reg) & 0x1
}

// PMC.PMC_WPMR: Write Protect Mode Register
func (o *PMC_Type) SetPMC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.PMC_WPMR.Reg, volatile.LoadUint32(&o.PMC_WPMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.PMC_WPMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.PMC_WPMR.Reg, volatile.LoadUint32(&o.PMC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PMC_Type) GetPMC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.PMC_WPMR.Reg) & 0xffffff00) >> 8
}

// PMC.PMC_WPSR: Write Protect Status Register
func (o *PMC_Type) SetPMC_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.PMC_WPSR.Reg, volatile.LoadUint32(&o.PMC_WPSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.PMC_WPSR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.PMC_WPSR.Reg, volatile.LoadUint32(&o.PMC_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PMC_Type) GetPMC_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.PMC_WPSR.Reg) & 0xffff00) >> 8
}

// Universal Asynchronous Receiver Transmitter
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [220]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// UART.CR: Control Register
func (o *UART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// UART.MR: Mode Register
func (o *UART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *UART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *UART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *UART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// UART.IER: Interrupt Enable Register
func (o *UART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}

// UART.IDR: Interrupt Disable Register
func (o *UART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}

// UART.IMR: Interrupt Mask Register
func (o *UART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}

// UART.SR: Status Register
func (o *UART_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UART_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}

// UART.RHR: Receive Holding Register
func (o *UART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// UART.THR: Transmit Holding Register
func (o *UART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// UART.BRGR: Baud Rate Generator Register
func (o *UART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// UART.RPR: Receive Pointer Register
func (o *UART_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *UART_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// UART.RCR: Receive Counter Register
func (o *UART_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// UART.TPR: Transmit Pointer Register
func (o *UART_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *UART_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// UART.TCR: Transmit Counter Register
func (o *UART_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// UART.RNPR: Receive Next Pointer Register
func (o *UART_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *UART_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// UART.RNCR: Receive Next Counter Register
func (o *UART_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// UART.TNPR: Transmit Next Pointer Register
func (o *UART_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *UART_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// UART.TNCR: Transmit Next Counter Register
func (o *UART_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// UART.PTCR: Transfer Control Register
func (o *UART_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *UART_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *UART_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// UART.PTSR: Transfer Status Register
func (o *UART_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *UART_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Chip Identifier
type CHIPID_Type struct {
	CIDR volatile.Register32 // 0x0
	EXID volatile.Register32 // 0x4
}

// CHIPID.CIDR: Chip ID Register
func (o *CHIPID_Type) SetCIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x1f)|value)
}
func (o *CHIPID_Type) GetCIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CIDR.Reg) & 0x1f
}
func (o *CHIPID_Type) SetCIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *CHIPID_Type) GetCIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xe0) >> 5
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf00) >> 8
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf000) >> 12
}
func (o *CHIPID_Type) SetCIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *CHIPID_Type) GetCIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf0000) >> 16
}
func (o *CHIPID_Type) SetCIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *CHIPID_Type) GetCIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xff00000) >> 20
}
func (o *CHIPID_Type) SetCIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *CHIPID_Type) GetCIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x70000000) >> 28
}
func (o *CHIPID_Type) SetCIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *CHIPID_Type) GetCIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x80000000) >> 31
}

// CHIPID.EXID: Chip ID Extension Register
func (o *CHIPID_Type) SetEXID(value uint32) {
	volatile.StoreUint32(&o.EXID.Reg, value)
}
func (o *CHIPID_Type) GetEXID() uint32 {
	return volatile.LoadUint32(&o.EXID.Reg)
}

// Embedded Flash Controller 0
type EFC_Type struct {
	FMR volatile.Register32 // 0x0
	FCR volatile.Register32 // 0x4
	FSR volatile.Register32 // 0x8
	FRR volatile.Register32 // 0xC
}

// EFC.FMR: EEFC Flash Mode Register
func (o *EFC_Type) SetFMR_FRDY(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetFMR_FRDY() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}
func (o *EFC_Type) SetFMR_FWS(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xf00)|value<<8)
}
func (o *EFC_Type) GetFMR_FWS() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xf00) >> 8
}
func (o *EFC_Type) SetFMR_SCOD(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x10000)|value<<16)
}
func (o *EFC_Type) GetFMR_SCOD() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x10000) >> 16
}
func (o *EFC_Type) SetFMR_FAM(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1000000)|value<<24)
}
func (o *EFC_Type) GetFMR_FAM() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x1000000) >> 24
}

// EFC.FCR: EEFC Flash Command Register
func (o *EFC_Type) SetFCR_FCMD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *EFC_Type) GetFCR_FCMD() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}
func (o *EFC_Type) SetFCR_FARG(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xffff00)|value<<8)
}
func (o *EFC_Type) GetFCR_FARG() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xffff00) >> 8
}
func (o *EFC_Type) SetFCR_FKEY(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff000000)|value<<24)
}
func (o *EFC_Type) GetFCR_FKEY() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xff000000) >> 24
}

// EFC.FSR: EEFC Flash Status Register
func (o *EFC_Type) SetFSR_FRDY(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetFSR_FRDY() uint32 {
	return volatile.LoadUint32(&o.FSR.Reg) & 0x1
}
func (o *EFC_Type) SetFSR_FCMDE(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x2)|value<<1)
}
func (o *EFC_Type) GetFSR_FCMDE() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0x2) >> 1
}
func (o *EFC_Type) SetFSR_FLOCKE(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x4)|value<<2)
}
func (o *EFC_Type) GetFSR_FLOCKE() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0x4) >> 2
}

// EFC.FRR: EEFC Flash Result Register
func (o *EFC_Type) SetFRR(value uint32) {
	volatile.StoreUint32(&o.FRR.Reg, value)
}
func (o *EFC_Type) GetFRR() uint32 {
	return volatile.LoadUint32(&o.FRR.Reg)
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER    volatile.Register32 // 0x0
	PDR    volatile.Register32 // 0x4
	PSR    volatile.Register32 // 0x8
	_      [4]byte
	OER    volatile.Register32 // 0x10
	ODR    volatile.Register32 // 0x14
	OSR    volatile.Register32 // 0x18
	_      [4]byte
	IFER   volatile.Register32 // 0x20
	IFDR   volatile.Register32 // 0x24
	IFSR   volatile.Register32 // 0x28
	_      [4]byte
	SODR   volatile.Register32 // 0x30
	CODR   volatile.Register32 // 0x34
	ODSR   volatile.Register32 // 0x38
	PDSR   volatile.Register32 // 0x3C
	IER    volatile.Register32 // 0x40
	IDR    volatile.Register32 // 0x44
	IMR    volatile.Register32 // 0x48
	ISR    volatile.Register32 // 0x4C
	MDER   volatile.Register32 // 0x50
	MDDR   volatile.Register32 // 0x54
	MDSR   volatile.Register32 // 0x58
	_      [4]byte
	PUDR   volatile.Register32 // 0x60
	PUER   volatile.Register32 // 0x64
	PUSR   volatile.Register32 // 0x68
	_      [4]byte
	ABSR   volatile.Register32 // 0x70
	_      [12]byte
	SCIFSR volatile.Register32 // 0x80
	DIFSR  volatile.Register32 // 0x84
	IFDGSR volatile.Register32 // 0x88
	SCDR   volatile.Register32 // 0x8C
	_      [16]byte
	OWER   volatile.Register32 // 0xA0
	OWDR   volatile.Register32 // 0xA4
	OWSR   volatile.Register32 // 0xA8
	_      [4]byte
	AIMER  volatile.Register32 // 0xB0
	AIMDR  volatile.Register32 // 0xB4
	AIMMR  volatile.Register32 // 0xB8
	_      [4]byte
	ESR    volatile.Register32 // 0xC0
	LSR    volatile.Register32 // 0xC4
	ELSR   volatile.Register32 // 0xC8
	_      [4]byte
	FELLSR volatile.Register32 // 0xD0
	REHLSR volatile.Register32 // 0xD4
	FRLHSR volatile.Register32 // 0xD8
	_      [4]byte
	LOCKSR volatile.Register32 // 0xE0
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// PIO.PER: PIO Enable Register
func (o *PIO_Type) SetPER_P0(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPER_P0() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0x1
}
func (o *PIO_Type) SetPER_P1(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPER_P1() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPER_P2(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPER_P2() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPER_P3(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPER_P3() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPER_P4(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPER_P4() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPER_P5(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPER_P5() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPER_P6(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPER_P6() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPER_P7(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPER_P7() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPER_P8(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPER_P8() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPER_P9(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPER_P9() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPER_P10(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPER_P10() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPER_P11(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPER_P11() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPER_P12(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPER_P12() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPER_P13(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPER_P13() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPER_P14(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPER_P14() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPER_P15(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPER_P15() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPER_P16(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPER_P16() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPER_P17(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPER_P17() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPER_P18(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPER_P18() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPER_P19(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPER_P19() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPER_P20(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPER_P20() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPER_P21(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPER_P21() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPER_P22(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPER_P22() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPER_P23(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPER_P23() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPER_P24(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPER_P24() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPER_P25(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPER_P25() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPER_P26(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPER_P26() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPER_P27(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPER_P27() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPER_P28(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPER_P28() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPER_P29(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPER_P29() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPER_P30(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPER_P30() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPER_P31(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPER_P31() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000000) >> 31
}

// PIO.PDR: PIO Disable Register
func (o *PIO_Type) SetPDR_P0(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDR_P0() uint32 {
	return volatile.LoadUint32(&o.PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPDR_P1(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDR_P2(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDR_P3(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDR_P4(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDR_P5(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDR_P6(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDR_P7(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDR_P8(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDR_P9(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDR_P10(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDR_P11(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDR_P12(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDR_P13(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDR_P14(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDR_P15(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDR_P16(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDR_P17(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDR_P18(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDR_P19(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDR_P20(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDR_P21(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDR_P22(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDR_P23(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDR_P24(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDR_P25(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDR_P26(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDR_P27(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDR_P28(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDR_P29(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDR_P30(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDR_P31(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000000) >> 31
}

// PIO.PSR: PIO Status Register
func (o *PIO_Type) SetPSR_P0(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPSR_P0() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPSR_P1(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPSR_P2(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPSR_P3(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPSR_P4(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPSR_P5(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPSR_P6(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPSR_P7(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPSR_P8(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPSR_P9(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPSR_P10(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPSR_P11(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPSR_P12(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPSR_P13(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPSR_P14(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPSR_P15(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPSR_P16(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPSR_P17(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPSR_P18(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPSR_P19(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPSR_P20(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPSR_P21(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPSR_P22(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPSR_P23(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPSR_P24(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPSR_P25(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPSR_P26(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPSR_P27(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPSR_P28(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPSR_P29(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPSR_P30(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPSR_P31(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000000) >> 31
}

// PIO.OER: Output Enable Register
func (o *PIO_Type) SetOER_P0(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOER_P0() uint32 {
	return volatile.LoadUint32(&o.OER.Reg) & 0x1
}
func (o *PIO_Type) SetOER_P1(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOER_P1() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOER_P2(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOER_P2() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOER_P3(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOER_P3() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOER_P4(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOER_P4() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOER_P5(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOER_P5() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOER_P6(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOER_P6() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOER_P7(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOER_P7() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOER_P8(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOER_P8() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOER_P9(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOER_P9() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOER_P10(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOER_P10() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOER_P11(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOER_P11() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOER_P12(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOER_P12() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOER_P13(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOER_P13() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOER_P14(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOER_P14() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOER_P15(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOER_P15() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOER_P16(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOER_P16() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOER_P17(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOER_P17() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOER_P18(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOER_P18() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOER_P19(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOER_P19() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOER_P20(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOER_P20() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOER_P21(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOER_P21() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOER_P22(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOER_P22() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOER_P23(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOER_P23() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOER_P24(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOER_P24() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOER_P25(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOER_P25() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOER_P26(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOER_P26() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOER_P27(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOER_P27() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOER_P28(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOER_P28() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOER_P29(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOER_P29() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOER_P30(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOER_P30() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOER_P31(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOER_P31() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000000) >> 31
}

// PIO.ODR: Output Disable Register
func (o *PIO_Type) SetODR_P0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODR_P0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *PIO_Type) SetODR_P1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODR_P2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODR_P3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODR_P4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODR_P5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODR_P6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODR_P7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODR_P8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODR_P9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODR_P10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODR_P11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODR_P12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODR_P13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODR_P14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODR_P15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODR_P16(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODR_P17(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODR_P18(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODR_P19(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODR_P20(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODR_P21(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODR_P22(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODR_P23(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODR_P24(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODR_P25(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODR_P26(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODR_P27(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODR_P28(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODR_P29(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODR_P30(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODR_P31(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000000) >> 31
}

// PIO.OSR: Output Status Register
func (o *PIO_Type) SetOSR_P0(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOSR_P0() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *PIO_Type) SetOSR_P1(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOSR_P2(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOSR_P3(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOSR_P4(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOSR_P5(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOSR_P6(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOSR_P7(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOSR_P8(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOSR_P9(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOSR_P10(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOSR_P11(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOSR_P12(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOSR_P13(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOSR_P14(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOSR_P15(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOSR_P16(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOSR_P17(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOSR_P18(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOSR_P19(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOSR_P20(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOSR_P21(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOSR_P22(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOSR_P23(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOSR_P24(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOSR_P25(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOSR_P26(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOSR_P27(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOSR_P28(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOSR_P29(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOSR_P30(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOSR_P31(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000000) >> 31
}

// PIO.IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetIFER_P0(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFER_P0() uint32 {
	return volatile.LoadUint32(&o.IFER.Reg) & 0x1
}
func (o *PIO_Type) SetIFER_P1(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFER_P2(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFER_P3(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFER_P4(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFER_P5(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFER_P6(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFER_P7(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFER_P8(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFER_P9(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFER_P10(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFER_P11(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFER_P12(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFER_P13(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFER_P14(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFER_P15(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFER_P16(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFER_P17(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFER_P18(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFER_P19(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFER_P20(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFER_P21(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFER_P22(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFER_P23(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFER_P24(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFER_P25(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFER_P26(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFER_P27(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFER_P28(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFER_P29(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFER_P30(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFER_P31(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000000) >> 31
}

// PIO.IFDR: Glitch Input Filter Disable Register
func (o *PIO_Type) SetIFDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSR: Glitch Input Filter Status Register
func (o *PIO_Type) SetIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000000) >> 31
}

// PIO.SODR: Set Output Data Register
func (o *PIO_Type) SetSODR_P0(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSODR_P0() uint32 {
	return volatile.LoadUint32(&o.SODR.Reg) & 0x1
}
func (o *PIO_Type) SetSODR_P1(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSODR_P1() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSODR_P2(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSODR_P2() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSODR_P3(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSODR_P3() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSODR_P4(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSODR_P4() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSODR_P5(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSODR_P5() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSODR_P6(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSODR_P6() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSODR_P7(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSODR_P7() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSODR_P8(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSODR_P8() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSODR_P9(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSODR_P9() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSODR_P10(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSODR_P10() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSODR_P11(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSODR_P11() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSODR_P12(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSODR_P12() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSODR_P13(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSODR_P13() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSODR_P14(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSODR_P14() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSODR_P15(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSODR_P15() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSODR_P16(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSODR_P16() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSODR_P17(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSODR_P17() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSODR_P18(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSODR_P18() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSODR_P19(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSODR_P19() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSODR_P20(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSODR_P20() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSODR_P21(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSODR_P21() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSODR_P22(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSODR_P22() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSODR_P23(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSODR_P23() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSODR_P24(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSODR_P24() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSODR_P25(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSODR_P25() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSODR_P26(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSODR_P26() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSODR_P27(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSODR_P27() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSODR_P28(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSODR_P28() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSODR_P29(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSODR_P29() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSODR_P30(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSODR_P30() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSODR_P31(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSODR_P31() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000000) >> 31
}

// PIO.CODR: Clear Output Data Register
func (o *PIO_Type) SetCODR_P0(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetCODR_P0() uint32 {
	return volatile.LoadUint32(&o.CODR.Reg) & 0x1
}
func (o *PIO_Type) SetCODR_P1(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetCODR_P1() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetCODR_P2(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetCODR_P2() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetCODR_P3(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetCODR_P3() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetCODR_P4(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetCODR_P4() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetCODR_P5(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetCODR_P5() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetCODR_P6(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetCODR_P6() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetCODR_P7(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetCODR_P7() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetCODR_P8(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetCODR_P8() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetCODR_P9(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetCODR_P9() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetCODR_P10(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetCODR_P10() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetCODR_P11(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetCODR_P11() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetCODR_P12(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetCODR_P12() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetCODR_P13(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetCODR_P13() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetCODR_P14(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetCODR_P14() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetCODR_P15(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetCODR_P15() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetCODR_P16(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetCODR_P16() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetCODR_P17(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetCODR_P17() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetCODR_P18(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetCODR_P18() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetCODR_P19(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetCODR_P19() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetCODR_P20(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetCODR_P20() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetCODR_P21(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetCODR_P21() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetCODR_P22(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetCODR_P22() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetCODR_P23(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetCODR_P23() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetCODR_P24(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetCODR_P24() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetCODR_P25(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetCODR_P25() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetCODR_P26(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetCODR_P26() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetCODR_P27(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetCODR_P27() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetCODR_P28(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetCODR_P28() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetCODR_P29(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetCODR_P29() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetCODR_P30(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetCODR_P30() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetCODR_P31(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetCODR_P31() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000000) >> 31
}

// PIO.ODSR: Output Data Status Register
func (o *PIO_Type) SetODSR_P0(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODSR_P0() uint32 {
	return volatile.LoadUint32(&o.ODSR.Reg) & 0x1
}
func (o *PIO_Type) SetODSR_P1(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODSR_P2(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODSR_P3(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODSR_P4(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODSR_P5(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODSR_P6(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODSR_P7(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODSR_P8(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODSR_P9(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODSR_P10(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODSR_P11(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODSR_P12(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODSR_P13(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODSR_P14(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODSR_P15(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODSR_P16(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODSR_P17(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODSR_P18(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODSR_P19(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODSR_P20(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODSR_P21(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODSR_P22(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODSR_P23(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODSR_P24(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODSR_P25(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODSR_P26(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODSR_P27(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODSR_P28(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODSR_P29(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODSR_P30(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODSR_P31(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000000) >> 31
}

// PIO.PDSR: Pin Data Status Register
func (o *PIO_Type) SetPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000000) >> 31
}

// PIO.IER: Interrupt Enable Register
func (o *PIO_Type) SetIER_P0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIER_P0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PIO_Type) SetIER_P1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIER_P1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIER_P2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIER_P2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIER_P3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIER_P3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIER_P4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIER_P4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIER_P5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIER_P5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIER_P6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIER_P6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIER_P7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIER_P7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIER_P8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIER_P8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIER_P9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIER_P9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIER_P10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIER_P10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIER_P11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIER_P11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIER_P12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIER_P12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIER_P13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIER_P13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIER_P14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIER_P14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIER_P15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIER_P15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIER_P16(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIER_P16() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIER_P17(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIER_P17() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIER_P18(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIER_P18() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIER_P19(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIER_P19() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIER_P20(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIER_P20() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIER_P21(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIER_P21() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIER_P22(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIER_P22() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIER_P23(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIER_P23() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIER_P24(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIER_P24() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIER_P25(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIER_P25() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIER_P26(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIER_P26() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIER_P27(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIER_P27() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIER_P28(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIER_P28() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIER_P29(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIER_P29() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIER_P30(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIER_P30() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIER_P31(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIER_P31() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// PIO.IDR: Interrupt Disable Register
func (o *PIO_Type) SetIDR_P0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIDR_P0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PIO_Type) SetIDR_P1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIDR_P2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIDR_P3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIDR_P4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIDR_P5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIDR_P6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIDR_P7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIDR_P8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIDR_P9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIDR_P10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIDR_P11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIDR_P12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIDR_P13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIDR_P14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIDR_P15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIDR_P16(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIDR_P17(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIDR_P18(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIDR_P19(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIDR_P20(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIDR_P21(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIDR_P22(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIDR_P23(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIDR_P24(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIDR_P25(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIDR_P26(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIDR_P27(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIDR_P28(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIDR_P29(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIDR_P30(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIDR_P31(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// PIO.IMR: Interrupt Mask Register
func (o *PIO_Type) SetIMR_P0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIMR_P0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PIO_Type) SetIMR_P1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIMR_P1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIMR_P2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIMR_P2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIMR_P3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIMR_P3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIMR_P4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIMR_P4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIMR_P5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIMR_P5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIMR_P6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIMR_P6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIMR_P7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIMR_P7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIMR_P8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIMR_P8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIMR_P9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIMR_P9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIMR_P10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIMR_P10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIMR_P11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIMR_P11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIMR_P12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIMR_P12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIMR_P13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIMR_P13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIMR_P14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIMR_P14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIMR_P15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIMR_P15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIMR_P16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIMR_P16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIMR_P17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIMR_P17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIMR_P18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIMR_P18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIMR_P19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIMR_P19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIMR_P20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIMR_P20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIMR_P21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIMR_P21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIMR_P22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIMR_P22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIMR_P23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIMR_P23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIMR_P24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIMR_P24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIMR_P25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIMR_P25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIMR_P26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIMR_P26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIMR_P27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIMR_P27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIMR_P28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIMR_P28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIMR_P29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIMR_P29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIMR_P30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIMR_P30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIMR_P31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIMR_P31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// PIO.ISR: Interrupt Status Register
func (o *PIO_Type) SetISR_P0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetISR_P0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PIO_Type) SetISR_P1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetISR_P1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetISR_P2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetISR_P2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetISR_P3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetISR_P3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetISR_P4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetISR_P4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetISR_P5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetISR_P5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetISR_P6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetISR_P6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetISR_P7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetISR_P7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetISR_P8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetISR_P8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetISR_P9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetISR_P9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetISR_P10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetISR_P10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetISR_P11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetISR_P11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetISR_P12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetISR_P12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetISR_P13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetISR_P13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetISR_P14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetISR_P14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetISR_P15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetISR_P15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetISR_P16(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetISR_P16() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetISR_P17(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetISR_P17() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetISR_P18(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetISR_P18() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetISR_P19(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetISR_P19() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetISR_P20(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetISR_P20() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetISR_P21(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetISR_P21() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetISR_P22(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetISR_P22() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetISR_P23(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetISR_P23() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetISR_P24(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetISR_P24() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetISR_P25(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetISR_P25() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetISR_P26(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetISR_P26() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetISR_P27(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetISR_P27() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetISR_P28(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetISR_P28() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetISR_P29(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetISR_P29() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetISR_P30(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetISR_P30() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetISR_P31(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetISR_P31() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// PIO.MDER: Multi-driver Enable Register
func (o *PIO_Type) SetMDER_P0(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDER_P0() uint32 {
	return volatile.LoadUint32(&o.MDER.Reg) & 0x1
}
func (o *PIO_Type) SetMDER_P1(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDER_P1() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDER_P2(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDER_P2() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDER_P3(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDER_P3() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDER_P4(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDER_P4() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDER_P5(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDER_P5() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDER_P6(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDER_P6() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDER_P7(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDER_P7() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDER_P8(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDER_P8() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDER_P9(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDER_P9() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDER_P10(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDER_P10() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDER_P11(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDER_P11() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDER_P12(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDER_P12() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDER_P13(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDER_P13() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDER_P14(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDER_P14() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDER_P15(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDER_P15() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDER_P16(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDER_P16() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDER_P17(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDER_P17() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDER_P18(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDER_P18() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDER_P19(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDER_P19() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDER_P20(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDER_P20() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDER_P21(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDER_P21() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDER_P22(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDER_P22() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDER_P23(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDER_P23() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDER_P24(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDER_P24() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDER_P25(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDER_P25() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDER_P26(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDER_P26() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDER_P27(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDER_P27() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDER_P28(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDER_P28() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDER_P29(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDER_P29() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDER_P30(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDER_P30() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDER_P31(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDER_P31() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000000) >> 31
}

// PIO.MDDR: Multi-driver Disable Register
func (o *PIO_Type) SetMDDR_P0(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDDR_P0() uint32 {
	return volatile.LoadUint32(&o.MDDR.Reg) & 0x1
}
func (o *PIO_Type) SetMDDR_P1(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDDR_P2(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDDR_P3(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDDR_P4(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDDR_P5(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDDR_P6(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDDR_P7(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDDR_P8(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDDR_P9(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDDR_P10(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDDR_P11(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDDR_P12(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDDR_P13(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDDR_P14(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDDR_P15(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDDR_P16(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDDR_P17(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDDR_P18(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDDR_P19(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDDR_P20(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDDR_P21(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDDR_P22(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDDR_P23(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDDR_P24(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDDR_P25(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDDR_P26(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDDR_P27(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDDR_P28(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDDR_P29(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDDR_P30(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDDR_P31(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000000) >> 31
}

// PIO.MDSR: Multi-driver Status Register
func (o *PIO_Type) SetMDSR_P0(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDSR_P0() uint32 {
	return volatile.LoadUint32(&o.MDSR.Reg) & 0x1
}
func (o *PIO_Type) SetMDSR_P1(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDSR_P2(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDSR_P3(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDSR_P4(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDSR_P5(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDSR_P6(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDSR_P7(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDSR_P8(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDSR_P9(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDSR_P10(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDSR_P11(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDSR_P12(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDSR_P13(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDSR_P14(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDSR_P15(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDSR_P16(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDSR_P17(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDSR_P18(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDSR_P19(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDSR_P20(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDSR_P21(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDSR_P22(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDSR_P23(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDSR_P24(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDSR_P25(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDSR_P26(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDSR_P27(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDSR_P28(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDSR_P29(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDSR_P30(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDSR_P31(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000000) >> 31
}

// PIO.PUDR: Pull-up Disable Register
func (o *PIO_Type) SetPUDR_P0(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUDR_P0() uint32 {
	return volatile.LoadUint32(&o.PUDR.Reg) & 0x1
}
func (o *PIO_Type) SetPUDR_P1(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUDR_P2(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUDR_P3(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUDR_P4(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUDR_P5(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUDR_P6(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUDR_P7(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUDR_P8(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUDR_P9(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUDR_P10(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUDR_P11(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUDR_P12(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUDR_P13(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUDR_P14(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUDR_P15(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUDR_P16(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUDR_P17(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUDR_P18(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUDR_P19(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUDR_P20(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUDR_P21(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUDR_P22(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUDR_P23(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUDR_P24(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUDR_P25(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUDR_P26(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUDR_P27(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUDR_P28(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUDR_P29(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUDR_P30(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUDR_P31(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000000) >> 31
}

// PIO.PUER: Pull-up Enable Register
func (o *PIO_Type) SetPUER_P0(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUER_P0() uint32 {
	return volatile.LoadUint32(&o.PUER.Reg) & 0x1
}
func (o *PIO_Type) SetPUER_P1(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUER_P1() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUER_P2(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUER_P2() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUER_P3(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUER_P3() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUER_P4(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUER_P4() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUER_P5(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUER_P5() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUER_P6(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUER_P6() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUER_P7(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUER_P7() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUER_P8(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUER_P8() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUER_P9(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUER_P9() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUER_P10(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUER_P10() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUER_P11(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUER_P11() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUER_P12(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUER_P12() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUER_P13(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUER_P13() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUER_P14(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUER_P14() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUER_P15(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUER_P15() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUER_P16(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUER_P16() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUER_P17(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUER_P17() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUER_P18(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUER_P18() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUER_P19(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUER_P19() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUER_P20(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUER_P20() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUER_P21(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUER_P21() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUER_P22(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUER_P22() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUER_P23(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUER_P23() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUER_P24(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUER_P24() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUER_P25(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUER_P25() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUER_P26(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUER_P26() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUER_P27(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUER_P27() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUER_P28(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUER_P28() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUER_P29(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUER_P29() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUER_P30(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUER_P30() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUER_P31(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUER_P31() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000000) >> 31
}

// PIO.PUSR: Pad Pull-up Status Register
func (o *PIO_Type) SetPUSR_P0(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUSR_P0() uint32 {
	return volatile.LoadUint32(&o.PUSR.Reg) & 0x1
}
func (o *PIO_Type) SetPUSR_P1(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUSR_P2(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUSR_P3(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUSR_P4(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUSR_P5(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUSR_P6(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUSR_P7(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUSR_P8(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUSR_P9(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUSR_P10(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUSR_P11(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUSR_P12(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUSR_P13(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUSR_P14(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUSR_P15(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUSR_P16(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUSR_P17(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUSR_P18(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUSR_P19(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUSR_P20(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUSR_P21(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUSR_P22(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUSR_P23(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUSR_P24(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUSR_P25(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUSR_P26(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUSR_P27(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUSR_P28(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUSR_P29(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUSR_P30(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUSR_P31(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000000) >> 31
}

// PIO.ABSR: Peripheral AB Select Register
func (o *PIO_Type) SetABSR_P0(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetABSR_P0() uint32 {
	return volatile.LoadUint32(&o.ABSR.Reg) & 0x1
}
func (o *PIO_Type) SetABSR_P1(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetABSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetABSR_P2(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetABSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetABSR_P3(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetABSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetABSR_P4(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetABSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetABSR_P5(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetABSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetABSR_P6(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetABSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetABSR_P7(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetABSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetABSR_P8(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetABSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetABSR_P9(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetABSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetABSR_P10(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetABSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetABSR_P11(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetABSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetABSR_P12(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetABSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetABSR_P13(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetABSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetABSR_P14(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetABSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetABSR_P15(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetABSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetABSR_P16(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetABSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetABSR_P17(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetABSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetABSR_P18(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetABSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetABSR_P19(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetABSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetABSR_P20(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetABSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetABSR_P21(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetABSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetABSR_P22(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetABSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetABSR_P23(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetABSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetABSR_P24(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetABSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetABSR_P25(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetABSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetABSR_P26(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetABSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetABSR_P27(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetABSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetABSR_P28(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetABSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetABSR_P29(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetABSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetABSR_P30(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetABSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetABSR_P31(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetABSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x80000000) >> 31
}

// PIO.SCIFSR: System Clock Glitch Input Filter Select Register
func (o *PIO_Type) SetSCIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSCIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.SCIFSR.Reg) & 0x1
}
func (o *PIO_Type) SetSCIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSCIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSCIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSCIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSCIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSCIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSCIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSCIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSCIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSCIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSCIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSCIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSCIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSCIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSCIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSCIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSCIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSCIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSCIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSCIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSCIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSCIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSCIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSCIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSCIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSCIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSCIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSCIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSCIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSCIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSCIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSCIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSCIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSCIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSCIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSCIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSCIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSCIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSCIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSCIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSCIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSCIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSCIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSCIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSCIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSCIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSCIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSCIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSCIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSCIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSCIFSR_P26(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSCIFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSCIFSR_P27(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSCIFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSCIFSR_P28(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSCIFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSCIFSR_P29(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSCIFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSCIFSR_P30(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSCIFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSCIFSR_P31(value uint32) {
	volatile.StoreUint32(&o.SCIFSR.Reg, volatile.LoadUint32(&o.SCIFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSCIFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.SCIFSR.Reg) & 0x80000000) >> 31
}

// PIO.DIFSR: Debouncing Input Filter Select Register
func (o *PIO_Type) SetDIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetDIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.DIFSR.Reg) & 0x1
}
func (o *PIO_Type) SetDIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetDIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetDIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetDIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetDIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetDIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetDIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetDIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetDIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetDIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetDIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetDIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetDIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetDIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetDIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetDIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetDIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetDIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetDIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetDIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetDIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetDIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetDIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetDIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetDIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetDIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetDIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetDIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetDIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetDIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetDIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetDIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetDIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetDIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetDIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetDIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetDIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetDIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetDIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetDIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetDIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetDIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetDIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetDIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetDIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetDIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetDIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetDIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetDIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetDIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetDIFSR_P26(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetDIFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetDIFSR_P27(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetDIFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetDIFSR_P28(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetDIFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetDIFSR_P29(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetDIFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetDIFSR_P30(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetDIFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetDIFSR_P31(value uint32) {
	volatile.StoreUint32(&o.DIFSR.Reg, volatile.LoadUint32(&o.DIFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetDIFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.DIFSR.Reg) & 0x80000000) >> 31
}

// PIO.IFDGSR: Glitch or Debouncing Input Filter Clock Selection Status Register
func (o *PIO_Type) SetIFDGSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFDGSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFDGSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFDGSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFDGSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFDGSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFDGSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFDGSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFDGSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFDGSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFDGSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFDGSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFDGSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFDGSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFDGSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFDGSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFDGSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFDGSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFDGSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFDGSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFDGSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFDGSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFDGSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFDGSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFDGSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFDGSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFDGSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFDGSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFDGSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFDGSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFDGSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFDGSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFDGSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFDGSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFDGSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFDGSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFDGSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFDGSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFDGSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFDGSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFDGSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFDGSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFDGSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFDGSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFDGSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFDGSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFDGSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFDGSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFDGSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFDGSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFDGSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFDGSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFDGSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFDGSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFDGSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFDGSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFDGSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFDGSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFDGSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFDGSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFDGSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFDGSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFDGSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFDGSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFDGSR.Reg, volatile.LoadUint32(&o.IFDGSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFDGSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFDGSR.Reg) & 0x80000000) >> 31
}

// PIO.SCDR: Slow Clock Divider Debouncing Register
func (o *PIO_Type) SetSCDR_DIV(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x3fff)|value)
}
func (o *PIO_Type) GetSCDR_DIV() uint32 {
	return volatile.LoadUint32(&o.SCDR.Reg) & 0x3fff
}

// PIO.OWER: Output Write Enable
func (o *PIO_Type) SetOWER_P0(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWER_P0() uint32 {
	return volatile.LoadUint32(&o.OWER.Reg) & 0x1
}
func (o *PIO_Type) SetOWER_P1(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWER_P1() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWER_P2(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWER_P2() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWER_P3(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWER_P3() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWER_P4(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWER_P4() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWER_P5(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWER_P5() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWER_P6(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWER_P6() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWER_P7(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWER_P7() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWER_P8(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWER_P8() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWER_P9(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWER_P9() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWER_P10(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWER_P10() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWER_P11(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWER_P11() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWER_P12(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWER_P12() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWER_P13(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWER_P13() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWER_P14(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWER_P14() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWER_P15(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWER_P15() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWER_P16(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWER_P16() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWER_P17(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWER_P17() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWER_P18(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWER_P18() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWER_P19(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWER_P19() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWER_P20(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWER_P20() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWER_P21(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWER_P21() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWER_P22(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWER_P22() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWER_P23(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWER_P23() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWER_P24(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWER_P24() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWER_P25(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWER_P25() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWER_P26(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWER_P26() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWER_P27(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWER_P27() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWER_P28(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWER_P28() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWER_P29(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWER_P29() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWER_P30(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWER_P30() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWER_P31(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWER_P31() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000000) >> 31
}

// PIO.OWDR: Output Write Disable
func (o *PIO_Type) SetOWDR_P0(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWDR_P0() uint32 {
	return volatile.LoadUint32(&o.OWDR.Reg) & 0x1
}
func (o *PIO_Type) SetOWDR_P1(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWDR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWDR_P2(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWDR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWDR_P3(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWDR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWDR_P4(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWDR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWDR_P5(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWDR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWDR_P6(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWDR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWDR_P7(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWDR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWDR_P8(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWDR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWDR_P9(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWDR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWDR_P10(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWDR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWDR_P11(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWDR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWDR_P12(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWDR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWDR_P13(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWDR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWDR_P14(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWDR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWDR_P15(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWDR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWDR_P16(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWDR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWDR_P17(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWDR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWDR_P18(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWDR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWDR_P19(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWDR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWDR_P20(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWDR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWDR_P21(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWDR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWDR_P22(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWDR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWDR_P23(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWDR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWDR_P24(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWDR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWDR_P25(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWDR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWDR_P26(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWDR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWDR_P27(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWDR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWDR_P28(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWDR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWDR_P29(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWDR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWDR_P30(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWDR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWDR_P31(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWDR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000000) >> 31
}

// PIO.OWSR: Output Write Status Register
func (o *PIO_Type) SetOWSR_P0(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWSR_P0() uint32 {
	return volatile.LoadUint32(&o.OWSR.Reg) & 0x1
}
func (o *PIO_Type) SetOWSR_P1(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWSR_P2(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWSR_P3(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWSR_P4(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWSR_P5(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWSR_P6(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWSR_P7(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWSR_P8(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWSR_P9(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWSR_P10(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWSR_P11(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWSR_P12(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWSR_P13(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWSR_P14(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWSR_P15(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWSR_P16(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWSR_P17(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWSR_P18(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWSR_P19(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWSR_P20(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWSR_P21(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWSR_P22(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWSR_P23(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWSR_P24(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWSR_P25(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWSR_P26(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWSR_P27(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWSR_P28(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWSR_P29(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWSR_P30(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWSR_P31(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000000) >> 31
}

// PIO.AIMER: Additional Interrupt Modes Enable Register
func (o *PIO_Type) SetAIMER_P0(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMER_P0() uint32 {
	return volatile.LoadUint32(&o.AIMER.Reg) & 0x1
}
func (o *PIO_Type) SetAIMER_P1(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMER_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMER_P2(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMER_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMER_P3(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMER_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMER_P4(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMER_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMER_P5(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMER_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMER_P6(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMER_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMER_P7(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.