/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class HtmlQuotesConverter
extends XmlRecursiveElementVisitor
implements Runnable {
    private final TextRange myOriginalRange;
    private final Document myDocument;
    private final PsiDocumentManager myDocumentManager;
    private final PostFormatProcessorHelper myPostProcessorHelper;
    private final PsiElement myContext;
    private final String myNewQuote;

    public HtmlQuotesConverter(@NotNull CodeStyleSettings.QuoteStyle style, @NotNull PsiElement context, @NotNull PostFormatProcessorHelper postFormatProcessorHelper) {
        if (style == null) {
            HtmlQuotesConverter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HtmlQuotesConverter.$$$reportNull$$$0(1);
        }
        if (postFormatProcessorHelper == null) {
            HtmlQuotesConverter.$$$reportNull$$$0(2);
        }
        this.myPostProcessorHelper = postFormatProcessorHelper;
        Project project = context.getProject();
        PsiFile file = context.getContainingFile();
        this.myContext = context;
        this.myOriginalRange = postFormatProcessorHelper.getResultTextRange();
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)project);
        this.myDocument = file.getViewProvider().getDocument();
        this.myNewQuote = switch (style) {
            case CodeStyleSettings.QuoteStyle.Single -> "'";
            case CodeStyleSettings.QuoteStyle.Double -> "\"";
            default -> String.valueOf(0);
        };
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
        PsiElement child;
        if (value == null) {
            HtmlQuotesConverter.$$$reportNull$$$0(3);
        }
        if (this.myOriginalRange.contains(value.getTextRange()) && (child = value.getFirstChild()) != null && !this.containsQuoteChars(value)) {
            if (child.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                CharSequence delimiterChars;
                PsiElement lastChild = value.getLastChild();
                if (lastChild != null && lastChild.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && (delimiterChars = child.getNode().getChars()).length() == 1 && !StringUtil.equals((CharSequence)delimiterChars, (CharSequence)this.myNewQuote)) {
                    int startOffset = value.getTextRange().getStartOffset();
                    int endOffset = value.getTextRange().getEndOffset();
                    this.replaceString(startOffset, startOffset + 1, this.myNewQuote);
                    this.replaceString(endOffset - 1, endOffset, this.myNewQuote);
                }
            } else if (child.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && child == value.getLastChild()) {
                this.insertString(child.getTextRange().getStartOffset(), this.myNewQuote);
                this.insertString(child.getTextRange().getEndOffset(), this.myNewQuote);
            }
        }
    }

    private void replaceString(int start, int end, String newValue) {
        int mappedStart = this.myPostProcessorHelper.mapOffset(start);
        int mappedEnd = this.myPostProcessorHelper.mapOffset(end);
        this.myDocument.replaceString(mappedStart, mappedEnd, (CharSequence)newValue);
        this.myPostProcessorHelper.updateResultRange(end - start, newValue.length());
    }

    private void insertString(int offset, String value) {
        int mappedOffset = this.myPostProcessorHelper.mapOffset(offset);
        this.myDocument.insertString(mappedOffset, (CharSequence)value);
        this.myPostProcessorHelper.updateResultRange(0, value.length());
    }

    private boolean containsQuoteChars(@NotNull XmlAttributeValue value) {
        if (value == null) {
            HtmlQuotesConverter.$$$reportNull$$$0(4);
        }
        for (PsiElement child = value.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (HtmlQuotesConverter.isDelimiter(child.getNode().getElementType()) || !StringUtil.contains((CharSequence)child.getNode().getChars(), (CharSequence)this.myNewQuote)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDelimiter(@NotNull IElementType elementType) {
        if (elementType == null) {
            HtmlQuotesConverter.$$$reportNull$$$0(5);
        }
        return elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
    }

    @Override
    public void run() {
        if (this.myDocument == null) {
            return;
        }
        this.runSimple();
        this.myDocumentManager.commitDocument(this.myDocument);
    }

    public void runSimple() {
        if (this.myDocument == null) {
            return;
        }
        this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
        this.myContext.accept((PsiElementVisitor)this);
    }

    public static void runOnElement(@NotNull CodeStyleSettings.QuoteStyle quoteStyle, @NotNull PsiElement element) {
        if (quoteStyle == null) {
            HtmlQuotesConverter.$$$reportNull$$$0(6);
        }
        if (element == null) {
            HtmlQuotesConverter.$$$reportNull$$$0(7);
        }
        CommonCodeStyleSettings settings = CodeStyle.getSettings((PsiFile)element.getContainingFile()).getCommonSettings((Language)HTMLLanguage.INSTANCE);
        PostFormatProcessorHelper postFormatProcessorHelper = new PostFormatProcessorHelper(settings);
        postFormatProcessorHelper.setResultTextRange(element.getTextRange());
        new HtmlQuotesConverter(quoteStyle, element, postFormatProcessorHelper).runSimple();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postFormatProcessorHelper";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoteStyle";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/html/HtmlQuotesConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlAttributeValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "containsQuoteChars";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isDelimiter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runOnElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

